/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.ValidatorForm;
import org.compiere.framework.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.Info;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;

/**
 * @author Shinjirito
 *
 */
public class InfoLookupSearchAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(getClass());

	/**
	 * 
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 
		
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
		InfoLookupForm searchInfoForm = (InfoLookupForm)baseForm;
		HttpSession session = request.getSession();
		if (searchInfoForm != null) {
			int windowNo = searchInfoForm.getWindowNo();
			int AD_Column_ID = searchInfoForm.getColumn_ID();
			String columnName = searchInfoForm.getColumnName();
			String lookupID = searchInfoForm.getLookupID();
			if (lookupID == null || lookupID.length() == 0) {
				lookupID = AmpiereUtil.getFixedColumnName(columnName);
				searchInfoForm.setLookupID(lookupID);
			}
			String forward = lookupID.toLowerCase();
			session.setAttribute("searchResult" + lookupID, null);

			Info info = (Info)session.getAttribute("infoLookup" + lookupID);
			if (info != null) {
				// Create column lookup 
				Lookup lookup = createLookup(wsc.ctx, windowNo, AD_Column_ID, columnName);
				
				
				if(searchInfoForm.getSearchWhere() != null){
					info.createWhereClause(searchInfoForm.getSearchWhere(), wsc.dateFormat);
					info.setQueryParas(wsc, request);
					
				    // Check record number
				    int rowCount = info.testCount(wsc.ctx);
				    rowCount = AmpiereUtil.setLargeRecordMsg(wsc.ctx, searchInfoForm, rowCount);

				    // Execute query and put result to session
					ArrayList result = info.executeQuery(wsc.ctx, rowCount, lookup);
				    if (result != null) {
				    	// Set search result
				    	session.setAttribute("searchResult" + lookupID, result);
				    }
				}else{
					info = null;
				}
			}

			searchInfoForm.statInit(wsc.ctx);
			if (info != null) {
				searchInfoForm.setTitle(info.getTitle());
			}
			searchInfoForm.setDateInfos(wsc.language.getLocale(), wsc.dateFormat.toPattern(), Msg.translate(wsc.ctx, "InvalidDate"));

			// Set search info form
			session.setAttribute("searchInfoForm" + lookupID, searchInfoForm);

			// Forward
			request.setAttribute("doQuery", "0");
			return mapping.findForward(forward);
		}

		request.setAttribute("doQuery", "0");
		return mapping.findForward("general");
	}
}
