/**
 *
 */
package com.ampiere.web.struts.search;

import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.InfoOrder;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;

/**
 * @author CLMG
 *
 */
public class InfoOrderSearchAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(getClass());

	/**
	 *
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);
		
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

		WebSessionCtx wsc = WebSessionCtx.get(request);
		HttpSession session = request.getSession();
		InfoOrderForm searchInfoFormOrder = (InfoOrderForm)baseForm;
		
		//検索条件の整理
		if(StringUtils.isEmpty(searchInfoFormOrder.getCbpartneridf())){
			searchInfoFormOrder.setCbpartneridd("");
		}
		searchInfoFormOrder.setCbpartnerId(searchInfoFormOrder.getCbpartneridd());
		searchInfoFormOrder.setIsSOTrx(request.getParameter("isSOTrx"));
		session.setAttribute("searchResultOrder", null);
		
		if (searchInfoFormOrder != null) {
			int windowNo = searchInfoFormOrder.getWindowNo();
			int AD_Column_ID = searchInfoFormOrder.getColumn_ID();
			String columnName = searchInfoFormOrder.getColumnName();

			// Create column lookup
			Lookup lookup = createLookup(wsc.ctx, windowNo, AD_Column_ID, columnName);

			// Get where clause
//			String whereClause = getWhereClause(wsc.ctx, lookup, columnName);
			String whereClause = "";

			String value = searchInfoFormOrder.getValue();
			if (WebEnv.NBSP_UNICODE.equals(value)) {
				value = "";
			}
			String name = searchInfoFormOrder.getName();
			if (WebEnv.NBSP_UNICODE.equals(name)) {
				name = "";
			}
			if (value.length() == 0 && name != null && name.length() > 0) {
				value = "@" + name + "@";   //  Name indicator - otherwise Value
			}

			int M_Warehouse_ID = wsc.ctx.getContextAsInt(windowNo, "M_Warehouse_ID");

		    InfoOrder info = new InfoOrder(windowNo, value, false, whereClause, wsc.ctx);
		    info.setQueryParas(wsc, request);
		    
		    //SET BPARTNER
			if (!StringUtils.isEmpty(searchInfoFormOrder.getCbpartnerId())) {
				String bpartnerName = AmpiereUtil.getBPartnerName(searchInfoFormOrder.getCbpartnerId());
				searchInfoFormOrder.setCbpartneridf(bpartnerName);
			}else{
				searchInfoFormOrder.setCbpartneridf("");
			}

		    // Check record number
		    int rowCount = info.testCount(wsc.ctx);
		    rowCount = AmpiereUtil.setLargeRecordMsg(wsc.ctx, searchInfoFormOrder, rowCount);
		    ArrayList result = info.executeQuery(wsc.ctx, rowCount, lookup);
		    if (result != null && result.size() > 0) {
		    	// Set search result
		    	session.setAttribute("searchResultOrder", result);
		    }
		}

		request.setAttribute("doQuery", "0");
		session.setAttribute("searchInfoFormOrder", searchInfoFormOrder);
		return mapping.findForward("success");
	}

}
