/**
 * 
 */
package com.ampiere.web.struts.search;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

import com.ampiere.web.struts.common.PopupBaseForm;
import com.jware.base.web.struts.jWareBaseForm;

/**
 * @author Shinjirito
 *
 */
public class InfoPAttributeInstanceForm extends PopupBaseForm implements Serializable  {
	private static final long serialVersionUID = 6816113647340102852L;
	private String title;
	private String closeBtnTitle;
	private String submitBtnTitle;
	private String months;
	private String shortMonths;
	private String weeks;
	private String shortWeeks;
	private String dateFormat = "MM/DD/YYYY";
	private String invalidDateMsg = "Invalid Date";//clmg 2009/02/24

	public String getInvalidDateMsg() {
		return invalidDateMsg;
	}
	public void setInvalidDateMsg(String invalidDateMsg) {
		this.invalidDateMsg = invalidDateMsg;
	}
	public String getCloseBtnTitle() {
		return closeBtnTitle;
	}
	public void setCloseBtnTitle(String closeBtnTitle) {
		this.closeBtnTitle = closeBtnTitle;
	}
	public String getSubmitBtnTitle() {
		return submitBtnTitle;
	}
	public void setSubmitBtnTitle(String submitBtnTitle) {
		this.submitBtnTitle = submitBtnTitle;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getDateFormat() {
		return dateFormat;
	}
	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}
	public String getMonths() {
		return months;
	}
	public void setMonths(String months) {
		this.months = months;
	}
	public String getShortMonths() {
		return shortMonths;
	}
	public void setShortMonths(String shortMonths) {
		this.shortMonths = shortMonths;
	}
	public String getShortWeeks() {
		return shortWeeks;
	}
	public void setShortWeeks(String shortWeeks) {
		this.shortWeeks = shortWeeks;
	}
	public String getWeeks() {
		return weeks;
	}
	public void setWeeks(String weeks) {
		this.weeks = weeks;
	}
	/**
	 * Set date relative informations(month, day, week day, date format)
	 * @param loc
	 */
	public void setDateInfos(Locale loc, String dateFormat) {
		SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(DateFormat.LONG, loc);
		months = generateJavascriptArray(formatDate.getDateFormatSymbols().getMonths());
		shortMonths = generateJavascriptArray(formatDate.getDateFormatSymbols().getShortMonths());
		String wk[] = formatDate.getDateFormatSymbols().getWeekdays();
		String swk[] = formatDate.getDateFormatSymbols().getShortWeekdays();
		String weekss[] = new String [7];
		String shortWeekss[] = new String [7];
		// 0:blank, 1:Sunday ... ==> 0:Sunday 1:Monday ...
		for (int i = 1; i < wk.length; i++) {
			weekss[i - 1] = wk[i];
			shortWeekss[i - 1] = swk[i];
		}
		weeks = generateJavascriptArray(weekss);
		shortWeeks = generateJavascriptArray(shortWeekss);
		this.dateFormat = "\"" + dateFormat + "\"";
		this.invalidDateMsg = "\"" + invalidDateMsg + "\""; //clmg 2009/02/24
	}
	/**
	 * Javascript array deceleration
	 * @param p
	 * @return
	 */
	private String generateJavascriptArray(String p[]) {
		String s = "new Array(";
		for (int i = 0; i < p.length; i++) {
			if (p[i] != null && p[i].length() > 0) {
				s += ("\"" + p[i] + "\",");
			}
		}
		s = s.substring(0, s.length() - 1);
		s += ")";
		return s;
	}
}
