/**
 *
 */
package com.ampiere.web.struts.search;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.compiere.model.MRole;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

import com.ampiere.dto.CodeValue;
import com.ampiere.web.struts.common.PopupBaseForm;

/**
 * @author Shinjirito
 *
 */
public class InfoPaymentForm extends PopupBaseForm {
	private static final long serialVersionUID = -2979814699715706579L;
	
	private String cbpartneridf;	
	private String cbpartneridd;

	private String name;
	private String nameLabel;
	private String upc;
	private String upcLabel;
	private String sku;
	private String skuLabel;
	private String warehouse;
	private String warehouseLabel;
	private String paSearchFlag = "false";
	private String paSearchWhere = "";
	private ArrayList<CodeValue> warehouseList = new ArrayList<CodeValue>();
	private ArrayList<CodeValue> priceList = new ArrayList<CodeValue>();

	private String documentNo;
	private String cbpartnerId;
	private String isSOTrx;
	private String isPaid;
	private String isReceipt;

	private String description;

	private String dateOrdered;
	private String dateFrom;
	private String dateTo;
	private String poReference;
	private String orderId;
	private String grandTotal;
	private String amountFrom;
	private String amountTo;
	
	private String orderIdLabel;
	private String documentNoLabel;
	private String cbpartnerIdLabel;
	private String isSOTrxLabel;
	private String isPaidLabel;
	private String isReceiptLabel;
	private String dLabel;
	private String dateOrderedLabel;
	private String poReferenceLabel;	
	private String grandTotalLabel;
	private String payAmtLabel;
	private String dateTrxLabel;
	
	
	public String getPayAmtLabel() {
		return payAmtLabel;
	}

	public void setPayAmtLabel(String payAmtLabel) {
		this.payAmtLabel = payAmtLabel;
	}

	public String getDateTrxLabel() {
		return dateTrxLabel;
	}

	public void setDateTrxLabel(String dateTrxLabel) {
		this.dateTrxLabel = dateTrxLabel;
	}
	
	public String getIsPaidLabel() {
		return isPaidLabel;
	}

	public void setIsPaidLabel(String isPaidLabel) {
		this.isPaidLabel = isPaidLabel;
	}
	
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}
	
	public String getIsPaid() {
		return isPaid;
	}

	public void setIsPaid(String isPaid) {
		this.isPaid = isPaid;
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public String getdLabel() {
		return dLabel;
	}

	public void setdLabel(String dLabel) {
		this.dLabel = dLabel;
	}
	
	public String getPoReferenceLabel() {
		return poReferenceLabel;
	}

	public void setPoReferenceLabel(String poReferenceLabel) {
		this.poReferenceLabel = poReferenceLabel;
	}

	public String getDocumentNo() {
		return documentNo;
	}

	public void setDocumentNo(String documentNo) {
		this.documentNo = documentNo;
	}

	public String getCbpartnerId() {
		return cbpartnerId;
	}

	public void setCbpartnerId(String cbpartnerId) {
		this.cbpartnerId = cbpartnerId;
	}

	public String getIsSOTrx() {
		return isSOTrx;
	}

	public void setIsSOTrx(String isSOTrx) {
		this.isSOTrx = isSOTrx;
	}

	public String getDateOrdered() {
		return dateOrdered;
	}

	public void setDateOrdered(String dateOrdered) {
		this.dateOrdered = dateOrdered;
	}

	public String getDateFrom() {
		return dateFrom;
	}

	public void setDateFrom(String dateFrom) {
		this.dateFrom = dateFrom;
	}

	public String getDateTo() {
		return dateTo;
	}

	public void setDateTo(String dateTo) {
		this.dateTo = dateTo;
	}

	public String getPoReference() {
		return poReference;
	}

	public void setPoReference(String poReference) {
		this.poReference = poReference;
	}

	public String getGrandTotal() {
		return grandTotal;
	}

	public void setGrandTotal(String grandTotal) {
		this.grandTotal = grandTotal;
	}

	public String getAmountFrom() {
		return amountFrom;
	}

	public void setAmountFrom(String amountFrom) {
		this.amountFrom = amountFrom;
	}

	public String getAmountTo() {
		return amountTo;
	}

	public void setAmountTo(String amountTo) {
		this.amountTo = amountTo;
	}

	public String getDocumentNoLabel() {
		return documentNoLabel;
	}

	public void setDocumentNoLabel(String documentNoLabel) {
		this.documentNoLabel = documentNoLabel;
	}

	public String getCbpartnerIdLabel() {
		return cbpartnerIdLabel;
	}

	public void setCbpartnerIdLabel(String cbpartnerIdLabel) {
		this.cbpartnerIdLabel = cbpartnerIdLabel;
	}

	public String getIsSOTrxLabel() {
		return isSOTrxLabel;
	}

	public void setIsSOTrxLabel(String isSOTrxLabel) {
		this.isSOTrxLabel = isSOTrxLabel;
	}

	public String getDateOrderedLabel() {
		return dateOrderedLabel;
	}

	public void setDateOrderedLabel(String dateOrderedLabel) {
		this.dateOrderedLabel = dateOrderedLabel;
	}

	public String getGrandTotalLabel() {
		return grandTotalLabel;
	}

	public void setGrandTotalLabel(String grandTotalLabel) {
		this.grandTotalLabel = grandTotalLabel;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getNameLabel() {
		return nameLabel;
	}

	public void setNameLabel(String nameLabel) {
		this.nameLabel = nameLabel;
	}

	public String getSku() {
		return sku;
	}

	public void setSku(String sku) {
		this.sku = sku;
	}

	public String getSkuLabel() {
		return skuLabel;
	}

	public void setSkuLabel(String skuLabel) {
		this.skuLabel = skuLabel;
	}

	public String getUpc() {
		return upc;
	}

	public void setUpc(String upc) {
		this.upc = upc;
	}

	public String getUpcLabel() {
		return upcLabel;
	}

	public void setUpcLabel(String upcLabel) {
		this.upcLabel = upcLabel;
	}

	public String getWarehouse() {
		return warehouse;
	}

	public void setWarehouse(String warehouse) {
		this.warehouse = warehouse;
	}

	public String getWarehouseLabel() {
		return warehouseLabel;
	}

	public void setWarehouseLabel(String warehouseLabel) {
		this.warehouseLabel = warehouseLabel;
	}

	public String getPaSearchWhere() {
		return paSearchWhere;
	}

	public void setPaSearchWhere(String paSearchWhere) {
		this.paSearchWhere = paSearchWhere;
	}

	public String getPaSearchFlag() {
		return paSearchFlag;
	}

	public void setPaSearchFlag(String paSearchFlag) {
		this.paSearchFlag = paSearchFlag;
	}
	
	public String getOrderIdLabel() {
		return orderIdLabel;
	}

	public void setOrderIdLabel(String orderIdLabel) {
		this.orderIdLabel = orderIdLabel;
	}

	/**
	 * Reset all properties to their default values.
	 *
	 * @param mapping The mapping used to select this instance
	 * @param request The servlet request we are processing
	 */
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		/**
    	 * This will set LoginUserId From Session
    	 */
    	super.reset(mapping, request);
	}

	/**
	 *	Static Setup - set field value
	 */
	public void statInit(Ctx ctx) {
		super.statInit(ctx);
		setTitle(Msg.translate(ctx, "InfoProduct"));

		setValueLabel(Msg.translate(ctx, "Value"));
		setNameLabel(Msg.translate(ctx, "Name"));
		setUpcLabel(Msg.translate(ctx, "UPC"));
		setSkuLabel(Msg.translate(ctx, "SKU"));
		setWarehouseLabel(Msg.translate(ctx, "Warehouse"));

		setCbpartnerIdLabel(Msg.translate(ctx, "C_BPartner_ID"));
		setDateOrderedLabel(Msg.translate(ctx, "MovementDate"));
		setDocumentNoLabel(Msg.translate(ctx, "DocumentNo"));
		setGrandTotalLabel(Msg.translate(ctx, "GrandTotal"));
		setIsPaidLabel(Msg.translate(ctx, "IsPaid"));
		setIsSOTrxLabel(Msg.translate(ctx, "IsSOTrx"));
		setdLabel(Msg.translate(ctx, "Description"));
		setPoReferenceLabel(Msg.translate(ctx, "POReference"));
		setOrderIdLabel(Msg.translate(ctx, "C_Order_ID"));
		setIsReceiptLabel(Msg.translate(ctx, "IsReceipt"));
		setPayAmtLabel(Msg.translate(ctx, "PayAmt"));
		setDateTrxLabel(Msg.translate(ctx, "DateTrx"));
	}

	/**
	 *	Dynamic Init
	 *  @param bpName BPartner name
	 *  @param whereClause where clause
	 */
	public void initInfo(String value, int M_Warehouse_ID, Ctx ctx, int windowNo)
	{
//		getDataLists(M_PriceList_ID);

//		int M_PriceList_Version_ID = findPLV (M_PriceList_ID, ctx, windowNo);

		//	Set Value or Name
		if (value.startsWith("@") && value.endsWith("@")) {
			name = value.substring(1,value.length()-1);
		} else {
			setValue(value);
		}

		//	Set Warehouse
		if (M_Warehouse_ID == 0) {
//			M_Warehouse_ID = Env.getContextAsInt(ctx, "#M_Warehouse_ID");
			M_Warehouse_ID = ctx.getContextAsInt("#M_Warehouse_ID");
		}
		if (M_Warehouse_ID != 0) {
			setWarehouse (Integer.toString(M_Warehouse_ID));
		}

		// 	Set PriceList Version
//		if (M_PriceList_Version_ID != 0) {
//			setPriceListVersion (Integer.toString(M_PriceList_Version_ID));
//		}
	}	//	initInfo

	/**
	 *	Get warehouse list and price list
	 *
	 * @param M_PriceList_ID price list
	 */
	private void getDataLists(Ctx ctx,int M_PriceList_ID)
	{
		warehouseList.clear();
		priceList.clear();

		//	Price List
		String SQL = "SELECT M_PriceList_Version.M_PriceList_Version_ID,"
			+ " M_PriceList_Version.Name || ' (' || c.Iso_Code || ')' AS ValueName "
			+ "FROM M_PriceList_Version, M_PriceList pl, C_Currency c "
			+ "WHERE M_PriceList_Version.M_PriceList_ID=pl.M_PriceList_ID"
			+ " AND pl.C_Currency_ID=c.C_Currency_ID"
			+ " AND M_PriceList_Version.IsActive='Y' AND pl.IsActive='Y'";
		//	Same PL currency as original one
		if (M_PriceList_ID != 0) {
			SQL += " AND EXISTS (SELECT * FROM M_PriceList xp WHERE xp.M_PriceList_ID=" + M_PriceList_ID
				+ " AND pl.C_Currency_ID=xp.C_Currency_ID)";
		}

		//	Add Access & Order
		SQL = MRole.getDefault(ctx,false).addAccessSQL (SQL, "M_PriceList_Version", true, false)	// fully qualidfied - RO
					+ " ORDER BY M_PriceList_Version.Name";
		try
		{
			priceList.add(new CodeValue("0", ""));
			PreparedStatement pstmt = DB.prepareStatement(SQL, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				priceList.add(new CodeValue(rs.getString(1), rs.getString(2)));
			}
			rs.close();
			pstmt.close();

			//	Warehouse
			SQL = MRole.getDefault(ctx,false).addAccessSQL (
				"SELECT M_Warehouse_ID, Value || ' - ' || Name AS ValueName "
				+ "FROM M_Warehouse "
				+ "WHERE IsActive='Y'",
					"M_Warehouse", MRole.SQL_NOTQUALIFIED, MRole.SQL_RO)
				+ " ORDER BY Value";
			warehouseList.add(new CodeValue("0", ""));
			pstmt = DB.prepareStatement(SQL, null);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				warehouseList.add(new CodeValue(rs.getString("M_Warehouse_ID"), rs.getString("ValueName")));
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}	//	fillPicks

	/**
	 *	Find Price List Version and update context
	 *
	 * @param M_PriceList_ID price list
	 * @return M_PriceList_Version_ID price list version
	 */
	private int findPLV (int M_PriceList_ID, Ctx ctx, int windowNo)
	{
		Timestamp priceDate = null;

		//	Sales Order Date
//		String dateStr = Env.getContext(ctx, windowNo, "DateOrdered");
		String dateStr = ctx.getContext(windowNo, "DateOrdered");
		if (dateStr != null && dateStr.length() > 0)
//			priceDate = Env.getContextAsDate(ctx, windowNo, "DateOrdered");
			priceDate = new Timestamp(ctx.getContextAsTime(windowNo, "DateOrdered"));
		else	//	Invoice Date
		{
//			dateStr = Env.getContext(ctx, windowNo, "DateInvoiced");
			dateStr = ctx.getContext(windowNo, "DateInvoiced");
			if (dateStr != null && dateStr.length() > 0)
//				priceDate = Env.getContextAsDate(ctx, windowNo, "DateInvoiced");
				priceDate = new Timestamp(ctx.getContextAsTime(windowNo, "DateInvoiced"));
		}

		//	Today
		if (priceDate == null) {
			priceDate = new Timestamp(System.currentTimeMillis());
		}

		//
		int retValue = 0;
		String sql = "SELECT plv.M_PriceList_Version_ID, plv.ValidFrom "
			+ "FROM M_PriceList pl, M_PriceList_Version plv "
			+ "WHERE pl.M_PriceList_ID=plv.M_PriceList_ID"
			+ " AND plv.IsActive='Y'"
			+ " AND pl.M_PriceList_ID=? "					//	1
			+ "ORDER BY plv.ValidFrom DESC";
		//	find newest one
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, M_PriceList_ID);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next() && retValue == 0)
			{
				Timestamp plDate = rs.getTimestamp(2);
				if (!priceDate.before(plDate)) {
					retValue = rs.getInt(1);
				}
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
//		Env.setContext(ctx, windowNo, "M_PriceList_Version_ID", retValue);
		ctx.setContext(windowNo, "M_PriceList_Version_ID", retValue);
		return retValue;
	}	//	findPLV

	public ArrayList<CodeValue> getPriceList() {
		return priceList;
	}

	public ArrayList<CodeValue> getWarehouseList() {
		return warehouseList;
	}
	

	public String getCbpartneridd() {
		return cbpartneridd;
	}

	public void setCbpartneridd(String cbpartneridd) {
		this.cbpartneridd = cbpartneridd;
	}

	public String getCbpartneridf() {
		return cbpartneridf;
	}

	public void setCbpartneridf(String cbpartneridf) {
		this.cbpartneridf = cbpartneridf;
	}
	
	public String getIsReceiptLabel() {
		return isReceiptLabel;
	}

	public void setIsReceiptLabel(String isReceiptLabel) {
		this.isReceiptLabel = isReceiptLabel;
	}
	
	public String getIsReceipt() {
		return isReceipt;
	}

	public void setIsReceipt(String isReceipt) {
		this.isReceipt = isReceipt;
	}
}
