/**
 *
 */
package com.ampiere.web.struts.search;

import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.InfoPayment;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;

/**
 * @author CLMG
 *
 */
public class InfoPaymentSearchAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(getClass());

	/**
	 *
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);

		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 
        
		WebSessionCtx wsc = WebSessionCtx.get(request);
		HttpSession session = request.getSession();
		InfoPaymentForm searchInfoFormPayment = (InfoPaymentForm)baseForm;
		
		//検索条件の整理
		if(StringUtils.isEmpty(searchInfoFormPayment.getCbpartneridf())){
			searchInfoFormPayment.setCbpartneridd("");
		}
		searchInfoFormPayment.setCbpartnerId(searchInfoFormPayment.getCbpartneridd());
		searchInfoFormPayment.setIsReceipt(request.getParameter("isReceipt"));
		session.setAttribute("searchResultPayment", null);
		
		if (searchInfoFormPayment != null) {
			int windowNo = searchInfoFormPayment.getWindowNo();
			int AD_Column_ID = searchInfoFormPayment.getColumn_ID();
			String columnName = searchInfoFormPayment.getColumnName();

			// Create column lookup
			Lookup lookup = createLookup(wsc.ctx, windowNo, AD_Column_ID, columnName);

			// Get where clause
//			String whereClause = getWhereClause(wsc.ctx, lookup, columnName);
			String whereClause = "";

			String value = searchInfoFormPayment.getValue();
			if (WebEnv.NBSP_UNICODE.equals(value)) {
				value = "";
			}
			String name = searchInfoFormPayment.getName();
			if (WebEnv.NBSP_UNICODE.equals(name)) {
				name = "";
			}
			if (value.length() == 0 && name != null && name.length() > 0) {
				value = "@" + name + "@";   //  Name indicator - otherwise Value
			}
			
			int M_Warehouse_ID = wsc.ctx.getContextAsInt(windowNo, "M_Warehouse_ID");

		    InfoPayment info = new InfoPayment(windowNo, value, false, whereClause, wsc.ctx);
		    info.setQueryParas(wsc, request);
		    
		    //SET BPARTNER
			if (!StringUtils.isEmpty(searchInfoFormPayment.getCbpartnerId())) {
				String bpartnerName = AmpiereUtil.getBPartnerName(searchInfoFormPayment.getCbpartnerId());
				searchInfoFormPayment.setCbpartneridf(bpartnerName);
			}else{
				searchInfoFormPayment.setCbpartneridf("");
			}

		    // Check record number
		    int rowCount = info.testCount(wsc.ctx);
		    rowCount = AmpiereUtil.setLargeRecordMsg(wsc.ctx, searchInfoFormPayment, rowCount);
		    ArrayList result = info.executeQuery(wsc.ctx, rowCount, lookup);
		    if (result != null && result.size() > 0) {
		    	// Set search result
		    	session.setAttribute("searchResultPayment", result);
		    }
		}

		request.setAttribute("doQuery", "0");
		session.setAttribute("searchInfoFormPayment", searchInfoFormPayment);
		return mapping.findForward("success");
	}

}
