/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.ArrayList;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.WebSessionCtx;

import com.ampiere.search.InfoPostal;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;

/**
 * @author Shinjirito
 *
 */
public class InfoPostalSearchAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(getClass());

	/**
	 * 
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm, HttpServletRequest request, HttpServletResponse response, ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);
		
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

		WebSessionCtx wsc = WebSessionCtx.get(request);
		HttpSession session = request.getSession();
		InfoPostalForm searchInfoFormPostal = (InfoPostalForm)baseForm;
		session.setAttribute("searchResultPostal", null);
		if (searchInfoFormPostal != null) {
			int windowNo = searchInfoFormPostal.getWindowNo();
			int AD_Column_ID = searchInfoFormPostal.getColumn_ID();
			int countryId = searchInfoFormPostal.getCountryId();
			String columnName = searchInfoFormPostal.getColumnName();

			// Create column lookup 
			Lookup lookup = createLookup(wsc.ctx, windowNo, AD_Column_ID, columnName);

		    InfoPostal info = new InfoPostal(windowNo, countryId, "", false, "", wsc.ctx);
		    info.setQueryParas(wsc, request);

		    // Check record number
		    int rowCount = info.testCount(wsc.ctx);
		    rowCount = AmpiereUtil.setLargeRecordMsg(wsc.ctx, searchInfoFormPostal, rowCount);

		    ArrayList result = info.executeQuery(wsc.ctx, rowCount, lookup);

	    	// Set search result
	    	session.setAttribute("searchResultPostal", result);
		}

		request.setAttribute("doQuery", "0");
		return mapping.findForward("success");
	}
}
