/**
 * 
 */
package com.ampiere.web.struts.search;

import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

import com.ampiere.util.Constants;


/**
 * @author Shinjirito
 *
 */
public class InfoProductAction extends InfoBaseAction {
	/**	Logger			*/
	protected CLogger	log = CLogger.getCLogger(this.getClass());

	/* (non-Javadoc)
	 * @see com.jware.base.web.struts.jWareBaseAction#doExecute(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionErrors, boolean)
	 */
	public ActionForward doExecute(ActionMapping mapping, ActionForm baseForm,
			HttpServletRequest request, HttpServletResponse response,
			ActionErrors errors, boolean mochaFlag) throws Exception {
		super.doExecute(mapping, baseForm, request, response, errors, mochaFlag);
		
		//201001 
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        //--201001	 

		String doQurey = "0";
		HttpSession session = request.getSession();
		InfoProductForm searchInfoFormProduct = (InfoProductForm)baseForm;
		// Clear all
		session.setAttribute("searchResultProduct", null);
		session.setAttribute("warehouseListProduct", null);
		session.setAttribute("priceListProduct", null);
		if (searchInfoFormProduct != null) {
		  	WebSessionCtx wsc = WebSessionCtx.get(request);
			int windowNo = searchInfoFormProduct.getWindowNo();
			String name = searchInfoFormProduct.getName();
			if (WebEnv.NBSP_UNICODE.equals(name)) {
				name = "";
			}

//			int M_Warehouse_ID = Env.getContextAsInt(wsc.ctx, windowNo, "M_Warehouse_ID");
//			int M_PriceList_ID = Env.getContextAsInt(wsc.ctx, windowNo, "M_PriceList_ID");
			int M_Warehouse_ID = wsc.ctx.getContextAsInt(windowNo, "M_Warehouse_ID");
			int M_PriceList_ID = wsc.ctx.getContextAsInt(windowNo, "M_PriceList_ID");
			searchInfoFormProduct.statInit(wsc.ctx);
			if (name != null && name.length() > 0) {
				name = "@" + name + "@";   //  Name indicator - otherwise Value
				doQurey = "1";
			}
			searchInfoFormProduct.initInfo(name, M_PriceList_ID, M_Warehouse_ID, wsc.ctx, windowNo);

			// Set search info form
			searchInfoFormProduct.setTitle("製品情報");//clmg 2009/03/06
			session.setAttribute("searchInfoFormProduct", searchInfoFormProduct);
			session.setAttribute("warehouseListProduct", searchInfoFormProduct.getWarehouseList());
			session.setAttribute("priceListProduct", searchInfoFormProduct.getPriceList());
		}

		request.setAttribute("doQuery", doQurey);
	    return mapping.findForward("success");
	}
}
