package com.ampiere.web.struts.search;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.table.DefaultTableModel;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.ScheduleUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.WebSessionCtx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;
import com.jware.util.DateUtils;
import com.jware.util.StringToIntConverter;

/**
 * @author clmg
 */
public class InfoSchedule extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());    
    
    /** SUCCESS FORWARD. */
    private static final String SUCCESS = "success";

    /** Action Form. */
    private static final String ACTION_FORM = "InfoScheduleForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";
    
    private String M_MASSIGNMENT = "m_mAssignment";
    
    String RESOURCE_TYPE = "RESOURE_TYPE";
    String RESOURCE = "RESOURE";
    
	String ACTION_RESOURE_TYPE = "1";
	String ACTION_RESOURE = "2";
	String ACTION_PREV = "3";
	String ACTION_NEXT = "4";
	String ACTION_TAB = "5";
	String ACTION_DATE = "6";
	
	String DAY = "day";
	String WEEK = "week";
	String MONTH = "month";
	String TAB_INDEX = "tabIndex";
	String TAB_DAY = "0";
	String TAB_WEEK = "1";
	String TAB_MONTH = "2";
    

	
    /**
     * Action execute.
     * @param mapping mapping
     * @param actionForm actionForm
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm actionForm,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
	  	WWindowStatus ws = WWindowStatus.get(request);
	  	HttpSession session = request.getSession();

		String doQurey = "0";
		
		
		if (wsc == null) {
			log.log(Level.SEVERE, "Session Time Out.");
			return mapping.findForward(ERROR_FORWARD);
		}

		InfoScheduleForm infoScheduleForm =
			(InfoScheduleForm) request.getAttribute(ACTION_FORM);
		if (infoScheduleForm == null) {
			infoScheduleForm = (InfoScheduleForm) infoScheduleForm;
			if (infoScheduleForm == null) {
				infoScheduleForm = new InfoScheduleForm();
			}
		}
		infoScheduleForm.statInit(wsc.ctx);
		
		MResourceAssignment m_mAssignment = new MResourceAssignment(wsc.ctx, 0, null); 
		session.setAttribute(M_MASSIGNMENT, m_mAssignment);
		
		String actionType = request.getParameter(Constants.ACTION_TYPE);
		//actions below
		if(ACTION_RESOURE_TYPE.equals(actionType)){
			request.setAttribute(RESOURCE_TYPE, request.getParameter("resourceType"));
			List<KeyNamePair> resourceList = getResourceList(request);
			setResourceIdAttribute(request, resourceList);
			Document xml_doc = getCalendarXml(request);
			xml_doc = addResourceList(request, xml_doc, resourceList);
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}
		else if(ACTION_RESOURE.equals(actionType)){
			Document xml_doc = getCalendarXml(request);
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}		
		else if(ACTION_PREV.equals(actionType)){
			return null;
		}
		else if(ACTION_NEXT.equals(actionType)){
			return null;
		}
		else if(ACTION_TAB.equals(actionType)){
			Document xml_doc = getCalendarXml(request);
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}
		
		List<KeyNamePair> resourceTypeList = getResourceTypeList(request);
		request.setAttribute("resourceTypeList", resourceTypeList);
		
		List<KeyNamePair> resourceList = getResourceList(request);
		request.setAttribute("resourceList", resourceList);
		
		table resultTable = getCalendarTable(request);
		String html = resultTable.toString();
		infoScheduleForm.setScheduleHtml(html);
		
		//default date
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		Date today = calendar.getTime();
		Timestamp date = new Timestamp(today.getTime());
		infoScheduleForm.setDate(wsc.dateFormat.format(date));
		
		request.setAttribute(ACTION_FORM, infoScheduleForm);
		return mapping.findForward("success");
    }

	/**
	 * 	Fill Resource Type (one time)
	 */
	private List<KeyNamePair> getResourceTypeList(HttpServletRequest request)
	{
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
	  	WWindowStatus ws = WWindowStatus.get(request);
	  	HttpSession session = request.getSession();
		MResourceAssignment m_mAssignment = (MResourceAssignment)session.getAttribute(M_MASSIGNMENT);
		List<KeyNamePair> resourceTypeList = new ArrayList();
		//	Get ResourceType of selected Resource
		int S_ResourceType_ID = 0;
		if (m_mAssignment != null && m_mAssignment.getS_Resource_ID() != 0)
		{
			String sql = "SELECT S_ResourceType_ID FROM S_Resource WHERE S_Resource_ID=?";
			try
			{
				PreparedStatement pstmt = DB.prepareStatement(sql, null);
				pstmt.setInt(1, m_mAssignment.getS_Resource_ID());
				ResultSet rs = pstmt.executeQuery();
				if (rs.next())
					S_ResourceType_ID = rs.getInt(1);
				rs.close();
				pstmt.close();
			}
			catch (SQLException e)
			{
				log.log(Level.SEVERE, sql, e);
			}
		}

		//	Get Resource Types
		String sql = MRole.getDefault(wsc.ctx, true).addAccessSQL(
			"SELECT S_ResourceType_ID, Name FROM S_ResourceType WHERE IsActive='Y' ORDER BY 2",
			"S_ResourceType", MRole.SQL_NOTQUALIFIED, MRole.SQL_RO);
		KeyNamePair defaultValue = null;
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
				if (S_ResourceType_ID == pp.getKey())
					defaultValue = pp;
				resourceTypeList.add(pp);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		
		return resourceTypeList;
	}	//	fillResourceType
	
	/**
	 * 	Fill Resource Pick from Resource Type
	 */
	private List<KeyNamePair> getResourceList(HttpServletRequest request)
	{
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
	  	WWindowStatus ws = WWindowStatus.get(request);
	  	HttpSession session = request.getSession();	
	  	List<KeyNamePair> resourceList = new ArrayList();
	  	
		//	Get Resource Type
		int S_ResourceType_ID = getResourceTypeId(request);
		
		KeyNamePair pp;
		KeyNamePair defaultValue = null;

		//	Load Resources
		String sql = "SELECT S_Resource_ID, Name FROM S_Resource WHERE S_ResourceType_ID=? ORDER BY 2";
		try
		{
			PreparedStatement pstmt = DB.prepareStatement(sql, null);
			pstmt.setInt(1, S_ResourceType_ID);
			ResultSet rs = pstmt.executeQuery();
			while (rs.next())
			{
				pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
				resourceList.add(pp);
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException e)
		{
			log.log(Level.SEVERE, sql, e);
		}
		
		return resourceList;
	}	//	fillResource
	
	/**
	 * 	Display Calendar for selected Resource, Time(day/week/month) and Date
	 */
	private Document getCalendarXml (HttpServletRequest request)
	{
	  	Document document = AmpiereUtil.CreateNewDocument(request);
	  	table calendarTable = getCalendarTable(request);
	  	
		String resultHtml = calendarTable.toString();
		List<String> resultList = new ArrayList();
		int unit = 2000;
		int beginIndex = 0;
		int endIndex = 0;
		String tempStr = "";
		
		while(resultHtml.length() > 0){
			if(resultHtml.length() + tempStr.length() < unit){
				resultList.add(tempStr + resultHtml);
				break;
			}
			endIndex = resultHtml.indexOf("<tr>") + "<tr>".length();
			String str1 = resultHtml.substring(beginIndex, endIndex);
			String str2 = resultHtml.substring(endIndex, resultHtml.length());
			tempStr += str1;
			if(tempStr.length() > unit){
				resultList.add(tempStr);
				tempStr = "";
			}
			resultHtml = str2;
		}
	  	
		//build document below
    	try{
    		for(int i=0; i<resultList.size(); i++){
        		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
    			document.getFirstChild().appendChild(element);

    			org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
    			String objId = Constants.DUMMY;
    			elm_id.appendChild(document.createTextNode(objId));
    			element.appendChild(elm_id);

    			org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
    			element.appendChild(elm_lookup);
    			elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

    			org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
    			element.appendChild(elm_visibility);
    			elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

    			org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
    			element.appendChild(elm_newValue);
    			elm_newValue.appendChild(document.createTextNode(resultList.get(i)));

    			org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
    			element.appendChild(elm_readonly);
    			elm_readonly.appendChild(document.createTextNode(Constants.NO));

    			org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
    			element.appendChild(elm_type);
    			elm_type.appendChild(document.createTextNode(Constants.HTML));
    		}
    	}catch(Exception e){
    		;
    	}		
		
    	document = addTabIndex(request, document);
		return document;

	}	//	displayCalendar
	
	private Document addTabIndex (HttpServletRequest request, Document document){		
		String tabIndex = request.getParameter(TAB_INDEX);
		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
		document.getFirstChild().appendChild(element);

		org.w3c.dom.Element elm_id=document.createElement(Constants.ID);
		String objId = Constants.DUMMY;
		elm_id.appendChild(document.createTextNode(objId));
		element.appendChild(elm_id);

		org.w3c.dom.Element elm_lookup=document.createElement(Constants.LOOKUP);
		element.appendChild(elm_lookup);
		elm_lookup.appendChild(document.createTextNode(Constants.DISABLED));

		org.w3c.dom.Element elm_visibility=document.createElement(Constants.VISIBILITY);
		element.appendChild(elm_visibility);
		elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

		org.w3c.dom.Element elm_newValue=document.createElement(Constants.NEW_VALUE);
		element.appendChild(elm_newValue);
		elm_newValue.appendChild(document.createTextNode(tabIndex));

		org.w3c.dom.Element elm_readonly=document.createElement(Constants.READONLY);
		element.appendChild(elm_readonly);
		elm_readonly.appendChild(document.createTextNode(Constants.NO));

		org.w3c.dom.Element elm_type=document.createElement(Constants.TYPE);
		element.appendChild(elm_type);
		elm_type.appendChild(document.createTextNode("tab"));
		
		return document;
	}
	
	/**
	 * 	Display Calendar for selected Resource, Time(day/week/month) and Date
	 */
	private table getCalendarTable (HttpServletRequest request)
	{
		WebSessionCtx wsc = WebSessionCtx.get(request);
	  	WWindowStatus ws = WWindowStatus.get(request);
	  	HttpSession session = request.getSession();
		//	Get Values
		int S_Resource_ID = getResourceId(request);
		
		if(S_Resource_ID == 0){
		  	table resultTable = new table("1", "0", "5", "auto", null);
		  	tr header = new tr();
		  	resultTable.addElement(header);
		  	
		  	return resultTable;
		}
		
		MResourceAssignment m_mAssignment = new MResourceAssignment(wsc.ctx, 0, null);
		m_mAssignment.setS_Resource_ID(S_Resource_ID);
		session.setAttribute(M_MASSIGNMENT, m_mAssignment);

		Timestamp date = null;
		String DateFrom = request.getParameter("date");
		if (!StringUtils.isEmpty(DateFrom))
		{
			try{					
				try{
					date = new Timestamp(wsc.dateFormat.parse(DateFrom).getTime());
				}catch (Exception e){
					date = null;
				}
			}catch(Exception e){
				;
			}
		}
		
		if(date == null){			
			Calendar calendar = Calendar.getInstance();
			calendar.set(Calendar.HOUR_OF_DAY, 0);
			calendar.set(Calendar.MINUTE, 0);
			calendar.set(Calendar.SECOND, 0);
			calendar.set(Calendar.MILLISECOND, 0);
			Date today = calendar.getTime();

			date = new Timestamp(today.getTime());
		}
		
		VSchedule.Period m_numDays = getPeriodType(request);//default
		ScheduleUtil m_model = new ScheduleUtil(wsc.ctx);
		
		Calendar s_calendar = Calendar.getInstance(Language.getLoginLanguage().getLocale());
		s_calendar.setTime(date);
        s_calendar.set(Calendar.HOUR, 0);
        s_calendar.set(Calendar.MINUTE, 0);
        s_calendar.set(Calendar.SECOND, 0);
        s_calendar.set(Calendar.MILLISECOND, 0);
		if (m_numDays == VSchedule.Period.WEEK)
            s_calendar.set(Calendar.DAY_OF_WEEK, s_calendar.getFirstDayOfWeek());
		else if (m_numDays == VSchedule.Period.MONTH)
            s_calendar.set(Calendar.DAY_OF_MONTH, 1);
		Timestamp m_startDate = new Timestamp(s_calendar.getTimeInMillis());
		
		//	Calculate End Date
        s_calendar.add(m_numDays.type(), 1);
        Timestamp m_endDate = new Timestamp (s_calendar.getTimeInMillis());
		
		log.config("(" + m_numDays + ") Resource_ID=" + S_Resource_ID + ": " + m_startDate + "->" + m_endDate);
        
		//	Create Slots
		MAssignmentSlot[] mas =
            m_model.getAssignmentSlots(S_Resource_ID, m_startDate, m_endDate, null, true, null);
		MAssignmentSlot[] mts = m_model.getDayTimeSlots();
		
		//	Set Panels
		VSchedulePanel schedulePanel = new VSchedulePanel();
		schedulePanel.setAssignmentSlots(mas, mts, S_Resource_ID, m_startDate, m_numDays);
		DefaultTableModel model = (DefaultTableModel)schedulePanel.getModel();
		Vector dataVector = model.getDataVector();
		
	  	table resultTable = new table("1", "0", "5", "auto", null);
	  	tr header = new tr();
	  	resultTable.addElement(header);
	  	header.addElement(new td());
	  	
		Vector head_columns = (Vector)dataVector.get(0);
		for(int x = 0; x < head_columns.size(); x++){
			td headTd = new td();
			header.addElement(headTd);
			Timestamp t = (Timestamp)head_columns.get(x);
			headTd.addElement(wsc.dateFormat.format(t));
		}
	  	
		for(int i = 0; i < dataVector.size(); i++){
			tr oneTr = new tr();
			resultTable.addElement(oneTr);
			Vector columns = (Vector)dataVector.get(i);
			for(int j = 0; j < columns.size(); j++){
				Timestamp t = (Timestamp)columns.get(j);
				if(j == 0){
					td hourTd = new td();
					oneTr.addElement(hourTd);
					hourTd.addElement(DateUtils.getHours(t) + ":" + DateUtils.getMinutes(t));
				}
				td oneTd = new td();
				oneTr.addElement(oneTd);				
				oneTd.addElement(getAssignmentText(mas, t));
			}
		}
	  	
	  	for(int i = 0; i < mts.length; i++){
	  		tr oneTr = new tr();
	  		MAssignmentSlot onSlot = mts[i];
	  		String name = onSlot.getName();
	  	}
		
		return resultTable;
	}	//	displayCalendar	
	
	String getAssignmentText(MAssignmentSlot[] mts, Timestamp t){
		String ret = "";
		for(int i = 0; i < mts.length; i++){
			MAssignmentSlot assignment = mts[i];
			if(t.compareTo(assignment.getStartTime()) >= 0 
					&& t.compareTo(assignment.getEndTime()) < 0 ){
				ret = assignment.getName();
				break;
			}
		}
		
		return ret;
	}
	
	private Document addResourceList (HttpServletRequest request, Document document, List<KeyNamePair> resourceList){
		org.w3c.dom.Element element = document.createElement(Constants.ELEMENT);
		document.getFirstChild().appendChild(element);

		Element elm_id=document.createElement(Constants.ID);
		elm_id.appendChild(document.createTextNode("resource"));
		element.appendChild(elm_id);

		Element elm_lookup=document.createElement(Constants.LOOKUP);
		element.appendChild(elm_lookup);
		elm_lookup.appendChild(document.createTextNode(Constants.ENABLED));

		Element elm_visibility=document.createElement(Constants.VISIBILITY);
		element.appendChild(elm_visibility);
		elm_visibility.appendChild(document.createTextNode(Constants.ENABLED));

		Element elm_newValue=document.createElement(Constants.NEW_VALUE);
		element.appendChild(elm_newValue);

		for(int p=0; p<resourceList.size(); p++){

			KeyNamePair pair = resourceList.get(p);
			String key = String.valueOf(pair.getKey());
			String value = pair.getName();

			//list
			//<name>
			Element elm_item=document.createElement(Constants.ITEM);
			elm_newValue.appendChild(elm_item);
			//<key>
			Element elm_key=document.createElement(Constants.KEY);
			elm_item.appendChild(elm_key);
			elm_key.appendChild(document.createTextNode(String.valueOf(key)));
			//<value>
			Element elm_value=document.createElement(Constants.VALUE);
			elm_item.appendChild(elm_value);
			elm_value.appendChild(document.createTextNode(value));
		}

		Element elm_readonly=document.createElement(Constants.READONLY);
		element.appendChild(elm_readonly);
		elm_readonly.appendChild(document.createTextNode(Constants.NO));

		Element elm_type=document.createElement(Constants.TYPE);
		element.appendChild(elm_type);
		elm_type.appendChild(document.createTextNode(Constants.ENABLED));		
		
		return document;
	}	

    
    VSchedule.Period getPeriodType(HttpServletRequest request){
    	VSchedule.Period Type = VSchedule.Period.DAY;
    	String tab_str = request.getParameter(TAB_INDEX);
    	if(TAB_WEEK.equals(tab_str)){
    		Type = VSchedule.Period.WEEK;
    	}else if(TAB_MONTH.equals(tab_str)){
    		Type = VSchedule.Period.MONTH;
    	}
	  	return Type;
    }
    
    int getResourceTypeId(HttpServletRequest request){
    	int S_ResourceType_ID = 0;
    	S_ResourceType_ID = StringToIntConverter.StringToInt(request.getParameter("resourceType"));
    	if(S_ResourceType_ID == 0){
    		String rt_attr = (String)request.getAttribute(RESOURCE_TYPE);
    		S_ResourceType_ID = StringToIntConverter.StringToInt(rt_attr);
    	}
    	if(S_ResourceType_ID == 0){
    		if(S_ResourceType_ID == 0){
    			List<KeyNamePair> resourceTypeList = (List<KeyNamePair>)request.getAttribute("resourceTypeList");
    			if(resourceTypeList != null && resourceTypeList.size() > 0){
    				S_ResourceType_ID = resourceTypeList.get(0).getKey();
    			}			
    		}
    	}
    	return S_ResourceType_ID;
    }

    int getResourceId(HttpServletRequest request){
    	int S_Resource_ID = 0;
    	if(S_Resource_ID == 0){
    		String re_attr = (String)request.getAttribute(RESOURCE);
    		S_Resource_ID = StringToIntConverter.StringToInt(re_attr);			
    	}
    	if(S_Resource_ID == 0){
    		S_Resource_ID = StringToIntConverter.StringToInt(request.getParameter("resource"));
    	}    	
    	if(S_Resource_ID == 0){
    		List<KeyNamePair> resourceList = (List<KeyNamePair>)request.getAttribute("resourceList");
    		if(resourceList != null && resourceList.size() > 0){
    			S_Resource_ID = resourceList.get(0).getKey();
    		}			
    	}
    	return S_Resource_ID;
    }
    
    void setResourceIdAttribute(HttpServletRequest request, List<KeyNamePair> resourceList){
    	if(resourceList != null && resourceList.size() > 0){
    		int S_Resource_ID =  resourceList.get(0).getKey();
    		request.setAttribute(RESOURCE, String.valueOf(S_Resource_ID));
    	}
    }
    
    table getNullTable(){
	  	table resultTable = new table("1", "0", "5", "auto", null);
	  	tr header = new tr();
	  	resultTable.addElement(header.addElement(new td()));
	  	return resultTable;
    }

}
