package com.ampiere.web.struts.tools;

import java.util.logging.Level;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MChat;
import org.compiere.model.MChatEntry;
import org.compiere.util.CLogger;
import org.compiere.util.WebSessionCtx;
import org.w3c.dom.Document;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.Constants;
import com.ampiere.web.servlet.WWindowStatus;

/**
 * @author clmg
 */
public class Chat extends Action {

    /** Logger. */
    private CLogger log = CLogger.getCLogger(this.getClass());    
    
    /** SUCCESS FORWARD. */
    private static final String SUCCESS = "success";

    /** Action Form. */
    private static final String ACTION_FORM = "ChatForm";

    /** Global Error Forward. */
    private static final String ERROR_FORWARD = "error";
    
	String ACTION_POST = "1";
	
	String MCHAT = "MCHAT";
	
    /**
     * Action execute.
     * @param mapping mapping
     * @param actionForm actionForm
     * @param request request
     * @param response response
     * @throws Exception Exception
     * @return ActionForward
     * @see org.apache.struts.action.Action#execute(
     *      org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    public final ActionForward execute(
            final ActionMapping mapping,
            final ActionForm actionForm,
            final HttpServletRequest request,
            final HttpServletResponse response)
    throws Exception {
    	
        WebSessionCtx wscTest = WebSessionCtx.get(request); 
        if (wscTest == null) {
            log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute(Constants.SESSION_TIMEOUT_INFO, "Session Time Out. Please login again.");
            return mapping.findForward(Constants.SESSION_TIMEOUT);
        }
        
	  	WebSessionCtx wsc = WebSessionCtx.get(request);
	  	WWindowStatus ws = WWindowStatus.get(request);
	  	HttpSession session = request.getSession();

		String doQurey = "0";
		
		
		if (wsc == null) {
			log.log(Level.SEVERE, "Session Time Out.");
			return mapping.findForward(ERROR_FORWARD);
		}

		ChatForm chatForm =
			(ChatForm) request.getAttribute(ACTION_FORM);
		if (chatForm == null) {
			chatForm = (ChatForm) chatForm;
			if (chatForm == null) {
				chatForm = new ChatForm();
			}
		}
		chatForm.statInit(wsc.ctx);
		
		int CM_Chat_ID = ws.getCurTab().getCM_ChatID();
		MChat m_chat = null;
		String Description = getDescription(ws.getCurTab());
		
		if(ws.getCurTab().getRecord_ID() == -1){
			return null;
		}
		
		//	Create Model
		if (CM_Chat_ID == 0)
			m_chat = new MChat (ws.ctx, ws.getCurTab().getAD_Table_ID(), ws.getCurTab().getRecord_ID(), Description, null);
		else
			m_chat = new MChat (ws.ctx, CM_Chat_ID, null);
		
		session.setAttribute(MCHAT, m_chat);
		
		ws.getCurTab().loadChats();
		
		String chartHistory = getChatText(m_chat);

		String actionType = request.getParameter(Constants.ACTION_TYPE);
		//actions below
		if(ACTION_POST.equals(actionType)){
			String inputText = request.getParameter("text");
			inputText = AmpiereUtil.sanitizing(inputText);
			Document xml_doc = actionChart(request);
			AWebUtil.createCalloutAjaxResponse(response, xml_doc);
			return null;
		}
		
		chatForm.setHistory(chartHistory);
		request.setAttribute(ACTION_FORM, chatForm);
		return mapping.findForward("success");
    }
    
    String getDescription(GridTab m_curTab){
		String infoName = null;
		String infoDisplay = null;
		for (int i = 0; i < m_curTab.getFieldCount(); i++)
		{
			GridField field = m_curTab.getField(i);
			if (field.isKey())
				infoName = field.getHeader();
			if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo") )
				&& field.getValue() != null)
				infoDisplay = field.getValue().toString();
			if (infoName != null && infoDisplay != null)
				break;
		}
		String description = infoName + ": " + infoDisplay;
		return description;
    }
    
	/**
	 * 	Load Chat
	 */
	private String getChatText(MChat m_chat)
	{
		String text = m_chat.getHistory(MChat.CONFIDENTIALTYPE_Internal).toString();
		return text;
	}	//	loadChat
	
	Document actionChart(HttpServletRequest request){
		HttpSession session = request.getSession();
		String data = request.getParameter("text");
		if (data != null && data.length() > 0)
		{
			log.config(data);
			MChat m_chat = (MChat)session.getAttribute(MCHAT);
			if (m_chat.get_ID() == 0)
				m_chat.save();
			MChatEntry entry = new MChatEntry(m_chat, data);
			entry.save();
			session.setAttribute(MCHAT, m_chat);
		}	//	data to be saved
		
		Document document = AmpiereUtil.getCloseWindowScript(request);
		return document;
	}

}
