package com.jware.apps.scheduler.web.struts.schedule;

import java.text.ParseException;
import java.util.Date;

import org.apache.struts.validator.ValidatorForm;

import com.jware.apps.scheduler.util.JobSchedulerUtils;

/**
 * @author Jrmt
 */
public class JobUITriggerForm extends ValidatorForm {
	
	private String startTime;
	private String stopTime;
	
	private String triggerName;
	private String triggerGroup;
	private String jobName;
	private String jobGroup;
	private String description;

	private Integer[] years;
	private Integer[] months;
	private Integer[] daysOfMonth;
	private Integer[] daysOfWeek;

	private Integer[] hours;
	private Integer[] minutes;
	private Integer[] seconds;
	
	public JobUITriggerForm() {
	}
	
	/**
	 * @return Returns the daysOfMonth.
	 */
	public Integer[] getDaysOfMonth() {
		return daysOfMonth;
	}
	/**
	 * @param daysOfMonth The daysOfMonth to set.
	 */
	public void setDaysOfMonth(Integer[] daysOfMonth) {
		this.daysOfMonth = daysOfMonth;
	}
	/**
	 * @return Returns the daysOfWeek.
	 */
	public Integer[] getDaysOfWeek() {
		return daysOfWeek;
	}
	/**
	 * @param daysOfWeek The daysOfWeek to set.
	 */
	public void setDaysOfWeek(Integer[] daysOfWeek) {
		this.daysOfWeek = daysOfWeek;
	}
	/**
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return Returns the hours.
	 */
	public Integer[] getHours() {
		return hours;
	}
	/**
	 * @param hours The hours to set.
	 */
	public void setHours(Integer[] hours) {
		this.hours = hours;
	}
	/**
	 * @return Returns the jobGroup.
	 */
	public String getJobGroup() {
		return jobGroup;
	}
	/**
	 * @param jobGroup The jobGroup to set.
	 */
	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}
	/**
	 * @return Returns the jobName.
	 */
	public String getJobName() {
		return jobName;
	}
	/**
	 * @param jobName The jobName to set.
	 */
	public void setJobName(String jobName) {
		this.jobName = jobName;
	}
	/**
	 * @return Returns the minute.
	 */
	public Integer[] getMinutes() {
		return minutes;
	}
	/**
	 * @param minute The minute to set.
	 */
	public void setMinutes(Integer[] minutes) {
		this.minutes = minutes;
	}
	/**
	 * @return Returns the months.
	 */
	public Integer[] getMonths() {
		return months;
	}
	/**
	 * @param months The months to set.
	 */
	public void setMonths(Integer[] months) {
		this.months = months;
	}
	/**
	 * @return Returns the second.
	 */
	public Integer[] getSeconds() {
		return seconds;
	}
	/**
	 * @param second The second to set.
	 */
	public void setSeconds(Integer[] seconds) {
		this.seconds = seconds;
	}
	/**
	 * @return Returns the triggerGroup.
	 */
	public String getTriggerGroup() {
		return triggerGroup;
	}
	/**
	 * @param triggerGroup The triggerGroup to set.
	 */
	public void setTriggerGroup(String triggerGroup) {
		this.triggerGroup = triggerGroup;
	}
	/**
	 * @return Returns the triggerName.
	 */
	public String getTriggerName() {
		return triggerName;
	}
	/**
	 * @param triggerName The triggerName to set.
	 */
	public void setTriggerName(String triggerName) {
		this.triggerName = triggerName;
	}
	/**
	 * @return Returns the years.
	 */
	public Integer[] getYears() {
		return years;
	}
	/**
	 * @param years The years to set.
	 */
	public void setYears(Integer[] years) {
		this.years = years;
	}

	/**
	 * @return Returns the startTime.
	 */
	public String getStartTime() {
		return startTime;
	}
	/**
	 * @param startTime The startTime to set.
	 */
	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}
	/**
	 * @return Returns the stopTime.
	 */
	public String getStopTime() {
		return stopTime;
	}
	/**
	 * @param stopTime The stopTime to set.
	 */
	public void setStopTime(String stopTime) {
		this.stopTime = stopTime;
	}

	public Date getStartTimeAsDate() throws ParseException {
		return JobSchedulerUtils.parseStringToDate(startTime);
	}

	public Date getStopTimeAsDate() throws ParseException {
		return JobSchedulerUtils.parseStringToDate(stopTime);
	}

}
