/*
 * Created on 2004/08/10
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.jware.base.web.struts;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.TilesRequestProcessor;

import com.jware.util.string.StringConverter;

/**
 * @author jrmt
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class jWareRequestProcessor extends TilesRequestProcessor {

	static final String REQUEST_PROCESSOR_FIELD_MAP = "RequestProcessorFieldMap"; 

	static final String RPROCESS_NONE = "NONE"; 
	static final String RPROCESS_STRIP = "STRIP"; 
	static final String RPROCESS_TRIM = "TRIM"; 
	static final String RPROCESS_ZENKAKU = "ZENKAKU"; 
	static final String RPROCESS_HANKAKU = "HANKAKU"; 
	static final String RPROCESS_ZENKANA = "ZENKANA"; 
	static final String RPROCESS_HANKANA = "HANKANA"; 
	static final String RPROCESS_KATAKANA = "KATAKANA"; 
	static final String RPROCESS_HIRAKANA = "HIRAKANA"; 
	static final String RPROCESS_HANKAKUSP = "HANKAKUSP"; 
	static final String RPROCESS_ZENKAKUSP = "ZENKAKUSP"; 

	private final Log log = LogFactory.getLog(getClass());

	/**
	 * 
	 */
	public jWareRequestProcessor() {

		super();

		if( log.isDebugEnabled() ){
			log.debug( " MochaRequestProcessor Constructor................... " );
		}

	}


	/* (non-Javadoc)
	 * @see org.apache.struts.action.RequestProcessor#process(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
		
		HashMap fieldMap = (HashMap)super.getServletContext().getAttribute(REQUEST_PROCESSOR_FIELD_MAP);
		
		if( fieldMap == null ) {
			
			fieldMap = new HashMap();
			
			String propFileName = super.getServletContext().getInitParameter("RequestProcessorProperties");

			if( log.isDebugEnabled() ){
				log.debug( " RequestProcessorProperties propFileName = " + propFileName );
			}

			boolean defaultExist = false;
			try {
				if( propFileName != null && propFileName.trim().length() > 0 ) {
					
					ResourceBundle propeties = ResourceBundle.getBundle( propFileName );
					
					if( propeties != null ) {
						
						Enumeration fieldNames = propeties.getKeys();
						while ( fieldNames != null && fieldNames.hasMoreElements() ) {
	
							String fieldName = (String)fieldNames.nextElement();
							if( log.isDebugEnabled() ){
								log.debug( " RequestProcessorProperties fieldName = " + fieldName );
							}
							
							String fieldSetting = propeties.getString( fieldName );
	
							if( log.isDebugEnabled() ){
								log.debug( " RequestProcessorProperties fieldSetting = " + fieldSetting );
							}
	
							fieldMap.put(fieldName, fieldSetting);

							if( "default".equalsIgnoreCase(fieldName)){
								defaultExist = true;
							}
															 						
						}
					} 
				}
						
			} catch ( Exception e ) {
				
				if( log.isDebugEnabled() ){
					log.debug( " Reading RequestProcessorProperties Exception " + e.getMessage() );
				}
				
			}
			
			if( defaultExist == false ){
				fieldMap.put("default", "NONE" );
			}
			
			super.getServletContext().setAttribute(REQUEST_PROCESSOR_FIELD_MAP, fieldMap );

		}

		Map map = request.getParameterMap();
		Enumeration enumPara = request.getParameterNames();
		
		while( enumPara.hasMoreElements() ){

			Object objName = enumPara.nextElement();
			if( log.isDebugEnabled() ){
				log.debug( objName.toString()+ "= : " );
			}
			
			String fieldSettings = (String)fieldMap.get( objName );
			if( fieldSettings == null || fieldSettings.length() == 0 ){
				fieldSettings = (String)fieldMap.get( "default" );			
			}
			
			String[] objValue = (String[])map.get(objName);
			
			for(int i=0; i<objValue.length; i++ ){
				
				if( log.isDebugEnabled() ){
					log.debug( "Before("+String.valueOf( i ) + ")= : [" + objValue[i] + "]");
				}
				
				if( log.isDebugEnabled() ){
					log.debug( "Processing("+fieldSettings + ")");
				}
				String[] fieldSettingArray = fieldSettings.split(",");
				int arrayLength = fieldSettingArray.length;
				for(int l=0; l<arrayLength; l++ ){			

					String fieldSetting = fieldSettingArray[l].trim();

					if( RPROCESS_NONE.equalsIgnoreCase(fieldSetting) ){
						// #NONE  = 何もしない、defaultの設定無しの場合はNONEになる
						continue;
						
					} else if ( RPROCESS_STRIP.equalsIgnoreCase(fieldSetting) ){
						// #STRIP = 前のスペースを取る　*
						String strValue = objValue[i];
						strValue = StringUtils.strip( strValue );
						objValue[i] = strValue;
						
					} else if ( RPROCESS_TRIM.equalsIgnoreCase(fieldSetting) ){
						// #TRIM  = 後ろのスペースを取る *
						String strValue = objValue[i];
						strValue = strValue.trim();
						objValue[i] = strValue;
						
					} else if ( RPROCESS_ZENKAKU.equalsIgnoreCase(fieldSetting) ){
						// #ZENKAKU  = 半角英数字記号を全角に変換する
						String strValue = objValue[i];
						objValue[i] = StringConverter.hankaku2Zenkaku(strValue);
						
					} else if ( RPROCESS_HANKAKU.equalsIgnoreCase(fieldSetting) ){
						// #HANKAKU  = 全角英数字記号を半角に変換する *
						String strValue = objValue[i];
						objValue[i] = StringConverter.zenkaku2Hankeku(strValue);
						
					} else if ( RPROCESS_ZENKANA.equalsIgnoreCase(fieldSetting) ){
						// #ZENKANA  = 半角のカタカナを全角カタカナに変換する *
						String strValue = objValue[i];
						objValue[i] = StringConverter.HankakuKatakana2katakana(strValue);
						
					} else if ( RPROCESS_KATAKANA.equalsIgnoreCase(fieldSetting) ){
						// #KATAKANA = 平仮名を全角カタカナに変換する *
						String strValue = objValue[i];
						objValue[i] = StringConverter.hiragana2Katakana(strValue);
						
					} else if ( RPROCESS_HIRAKANA.equalsIgnoreCase(fieldSetting) ){
						// #HIRAKANA = 全角のカタカナを平仮名に変換する
						String strValue = objValue[i];
						objValue[i] = StringConverter.katakana2Hiragana(strValue);
						
					} else if ( RPROCESS_HANKAKUSP.equalsIgnoreCase(fieldSetting) ){
						// #HANKAKUSP = 全角スペースを半角に変換する　*
						String strValue = objValue[i];
						if( strValue != null ){
							objValue[i] = strValue.replace((char)0x8140, ' ' );
						}
						
					} else if ( RPROCESS_ZENKAKUSP.equalsIgnoreCase(fieldSetting) ){
						// #ZENKAKUSP = 半角スペースを全角に変換する　*
						String strValue = objValue[i];
						if( strValue != null ){
							objValue[i] = strValue.replace(' ', (char)0x8140 );
						}
						
					}

				}

				if( log.isDebugEnabled() ){
					log.debug( "After("+String.valueOf( i ) + ")= : [" + objValue[i] +"]");
				}
				
			}
			
		}
		
		return(super.processPreprocess(request, response));
		
	}

}
