/*  protocalendar.js
 *  (c) 2009 Spookies
 * 
 *  License : MIT-style license.
 *  Web site: http://labs.spookies.jp/product/protocalendar
 *
 *  protocalendar.js - depends on prototype.js 1.6 or later
 *  http://www.prototypejs.org/
 */
var ProtoCalendar=Class.create();ProtoCalendar.Version="1.1.8.2";ProtoCalendar.LangFile=new Object();ProtoCalendar.LangFile.en={HOUR_MINUTE_ERROR:"The time is not valid.",NO_DATE_ERROR:"No day has been selected.",OK_LABEL:"OK",DEFAULT_FORMAT:"mm/dd/yyyy",LABEL_FORMAT:"ddd mm/dd/yyyy",MONTH_ABBRS:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],MONTH_NAMES:["January","February","March","April","May","June","July","August","September","October","November","December"],YEAR_LABEL:" ",MONTH_LABEL:" ",WEEKDAY_ABBRS:["Sun","Mon","Tue","Wed","Thr","Fri","Sat"],WEEKDAY_NAMES:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],YEAR_AND_MONTH:false};ProtoCalendar.LangFile.defaultLang="en";ProtoCalendar.LangFile.defaultLangFile=function(){return ProtoCalendar.LangFile[defaultLang]};ProtoCalendar.newDate=function(){var a=new Date();a.setDate(1);return a};ProtoCalendar.withinViewport=function(c){var f=ProtoCalendar.callWithVisibility(c,function(){return c.getDimensions()});var d=f.width;var b=f.height;var e=ProtoCalendar.callWithVisibility(c,function(){return c.viewportOffset()});var a=e.left;var g=e.top;return(g>=0)&&(g+b<=document.viewport.getHeight())};ProtoCalendar.callWithVisibility=function(d,f){d=$(d);var h=$(d).getStyle("display");if(h!="none"&&h!=null){return f()}var c=d.style;var g=c.visibility;var e=c.position;var b=c.display;c.visibility="hidden";c.position="absolute";c.display="block";var a=f();c.display=b;c.position=e;c.visibility=g;return a};Object.extend(ProtoCalendar,{JAN:0,FEB:1,MAR:2,APR:3,MAY:4,JUNE:5,JULY:6,AUG:7,SEPT:8,OCT:9,NOV:10,DEC:11,SUNDAY:0,MONDAY:1,TUESDAY:2,WEDNESDAY:3,THURSDAY:4,FRIDAY:5,SATURDAY:6,getNumDayOfMonth:function(a,b){return 32-new Date(a,b,32).getDate()},getDayOfWeek:function(b,c,a){return new Date(b,c,a).getDay()}});ProtoCalendar.prototype={initialize:function(c){var b=ProtoCalendar.newDate();this.options=Object.extend({month:b.getMonth(),year:b.getFullYear(),lang:ProtoCalendar.LangFile.defaultLang},c||{});var a=ProtoCalendar.LangFile[this.options.lang]["getHolidays"];if(a){this.initializeHolidays=a.bind(top,this)}else{this.initializeHolidays=function(){this.holidays=[]}}this.date=new Date(this.options.year,this.options.month,1)},getMonth:function(){return this.date.getMonth()},getYear:function(){return this.date.getFullYear()},invalidate:function(){this.holidays=undefined},setMonth:function(a){if(a!=this.getMonth()){this.invalidate()}return this.date.setMonth(a)},setYear:function(a){if(a!=this.getYear()){this.invalidate()}return this.date.setFullYear(a)},getDate:function(){return this.date},setDate:function(a){this.invalidate();this.date=a},setYearByOffset:function(a){if(a!=0){this.invalidate()}this.date.setFullYear(this.date.getFullYear()+a)},setMonthByOffset:function(a){if(a!=0){this.invalidate()}this.date.setMonth(this.date.getMonth()+a)},getNumDayOfMonth:function(){return ProtoCalendar.getNumDayOfMonth(this.getYear(),this.getMonth())},getDayOfWeek:function(a){return ProtoCalendar.getDayOfWeek(this.getYear(),this.getMonth(),a)},clone:function(){return new ProtoCalendar({year:this.getYear(),month:this.getMonth()})},getHoliday:function(a){if(!this.holidays){this.initializeHolidays()}var b=this.holidays[a];return b?b:false},initializeHolidays:function(){}};var AbstractProtoCalendarRender=Class.create();Object.extend(AbstractProtoCalendarRender,{id:1,WEEK_DAYS_SUNDAY:[0,1,2,3,4,5,6],WEEK_DAYS_MONDAY:[1,2,3,4,5,6,0],WEEK_DAYS_INDEX_SUNDAY:[0,1,2,3,4,5,6],WEEK_DAYS_INDEX_MONDAY:[6,0,1,2,3,4,5],getId:function(){var a=AbstractProtoCalendarRender.id;AbstractProtoCalendarRender.id+=1;return a}});AbstractProtoCalendarRender.prototype={initialize:function(a){this.id=AbstractProtoCalendarRender.getId();this.options=Object.extend({weekFirstDay:ProtoCalendar.MONDAY,containerClass:"cal-container",tableClass:"cal-table",headerTopClass:"cal-header-top",headerClass:"cal-header",headerBottomClass:"cal-header-bottom",bodyTopClass:"cal-body-top",bodyClass:"cal-body",bodyBottomClass:"cal-body-bottom",bodyId:this.getIdPrefix()+"-body",footerTopClass:"cal-footer-top",footerClass:"cal-footer",footerBottomClass:"cal-footer-bottom",footerId:this.getIdPrefix()+"-footer",yearSelectClass:"cal-select-year",yearSelectId:this.getIdPrefix()+"-select-year",monthSelectClass:"cal-select-month",monthSelectId:this.getIdPrefix()+"-select-month",borderClass:"cal-border",hourMinuteInputClass:"cal-input-hour-minute",hourMinuteInputId:this.getIdPrefix()+"-input-hour-minute",hourInputClass:"cal-input-hour",hourInputId:this.getIdPrefix()+"-input-hour",minuteInputClass:"cal-input-minute",minuteInputId:this.getIdPrefix()+"-input-minute",secondInputClass:"cal-input-second",secondInputId:this.getIdPrefix()+"-input-second",okButtonClass:"cal-ok-button",okButtonId:this.getIdPrefix()+"-ok-button",errorDivClass:"cal-error-list",errorDivId:this.getIdPrefix()+"-error-list",labelRowClass:"cal-label-row",labelCellClass:"cal-label-cell",nextButtonClass:"cal-next-btn",prevButtonClass:"cal-prev-btn",dayCellClass:"cal-day-cell",dayClass:"cal-day",weekdayClass:"cal-weekday",sundayClass:"cal-sunday",saturdayClass:"cal-saturday",holidayClass:"cal-holiday",otherdayClass:"cal-otherday",disabledDayClass:"cal-disabled",selectedDayClass:"cal-selected",nextBtnId:this.getIdPrefix()+"-next-btn",prevBtnId:this.getIdPrefix()+"-prev-btn",lang:ProtoCalendar.LangFile.defaultLang,showEffect:"Appear",hideEffect:"Fade",ifInvisible:"Flip",scrollMargin:20},a||{});this.langFile=ProtoCalendar.LangFile[this.options.lang];this.weekFirstDay=this.options.weekFirstDay;this.initWeekData();this.container=this.createContainer();this.alignTo=$(this.options.alignTo);this.alignOrient="Below";if(navigator.appVersion.match(/\bMSIE\b/)){this.iframe=this.createIframe()}this.resizeHandler=this.setPosition.bind(this)},createContainer:function(){var a=$(document.createElement("div"));a.addClassName(this.options.containerClass);a.setStyle({position:"absolute",top:"0px",left:"0px",zindex:1,display:"none"});a.hide();document.body.appendChild(a);return a},createIframe:function(){var a=document.createElement("iframe");a.setAttribute("src","javascript:false;");a.setAttribute("frameBorder","0");a.setAttribute("scrolling","no");Element.setStyle(a,{position:"absolute",top:"0px",left:"0px",zindex:10,display:"none",overflow:"hidden",filter:"progid:DXImageTransform.Microsoft.Alpha(opacity=0)"});document.body.appendChild(a);return $(a)},getWeekdayLabel:function(a){return this.langFile.WEEKDAY_ABBRS[a]},getWeekdays:function(){return this.weekdays},initWeekData:function(){if(this.weekFirstDay==ProtoCalendar.SUNDAY){this.weekLastDay=ProtoCalendar.SATURDAY;this.weekdays=AbstractProtoCalendarRender.WEEK_DAYS_SUNDAY;this.weekdaysIndex=AbstractProtoCalendarRender.WEEK_DAYS_INDEX_SUNDAY}else{this.weekFirstDay==ProtoCalendar.MONDAY;this.weekLastDay=ProtoCalendar.SUNDAY;this.weekdays=AbstractProtoCalendarRender.WEEK_DAYS_MONDAY;this.weekdaysIndex=AbstractProtoCalendarRender.WEEK_DAYS_INDEX_MONDAY}},getCalendarBeginDay:function(b){var c=this.getDayIndexOfWeek(b,1);var a=new Date(b.getYear(),b.getMonth(),1-c);return a},getCalendarEndDay:function(c){var a=c.getNumDayOfMonth();var d=6-this.getDayIndexOfWeek(c,a);var b=new Date(c.getYear(),c.getMonth(),a+d+1);return b},getDayIndexOfWeek:function(b,a){return this.weekdaysIndex[b.getDayOfWeek(a)]},getIdPrefix:function(){return"cal"+this.id},getDayDivId:function(a){return this.getIdPrefix()+"-year"+a.getFullYear()+"-month"+a.getMonth()+"-day"+a.getDate()},setPosition:function(){if(!this.alignTo){return true}this.setAlignment(this.alignTo,this.container,this.alignOrient);var b=ProtoCalendar.withinViewport(this.container);if(!b&&this.options.ifInvisible=="Flip"){this.alignOrient=(this.alignOrient=="Above"?"Below":"Above");this.setAlignment(this.alignTo,this.container,this.alignOrient)}if(this.iframe){var a=Element.getDimensions(this.container);this.iframe.setAttribute("width",a.width);this.iframe.setAttribute("height",a.height);this.setAlignment(this.alignTo,this.iframe,this.alignOrient)}if(this.options.ifInvisible=="Scroll"){this.scrollIfInvisible()}return true},setAlignment:function(d,a,e){var c=Position.cumulativeOffset(d);a.setStyle({left:c[0]+"px"});if(e=="Above"){var b=ProtoCalendar.callWithVisibility(a,function(){return a.offsetHeight});a.setStyle({top:(c[1]-b)+"px"})}else{if(e=="Below"){a.setStyle({top:(c[1]+d.offsetHeight)+"px"})}else{}}},show:function(b){Event.observe(window,"resize",this.resizeHandler);this.setPosition();if(typeof Effect!="undefined"){var a=this.options.showEffect||"Appear";if(!this._effect||this._effect.state=="finished"){this._effect=new Effect[a](this.container,{duration:0.5})}}else{this.container.show()}if(this.iframe){this.iframe.show()}},scrollIfInvisible:function(){var c=this.container;var f=ProtoCalendar.callWithVisibility(c,function(){return c.getDimensions()});var d=f.width;var b=f.height;var e=ProtoCalendar.callWithVisibility(c,function(){return c.viewportOffset()});var a=e.left;var h=e.top;var g=h+b-document.viewport.getHeight();if(g>0){window.scrollBy(0,g+this.options.scrollMargin)}},hide:function(b){Event.stopObserving(window,"resize",this.resizeHandler);if(!this.container.visible()){return}if(typeof Effect!="undefined"){var a=this.options.hideEffect||"Fade";if(!this._effect||this._effect.state=="finished"){this._effect=new Effect[a](this.container,{duration:0.3})}}else{this.container.hide()}if(this.iframe){this.iframe.hide()}},hideImmediately:function(a){if(!this.container.visible()){return}this.container.hide();if(this.iframe){this.iframe.hide()}},toggle:function(a){this.container.visible()?this.hide():this.show()},render:function(a){},rerender:function(a){},getContainer:function(){return this.container},getPrevButton:function(){return $(this.options.prevBtnId)},getNextButton:function(){return $(this.options.nextBtnId)},getYearSelect:function(){return $(this.options.yearSelectId)},getMonthSelect:function(){return $(this.options.monthSelectId)},getHourInput:function(){return $(this.options.hourInputId)},getMinuteInput:function(){return $(this.options.minuteInputId)},getSecondInput:function(){return $(this.options.secondInputId)},getOkButton:function(){return $(this.options.okButtonId)},getBody:function(){return $(this.options.bodyId)},getDayDivs:function(){var b=[];var a=this.dayDivs;for(var c=0;c<a.length;c++){b.push(document.getElementById(a[c]))}return b},getDateFromEl:function(b){var a=$(b);return new Date(a.readAttribute("year"),a.readAttribute("month"),a.readAttribute("day"))},injectHourMinute:function(a){if(!a||isNaN(a.getTime())){return undefined}var b=new Date(a.getFullYear(),a.getMonth(),a.getDate());b.setHours(parseInt(this.getHourInput().value,10));b.setMinutes(this.getMinuteInput().value);if(this.options.enableSecond){b.setSeconds(this.getSecondInput().value)}return isNaN(b.getTime())?undefined:b},selectDate:function(a){var b=$(this.getDayDivId(a));if(b){b.addClassName(this.options.selectedDayClass)}},selectTime:function(a){if(!a){return}this.getHourInput().value=a.getHours();this.getMinuteInput().value=a.getMinutes();if(this.options.enableSecond){this.getSecondInput().value=a.getSeconds()}},deselectDate:function(b){if(b){var a=$(this.getDayDivId(b));if(a){a.removeClassName(this.options.selectedDayClass)}}},evaluateWithOptions:function(a){var b=new Template(a);return b.evaluate(this.options)},defaultOnError:function(a){this.ensureErrorDiv();this.errorDiv.show();this.errorDiv.innerHTML+="<li>"+this.langFile[a]+"</li>"},hideError:function(){this.ensureErrorDiv();this.errorDiv.innerHTML="";this.errorDiv.hide()},ensureErrorDiv:function(){if(!this.errorDiv){var a='<div class="#{errorDivClass}" id="#{errorDivId}"><ul></ul></div>';new Insertion.Before($(this.options.footerId),this.evaluateWithOptions(a));this.errorDiv=$(this.options.errorDivId)}},isSelectable:function(a){return(this.options.minDate-a)<=0&&(a-this.options.maxDate)<=0}};var ProtoCalendarRender=Class.create();Object.extend(ProtoCalendarRender.prototype,AbstractProtoCalendarRender.prototype);Object.extend(ProtoCalendarRender.prototype,{render:function(b){var a="";a+=this.renderHeader(b);a+='<div class="#{bodyTopClass}"></div><div class="#{bodyClass}" id="#{bodyId}">';a+='</div><div class="#{bodyBottomClass}"></div>';if(this.options.enableHourMinute){a+=this.renderHourMinute()}a+=this.renderFooter(b);this.container.innerHTML=this.evaluateWithOptions(a);this.rerender(b)},rerender:function(a){this.getBody().innerHTML=this.evaluateWithOptions(this.renderBody(a));SelectCalendar.selectOption(this.getMonthSelect(),a.getMonth());SelectCalendar.selectOption(this.getYearSelect(),a.getYear());if(this.container.visible()){this.setPosition()}},renderHeader:function(b){var a="";a+='<div class="#{headerTopClass}"></div><div class="#{headerClass}"><a href="#" id="#{prevBtnId}" class="#{prevButtonClass}">&lt;&lt;</a>'+this.createSelect(b.getYear(),b.getMonth())+'<a href="#" id="#{nextBtnId}" class="#{nextButtonClass}">&gt;&gt;</a></div><div class="#{headerBottomClass}"></div>';return a},renderFooter:function(a){return'<div class="#{footerTopClass}"></div><div class="#{footerClass}" id="#{footerId}"></div><div class="#{footerBottomClass}"></div>'},renderHourMinute:function(){if(!this.hourMinuteHtml){var a='<div class="#{borderClass}"></div><div id="#{hourMinuteInputId}" class="#{hourMinuteInputClass}">';a+='<input type="text" name="hour" size="2" maxlength="2" class="#{hourInputClass}" id="#{hourInputId}" />:<input type="text" name="minute" size="2" maxlength="2" class="#{minuteInputClass}" id="#{minuteInputId}" />';if(this.options.enableSecond){a+=':<input type="text" name="second" size="2" maxlength="2" class="#{secondInputClass}" id="#{secondInputId}"/>'}a+='<input type="button" value="'+this.langFile.OK_LABEL+'" class="#{okButtonClass}" name="ok_button" id="#{okButtonId}"/>';a+="</div>";this.hourMinuteHtml=a}return this.hourMinuteHtml},createSelect:function(c,d){var b=this.createYearSelect(c)+this.langFile.YEAR_LABEL;var a=this.createMonthSelect(d)+this.langFile.MONTH_LABEL;if(this.langFile.YEAR_AND_MONTH){return b+a}else{return a+b}},createYearSelect:function(b){var a="";a+='<select id="#{yearSelectId}" class="#{yearSelectClass}">';for(var d=this.options.startYear,c=this.options.endYear;d<=c;d+=1){a+='<option value="'+d+'"'+(d==b?" selected":"")+">"+d+"</option>"}a+="</select>";return a},createMonthSelect:function(c){if(!this.monthSelectHtml){var b="";b+='<select id="#{monthSelectId}" class="#{monthSelectClass}">';for(var a=ProtoCalendar.JAN;a<=ProtoCalendar.DEC;a+=1){b+='<option value="'+a+'"'+(a==c?" selected":"")+">"+this.langFile.MONTH_ABBRS[a]+"</option>"}b+="</select>";this.monthSelectHtml=b}return this.monthSelectHtml},renderBody:function(g){this.dayDivs=[];var j='<table class="#{tableClass}" cellspacing="0">';j+='<tr class="#{labelRowClass}">';var b=this;if(!this.headHtml){this.headHtml="";$A(this.getWeekdays()).each(function(m){var i="";if(m==ProtoCalendar.SUNDAY){i=" #{sundayClass}"}if(m==ProtoCalendar.SATURDAY){i=" #{saturdayClass}"}b.headHtml+='<th class="#{labelCellClass}'+i+'">'+b.getWeekdayLabel(m)+"</th>"})}j+=this.headHtml;var e=this.getCalendarBeginDay(g);var a=this.getCalendarEndDay(g);j+="<tbody>";var c=Math.round((a-e)/1000/60/60/24);for(var h=0;h<c;h+=1,e.setDate(e.getDate()+1)){var k;var f=g.getHoliday(e.getDate());if(e.getMonth()!=g.getMonth()){k=this.options.otherdayClass}else{if(f){k=this.options.holidayClass}else{if(e.getDay()==ProtoCalendar.SUNDAY){k=this.options.sundayClass}else{if(e.getDay()==ProtoCalendar.SATURDAY){k=this.options.saturdayClass}else{k=this.options.weekdayClass}}}}if(e.getDay()==this.weekFirstDay){j+="<tr>"}var l=this.getDayDivId(e);var d="";if(this.isSelectable(e)){d='<a class="#{dayClass}" href="#" id="'+l+(f?'" title="'+f:"")+'" year="'+e.getFullYear()+'" month="'+e.getMonth()+'" day="'+e.getDate()+'">'+e.getDate()+"</a>";this.dayDivs.push(l)}else{k+=" "+this.options.disabledDayClass;d=e.getDate()}j+='<td class="'+k+' #{dayCellClass}">'+d+"</td>";if(e.getDay()==this.weekLastDay){j+="</tr>"}}j+="</tbody></table>";return j}});var ProtoCalendarController=Class.create();ProtoCalendarController.prototype={initialize:function(c,b){this.options=Object.extend({onHourMinuteError:this.defaultOnHourMinuteError.bind(this),onNoDateError:this.defaultOnNoDateError.bind(this)},b);this.calendarRender=c;this.initializeDate();this.calendar=new ProtoCalendar(this.options);this.calendarRender.render(this.calendar);if(b.year&&b.month&&b.day){var a=new Date(this.options.year,this.options.month,this.options.day);if(b.hour&&b.minute&&b.second){a.setHours(b.hour,b.minute&&b.second)}this.selectDate(a,true)}else{this.selectDate(null)}this.observeEventsOnce();this.observeEvents();this.onChangeHandlers=[]},initializeDate:function(){var a=ProtoCalendar.newDate();if(!this.options.year){if(a.getFullYear()>=this.options.startYear&&a.getFullYear()<=this.options.endYear){this.options.year=a.getFullYear()}else{this.options.year=this.options.startYear}}if(!this.options.month){this.options.month=a.getMonth()}if(!this.options.day){this.options.day=a.getDate()}},observeEventsOnce:function(){var g=this.calendarRender;g.getPrevButton().observe("click",this.showPrevMonth.bindAsEventListener(this));g.getNextButton().observe("click",this.showNextMonth.bindAsEventListener(this));var c=this;var i=g.getYearSelect();var d=g.getMonthSelect();var j=this.calendar.getYear();var h=this.calendar.getMonth();i.observe("change",function(){c.setMonth(parseInt(i[i.selectedIndex].value,10),parseInt(d[d.selectedIndex].value,10))});d.observe("change",function(){c.setMonth(parseInt(i[i.selectedIndex].value,10),parseInt(d[d.selectedIndex].value,10))});if(this.options.enableHourMinute){var f=g.getHourInput();var e=g.getMinuteInput();f.observe("keyup",this._autoFocus.bindAsEventListener(f,e));f.observe("keydown",this._disablePaste.bindAsEventListener(f));f.observe("contextmenu",this._disableContextMenu.bindAsEventListener(f));var b=this.options.enableSecond?g.getSecondInput():g.getOkButton();e.observe("keyup",this._autoFocus.bindAsEventListener(e,b));e.observe("keydown",this._disablePaste.bindAsEventListener(e));e.observe("contextmenu",this._disableContextMenu.bindAsEventListener(e));if(navigator.appVersion.match(/\bMSIE\b/)){f.setStyle({imeMode:"disabled"});e.setStyle({imeMode:"disabled"})}}if(this.options.enableSecond){var a=g.getSecondInput();a.observe("keyup",this._autoFocus.bindAsEventListener(a,g.getOkButton()));a.observe("keydown",this._disablePaste.bindAsEventListener(a));a.observe("contextmenu",this._disableContextMenu.bindAsEventListener(a));if(navigator.appVersion.match(/\bMSIE\b/)){a.setStyle({imeMode:"disabled"})}}if(this.options.enableHourMinute){g.getOkButton().observe("click",this.onSubmit.bind(this))}},_disableContextMenu:function(a){Event.stop(a);return false},_disablePaste:function(a){if((a.keyCode==86&&a.ctrlKey)||(a.keyCode==45&&a.shiftKey)){Event.stop(a);return false}},_autoFocus:function(c,a){if(c.keyCode==16||c.keyCode==9||(c.keyCode==9&&c.shiftKey)){Event.stop(c);return false}var b=this.value;if(b.length&&b.length==2){a.focus();a.select()}return true},observeEvents:function(){var a=this;this.calendarRender.getDayDivs().each(function(b){Event.observe(b,"click",a.onClickHandler.bindAsEventListener(a))})},onClickHandler:function(b){Event.stop(b);var a=this.calendarRender.getDateFromEl(Event.element(b));if(a){this.selectDate(a);if(!this.options.enableHourMinute){this.onChangeHandler();setTimeout(this.hideCalendar.bind(this),150)}}},onSubmit:function(){this.hideError();var a=this.selectedDate;if(!a){return this.options.onNoDateError()}a=this.calendarRender.injectHourMinute(a);if(!a){this.options.onHourMinuteError()}else{this.selectDate(a,true);if(this.options.enableHourMinute){this.calendarRender.selectTime(a)}this.onChangeHandler();this.hideCalendar()}},selectDate:function(a,b){this.calendarRender.deselectDate(this.selectedDate);this.selectedDate=a;if(!a){return}if(b&&(a.getFullYear()!=this.calendar.getYear()||a.getMonth()!=this.calendar.getMonth())){this.setMonth(a.getFullYear(),a.getMonth())}this.calendarRender.selectDate(this.selectedDate)},getSelectedDate:function(){return this.selectedDate},addChangeHandler:function(a){this.onChangeHandlers.push(a)},onChangeHandler:function(){this.onChangeHandlers.each(function(a){a()})},showCalendar:function(){this.calendarRender.show()},hideCalendar:function(){this.calendarRender.hide()},blurCalendar:function(a){if(a.keyCode==9){this.hideImmediatelyCalendar()}},hideImmediatelyCalendar:function(){this.calendarRender.hideImmediately()},toggleCalendar:function(){this.calendarRender.toggle()},showPrevMonth:function(a){this.shiftMonthByOffset(-1);if(a){Event.stop(a)}},showNextMonth:function(a){this.shiftMonthByOffset(1);if(a){Event.stop(a)}},shiftMonthByOffset:function(b){if(b==0){return}var a=new Date(this.calendar.getDate().getTime());a.setMonth(a.getMonth()+b);if(this.options.startYear>a.getFullYear()||this.options.endYear<a.getFullYear()){return}this.calendar.setMonthByOffset(b);this.afterSet()},setMonth:function(a,b){if(this.calendar.getYear()==a&&this.calendar.getMonth()==b){return}this.calendar.setYear(a);this.calendar.setMonth(b);this.afterSet()},afterSet:function(){this.calendarRender.rerender(this.calendar);this.selectDate(this.selectedDate);this.observeEvents()},getContainer:function(){return this.calendarRender.getContainer()},defaultOnHourMinuteError:function(){this.calendarRender.defaultOnError("HOUR_MINUTE_ERROR")},defaultOnNoDateError:function(){this.calendarRender.defaultOnError("NO_DATE_ERROR")},hideError:function(){this.calendarRender.hideError()}};var BaseCalendar=Class.create();BaseCalendar.bindOnLoad=function(a){if(document.observe){document.observe("dom:loaded",a)}else{Event.observe(window,"load",a)}};BaseCalendar.prototype={initialize:function(a){throw"Cannot instantiate BaseCalendar."},initializeOptions:function(a){if(!a){a={}}this.options=Object.extend({startYear:ProtoCalendar.newDate().getFullYear()-10,endYear:ProtoCalendar.newDate().getFullYear()+10,minDate:new Date(1900,0,1),maxDate:new Date(3000,0,1),format:ProtoCalendar.LangFile[a.lang||ProtoCalendar.LangFile.defaultLang]["DEFAULT_FORMAT"],enableHourMinute:false,enableSecond:false,lang:ProtoCalendar.LangFile.defaultLang,triggers:[]},a)},initializeBase:function(){this.calendarController=new ProtoCalendarController(new ProtoCalendarRender(this.options),this.options);this.langFile=ProtoCalendar.LangFile[this.options.lang]||ProtoCalendar.LangFile.defaultLangFile();this.triggers=[];this.options.triggers.each(this.addTrigger.bind(this));this.changeHandlers=[];this.observeEvents()},addTrigger:function(a){this.triggers.push($(a));$(a).setStyle({cursor:"pointer"})},observeEvents:function(){Event.observe(document.body,"click",this.windowClickHandler.bindAsEventListener(this));this.calendarController.addChangeHandler(this.onCalendarChange.bind(this));this.doObserveEvents()},doObserveEvents:function(){},windowClickHandler:function(a){var b=$(Event.element(a));if(this.triggers.include(b)){this.calendarController.toggleCalendar()}else{if(b!=this.input&&!Element.descendantOf(b,this.calendarController.getContainer())){this.calendarController.hideCalendar()}}},addChangeHandler:function(a){this.changeHandlers.push(a)},onCalendarChange:function(){this.changeHandlers.each(function(a){a()})}};var InputCalendar=Class.create();InputCalendar.createOnLoaded=function(a,b){BaseCalendar.bindOnLoad(function(){new InputCalendar(a,b)})};InputCalendar.initCalendars=function(a,b){if(document.observe){document.observe("dom:loaded",function(){$$(a).each(function(c){new InputCalendar(c,b)})})}else{Event.observe(window,"load",function(){$$(a).each(function(c){new InputCalendar(c,b)})})}};Object.extend(InputCalendar.prototype,BaseCalendar.prototype);Object.extend(InputCalendar.prototype,{initialize:function(a,b){this.input=$(a);this.initializeOptions(b);this.options=Object.extend({alignTo:a,inputReadOnly:false,labelFormat:undefined,labelEl:undefined},this.options);this.initializeBase();this.initializeInput();this.initializeLabel()},initializeInput:function(){this.dateFormat=new ProtoCalendar.DateFormat(this.options.format);if(this.input.value&&this.dateFormat.parse(this.input.value)){this.onInputChange()}else{this.onCalendarChange()}if(this.options.enableHourMinute){this.calendarController.calendarRender.selectTime(this.calendarController.selectedDate)}if(this.options.inputReadOnly){this.input.setAttribute("readOnly",this.options.inputReadOnly)}},initializeLabel:function(){this.labelFormat=new ProtoCalendar.DateFormat(this.options.labelFormat||this.langFile.LABEL_FORMAT);var b=$(this.options.labelEl);if((!b)&&this.options.labelFormat){var a=this.input.id+"_label";new Insertion.After(this.input,"<div id='"+a+"'></div>");b=$(a)}this.labelEl=b;this.changeLabel()},changeLabel:function(){if(!this.labelEl){return}if(this.calendarController.getSelectedDate()){this.labelEl.innerHTML=this.labelFormat.format(this.calendarController.getSelectedDate(),this.options.lang)}},doObserveEvents:function(){this.input.observe("change",this.onInputChange.bind(this));this.input.observe("focus",this.calendarController.showCalendar.bind(this.calendarController));this.input.observe("keydown",this.calendarController.blurCalendar.bindAsEventListener(this.calendarController));this.addChangeHandler(this.changeInputValue.bind(this));this.addChangeHandler(this.changeLabel.bind(this))},onInputChange:function(){var b=this.dateFormat.parse(this.input.value);if(b){this.calendarController.selectDate(b,true);if(this.options.enableHourMinute){this.calendarController.calendarRender.selectTime(b)}}else{var a=this.input.value.toLowerCase();var b;if(this.langFile.today&&this.langFile.today==a||a=="today"){b=ProtoCalendar.newDate()}else{if(this.langFile.tomorrow&&this.langFile.tomorrow==a||a=="tomorrow"){b=ProtoCalendar.newDate();b.setDate(b.getDate()+1)}else{if(this.langFile.yesterday&&this.langFile.yesterday==a||a=="yesterday"){b=ProtoCalendar.newDate();b.setDate(b.getDate()-1)}else{if(this.langFile.parseDate&&(b=this.langFile.parseDate(a))){}else{b=undefined}}}}this.calendarController.selectDate(b,true);this.onCalendarChange()}this.changeLabel()},changeInputValue:function(){this.input.value=this.dateFormat.format(this.calendarController.getSelectedDate(),this.options.lang)}});ProtoCalendar.DateFormat=Class.create();Object.extend(ProtoCalendar.DateFormat,{MONTH_ABBRS:ProtoCalendar.LangFile.en.MONTH_ABBRS,MONTH_NAMES:ProtoCalendar.LangFile.en.MONTH_NAMES,WEEKDAY_ABBRS:ProtoCalendar.LangFile.en.WEEKDAY_ABBRS,WEEKDAY_NAMES:ProtoCalendar.LangFile.en.WEEKDAY_NAMES,formatRegexp:/(?:d{3,4}i|d{1,4}|m{1,4}|yy(?:yy)?|([hHMs])\1?|TT|tt|[lL])|.+?/g,zeroize:function(d,c){if(!c){c=2}d=String(d);for(var b=0,a="";b<(c-d.length);b++){a+="0"}return a+d}});ProtoCalendar.DateFormat.prototype={initialize:function(a){this.dateFormat=a;this.parserInited=false;this.formatterInited=false},format:function(a,d){if(!this.formatterInited){this.initFormatter()}if(!a){return""}var b=ProtoCalendar.LangFile[d||ProtoCalendar.LangFile.defaultLang];var c="";this.formatHandlers.each(function(e){c+=e(a,b)});return c},initFormatter:function(){var a=[];var c=this.dateFormat.match(ProtoCalendar.DateFormat.formatRegexp);for(var b=0,d=c.length;b<d;b++){switch(c[b]){case"d":a.push(function(f,e){return f.getDate()});break;case"dd":a.push(function(f,e){return ProtoCalendar.DateFormat.zeroize(f.getDate())});break;case"ddd":a.push(function(f,e){return ProtoCalendar.DateFormat.WEEKDAY_ABBRS[f.getDay()]});break;case"dddd":a.push(function(f,e){return ProtoCalendar.DateFormat.WEEKDAY_NAMES[f.getDay()]});break;case"dddi":a.push(function(f,e){return e.WEEKDAY_ABBRS[f.getDay()]});break;case"ddddi":a.push(function(f,e){return e.WEEKDAY_NAMES[f.getDay()]});break;case"m":a.push(function(f,e){return f.getMonth()+1});break;case"mm":a.push(function(f,e){return ProtoCalendar.DateFormat.zeroize(f.getMonth()+1)});break;case"mmm":a.push(function(f,e){return e.MONTH_ABBRS[f.getMonth()]});break;case"mmmm":a.push(function(f,e){return(e.MONTH_NAMES||ProtoCalendar.DateFormat)[f.getMonth()]});break;case"yy":a.push(function(f,e){return String(f.getFullYear()).substr(2)});break;case"yyyy":a.push(function(f,e){return f.getFullYear()});break;case"h":a.push(function(f,e){return f.getHours()%12||12});break;case"hh":a.push(function(f,e){return ProtoCalendar.DateFormat.zeroize(f.getHours()%12||12)});break;case"H":a.push(function(f,e){return f.getHours()});break;case"HH":a.push(function(f,e){return ProtoCalendar.DateFormat.zeroize(f.getHours())});break;case"M":a.push(function(f,e){return f.getMinutes()});break;case"MM":a.push(function(f,e){return ProtoCalendar.DateFormat.zeroize(f.getMinutes())});break;case"s":a.push(function(f,e){return f.getSeconds()});break;case"ss":a.push(function(f,e){return ProtoCalendar.DateFormat.zeroize(f.getSeconds())});break;case"l":a.push(function(f,e){return ProtoCalendar.DateFormat.zeroize(f.getMilliseconds(),3)});break;case"tt":a.push(function(f,e){return f.getHours()<12?"am":"pm"});break;case"TT":a.push(function(f,e){return f.getHours()<12?"AM":"PM"});break;default:a.push(ProtoCalendar.createIdentity(c[b]))}}this.formatHandlers=a;this.formatterInited=true},parse:function(d){if(!this.parserInited){this.initParser()}if(!d){return undefined}var c=d.match(this.parserRegexp);if(!c){return undefined}var a=ProtoCalendar.newDate();for(var b=0,e=this.parseHandlers.length;b<e;b++){if(this.parseHandlers[b]!=undefined){(this.parseHandlers[b])(a,c[b+1])}}this.parseCallback(a);return a},initParser:function(){var b=[];var f="";var e=this.dateFormat.match(ProtoCalendar.DateFormat.formatRegexp);var a,c;for(var d=0,g=e.length;d<g;d++){f+="(";switch(e[d]){case"d":case"dd":f+="\\d{1,2}";b.push(function(h,i){h.setDate(i)});break;case"m":case"mm":f+="\\d{1,2}";b.push(function(i,j){var h=parseInt(j,10)-1;i.setMonth(h)});break;case"yy":f+="\\d{2}";b.push(function(h,j){var i=parseInt(j,10);i=i<70?2000+i:1900+i;h.setFullYear(i)});break;case"yyyy":f+="\\d{4}";b.push(function(h,i){h.setFullYear(i)});break;case"h":case"hh":a=true;f+="\\d{1,2}";b.push(function(h,i){i=i%12||0;h.setHours(i)});break;case"H":case"HH":f+="\\d{1,2}";b.push(function(h,i){h.setHours(i)});break;case"M":case"MM":f+="\\d{1,2}";b.push(function(h,i){h.setMinutes(i)});break;case"s":case"ss":f+="\\d{1,2}";b.push(function(h,i){h.setSeconds(i)});break;case"l":f+="\\d{1,3}";b.push(function(h,i){h.setMilliSeconds(i)});break;case"tt":f+="am|pm";b.push(function(h,i){c=i});break;case"TT":f+="AM|PM";b.push(function(h,i){c=i.toLowerCase()});break;case"mmm":case"mmmm":case"ddd":case"dddd":case"dddi":case"ddddi":f+=".+?";b.push(undefined);break;default:f+=e[d];b.push(undefined)}f+=")"}this.parserRegexp=new RegExp(f);this.parseHandlers=b;if(c=="pm"&&a){this.parseCallback=this.normalizeHour.bind(this)}else{this.parseCallback=function(){}}this.parserInited=true},normalizeHour:function(b){var a=b.getHours();a=a==12?0:a+12;b.setHours(a)}};ProtoCalendar.createIdentity=function(a){return function(){return a}};var SelectCalendar=Class.create();SelectCalendar.selectTimeOption=function(a,b){var c=b-0;c=c<10?"0"+c:c;SelectCalendar.selectOption(a,c)};SelectCalendar.selectOption=function(a,d){var e=$(a);var b=e.options;for(var c=0;c<b.length;c++){if(b[c].value===d.toString()){b[c].selected=true;return}}};SelectCalendar.createOnLoaded=function(a,b){BaseCalendar.bindOnLoad(function(){new SelectCalendar(a,b)})};Object.extend(SelectCalendar.prototype,BaseCalendar.prototype);Object.extend(SelectCalendar.prototype,{initialize:function(a,b){this.yearSelect=$(a.yearSelect);this.monthSelect=$(a.monthSelect);this.daySelect=$(a.daySelect);this.initializeOptions(b);if(this.options.enableHourMinute){this.hourSelect=$(a.hourSelect);this.minuteSelect=$(a.minuteSelect);if(this.options.enableSecond){this.secondSelect=$(a.secondSelect)}}this.options=Object.extend({alignTo:a.yearSelect},this.options);this.initializeBase();this.initializeSelect()},initializeSelect:function(){if(this.getSelectedDate()){this.onSelectChange()}else{this.onCalendarChange()}},doObserveEvents:function(){this.yearSelect.observe("change",this.onSelectChange.bind(this));this.monthSelect.observe("change",this.onSelectChange.bind(this));this.daySelect.observe("change",this.onSelectChange.bind(this));if(this.options.enableHourMinute){this.hourSelect.observe("change",this.onSelectChange.bind(this));this.minuteSelect.observe("change",this.onSelectChange.bind(this));if(this.options.enableSecond){this.secondSelect.observe("change",this.onSelectChange.bind(this))}}this.addChangeHandler(this.changeSelectValue.bind(this))},onSelectChange:function(){var a=this.getSelectedDate();if(!a){return}this.calendarController.selectDate(a,true);if(this.options.enableHourMinute){this.calendarController.calendarRender.selectTime(a)}this.onCalendarChange()},changeSelectValue:function(){var a=this.calendarController.getSelectedDate();if(a){SelectCalendar.selectOption(this.yearSelect,a.getFullYear());SelectCalendar.selectOption(this.monthSelect,a.getMonth()+1);SelectCalendar.selectOption(this.daySelect,a.getDate());if(this.options.enableHourMinute){SelectCalendar.selectTimeOption(this.hourSelect,a.getHours());SelectCalendar.selectTimeOption(this.minuteSelect,a.getMinutes());if(this.options.enableSecond){SelectCalendar.selectTimeOption(this.secondSelect,a.getSeconds())}}}},getSelectedDate:function(){if(this.yearSelect.value==""||this.monthSelect.value==""||this.daySelect.value==""){return undefined}var a=ProtoCalendar.newDate();a.setFullYear(this.yearSelect.value);a.setMonth(this.monthSelect.value-1);a.setDate(this.daySelect.value);if(this.options.enableHourMinute){if(this.hourSelect.value==""||this.minuteSelect.value==""){return undefined}a.setHours(this.hourSelect.value-0);a.setMinutes(this.minuteSelect.value-0);if(this.options.enableSecond){if(this.secondSelect.value==""){return undefined}a.setSeconds(this.secondSelect.value-0)}}if(isNaN(a.getTime())){return undefined}else{return a}}});