<%@ page language="java" contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>

<h1><bean:message key="prompt.jobTriggerEditForm.title"/></h1>
<logic:messagesPresent>
	<ul>
	<bean:message key="errors.header"/>
	<html:messages id="error">
		<li><bean:write name="error"/></li>
	</html:messages>
	</ul>
	<hr>
</logic:messagesPresent>

<html:form action="/scheduler/jobCronTriggerEditAction" focus="triggerGroup" onsubmit="return validateJobCronTriggerForm(this);">
<html:hidden name="jobTriggerForm" property="jobName"/>
<html:hidden name="jobTriggerForm" property="jobGroup"/>

<div id="EDITTAG" align="left">

    <table width="100%">
    	<tr>
			<td  width="25%" class="title"><strong/><bean:message key="prompt.jobTriggerEditForm.groupName"/></strong><img src="images/4_dot.gif"/></td>
			<td>
				<logic:empty name="jobTriggerForm" property="triggerName">
					<html:text styleClass="inputtext" name="jobTriggerForm" property="triggerGroup"  size="32" maxlength="32"/>
				</logic:empty>
				<logic:notEmpty name="jobTriggerForm" property="triggerName">
					<html:text styleClass="inputtext" name="jobTriggerForm" property="triggerGroup" readonly="true" size="32" maxlength="32"/>
				</logic:notEmpty>
				<bean:message key="prompt.jobTriggerEditForm.groupNameUniq"/>
			</td>
		</tr>
    	<tr>
			<td class="title"><strong><bean:message key="prompt.jobTriggerEditForm.triggerName"/></strong><img src="images/4_dot.gif"/></td>
			<td>
				<logic:empty name="jobTriggerForm" property="triggerName">
					<html:text styleClass="inputtext" name="jobTriggerForm" property="triggerName"  size="32" maxlength="32"/>
				</logic:empty>
				<logic:notEmpty name="jobTriggerForm" property="triggerName">
					<html:text styleClass="inputtext" name="jobTriggerForm" property="triggerName" readonly="true" size="32" maxlength="32"/>
				</logic:notEmpty>
				<bean:message key="prompt.jobTriggerEditForm.groupNameUniq"/>
			</td>
		</tr>
		<tr>
			<td class="title"><strong><bean:message key="prompt.jobTriggerEditForm.triggerDescription"/></strong><img src="images/4_dot.gif"/></td>
			<td>
				<html:textarea styleClass="inputtext" name="jobTriggerForm" property="description" rows="5" cols="60"/>
			</td>
		</tr>
		<tr>
			<td class="title"><strong><bean:message key="prompt.jobTriggerEditForm.startTime"/></strong><img src="images/4_dot.gif"/></td>
			<td>
				<html:text styleClass="inputtext" name="jobTriggerForm" property="startTime"  size="32"/>
				<bean:message key="prompt.jobTriggerEditForm.timeFormat"/>
			</td>
		</tr>
		<tr>
			<td class="title"><strong><bean:message key="prompt.jobTriggerEditForm.stopTime"/></strong><img src="images/4_dot.gif"/></td>
			<td>
				<html:text styleClass="inputtext" name="jobTriggerForm" property="stopTime"  size="32"/>
				<bean:message key="prompt.jobTriggerEditForm.timeFormat"/>
			</td>
		</tr>
		<tr>
			<td class="title"><strong><bean:message key="prompt.jobTriggerEditForm.cronExpression"/></strong><img src="images/4_dot.gif"/></td>
			<td>
				<html:text styleClass="inputtext" name="jobTriggerForm" property="cronExpression"  size="32"/>
			</td>
		</tr>
	</table>
</div>
<div id="COMMANDTAG">
    <table width="100%">
      <tr>
        <td height="50" width="5%">
			&nbsp;
        </td>
        <td align="center" width="20%">
　　      <html:submit styleClass="button" property="submit" onclick="bCancel=false;">&nbsp;&nbsp;&nbsp;&nbsp;<bean:message key="prompt.scheduler.ok"/>&nbsp;&nbsp;&nbsp;&nbsp;</html:submit>
        </td>
        <td align="center" width="20%">
　　      <html:cancel styleClass="button" onclick="bCancel=true;"><bean:message key="prompt.scheduler.cancel"/></html:cancel>
		</td>
        <td align="center" width="20%">
　　　    <html:reset styleClass="button">&nbsp;&nbsp;<bean:message key="prompt.scheduler.reset"/>&nbsp;&nbsp;</html:reset>
        </td>
        <td height="50">
			&nbsp;
        </td>
      </tr>
    </table>
</div>
</html:form>

<div  id="DISPLAYTAG">

<p>For those unfamiliar with "cron", this means being able to create a
 firing schedule such as:  "At 8:00am every Monday through Friday" or
 "At 1:30am every last Friday of the month".</p>

<p>
A "Cron-Expression" is a string comprised of 6 or 7 fields separated by
 white space. The 6 mandatory and 1 optional fields are as follows:<br>
</p>

 <table width="100%">
   <thead>
   <tr>
     <th align="left">Field Name</th>
     <th align="left">Allowed Values</th>
     <th align="left">Allowed Special Characters</th>
   </tr>
   </thead>
   <tbody>
   <tr class="odd">
     <td align="left"><code>Seconds</code></td>
     <td align="left"><code>0-59</code></td>
     <td align="left"><code>, - * /</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>Minutes</code></td>
     <td align="left"><code>0-59</code></td>
     <td align="left"><code>, - * /</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>Hours</code></td>
     <td align="left"><code>0-23</code></td>
     <td align="left"><code>, - * /</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>Day-of-month</code></td>
     <td align="left"><code>1-31</code></td>
     <td align="left"><code>, - * ? / L C</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>Month</code></td>
     <td align="left"><code>1-12 or JAN-DEC</code></td>
     <td align="left"><code>, - * /</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>Day-of-Week</code></td>
     <td align="left"><code>1-7 or SUN-SAT</code></td>
     <td align="left"><code>, - * ? / L C #</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>Year (Optional)</code></td>
     <td align="left"><code>empty, 1970-2099</code></td>
     <td align="left"><code>, - * /</code></td>
   </tr>
   </tbody>
 </table>

 <p>The '*' character is used to specify all values. For example, "*" in
 the minute field means "every minute".</p>

 <p>The '?' character is allowed for the day-of-month and day-of-week fields.
 It is used to specify 'no specific value'. This is useful when you need
 to specify something in one of the two fileds, but not the other. See the
 examples below for clarification.</p>

 <p>The '-' character is used to specify ranges For example "10-12" in the
 hour field means "the hours 10, 11 and 12".</p>

 <p>The ',' character is used to specify additional values. For example
 "MON,WED,FRI" in the day-of-week field means "the days Monday,
 Wednesday, and Friday".</p>

 <p>The '/' character is used to specify increments. For example "0/15" in
 the seconds field means "the seconds 0, 15, 30, and 45".  And "5/15" in
 the seconds field means "the seconds 5, 20, 35, and 50".  You can also
 specify '/' after the '*' character - in this case '*' is equivalent to
 having '0' before the '/'.</p>

 <p>The 'L' character is allowed for the day-of-month and day-of-week fields.
 This character is short-hand for "last", but it has different meaning in each of
 the two fields.  For example, the value "L" in the  day-of-month field means
 "the last day of the month" - day 31 for  January, day 28 for February on
 non-leap years.  If used in the day-of-week field by itself, it simply
 means "7" or "SAT". But if used in the day-of-week field after another value,
 it means "the last xxx day of the month" - for example "6L" means
 "the last friday of the month".  When using the 'L' option, it is
 important not to specify lists, or ranges of values, as you'll get confusing
 results.</p>

 <p>The '#' character is allowed for the day-of-week field.  This character
 is used to specify "the nth" XXX day of the month.  For example, the value
 of "6#3" in the day-of-week field means the third Friday of the month
 (day 6 = Friday and "#3" = the 3rd one in the month). Other
 examples: "2#1" = the first Monday of the month and  "4#5" = the fifth
 Wednesday of the month.  Note that if you specify "#5" and there is not 5 of
 the given day-of-week in the month, then no firing will occur that month.</p>

 <p>The 'C' character is allowed for the day-of-month and day-of-week fields.
 This character is short-hand for "calendar".  This means values are
 calculated against the associated calendar, if any.  If no calendar is
 associated, then it is equivalent to having an all-inclusive calendar.
 A value of "5C" in the day-of-month field means "the first day included by
 the calendar on or after the 5th".  A value of "1C" in the day-of-week field
 means "the first day included by the calendar on or after sunday".</p>

 <p>The legal characters and the names of months and days of the week are not
 case sensitive.</p>

 <p>Here are some full examples:<br>
 <table width="100%">
   <thead>
   <tr>
     <th width="35%"align="left">Expression</th>
     <th align="left">Meaning</th>
   </tr>
   </thead>
   <tbody>
   <tr class="odd">
     <td align="left"><code>"0 0 12 * * ?"</code></td>
     <td align="left"><code>Fire at 12pm (noon) every day</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>"0 15 10 ? * *"</code></td>
     <td align="left"><code>Fire at 10:15am every day</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>"0 15 10 * * ?"</code></td>
     <td align="left"><code>Fire at 10:15am every day</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>"0 15 10 * * ? *"</code></td>
     <td align="left"><code>Fire at 10:15am every day</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>"0 15 10 * * ? 2005"</code></td>
     <td align="left"><code>Fire at 10:15am every day during the year 2005</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>"0 * 14 * * ?"</code></td>
     <td align="left"><code>Fire every minute starting at 2pm and ending at 2:59pm, every day</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>"0 0/5 14 * * ?"</code></td>
     <td align="left"><code>Fire every 5 minutes starting at 2pm and ending at 2:55pm, every day</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>"0 0/5 14,18 * * ?"</code></td>
     <td align="left"><code>Fire every 5 minutes starting at 2pm and ending at 2:55pm, AND fire every 5 minutes starting at 6pm and ending at 6:55pm, every day</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>"0 0-5 14 * * ?"</code></td>
     <td align="left"><code>Fire every minute starting at 2pm and ending at 2:05pm, every day</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>"0 10,44 14 ? 3 WED"</code></td>
     <td align="left"><code>Fire at 2:10pm and at 2:44pm every Wednesday in the month of March.</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>"0 15 10 ? * MON-FRI"</code></td>
     <td align="left"><code>Fire at 10:15am every Monday, Tuesday, Wednesday, Thursday and Friday</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>"0 15 10 15 * ?"</code></td>
     <td align="left"><code>Fire at 10:15am on the 15th day of every month</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>"0 15 10 L * ?"</code></td>
     <td align="left"><code>Fire at 10:15am on the last day of every month</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>"0 15 10 ? * 6L"</code></td>
     <td align="left"><code>Fire at 10:15am on the last Friday of every month</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>"0 15 10 ? * 6L"</code></td>
     <td align="left"><code>Fire at 10:15am on the last Friday of every month</code></td>
   </tr>
   <tr class="even">
     <td align="left"><code>"0 15 10 * * 6L 2002-2005"</code></td>
     <td align="left"><code>Fire at 10:15am on EVERY DAY of every month during the years 2002, 2003, 2004 and 2005</code></td>
   </tr>
   <tr class="odd">
     <td align="left"><code>"0 15 10 * * 6#3"</code></td>
     <td align="left"><code>Fire at 10:15am on the third Friday of every month</code></td>
   </tr>
   </tbody>
 </table>

 <p>Pay attention to the effects of '?' and '*' in the day-of-week and
 day-of-month fields!</p>

<b>NOTES:</b>
 <ul>
   <li>
      Support for the features described for the 'C' character is
      not complete.
   </li>
   <li>
      Support for specifying both a day-of-week and a day-of-month
      value is not complete (you'll need to use the '?' character in on of these
      fields).
   </li>
 </ul>

</div>

<html:javascript formName="jobCronTriggerForm"/>
