ALTER TABLE AD_PROCESS DROP COLUMN ISJASPERREPORT CASCADE CONSTRAINT;
ALTER TABLE AD_PROCESS DROP COLUMN AD_JASPERFORMAT_ID CASCADE CONSTRAINT;

ALTER TABLE AD_PROCESS
	ADD (
		ISJASPERREPORT CHAR(1) DEFAULT 'N' ,
		AD_JASPERFORMAT_ID NUMBER(10)
	);

DROP TABLE AD_JASPERFORMAT;
CREATE TABLE AD_JASPERFORMAT ( 
	AD_CLIENT_ID					NUMBER(10)		NOT NULL,
	AD_ORG_ID						NUMBER(10)		NOT NULL,
	AD_JASPERFORMAT_ID			NUMBER(10)		NOT NULL,
	AD_PROCESS_ID					NUMBER(10),
	AD_TABLE_ID						NUMBER(10),
	ISACTIVE						CHAR(1)			DEFAULT 'Y' 	NOT NULL,
	ISDEFAULT						CHAR(1)			DEFAULT 'N' 	NOT NULL,
	NAME							NVARCHAR2(60)	NOT NULL,
	DESCRIPTION						NVARCHAR2(255),
	CREATED							DATE			DEFAULT SYSDATE 	NOT NULL,
	CREATEDBY						NUMBER(10)		DEFAULT 0 	NOT NULL,
	UPDATED							DATE			DEFAULT SYSDATE 	NOT NULL,
	UPDATEDBY						NUMBER(10)		DEFAULT 0 	NOT NULL, 
	CONSTRAINT AD_JASPERFORMAT_CLIENT FOREIGN KEY(AD_CLIENT_ID) REFERENCES AD_CLIENT (AD_CLIENT_ID) , 
	CONSTRAINT AD_JASPERFORMAT_ORG FOREIGN KEY(AD_ORG_ID) REFERENCES AD_ORG (AD_ORG_ID) , 
	CONSTRAINT AD_JASPERFORMAT_TABLE FOREIGN KEY(AD_TABLE_ID) REFERENCES AD_TABLE (AD_TABLE_ID) ON DELETE CASCADE , 
	CONSTRAINT AD_JASPERFORMAT_PROCESS FOREIGN KEY(AD_PROCESS_ID) REFERENCES AD_PROCESS (AD_PROCESS_ID) , 
	CONSTRAINT AD_JASPERFORMAT_KEY PRIMARY KEY(AD_JASPERFORMAT_ID) , 
	CHECK(IsActive IN ('Y','N')) , 
	CHECK(IsDefault IN ('Y','N')) 
) ;


CREATE UNIQUE INDEX AD_PRINTFORMAT_INDEX_NAME
	ON AD_JASPERFORMAT (AD_CLIENT_ID, AD_TABLE_ID, NAME);

CREATE INDEX AD_JASPERFORMAT_INDEX_TABLE
	ON AD_JASPERFORMAT (AD_TABLE_ID) ;

CREATE INDEX AD_JASPERFORMAT_INDEX_PROCESS
	ON AD_JASPERFORMAT (AD_PROCESS_ID) ;
