/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package compiere.model;

/** Generated Model - DO NOT CHANGE */
import org.compiere.model.*;
import java.sql.*;
import java.math.*;
import org.compiere.framework.*;
import org.compiere.util.*;
/** Generated Model for I_EDI_Order
 *  @author Jorg Janke (generated) 
 *  @version Release 3.0.0 - $Id: X_I_EDI_Order.java,v 1.2 2010/06/14 02:43:51 jrmt Exp $ */
public class X_I_EDI_Order extends PO
{
/** Standard Constructor
@param ctx context
@param I_EDI_Order_ID id
@param trxName transaction
*/
public X_I_EDI_Order (Ctx ctx, int I_EDI_Order_ID, String trxName)
{
super (ctx, I_EDI_Order_ID, trxName);
/** if (I_EDI_Order_ID == 0)
{
setI_Edi_Order_ID (0);
setI_IsImported (false);
}
 */
}
/** Load Constructor 
@param ctx context
@param rs result set 
@param trxName transaction
*/
public X_I_EDI_Order (Ctx ctx, ResultSet rs, String trxName)
{
super (ctx, rs, trxName);
}
/** Serial Version No */
static final long serialVersionUID = 27554656525789L;
/** Last Updated Timestamp 2010-04-29 17:53:29.0 */
public static final long updatedMS = 1272531209000L;
/** AD_Table_ID=1000074 */
public static final int Table_ID=1000074;

/** TableName=I_EDI_Order */
public static final String Table_Name="I_EDI_Order";

protected static KeyNamePair Model = new KeyNamePair(1000074,"I_EDI_Order");

protected BigDecimal accessLevel = new BigDecimal(3);
/** AccessLevel
@return 3 - Client - Org 
*/
protected int get_AccessLevel()
{
return accessLevel.intValue();
}
/** Load Meta Data
@param ctx context
@return PO Info
*/
protected POInfo initPO (Ctx ctx)
{
POInfo poi = POInfo.getPOInfo (ctx, Table_ID);
return poi;
}
/** Info
@return info
*/
public String toString()
{
StringBuffer sb = new StringBuffer ("X_I_EDI_Order[").append(get_ID()).append("]");
return sb.toString();
}

/** AD_OrgTrx_ID AD_Reference_ID=130 */
public static final int AD_ORGTRX_ID_AD_Reference_ID=130;
/** Set Trx Organization.
@param AD_OrgTrx_ID Performing or initiating organization */
public void setAD_OrgTrx_ID (int AD_OrgTrx_ID)
{
if (AD_OrgTrx_ID <= 0) set_Value ("AD_OrgTrx_ID", null);
else
set_Value ("AD_OrgTrx_ID", new Integer(AD_OrgTrx_ID));
}
/** Get Trx Organization.
@return Performing or initiating organization */
public int getAD_OrgTrx_ID() 
{
Integer ii = (Integer)get_Value("AD_OrgTrx_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set User/Contact.
@param AD_User_ID User within the system - Internal or Business Partner Contact */
public void setAD_User_ID (int AD_User_ID)
{
if (AD_User_ID <= 0) set_Value ("AD_User_ID", null);
else
set_Value ("AD_User_ID", new Integer(AD_User_ID));
}
/** Get User/Contact.
@return User within the system - Internal or Business Partner Contact */
public int getAD_User_ID() 
{
Integer ii = (Integer)get_Value("AD_User_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Address 1.
@param Address1 Address line 1 for this location */
public void setAddress1 (String Address1)
{
if (Address1 != null && Address1.length() > 60)
{
log.warning("Length > 60 - truncated");
Address1 = Address1.substring(0,60);
}
set_Value ("Address1", Address1);
}
/** Get Address 1.
@return Address line 1 for this location */
public String getAddress1() 
{
return (String)get_Value("Address1");
}
/** Set Address 2.
@param Address2 Address line 2 for this location */
public void setAddress2 (String Address2)
{
if (Address2 != null && Address2.length() > 60)
{
log.warning("Length > 60 - truncated");
Address2 = Address2.substring(0,60);
}
set_Value ("Address2", Address2);
}
/** Get Address 2.
@return Address line 2 for this location */
public String getAddress2() 
{
return (String)get_Value("Address2");
}

/** ArrivalTime AD_Reference_ID=1000004 */
public static final int ARRIVALTIME_AD_Reference_ID=1000004;
/** AM 8 to 12 = 08 */
public static final String ARRIVALTIME_AM8To12 = "08";
/** AM 12 to PM  14 = 12 */
public static final String ARRIVALTIME_AM12ToPM14 = "12";
/** PM 14 to PM 16 = 14 */
public static final String ARRIVALTIME_PM14ToPM16 = "14";
/** PM 16 to PM 18 = 16 */
public static final String ARRIVALTIME_PM16ToPM18 = "16";
/** PM 18 to PM 20 = 18 */
public static final String ARRIVALTIME_PM18ToPM20 = "18";
/** PM 20 = 20 */
public static final String ARRIVALTIME_PM20 = "20";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isArrivalTimeValid (String test)
{
return test == null || test.equals("08") || test.equals("12") || test.equals("14") || test.equals("16") || test.equals("18") || test.equals("20");
}
/** Set ArrivalTime.
@param ArrivalTime ArrivalTime */
public void setArrivalTime (String ArrivalTime)
{
if (!isArrivalTimeValid(ArrivalTime))
throw new IllegalArgumentException ("ArrivalTime Invalid value - " + ArrivalTime + " - Reference_ID=1000004 - 08 - 12 - 14 - 16 - 18 - 20");
if (ArrivalTime != null && ArrivalTime.length() > 2)
{
log.warning("Length > 2 - truncated");
ArrivalTime = ArrivalTime.substring(0,2);
}
set_Value ("ArrivalTime", ArrivalTime);
}
/** Get ArrivalTime.
@return ArrivalTime */
public String getArrivalTime() 
{
return (String)get_Value("ArrivalTime");
}
/** Set Business Partner Key.
@param BPartnerValue Key of the Business Partner */
public void setBPartnerValue (String BPartnerValue)
{
if (BPartnerValue != null && BPartnerValue.length() > 40)
{
log.warning("Length > 40 - truncated");
BPartnerValue = BPartnerValue.substring(0,40);
}
set_Value ("BPartnerValue", BPartnerValue);
}
/** Get Business Partner Key.
@return Key of the Business Partner */
public String getBPartnerValue() 
{
return (String)get_Value("BPartnerValue");
}

/** BillTo_ID AD_Reference_ID=159 */
public static final int BILLTO_ID_AD_Reference_ID=159;
/** Set Invoice To.
@param BillTo_ID Bill to Address */
public void setBillTo_ID (int BillTo_ID)
{
if (BillTo_ID <= 0) set_Value ("BillTo_ID", null);
else
set_Value ("BillTo_ID", new Integer(BillTo_ID));
}
/** Get Invoice To.
@return Bill to Address */
public int getBillTo_ID() 
{
Integer ii = (Integer)get_Value("BillTo_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Activity.
@param C_Activity_ID Business Activity */
public void setC_Activity_ID (int C_Activity_ID)
{
if (C_Activity_ID <= 0) set_Value ("C_Activity_ID", null);
else
set_Value ("C_Activity_ID", new Integer(C_Activity_ID));
}
/** Get Activity.
@return Business Activity */
public int getC_Activity_ID() 
{
Integer ii = (Integer)get_Value("C_Activity_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Business Partner .
@param C_BPartner_ID Identifies a Business Partner */
public void setC_BPartner_ID (int C_BPartner_ID)
{
if (C_BPartner_ID <= 0) set_Value ("C_BPartner_ID", null);
else
set_Value ("C_BPartner_ID", new Integer(C_BPartner_ID));
}
/** Get Business Partner .
@return Identifies a Business Partner */
public int getC_BPartner_ID() 
{
Integer ii = (Integer)get_Value("C_BPartner_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Partner Location.
@param C_BPartner_Location_ID Identifies the (ship to) address for this Business Partner */
public void setC_BPartner_Location_ID (int C_BPartner_Location_ID)
{
if (C_BPartner_Location_ID <= 0) set_Value ("C_BPartner_Location_ID", null);
else
set_Value ("C_BPartner_Location_ID", new Integer(C_BPartner_Location_ID));
}
/** Get Partner Location.
@return Identifies the (ship to) address for this Business Partner */
public int getC_BPartner_Location_ID() 
{
Integer ii = (Integer)get_Value("C_BPartner_Location_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Campaign.
@param C_Campaign_ID Marketing Campaign */
public void setC_Campaign_ID (int C_Campaign_ID)
{
if (C_Campaign_ID <= 0) set_Value ("C_Campaign_ID", null);
else
set_Value ("C_Campaign_ID", new Integer(C_Campaign_ID));
}
/** Get Campaign.
@return Marketing Campaign */
public int getC_Campaign_ID() 
{
Integer ii = (Integer)get_Value("C_Campaign_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Country.
@param C_Country_ID Country  */
public void setC_Country_ID (int C_Country_ID)
{
if (C_Country_ID <= 0) set_Value ("C_Country_ID", null);
else
set_Value ("C_Country_ID", new Integer(C_Country_ID));
}
/** Get Country.
@return Country  */
public int getC_Country_ID() 
{
Integer ii = (Integer)get_Value("C_Country_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Currency.
@param C_Currency_ID The Currency for this record */
public void setC_Currency_ID (int C_Currency_ID)
{
if (C_Currency_ID <= 0) set_Value ("C_Currency_ID", null);
else
set_Value ("C_Currency_ID", new Integer(C_Currency_ID));
}
/** Get Currency.
@return The Currency for this record */
public int getC_Currency_ID() 
{
Integer ii = (Integer)get_Value("C_Currency_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Document Type.
@param C_DocType_ID Document type or rules */
public void setC_DocType_ID (int C_DocType_ID)
{
if (C_DocType_ID <= 0) set_Value ("C_DocType_ID", null);
else
set_Value ("C_DocType_ID", new Integer(C_DocType_ID));
}
/** Get Document Type.
@return Document type or rules */
public int getC_DocType_ID() 
{
Integer ii = (Integer)get_Value("C_DocType_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Address.
@param C_Location_ID Location or Address */
public void setC_Location_ID (int C_Location_ID)
{
if (C_Location_ID <= 0) set_Value ("C_Location_ID", null);
else
set_Value ("C_Location_ID", new Integer(C_Location_ID));
}
/** Get Address.
@return Location or Address */
public int getC_Location_ID() 
{
Integer ii = (Integer)get_Value("C_Location_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Order Line.
@param C_OrderLine_ID Order Line */
public void setC_OrderLine_ID (int C_OrderLine_ID)
{
if (C_OrderLine_ID <= 0) set_Value ("C_OrderLine_ID", null);
else
set_Value ("C_OrderLine_ID", new Integer(C_OrderLine_ID));
}
/** Get Order Line.
@return Order Line */
public int getC_OrderLine_ID() 
{
Integer ii = (Integer)get_Value("C_OrderLine_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Order.
@param C_Order_ID Order */
public void setC_Order_ID (int C_Order_ID)
{
if (C_Order_ID <= 0) set_Value ("C_Order_ID", null);
else
set_Value ("C_Order_ID", new Integer(C_Order_ID));
}
/** Get Order.
@return Order */
public int getC_Order_ID() 
{
Integer ii = (Integer)get_Value("C_Order_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Payment Term.
@param C_PaymentTerm_ID The terms of Payment (timing, discount) */
public void setC_PaymentTerm_ID (int C_PaymentTerm_ID)
{
if (C_PaymentTerm_ID <= 0) set_Value ("C_PaymentTerm_ID", null);
else
set_Value ("C_PaymentTerm_ID", new Integer(C_PaymentTerm_ID));
}
/** Get Payment Term.
@return The terms of Payment (timing, discount) */
public int getC_PaymentTerm_ID() 
{
Integer ii = (Integer)get_Value("C_PaymentTerm_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Project.
@param C_Project_ID Financial Project */
public void setC_Project_ID (int C_Project_ID)
{
if (C_Project_ID <= 0) set_Value ("C_Project_ID", null);
else
set_Value ("C_Project_ID", new Integer(C_Project_ID));
}
/** Get Project.
@return Financial Project */
public int getC_Project_ID() 
{
Integer ii = (Integer)get_Value("C_Project_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Region.
@param C_Region_ID Identifies a geographical Region */
public void setC_Region_ID (int C_Region_ID)
{
if (C_Region_ID <= 0) set_Value ("C_Region_ID", null);
else
set_Value ("C_Region_ID", new Integer(C_Region_ID));
}
/** Get Region.
@return Identifies a geographical Region */
public int getC_Region_ID() 
{
Integer ii = (Integer)get_Value("C_Region_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Tax.
@param C_Tax_ID Tax identifier */
public void setC_Tax_ID (int C_Tax_ID)
{
if (C_Tax_ID <= 0) set_Value ("C_Tax_ID", null);
else
set_Value ("C_Tax_ID", new Integer(C_Tax_ID));
}
/** Get Tax.
@return Tax identifier */
public int getC_Tax_ID() 
{
Integer ii = (Integer)get_Value("C_Tax_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set UOM.
@param C_UOM_ID Unit of Measure */
public void setC_UOM_ID (int C_UOM_ID)
{
if (C_UOM_ID <= 0) set_Value ("C_UOM_ID", null);
else
set_Value ("C_UOM_ID", new Integer(C_UOM_ID));
}
/** Get UOM.
@return Unit of Measure */
public int getC_UOM_ID() 
{
Integer ii = (Integer)get_Value("C_UOM_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Charge amount.
@param ChargeAmt Charge Amount */
public void setChargeAmt (BigDecimal ChargeAmt)
{
set_Value ("ChargeAmt", ChargeAmt);
}
/** Get Charge amount.
@return Charge Amount */
public BigDecimal getChargeAmt() 
{
BigDecimal bd = (BigDecimal)get_Value("ChargeAmt");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set City.
@param City Identifies a City */
public void setCity (String City)
{
if (City != null && City.length() > 60)
{
log.warning("Length > 60 - truncated");
City = City.substring(0,60);
}
set_Value ("City", City);
}
/** Get City.
@return Identifies a City */
public String getCity() 
{
return (String)get_Value("City");
}
/** Set Contact Name.
@param ContactName Business Partner Contact Name */
public void setContactName (String ContactName)
{
if (ContactName != null && ContactName.length() > 60)
{
log.warning("Length > 60 - truncated");
ContactName = ContactName.substring(0,60);
}
set_Value ("ContactName", ContactName);
}
/** Get Contact Name.
@return Business Partner Contact Name */
public String getContactName() 
{
return (String)get_Value("ContactName");
}
/** Set ISO Country Code.
@param CountryCode Upper-case two-letter alphabetic ISO Country code according to ISO 3166-1 - http://www.chemie.fu-berlin.de/diverse/doc/ISO_3166.html */
public void setCountryCode (String CountryCode)
{
if (CountryCode != null && CountryCode.length() > 2)
{
log.warning("Length > 2 - truncated");
CountryCode = CountryCode.substring(0,2);
}
set_Value ("CountryCode", CountryCode);
}
/** Get ISO Country Code.
@return Upper-case two-letter alphabetic ISO Country code according to ISO 3166-1 - http://www.chemie.fu-berlin.de/diverse/doc/ISO_3166.html */
public String getCountryCode() 
{
return (String)get_Value("CountryCode");
}
/** Set Customer Name.
@param CustomerName Customer Name */
public void setCustomerName (String CustomerName)
{
if (CustomerName != null && CustomerName.length() > 60)
{
log.warning("Length > 60 - truncated");
CustomerName = CustomerName.substring(0,60);
}
set_Value ("CustomerName", CustomerName);
}
/** Get Customer Name.
@return Customer Name */
public String getCustomerName() 
{
return (String)get_Value("CustomerName");
}
/** Set Customer Value.
@param CustomerValue Customer Value */
public void setCustomerValue (String CustomerValue)
{
if (CustomerValue != null && CustomerValue.length() > 60)
{
log.warning("Length > 60 - truncated");
CustomerValue = CustomerValue.substring(0,60);
}
set_Value ("CustomerValue", CustomerValue);
}
/** Get Customer Value.
@return Customer Value */
public String getCustomerValue() 
{
return (String)get_Value("CustomerValue");
}
/** Set Account Date.
@param DateAcct General Ledger Date */
public void setDateAcct (Timestamp DateAcct)
{
set_ValueNoCheck ("DateAcct", DateAcct);
}
/** Get Account Date.
@return General Ledger Date */
public Timestamp getDateAcct() 
{
return (Timestamp)get_Value("DateAcct");
}
/** Set Date Ordered.
@param DateOrdered Date of Order */
public void setDateOrdered (Timestamp DateOrdered)
{
set_ValueNoCheck ("DateOrdered", DateOrdered);
}
/** Get Date Ordered.
@return Date of Order */
public Timestamp getDateOrdered() 
{
return (Timestamp)get_Value("DateOrdered");
}
/** Set Date Promised.
@param DatePromised Date Order was promised */
public void setDatePromised (Timestamp DatePromised)
{
set_ValueNoCheck ("DatePromised", DatePromised);
}
/** Get Date Promised.
@return Date Order was promised */
public Timestamp getDatePromised() 
{
return (Timestamp)get_Value("DatePromised");
}
/** Set Deliver To.
@param DeliverTo Deliver To */
public void setDeliverTo (String DeliverTo)
{
if (DeliverTo != null && DeliverTo.length() > 255)
{
log.warning("Length > 255 - truncated");
DeliverTo = DeliverTo.substring(0,255);
}
set_Value ("DeliverTo", DeliverTo);
}
/** Get Deliver To.
@return Deliver To */
public String getDeliverTo() 
{
return (String)get_Value("DeliverTo");
}
/** Set DeliverToAddress1.
@param DeliverToAddress1 DeliverToAddress1 */
public void setDeliverToAddress1 (String DeliverToAddress1)
{
if (DeliverToAddress1 != null && DeliverToAddress1.length() > 90)
{
log.warning("Length > 90 - truncated");
DeliverToAddress1 = DeliverToAddress1.substring(0,90);
}
set_Value ("DeliverToAddress1", DeliverToAddress1);
}
/** Get DeliverToAddress1.
@return DeliverToAddress1 */
public String getDeliverToAddress1() 
{
return (String)get_Value("DeliverToAddress1");
}
/** Set DeliverToAddress2.
@param DeliverToAddress2 DeliverToAddress2 */
public void setDeliverToAddress2 (String DeliverToAddress2)
{
if (DeliverToAddress2 != null && DeliverToAddress2.length() > 90)
{
log.warning("Length > 90 - truncated");
DeliverToAddress2 = DeliverToAddress2.substring(0,90);
}
set_Value ("DeliverToAddress2", DeliverToAddress2);
}
/** Get DeliverToAddress2.
@return DeliverToAddress2 */
public String getDeliverToAddress2() 
{
return (String)get_Value("DeliverToAddress2");
}
/** Set DeliverToCity.
@param DeliverToCity DeliverToCity */
public void setDeliverToCity (String DeliverToCity)
{
if (DeliverToCity != null && DeliverToCity.length() > 60)
{
log.warning("Length > 60 - truncated");
DeliverToCity = DeliverToCity.substring(0,60);
}
set_Value ("DeliverToCity", DeliverToCity);
}
/** Get DeliverToCity.
@return DeliverToCity */
public String getDeliverToCity() 
{
return (String)get_Value("DeliverToCity");
}
/** Set Deliver To Fax.
@param DeliverToFax Deliver To Fax */
public void setDeliverToFax (String DeliverToFax)
{
if (DeliverToFax != null && DeliverToFax.length() > 16)
{
log.warning("Length > 16 - truncated");
DeliverToFax = DeliverToFax.substring(0,16);
}
set_Value ("DeliverToFax", DeliverToFax);
}
/** Get Deliver To Fax.
@return Deliver To Fax */
public String getDeliverToFax() 
{
return (String)get_Value("DeliverToFax");
}
/** Set Deliver To Phone.
@param DeliverToPhone Deliver To Phone */
public void setDeliverToPhone (String DeliverToPhone)
{
if (DeliverToPhone != null && DeliverToPhone.length() > 16)
{
log.warning("Length > 16 - truncated");
DeliverToPhone = DeliverToPhone.substring(0,16);
}
set_Value ("DeliverToPhone", DeliverToPhone);
}
/** Get Deliver To Phone.
@return Deliver To Phone */
public String getDeliverToPhone() 
{
return (String)get_Value("DeliverToPhone");
}
/** Set Deliver To Postal.
@param DeliverToPostal Deliver To Postal */
public void setDeliverToPostal (String DeliverToPostal)
{
if (DeliverToPostal != null && DeliverToPostal.length() > 90)
{
log.warning("Length > 90 - truncated");
DeliverToPostal = DeliverToPostal.substring(0,90);
}
set_Value ("DeliverToPostal", DeliverToPostal);
}
/** Get Deliver To Postal.
@return Deliver To Postal */
public String getDeliverToPostal() 
{
return (String)get_Value("DeliverToPostal");
}
/** Set DeliverToPostalAdd.
@param DeliverToPostalAdd DeliverToPostalAdd */
public void setDeliverToPostalAdd (String DeliverToPostalAdd)
{
if (DeliverToPostalAdd != null && DeliverToPostalAdd.length() > 10)
{
log.warning("Length > 10 - truncated");
DeliverToPostalAdd = DeliverToPostalAdd.substring(0,10);
}
set_Value ("DeliverToPostalAdd", DeliverToPostalAdd);
}
/** Get DeliverToPostalAdd.
@return DeliverToPostalAdd */
public String getDeliverToPostalAdd() 
{
return (String)get_Value("DeliverToPostalAdd");
}
/** Set DeliverToRegionName.
@param DeliverToRegionName DeliverToRegionName */
public void setDeliverToRegionName (String DeliverToRegionName)
{
if (DeliverToRegionName != null && DeliverToRegionName.length() > 40)
{
log.warning("Length > 40 - truncated");
DeliverToRegionName = DeliverToRegionName.substring(0,40);
}
set_Value ("DeliverToRegionName", DeliverToRegionName);
}
/** Get DeliverToRegionName.
@return DeliverToRegionName */
public String getDeliverToRegionName() 
{
return (String)get_Value("DeliverToRegionName");
}

/** DeliverToRegion_ID AD_Reference_ID=157 */
public static final int DELIVERTOREGION_ID_AD_Reference_ID=157;
/** Set DeliverToRegion_ID.
@param DeliverToRegion_ID Deliver To Region */
public void setDeliverToRegion_ID (int DeliverToRegion_ID)
{
if (DeliverToRegion_ID <= 0) set_Value ("DeliverToRegion_ID", null);
else
set_Value ("DeliverToRegion_ID", new Integer(DeliverToRegion_ID));
}
/** Get DeliverToRegion_ID.
@return Deliver To Region */
public int getDeliverToRegion_ID() 
{
Integer ii = (Integer)get_Value("DeliverToRegion_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** DeliveryToLoc_ID AD_Reference_ID=159 */
public static final int DELIVERYTOLOC_ID_AD_Reference_ID=159;
/** Set Delivery To Location.
@param DeliveryToLoc_ID Delivery To Location */
public void setDeliveryToLoc_ID (int DeliveryToLoc_ID)
{
if (DeliveryToLoc_ID <= 0) set_Value ("DeliveryToLoc_ID", null);
else
set_Value ("DeliveryToLoc_ID", new Integer(DeliveryToLoc_ID));
}
/** Get Delivery To Location.
@return Delivery To Location */
public int getDeliveryToLoc_ID() 
{
Integer ii = (Integer)get_Value("DeliveryToLoc_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** DeliveryTo_ID AD_Reference_ID=138 */
public static final int DELIVERYTO_ID_AD_Reference_ID=138;
/** Set Delivery To.
@param DeliveryTo_ID Delivery To */
public void setDeliveryTo_ID (int DeliveryTo_ID)
{
if (DeliveryTo_ID <= 0) set_Value ("DeliveryTo_ID", null);
else
set_Value ("DeliveryTo_ID", new Integer(DeliveryTo_ID));
}
/** Get Delivery To.
@return Delivery To */
public int getDeliveryTo_ID() 
{
Integer ii = (Integer)get_Value("DeliveryTo_ID");
if (ii == null) return 0;
return ii.intValue();
}

/** DeliveryViaRule AD_Reference_ID=152 */
public static final int DELIVERYVIARULE_AD_Reference_ID=152;
/** Air = A */
public static final String DELIVERYVIARULE_Air = "A";
/** Delivery = D */
public static final String DELIVERYVIARULE_Delivery = "D";
/** Pickup = P */
public static final String DELIVERYVIARULE_Pickup = "P";
/** Shipper = S */
public static final String DELIVERYVIARULE_Shipper = "S";
/** Vessel = V */
public static final String DELIVERYVIARULE_Vessel = "V";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isDeliveryViaRuleValid (String test)
{
return test == null || test.equals("A") || test.equals("D") || test.equals("P") || test.equals("S") || test.equals("V");
}
/** Set Shipping Method.
@param DeliveryViaRule How the order will be delivered */
public void setDeliveryViaRule (String DeliveryViaRule)
{
if (!isDeliveryViaRuleValid(DeliveryViaRule))
throw new IllegalArgumentException ("DeliveryViaRule Invalid value - " + DeliveryViaRule + " - Reference_ID=152 - A - D - P - S - V");
if (DeliveryViaRule != null && DeliveryViaRule.length() > 1)
{
log.warning("Length > 1 - truncated");
DeliveryViaRule = DeliveryViaRule.substring(0,1);
}
set_Value ("DeliveryViaRule", DeliveryViaRule);
}
/** Get Shipping Method.
@return How the order will be delivered */
public String getDeliveryViaRule() 
{
return (String)get_Value("DeliveryViaRule");
}
/** Set Description.
@param Description Optional short description of the record */
public void setDescription (String Description)
{
if (Description != null && Description.length() > 255)
{
log.warning("Length > 255 - truncated");
Description = Description.substring(0,255);
}
set_Value ("Description", Description);
}
/** Get Description.
@return Optional short description of the record */
public String getDescription() 
{
return (String)get_Value("Description");
}
/** Set Document Type Name.
@param DocTypeName Name of the Document Type */
public void setDocTypeName (String DocTypeName)
{
if (DocTypeName != null && DocTypeName.length() > 60)
{
log.warning("Length > 60 - truncated");
DocTypeName = DocTypeName.substring(0,60);
}
set_Value ("DocTypeName", DocTypeName);
}
/** Get Document Type Name.
@return Name of the Document Type */
public String getDocTypeName() 
{
return (String)get_Value("DocTypeName");
}
/** Set Document No.
@param DocumentNo Document sequence number of the document */
public void setDocumentNo (String DocumentNo)
{
if (DocumentNo != null && DocumentNo.length() > 30)
{
log.warning("Length > 30 - truncated");
DocumentNo = DocumentNo.substring(0,30);
}
set_Value ("DocumentNo", DocumentNo);
}
/** Get Document No.
@return Document sequence number of the document */
public String getDocumentNo() 
{
return (String)get_Value("DocumentNo");
}
/** Set EDI_No.
@param EDI_No EDI_No */
public void setEDI_No (String EDI_No)
{
if (EDI_No != null && EDI_No.length() > 20)
{
log.warning("Length > 20 - truncated");
EDI_No = EDI_No.substring(0,20);
}
set_Value ("EDI_No", EDI_No);
}
/** Get EDI_No.
@return EDI_No */
public String getEDI_No() 
{
return (String)get_Value("EDI_No");
}
/** Set EMail Address.
@param EMail Electronic Mail Address */
public void setEMail (String EMail)
{
if (EMail != null && EMail.length() > 60)
{
log.warning("Length > 60 - truncated");
EMail = EMail.substring(0,60);
}
set_Value ("EMail", EMail);
}
/** Get EMail Address.
@return Electronic Mail Address */
public String getEMail() 
{
return (String)get_Value("EMail");
}
/** Set EDI Imp Control.
@param E_Imp_Control_ID EDI Imp Control */
public void setE_Imp_Control_ID (int E_Imp_Control_ID)
{
if (E_Imp_Control_ID <= 0) set_Value ("E_Imp_Control_ID", null);
else
set_Value ("E_Imp_Control_ID", new Integer(E_Imp_Control_ID));
}
/** Get EDI Imp Control.
@return EDI Imp Control */
public int getE_Imp_Control_ID() 
{
Integer ii = (Integer)get_Value("E_Imp_Control_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set EDI Imp Execute.
@param E_Imp_Exe_ID EDI Imp Execute */
public void setE_Imp_Exe_ID (int E_Imp_Exe_ID)
{
if (E_Imp_Exe_ID <= 0) set_Value ("E_Imp_Exe_ID", null);
else
set_Value ("E_Imp_Exe_ID", new Integer(E_Imp_Exe_ID));
}
/** Get EDI Imp Execute.
@return EDI Imp Execute */
public int getE_Imp_Exe_ID() 
{
Integer ii = (Integer)get_Value("E_Imp_Exe_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Fax.
@param Fax Facsimile number */
public void setFax (String Fax)
{
if (Fax != null && Fax.length() > 40)
{
log.warning("Length > 40 - truncated");
Fax = Fax.substring(0,40);
}
set_Value ("Fax", Fax);
}
/** Get Fax.
@return Facsimile number */
public String getFax() 
{
return (String)get_Value("Fax");
}
/** Set Freight Amount.
@param FreightAmt Freight Amount  */
public void setFreightAmt (BigDecimal FreightAmt)
{
set_Value ("FreightAmt", FreightAmt);
}
/** Get Freight Amount.
@return Freight Amount  */
public BigDecimal getFreightAmt() 
{
BigDecimal bd = (BigDecimal)get_Value("FreightAmt");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set ISO Currency Code.
@param ISO_Code Three letter ISO 4217 Code of the Currency */
public void setISO_Code (String ISO_Code)
{
if (ISO_Code != null && ISO_Code.length() > 3)
{
log.warning("Length > 3 - truncated");
ISO_Code = ISO_Code.substring(0,3);
}
set_Value ("ISO_Code", ISO_Code);
}
/** Get ISO Currency Code.
@return Three letter ISO 4217 Code of the Currency */
public String getISO_Code() 
{
return (String)get_Value("ISO_Code");
}
/** Set I_Edi_Order_ID.
@param I_Edi_Order_ID I_Edi_Order_ID */
public void setI_Edi_Order_ID (int I_Edi_Order_ID)
{
if (I_Edi_Order_ID < 1) throw new IllegalArgumentException ("I_Edi_Order_ID is mandatory.");
set_ValueNoCheck ("I_Edi_Order_ID", new Integer(I_Edi_Order_ID));
}
/** Get I_Edi_Order_ID.
@return I_Edi_Order_ID */
public int getI_Edi_Order_ID() 
{
Integer ii = (Integer)get_Value("I_Edi_Order_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Import Error Message.
@param I_ErrorMsg Messages generated from import process */
public void setI_ErrorMsg (String I_ErrorMsg)
{
if (I_ErrorMsg != null && I_ErrorMsg.length() > 2000)
{
log.warning("Length > 2000 - truncated");
I_ErrorMsg = I_ErrorMsg.substring(0,2000);
}
set_Value ("I_ErrorMsg", I_ErrorMsg);
}
/** Get Import Error Message.
@return Messages generated from import process */
public String getI_ErrorMsg() 
{
return (String)get_Value("I_ErrorMsg");
}
/** Set Imported.
@param I_IsImported Has this import been processed */
public void setI_IsImported (boolean I_IsImported)
{
set_Value ("I_IsImported", new Boolean(I_IsImported));
}
/** Get Imported.
@return Has this import been processed */
public boolean isI_IsImported() 
{
Object oo = get_Value("I_IsImported");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Sales Transaction.
@param IsSOTrx This is a Sales Transaction */
public void setIsSOTrx (boolean IsSOTrx)
{
set_Value ("IsSOTrx", new Boolean(IsSOTrx));
}
/** Get Sales Transaction.
@return This is a Sales Transaction */
public boolean isSOTrx() 
{
Object oo = get_Value("IsSOTrx");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Line No.
@param Line Unique line for this document */
public void setLine (int Line)
{
set_Value ("Line", new Integer(Line));
}
/** Get Line No.
@return Unique line for this document */
public int getLine() 
{
Integer ii = (Integer)get_Value("Line");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Line Description.
@param LineDescription Description of the Line */
public void setLineDescription (String LineDescription)
{
if (LineDescription != null && LineDescription.length() > 255)
{
log.warning("Length > 255 - truncated");
LineDescription = LineDescription.substring(0,255);
}
set_Value ("LineDescription", LineDescription);
}
/** Get Line Description.
@return Description of the Line */
public String getLineDescription() 
{
return (String)get_Value("LineDescription");
}
/** Set Line Amount.
@param LineNetAmt Line Extended Amount (Quantity * Actual Price) without Freight and Charges */
public void setLineNetAmt (BigDecimal LineNetAmt)
{
set_Value ("LineNetAmt", LineNetAmt);
}
/** Get Line Amount.
@return Line Extended Amount (Quantity * Actual Price) without Freight and Charges */
public BigDecimal getLineNetAmt() 
{
BigDecimal bd = (BigDecimal)get_Value("LineNetAmt");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Price List.
@param M_PriceList_ID Unique identifier of a Price List */
public void setM_PriceList_ID (int M_PriceList_ID)
{
if (M_PriceList_ID <= 0) set_Value ("M_PriceList_ID", null);
else
set_Value ("M_PriceList_ID", new Integer(M_PriceList_ID));
}
/** Get Price List.
@return Unique identifier of a Price List */
public int getM_PriceList_ID() 
{
Integer ii = (Integer)get_Value("M_PriceList_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Product.
@param M_Product_ID Product, Service, Item */
public void setM_Product_ID (int M_Product_ID)
{
if (M_Product_ID <= 0) set_Value ("M_Product_ID", null);
else
set_Value ("M_Product_ID", new Integer(M_Product_ID));
}
/** Get Product.
@return Product, Service, Item */
public int getM_Product_ID() 
{
Integer ii = (Integer)get_Value("M_Product_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Freight Carrier.
@param M_Shipper_ID Method or manner of product delivery */
public void setM_Shipper_ID (int M_Shipper_ID)
{
if (M_Shipper_ID <= 0) set_Value ("M_Shipper_ID", null);
else
set_Value ("M_Shipper_ID", new Integer(M_Shipper_ID));
}
/** Get Freight Carrier.
@return Method or manner of product delivery */
public int getM_Shipper_ID() 
{
Integer ii = (Integer)get_Value("M_Shipper_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set Warehouse.
@param M_Warehouse_ID Storage Warehouse and Service Point */
public void setM_Warehouse_ID (int M_Warehouse_ID)
{
if (M_Warehouse_ID <= 0) set_Value ("M_Warehouse_ID", null);
else
set_Value ("M_Warehouse_ID", new Integer(M_Warehouse_ID));
}
/** Get Warehouse.
@return Storage Warehouse and Service Point */
public int getM_Warehouse_ID() 
{
Integer ii = (Integer)get_Value("M_Warehouse_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set ManufacturerCd.
@param ManufacturerCd ManufacturerCd */
public void setManufacturerCd (String ManufacturerCd)
{
if (ManufacturerCd != null && ManufacturerCd.length() > 40)
{
log.warning("Length > 40 - truncated");
ManufacturerCd = ManufacturerCd.substring(0,40);
}
set_Value ("ManufacturerCd", ManufacturerCd);
}
/** Get ManufacturerCd.
@return ManufacturerCd */
public String getManufacturerCd() 
{
return (String)get_Value("ManufacturerCd");
}
/** Set Name.
@param Name Alphanumeric identifier of the entity */
public void setName (String Name)
{
if (Name != null && Name.length() > 120)
{
log.warning("Length > 120 - truncated");
Name = Name.substring(0,120);
}
set_Value ("Name", Name);
}
/** Get Name.
@return Alphanumeric identifier of the entity */
public String getName() 
{
return (String)get_Value("Name");
}
/** Get Record ID/ColumnName
@return ID/ColumnName pair */
public KeyNamePair getKeyNamePair() 
{
return new KeyNamePair(get_ID(), getName());
}
/** Set Name 2.
@param Name2 Additional Name */
public void setName2 (String Name2)
{
if (Name2 != null && Name2.length() > 60)
{
log.warning("Length > 60 - truncated");
Name2 = Name2.substring(0,60);
}
set_Value ("Name2", Name2);
}
/** Get Name 2.
@return Additional Name */
public String getName2() 
{
return (String)get_Value("Name2");
}
/** Set Order Reference.
@param POReference Transaction Reference Number (Sales Order, Purchase Order) of your Business Partner */
public void setPOReference (String POReference)
{
if (POReference != null && POReference.length() > 32)
{
log.warning("Length > 32 - truncated");
POReference = POReference.substring(0,32);
}
set_Value ("POReference", POReference);
}
/** Get Order Reference.
@return Transaction Reference Number (Sales Order, Purchase Order) of your Business Partner */
public String getPOReference() 
{
return (String)get_Value("POReference");
}

/** PaymentRule AD_Reference_ID=195 */
public static final int PAYMENTRULE_AD_Reference_ID=195;
/** Cash = B */
public static final String PAYMENTRULE_Cash = "B";
/** Collect on Delivery = C */
public static final String PAYMENTRULE_CollectOnDelivery = "C";
/** Direct Debit = D */
public static final String PAYMENTRULE_DirectDebit = "D";
/** Credit Card = K */
public static final String PAYMENTRULE_CreditCard = "K";
/** Notes = N */
public static final String PAYMENTRULE_Notes = "N";
/** On Credit = P */
public static final String PAYMENTRULE_OnCredit = "P";
/** Check = S */
public static final String PAYMENTRULE_Check = "S";
/** Direct Deposit = T */
public static final String PAYMENTRULE_DirectDeposit = "T";
/** Is test a valid value.
@param test testvalue
@returns true if valid **/
public boolean isPaymentRuleValid (String test)
{
return test == null || test.equals("B") || test.equals("C") || test.equals("D") || test.equals("K") || test.equals("N") || test.equals("P") || test.equals("S") || test.equals("T");
}
/** Set Payment Method.
@param PaymentRule How you pay the invoice */
public void setPaymentRule (String PaymentRule)
{
if (!isPaymentRuleValid(PaymentRule))
throw new IllegalArgumentException ("PaymentRule Invalid value - " + PaymentRule + " - Reference_ID=195 - B - C - D - K - N - P - S - T");
if (PaymentRule != null && PaymentRule.length() > 1)
{
log.warning("Length > 1 - truncated");
PaymentRule = PaymentRule.substring(0,1);
}
set_Value ("PaymentRule", PaymentRule);
}
/** Get Payment Method.
@return How you pay the invoice */
public String getPaymentRule() 
{
return (String)get_Value("PaymentRule");
}
/** Set Payment Rule Name.
@param PaymentRuleName Name of the Payment Rule */
public void setPaymentRuleName (String PaymentRuleName)
{
if (PaymentRuleName != null && PaymentRuleName.length() > 60)
{
log.warning("Length > 60 - truncated");
PaymentRuleName = PaymentRuleName.substring(0,60);
}
set_Value ("PaymentRuleName", PaymentRuleName);
}
/** Get Payment Rule Name.
@return Name of the Payment Rule */
public String getPaymentRuleName() 
{
return (String)get_Value("PaymentRuleName");
}
/** Set Payment Term Key.
@param PaymentTermValue Key of the Payment Term */
public void setPaymentTermValue (String PaymentTermValue)
{
if (PaymentTermValue != null && PaymentTermValue.length() > 40)
{
log.warning("Length > 40 - truncated");
PaymentTermValue = PaymentTermValue.substring(0,40);
}
set_Value ("PaymentTermValue", PaymentTermValue);
}
/** Get Payment Term Key.
@return Key of the Payment Term */
public String getPaymentTermValue() 
{
return (String)get_Value("PaymentTermValue");
}
/** Set Phone.
@param Phone Identifies a telephone number */
public void setPhone (String Phone)
{
if (Phone != null && Phone.length() > 40)
{
log.warning("Length > 40 - truncated");
Phone = Phone.substring(0,40);
}
set_Value ("Phone", Phone);
}
/** Get Phone.
@return Identifies a telephone number */
public String getPhone() 
{
return (String)get_Value("Phone");
}
/** Set ZIP.
@param Postal Postal code */
public void setPostal (String Postal)
{
if (Postal != null && Postal.length() > 10)
{
log.warning("Length > 10 - truncated");
Postal = Postal.substring(0,10);
}
set_Value ("Postal", Postal);
}
/** Get ZIP.
@return Postal code */
public String getPostal() 
{
return (String)get_Value("Postal");
}
/** Set -.
@param Postal_Add Additional ZIP or Postal code */
public void setPostal_Add (String Postal_Add)
{
if (Postal_Add != null && Postal_Add.length() > 10)
{
log.warning("Length > 10 - truncated");
Postal_Add = Postal_Add.substring(0,10);
}
set_Value ("Postal_Add", Postal_Add);
}
/** Get -.
@return Additional ZIP or Postal code */
public String getPostal_Add() 
{
return (String)get_Value("Postal_Add");
}
/** Set Unit Price.
@param PriceActual Actual Price  */
public void setPriceActual (BigDecimal PriceActual)
{
set_Value ("PriceActual", PriceActual);
}
/** Get Unit Price.
@return Actual Price  */
public BigDecimal getPriceActual() 
{
BigDecimal bd = (BigDecimal)get_Value("PriceActual");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set PriceListName.
@param PriceListName PriceListName */
public void setPriceListName (String PriceListName)
{
if (PriceListName != null && PriceListName.length() > 40)
{
log.warning("Length > 40 - truncated");
PriceListName = PriceListName.substring(0,40);
}
set_Value ("PriceListName", PriceListName);
}
/** Get PriceListName.
@return PriceListName */
public String getPriceListName() 
{
return (String)get_Value("PriceListName");
}
/** Set Processed.
@param Processed The document has been processed */
public void setProcessed (boolean Processed)
{
set_Value ("Processed", new Boolean(Processed));
}
/** Get Processed.
@return The document has been processed */
public boolean isProcessed() 
{
Object oo = get_Value("Processed");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Process Now.
@param Processing Process Now */
public void setProcessing (boolean Processing)
{
set_Value ("Processing", new Boolean(Processing));
}
/** Get Process Now.
@return Process Now */
public boolean isProcessing() 
{
Object oo = get_Value("Processing");
if (oo != null) 
{
 if (oo instanceof Boolean) return ((Boolean)oo).booleanValue();
 return "Y".equals(oo);
}
return false;
}
/** Set Product Name.
@param ProductName Name of the Product */
public void setProductName (String ProductName)
{
if (ProductName != null && ProductName.length() > 60)
{
log.warning("Length > 60 - truncated");
ProductName = ProductName.substring(0,60);
}
set_Value ("ProductName", ProductName);
}
/** Get Product Name.
@return Name of the Product */
public String getProductName() 
{
return (String)get_Value("ProductName");
}
/** Set Product Key.
@param ProductValue Key of the Product */
public void setProductValue (String ProductValue)
{
if (ProductValue != null && ProductValue.length() > 40)
{
log.warning("Length > 40 - truncated");
ProductValue = ProductValue.substring(0,40);
}
set_Value ("ProductValue", ProductValue);
}
/** Get Product Key.
@return Key of the Product */
public String getProductValue() 
{
return (String)get_Value("ProductValue");
}
/** Set Quantity.
@param QtyEntered The Quantity Entered is based on the selected UoM */
public void setQtyEntered (BigDecimal QtyEntered)
{
set_Value ("QtyEntered", QtyEntered);
}
/** Get Quantity.
@return The Quantity Entered is based on the selected UoM */
public BigDecimal getQtyEntered() 
{
BigDecimal bd = (BigDecimal)get_Value("QtyEntered");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Ordered Quantity.
@param QtyOrdered Ordered Quantity */
public void setQtyOrdered (BigDecimal QtyOrdered)
{
set_Value ("QtyOrdered", QtyOrdered);
}
/** Get Ordered Quantity.
@return Ordered Quantity */
public BigDecimal getQtyOrdered() 
{
BigDecimal bd = (BigDecimal)get_Value("QtyOrdered");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Region.
@param RegionName Name of the Region */
public void setRegionName (String RegionName)
{
if (RegionName != null && RegionName.length() > 60)
{
log.warning("Length > 60 - truncated");
RegionName = RegionName.substring(0,60);
}
set_Value ("RegionName", RegionName);
}
/** Get Region.
@return Name of the Region */
public String getRegionName() 
{
return (String)get_Value("RegionName");
}
/** Set Row No.
@param RowNo Row No */
public void setRowNo (int RowNo)
{
set_Value ("RowNo", new Integer(RowNo));
}
/** Get Row No.
@return Row No */
public int getRowNo() 
{
Integer ii = (Integer)get_Value("RowNo");
if (ii == null) return 0;
return ii.intValue();
}
/** Set SKU.
@param SKU Stock Keeping Unit */
public void setSKU (String SKU)
{
if (SKU != null && SKU.length() > 30)
{
log.warning("Length > 30 - truncated");
SKU = SKU.substring(0,30);
}
set_Value ("SKU", SKU);
}
/** Get SKU.
@return Stock Keeping Unit */
public String getSKU() 
{
return (String)get_Value("SKU");
}
/** Set Representative Name.
@param SalesRepName Representative Name */
public void setSalesRepName (String SalesRepName)
{
if (SalesRepName != null && SalesRepName.length() > 40)
{
log.warning("Length > 40 - truncated");
SalesRepName = SalesRepName.substring(0,40);
}
set_Value ("SalesRepName", SalesRepName);
}
/** Get Representative Name.
@return Representative Name */
public String getSalesRepName() 
{
return (String)get_Value("SalesRepName");
}

/** SalesRep_ID AD_Reference_ID=190 */
public static final int SALESREP_ID_AD_Reference_ID=190;
/** Set Representative.
@param SalesRep_ID Company Agent like Sales Representitive, Purchase Agent, Customer Service Representative, ... */
public void setSalesRep_ID (int SalesRep_ID)
{
if (SalesRep_ID <= 0) set_Value ("SalesRep_ID", null);
else
set_Value ("SalesRep_ID", new Integer(SalesRep_ID));
}
/** Get Representative.
@return Company Agent like Sales Representitive, Purchase Agent, Customer Service Representative, ... */
public int getSalesRep_ID() 
{
Integer ii = (Integer)get_Value("SalesRep_ID");
if (ii == null) return 0;
return ii.intValue();
}
/** Set ShipperName.
@param ShipperName ShipperName */
public void setShipperName (String ShipperName)
{
if (ShipperName != null && ShipperName.length() > 60)
{
log.warning("Length > 60 - truncated");
ShipperName = ShipperName.substring(0,60);
}
set_Value ("ShipperName", ShipperName);
}
/** Get ShipperName.
@return ShipperName */
public String getShipperName() 
{
return (String)get_Value("ShipperName");
}
/** Set Tax Amount.
@param TaxAmt Tax Amount for a document */
public void setTaxAmt (BigDecimal TaxAmt)
{
set_Value ("TaxAmt", TaxAmt);
}
/** Get Tax Amount.
@return Tax Amount for a document */
public BigDecimal getTaxAmt() 
{
BigDecimal bd = (BigDecimal)get_Value("TaxAmt");
if (bd == null) return Env.ZERO;
return bd;
}
/** Set Tax Indicator.
@param TaxIndicator Short form for Tax to be printed on documents */
public void setTaxIndicator (String TaxIndicator)
{
if (TaxIndicator != null && TaxIndicator.length() > 5)
{
log.warning("Length > 5 - truncated");
TaxIndicator = TaxIndicator.substring(0,5);
}
set_Value ("TaxIndicator", TaxIndicator);
}
/** Get Tax Indicator.
@return Short form for Tax to be printed on documents */
public String getTaxIndicator() 
{
return (String)get_Value("TaxIndicator");
}
/** Set UPC/EAN.
@param UPC Bar Code (Universal Product Code or its superset European Article Number) */
public void setUPC (String UPC)
{
if (UPC != null && UPC.length() > 30)
{
log.warning("Length > 30 - truncated");
UPC = UPC.substring(0,30);
}
set_Value ("UPC", UPC);
}
/** Get UPC/EAN.
@return Bar Code (Universal Product Code or its superset European Article Number) */
public String getUPC() 
{
return (String)get_Value("UPC");
}
/** Set Valid to.
@param ValidTo Valid to including this date (last day) */
public void setValidTo (Timestamp ValidTo)
{
set_ValueNoCheck ("ValidTo", ValidTo);
}
/** Get Valid to.
@return Valid to including this date (last day) */
public Timestamp getValidTo() 
{
return (Timestamp)get_Value("ValidTo");
}
/** Set Warehouse Key.
@param WarehouseValue Key of the Warehouse */
public void setWarehouseValue (String WarehouseValue)
{
if (WarehouseValue != null && WarehouseValue.length() > 40)
{
log.warning("Length > 40 - truncated");
WarehouseValue = WarehouseValue.substring(0,40);
}
set_Value ("WarehouseValue", WarehouseValue);
}
/** Get Warehouse Key.
@return Key of the Warehouse */
public String getWarehouseValue() 
{
return (String)get_Value("WarehouseValue");
}
}
