/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.print;

import java.math.*;

import org.compiere.process.*;
import org.compiere.util.DB;

/**
 *	MPrintFormat to System.
 *  Change PrintFormat Client To SYstem
 *
 * 	@author 	Jirimuto
 * 	@version 	$Id: MPrintFormatChangeClient.java,v 1.2 2009/10/19 10:51:40 jrmt Exp $
 */
public class MPrintFormatChangeClient extends SvrProcess
{
	/** PrintFormat             */
	private BigDecimal	m_AD_PrintFormat_ID;
	/** Client             */
	private BigDecimal	m_AD_Client_ID;

	/**
	 *  Prepare - get Parameters.
	 */
	protected void prepare()
	{
		ProcessInfoParameter[] para = getParameter();
		for (int i = 0; i < para.length; i++)
		{
			String name = para[i].getParameterName();
			if (para[i].getParameter() == null)
				;
			else if (name.equals("AD_PrintFormat_ID"))
				m_AD_PrintFormat_ID = ((BigDecimal)para[i].getParameter());
			else if (name.equals("AD_Client_ID"))
				m_AD_Client_ID = ((BigDecimal)para[i].getParameter());
			else
				log.equals("prepare - Unknown Parameter=" + para[i].getParameterName());
		}
	}   //  prepare

	/**
	 *  Perform process.
	 *  <pre>
	 *  If AD_Table_ID is not null, create from table,
	 *  otherwise copy from AD_PrintFormat_ID
	 *  </pre>
	 * @return Message
	 * @throws Exception
	 */
	protected String doIt() throws Exception
	{
		
		StringBuffer sql = new StringBuffer("UPDATE AD_PRINTFORMATITEM_TRL SET AD_CLIENT_ID="+m_AD_Client_ID+", AD_ORG_ID=0 " 
				+ "WHERE AD_PRINTFORMATITEM_ID IN (SELECT AD_PRINTFORMATITEM_ID FROM AD_PRINTFORMATITEM " 
				+ " WHERE AD_PRINTFORMAT_ID=" + m_AD_PrintFormat_ID + ")");
		int no = DB.executeUpdate(sql.toString(), get_TrxName());
		
		sql = new StringBuffer("UPDATE AD_PRINTFORMATITEM SET AD_CLIENT_ID="+m_AD_Client_ID+", AD_ORG_ID=0 WHERE AD_PRINTFORMAT_ID="+m_AD_PrintFormat_ID);
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		
		sql = new StringBuffer("UPDATE AD_PRINTFORMAT SET AD_CLIENT_ID="+m_AD_Client_ID+", AD_ORG_ID=0 WHERE AD_PRINTFORMAT_ID="+m_AD_PrintFormat_ID);
		no = DB.executeUpdate(sql.toString(), get_TrxName());
		
		
		return "@Updated@=" + no;
	}	//	doIt

}	//	MPrintFormatProcess
