/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.print.layout;

import java.awt.*;
import java.awt.geom.*;
import org.compiere.print.*;
import org.compiere.util.*;

import com.d_project.qrcode.ErrorCorrectLevel;

/**
 * 	QRCode Print Element
 *	
 *  @author Jirimuto
 *  @version $Id: QRCodeElement.java,v 1.1 2009/12/09 16:36:01 jrmt Exp $
 */
public class QRCodeElement extends PrintElement
{
	/**
	 * 	QRCode Element Constructor
	 *	@param code QRCode data string
	 *	@param item format item
	 */
	public QRCodeElement (String code, MPrintFormatItem item)
	{
		super ();
		if (code == null || code.length() == 0
			|| item == null
			|| item.getBarcodeType() == null || item.getBarcodeType().length() == 0)
			m_valid = false;
		createQRCode(code, item);
		if (m_qrcomponent == null)
			m_valid = false;
	}	//	QRCodeElement

	/**	Valid					*/
	private boolean 	m_valid = true;
	/**	 QRCompnent				*/
	private QRCompnent		m_qrcomponent = null;
	/**	 CellSize				*/
	int cellsize = 1;

	/**
	 * 	Create QRCode
	 *	@param code QRCode data string
	 *	@param item printformat item
	 */
	private void createQRCode(String code, MPrintFormatItem item)
	{
		String type = item.getBarcodeType();
		
		try
		{
			m_qrcomponent = new QRCompnent(code, 10, ErrorCorrectLevel.H);
		}
		catch (Exception e)
		{
			log.warning(code + " - " + e.toString());
			m_valid = false;
		}
		
		if (m_valid && m_qrcomponent != null)
		{
			p_info = "QRCodeType=" + type;
			if (item.getAD_PrintFont_ID() != 0)
			{
				MPrintFont mFont = MPrintFont.get(item.getAD_PrintFont_ID());
				if (mFont != null){
					int size = mFont.getFont().getSize();
					if( size <= 8 )
						cellsize = 1;
					else if ( size <= 10 )
						cellsize = 2;
					else if ( size <= 12 )
						cellsize = 3;
					else if ( size <= 14 )
						cellsize = 4;
					else if ( size <= 16 )
						cellsize = 5;
					else if ( size <= 18 )
						cellsize = 6;
					else if ( size <= 20 )
						cellsize = 7;
					else if ( size <= 22 )
						cellsize = 8;
					else if ( size <= 24 )
						cellsize = 9;
					else
						cellsize = size - 15;
					m_qrcomponent.setCellSize(cellsize);
				}
			}
			m_qrcomponent.calculatesize();
			
			p_width = m_qrcomponent.getWidth();
			p_height = m_qrcomponent.getHeight();
			log.fine(type + " height=" + p_height + ", width=" + p_width);
		}
	}	//	createQRCode
	
	
	/**
	 * 	Get QRCode
	 *	@return QRCode
	 */
	public QRCompnent getQRComponent()
	{
		return m_qrcomponent;
	}	//	getQRCode
	
	/**
	 * 	Is QRCode Valid
	 *	@return true if valid
	 */
	public boolean isValid()
	{
		return m_valid;
	}	//	isValid
	
	/**
	 * 	Layout and Calculate Size
	 * 	Set p_width & p_height
	 * 	@return true if calculated
	 */
	protected boolean calculateSize ()
	{
		
		return true;
	}	//	calculateSize

	
	/**
	 * 	Paint Element
	 *	@param g2D graphics
	 *	@param pageNo page no
	 *	@param pageStart page start
	 *	@param ctx context
	 *	@param isView view
	 */
	public void paint (Graphics2D g2D, int pageNo, Point2D pageStart,
		Ctx ctx, boolean isView)
	{
		if (!m_valid || m_qrcomponent == null)
			return;
		
		//	Position
		Point2D.Double location = getAbsoluteLocation(pageStart);
		int x = (int)location.x;
		if (MPrintFormatItem.FIELDALIGNMENTTYPE_TrailingRight.equals(p_FieldAlignmentType))
			x += p_maxWidth - p_width;
		else if (MPrintFormatItem.FIELDALIGNMENTTYPE_Center.equals(p_FieldAlignmentType))
			x += (p_maxWidth - p_width) / 2;
		int y = (int)location.y;

		m_qrcomponent.draw(g2D, x, y, this);
	}	//	paint
	
	/**
	 * 	String Representation
	 *	@return info
	 */
	public String toString ()
	{
		if (m_qrcomponent == null)
			return super.toString();
		return super.toString() + " " + m_qrcomponent.getData();
	}	//	toString
	
}	//	QRCodeElement
