/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2007 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 3600 Bridge Parkway #102, Redwood City, CA 94065, USA      *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.print.layout;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

import javax.swing.JComponent;

import com.d_project.qrcode.ErrorCorrectLevel;
import com.d_project.qrcode.QRCode;

/**
 * 	QRComponent
 *	
 *  @author Jirimuto
 *  @version $Id: QRCompnent.java,v 1.1 2009/12/09 16:36:01 jrmt Exp $
 */
public class QRCompnent extends JComponent {

	/**
	 * 	QRCompnent Constructor
	 *	@param code String 
	 */
	public QRCompnent(String code ) {
		super();
		m_data = code;
		m_typeNumber = 1;
		m_cellSize = 1;
		m_margin = 1;
		m_errorCorrectLevel = ErrorCorrectLevel.H;
		m_qrcode = getQRCode(code, m_typeNumber, m_errorCorrectLevel);
	}
	
	/**
	 * 	QRCompnent Constructor
	 *	@param code String 
	 *	@param typeNumber Integer 
	 *	@param errorCorrectLevel Integer 
	 */
	public QRCompnent(String code, int typeNumber, int errorCorrectLevel ) {
		super();
		m_data = code;
		m_typeNumber = typeNumber;
		m_cellSize = 1;
		m_margin = 1;
		m_errorCorrectLevel = errorCorrectLevel;
		m_qrcode = getQRCode(code, m_typeNumber, m_errorCorrectLevel);
	}
	
	/**
	 * 	QRCompnent Constructor
	 *	@param code String 
	 *	@param typeNumber Integer 
	 *	@param errorCorrectLevel Integer 
	 *	@param cellSize Integer 
	 *	@param margen Integer 
	 */
	public QRCompnent(String code, int typeNumber, int errorCorrectLevel, int cellSize, int margen ) {
		super();
		m_data = code;
		m_typeNumber = typeNumber;
		m_cellSize = cellSize;
		m_margin = margen;
		m_errorCorrectLevel = errorCorrectLevel;
		m_qrcode = getQRCode(code, m_typeNumber, m_errorCorrectLevel);
	}
	/**	 QRCode				*/
	private QRCode		m_qrcode = null;
	/**	 typeNumber				*/
	int m_typeNumber = 1;
	/**	 CellSize				*/
	int m_cellSize = 1;
	/**	 margin				*/
	int m_margin = 1;
	/**	 data				*/
	String m_data = null;
	
	BufferedImage m_image = null;
	
	/**	 errorCorrectLevel				*/
	int m_errorCorrectLevel = ErrorCorrectLevel.H;
	
	private static QRCode getQRCode(String text, int typeNumber, int errorCorrectLevel) {

		if (typeNumber == 0) {

			return QRCode.getMinimumQRCode(text, errorCorrectLevel);

		} else {

			QRCode qr = new QRCode();
			qr.setTypeNumber(typeNumber);
			qr.setErrorCorrectLevel(errorCorrectLevel);
			qr.addData(text);
			qr.make();
			
			return qr;

		}
	}
	
	public boolean calculatesize (){
		
		try {
			m_image = m_qrcode.createImage(m_cellSize, m_margin);
			
		} catch (Exception e){
			m_image = null;
		}
		
		if( m_image != null)
			return true; 
		
		return false;
	}
	
	public int getWidth(){
		return m_image.getWidth();
	}
	
	public int getHeight(){
		return m_image.getHeight();
	}
	
	/**
	 * 	draw Component
	 *	@param g2D Graphics2D 
	 *	@param x Integer 
	 *	@param y Integer 
	 */
	public void draw (Graphics2D g2D, int x, int y, ImageObserver observer)
	{
		if( m_image != null )
			g2D.drawImage(m_image, x, y, observer);
	}	
	
	public QRCode getQRCode() {
		return m_qrcode;
	}

	public void setQRCode(QRCode m_qrcode) {
		this.m_qrcode = m_qrcode;
	}

	public int getTypeNumber() {
		return m_typeNumber;
	}

	public void setTypeNumber(int number) {
		m_typeNumber = number;
	}

	public int getCellSize() {
		return m_cellSize;
	}

	public void setCellSize(int size) {
		m_cellSize = size;
	}

	public int getMargin() {
		return m_margin;
	}

	public void setMargin(int m_margin) {
		this.m_margin = m_margin;
	}

	public int getErrorCorrectLevel() {
		return m_errorCorrectLevel;
	}

	public void setErrorCorrectLevel(int correctLevel) {
		m_errorCorrectLevel = correctLevel;
	}

	public String getData() {
		return m_data;
	}

	public void setData(String m_data) {
		this.m_data = m_data;
	}
	    
	
}
