/******************************************************************************
 * Product: Compiere ERP & CRM Smart Business Solution                        *
 * Copyright (C) 1999-2006 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software; you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.acct;

import java.math.BigDecimal;

import org.compiere.model.MBankStatementCharge;
import org.compiere.util.Env;

/**
 *  Post Bank Statemtnt Charge.
 *  <pre>
 *  Table:              C_BankStatementCharge (392)
 *  </pre>
 *  @author Bao
 *  @version  $Id: DocLine_BankCharge.java,v 1.1 2010/04/09 09:26:23 jrmt Exp $
 */
public class DocLine_BankCharge  extends DocLine
{

	/**
	 *  Constructor
	 * @param charge Bank Statement Charge
	 * @param doc header
	 */
	public DocLine_BankCharge(MBankStatementCharge charge, Doc_Bank doc) {
		super(charge, doc);
		m_ChargeAmt = charge.getChargeAmt();
		m_TaxAmt = charge.getTaxAmt();
		m_TotalAmt = charge.getTotalAmt();
		m_C_Charge_ID = charge.getC_Charge_ID();
		m_C_Tax_ID = charge.getC_Tax_ID();
		m_IsTaxIncluded = charge.isTaxIncluded();
		
		if( m_IsTaxIncluded )
			m_ChargeAmtNoTax = m_ChargeAmt.subtract(m_TaxAmt);
		else
			m_ChargeAmtNoTax = m_ChargeAmt;
	}		

	/** Charge Amt */
	private BigDecimal  m_ChargeAmt = Env.ZERO;
	/** Charge Amt No Tax*/
	private BigDecimal  m_ChargeAmtNoTax = Env.ZERO;
	/** Tax Amt */
	private BigDecimal  m_TaxAmt = Env.ZERO;
	/** Total Amt */
	private BigDecimal  m_TotalAmt = Env.ZERO;
	/** Charge ID */
	private int         m_C_Charge_ID = 0;
	/** Tax ID */
	private int         m_C_Tax_ID = 0;
	/** IsTaxIncluded */
	private boolean     m_IsTaxIncluded = true;
	
	public BigDecimal getChargeAmt() {
		return m_ChargeAmt;
	}
	public BigDecimal getTaxAmt() {
		return m_TaxAmt;
	}
	public BigDecimal getTotalAmt() {
		return m_TotalAmt;
	}
	public int getC_Charge_ID() {
		return m_C_Charge_ID;
	}
	public BigDecimal getChargeAmtNoTax() {
		return m_ChargeAmtNoTax;
	}
	public int getC_Tax_ID() {
		return m_C_Tax_ID;
	}
	public boolean isTaxIncluded() {
		return m_IsTaxIncluded;
	}
	
}	// DocLine_BankCharge
