<%@ include file="/WEB-INF/jspf/page.jspf" %>
<cws:priceList priceList_ID="0"/>
<html>
<!--
  - Author:  Jorg Janke
  - Version: $Id: index.jsp,v 1.3 2009/06/19 14:05:20 siqin Exp $
  - Compiere ERP & CRM Smart Business Solution - Copyright (c) 1999-2003 Jorg Janke
  - - -
  - Web Store Index
  -->
<head>
<%@ include file="/WEB-INF/jspf/head.jspf" %>
<title><c:out value='${ctx.name}'/> - <cws:message txt="W_Store_ID"/></title>
</head>
<body>
<div id="page">
<%@ include file="/WEB-INF/jspf/header.jspf" %>
<div id="main">
	<%@ include file="/WEB-INF/jspf/menu.jspf" %>
    <%@ include file="/WEB-INF/jspf/vendor.jspf" %>
	<div id="content">
		<div style="float:right;">
			<div id="banner"></div>
		</div>
		<div id="newsBlurb">
			<c:out value='${ctx.webParam2}' escapeXml='false'/>
		</div>
      <form action="productServlet" method="post" enctype="application/x-www-form-urlencoded" name="search" id="search">
          <fieldset>
              <legend><cws:message txt="Search" /></legend>
              <label id="productSearch" for="SearchString"><cws:message txt="M_Product_ID" /></label>
              <input name="SearchString" type="text" id="SearchString">
              <cws:productCategoryList/>
              <input type="submit" name="Submit" value="<cws:message txt='Search' />">
              <br><br>
              <c:if test='${priceList.notAllPrices}'>
                <font color="red"><cws:message txt="NotAllRecordsDisplayed"/></font>
              </c:if>
              <c:if test='${priceList.noLines}'>
                <font color="red"><cws:message txt="NoRecordsFoundBySearch"/></font>
              </c:if>
          </fieldset>
      </form>
      <br/>
      <form action="basketServlet" method="post" enctype="application/x-www-form-urlencoded" name="products" id="products">
        <input name="M_PriceList_ID" type="hidden" value="<c:out value='${priceList.priceList_ID}'/>">
        <input name="M_PriceList_Version_ID" type="hidden" value="<c:out value='${priceList.priceList_Version_ID}'/>">
        <table class="contentTable">
          <tr> 
            <th colspan="2" align="left"><cws:message txt="M_Product_ID"/></th>
            <th><cws:message txt="Description"/></th>
            <th style="text-align:center"><cws:message txt="Price"/>(<c:out value='${priceList.currency}'/>)</th>
            <th style="text-align:center"><cws:message txt="Quantity"/></th>
            <th style="text-align:center"><cws:message txt="C_UOM_ID"/></th>
            <th>&nbsp;</th>
            <th class="availProduct"><cws:message txt="Availability"/></th>
          </tr>
          
          <c:forEach items='${priceList.prices}' var='product' varStatus='status'> 
        	<jsp:useBean id="status" type="javax.servlet.jsp.jstl.core.LoopTagStatus" />
        	<c:choose>
        		<c:when test="<%= status.getCount() %2 == 0 %>">
	        		<c:set var="rowClass" value="evenRow"/>
        		</c:when>
        		<c:otherwise>
	        		<c:set var="rowClass" value="oddRow"/>
        		</c:otherwise>
        	</c:choose>
        	<tr> 
            <td class="<c:out value='${rowClass}' />"><c:if test='${not empty product.imageURL}'><img src="<c:out value='${product.imageURL}'/>"></c:if></td>
            <td class="<c:out value='${rowClass}' />"> <input name="Name_<c:out value='${product.id}'/>" type="hidden" value="<c:out value='${product.name}'/>">
                <c:choose>
                    <c:when test="${not empty product.descriptionURL}}">
                        <a href="<c:out value='${product.descriptionURL}'/>" target="pd"><c:out value="${product.name}"/></a>
                    </c:when>
                    <c:otherwise>
                        <c:out value='${product.name}'/>
                    </c:otherwise>
                </c:choose>
			</td>
            <td class="<c:out value='${rowClass}' />"><c:out value='${product.description}'/> <c:if test="${empty product.description}">&nbsp;</c:if></td>
            <td class="<c:out value='${rowClass}' /> amount"> <input name="Price_<c:out value='${product.id}'/>" type="hidden" value="<c:out value='${product.price}'/>"> 
              <fmt:formatNumber value='${product.price}' type="currency" currencySymbol="" /> </td>
            <td class="<c:out value='${rowClass}' /> quantity"> <input name="Qty_<c:out value='${product.id}'/>" type="text" id="qty_<c:out value='${product.id}'/>" value="1" size="5" maxlength="5"></td>
            <td class="<c:out value='${rowClass}' />"><c:out value='${product.uomName}'/>&nbsp;</td>
            <td class="<c:out value='${rowClass}' />"> <input name="Add_<c:out value='${product.id}'/>" type="submit" id="Add_<c:out value='${product.id}'/>" value="<cws:message txt='AddToBasket'/>"></td>
            <td class="<c:out value='${rowClass}'/> availProduct"><!-- c:out value='$ {product.available}'/ -->&nbsp;</td>
          </tr>
          </c:forEach> 
        </table>
      </form>
	  <p><font size="-1"><cws:message txt="M_PriceList_ID"/>: <c:out value='${priceList.name}'/>  (<c:out value='${priceList.priceCount}'/>) - <c:out value='${priceList.searchInfo}'/></font></p>
      <p>&nbsp;</p>
	</div>
</div>
<div style="clear:both;"></div>
<%@ include file="/WEB-INF/jspf/footer.jspf" %>
</div>
</body>
</html>
