<%@ include file="/WEB-INF/jspf/page.jspf" %>
<c:if test='${empty webUser || !webUser.loggedIn}'>
  <c:redirect url='loginServlet?ForwardTo=payments.jsp'/>
</c:if>
<html>
<!--
  - Author:  Jorg Janke
  - Version: $Id: payments.jsp,v 1.3 2009/06/19 14:05:20 siqin Exp $
  - Compiere ERP & CRM Smart Business Solution - Copyright (c) 1999-2003 Jorg Janke
  - - -
  - Web Store Payments
  -->
<head>
<%@ include file="/WEB-INF/jspf/head.jspf" %>
<title><c:out value='${ctx.name}'/> - <cws:message txt="C_Payment_ID"/></title>
</head>
<body><div id="page">
<%@ include file="/WEB-INF/jspf/header.jspf" %>
<div id="main">
	<%@ include file="/WEB-INF/jspf/menu.jspf" %>
    <%@ include file="/WEB-INF/jspf/vendor.jspf" %>
	<div id="content"> 
	<h1><cws:message txt="C_Payment_ID"/></h1>
	  <c:if test='${not empty info.info}'>
	    <p><b><c:out value='${info.message}'/></b></p>
	  </c:if>
      <form action="paymentServlet" method="get" enctype="application/x-www-form-urlencoded" name="MakePayment" id="MakePayment">
          <fieldset>
              <legend><cws:message txt="CreatePayment"/></legend>
              <label for="Amt"><cws:message txt="PayAmt"/>:</label>
              <input name="Amt" type="text" id="Amt" value="120.00" size="10">
              <input type="submit" name="Submit" value="<cws:message txt='Submit'/>">
          </fieldset>
      </form>
      <br/>
      <table class="contentTable">
        <tr> 
          <th><cws:message txt="DocumentNo"/></th>
          <th><cws:message txt="DocStatus"/></th>
          <th><cws:message txt="CreditCardType"/></th>
          <th><cws:message txt="DateTrx"/></th>
          <th align="right"><cws:message txt="PayAmt"/></th>
          <th><cws:message txt="R_AuthCode"/></th>
        </tr>
        <c:forEach items='${info.payments}' var='payment' varStatus='status'>
        	<jsp:useBean id="status" type="javax.servlet.jsp.jstl.core.LoopTagStatus" />
        	<c:choose>
        		<c:when test="<%= status.getCount() %2 == 0 %>">
	        		<c:set var="rowClass" value="evenRow"/>
        		</c:when>
        		<c:otherwise>
	        		<c:set var="rowClass" value="oddRow"/>
        		</c:otherwise>
        	</c:choose>
 
        <tr> 
          <td class="<c:out value='${rowClass}' />"><c:out value='${payment.documentNo}'/></td>
          <td class="<c:out value='${rowClass}' />"><c:out value='${payment.docStatusName}'/></td>
          <td class="<c:out value='${rowClass}' />"><c:out value='${payment.r_RespMsg}'/>&nbsp;</td>
          <td class="<c:out value='${rowClass}' />"><fmt:formatDate value='${payment.dateTrx}'/></td>
          <td class="<c:out value='${rowClass}' /> amount"><c:out value='${payment.currencyISO}'/>&nbsp;<fmt:formatNumber value='${payment.payAmt}' type="currency" currencySymbol=""/></td>
          <td class="<c:out value='${rowClass}' />">&nbsp;<c:out value='${payment.r_AuthCode}'/></td>
        </tr>
        </c:forEach> 
      </table>
    </div>
</div>
<div style="clear:both;"></div>
<%@ include file="/WEB-INF/jspf/footer.jspf" %>
</div></body>
</html>
