/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.client.xmldb.xmlrpc;

import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.client.xmldb.ResourceSetImpl;
import org.apache.xindice.client.xmldb.XindiceCollection;
import org.apache.xindice.client.xmldb.resources.BinaryResourceImpl;
import org.apache.xindice.client.xmldb.resources.XMLResourceImpl;
import org.apache.xindice.core.FaultCodes;
import org.apache.xindice.core.meta.MetaData;
import org.apache.xindice.util.SymbolDeserializer;
import org.apache.xindice.xml.TextWriter;
import org.apache.xindice.xml.dom.DOMParser;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class CollectionImpl
extends XindiceCollection {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$client$xmldb$xmlrpc$CollectionImpl == null ? (class$org$apache$xindice$client$xmldb$xmlrpc$CollectionImpl = CollectionImpl.class$("org.apache.xindice.client.xmldb.xmlrpc.CollectionImpl")) : class$org$apache$xindice$client$xmldb$xmlrpc$CollectionImpl));
    private XmlRpcClient client = null;
    static /* synthetic */ Class class$org$apache$xindice$client$xmldb$xmlrpc$CollectionImpl;

    public CollectionImpl(XmlRpcClient client, String collPath) throws XMLDBException {
        super(collPath);
        this.client = client;
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("collection", collPath);
        String exists = (String)this.runRemoteCommand("GetCollectionConfiguration", params);
        if (!"yes".equals(exists)) {
            throw new XMLDBException(200, 200, "Collection not found: " + collPath);
        }
    }

    private Object runRemoteCommand(String cmdName, Hashtable params) throws XMLDBException {
        try {
            params.put("message", cmdName);
            Vector<Hashtable> v = new Vector<Hashtable>();
            v.add(params);
            return ((Hashtable)this.client.execute("run", v)).get("result");
        }
        catch (XmlRpcException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got XmlRpc exception running command " + cmdName + ", code: " + e.code + ", msg: " + e.getMessage()));
            }
            if (e.code != 0) {
                throw new XMLDBException(e.code / 10000, e.code % 10000, e.getMessage());
            }
            throw new XMLDBException(0, 40, "Failed to execute command '" + cmdName + "' on server: " + this.client.getURL() + ", message: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, 40, "Cannot communicate with the server: " + this.client.getURL(), (Throwable)e);
        }
    }

    public Resource getResource(String id) throws XMLDBException {
        this.checkOpen();
        try {
            if (id == null) {
                return null;
            }
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            params.put("name", id);
            params.put("compressed", "true");
            Object result = this.runRemoteCommand("GetResource", params);
            if (result == null) {
                return null;
            }
            if (result instanceof Hashtable) {
                Hashtable compressed = (Hashtable)result;
                SymbolDeserializer symbolDeserial = new SymbolDeserializer();
                return new XMLResourceImpl(id, id, this, symbolDeserial.getSymbols(compressed), (byte[])compressed.get("document"));
            }
            if (result instanceof byte[]) {
                return new BinaryResourceImpl(id, this, (byte[])result);
            }
            return new XMLResourceImpl(id, this, (String)result);
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    public int getResourceCount() throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            return (Integer)this.runRemoteCommand("GetDocumentCount", params);
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    public void storeResource(Resource res) throws XMLDBException {
        if (res.getContent() == null) {
            throw new XMLDBException(301, "no resource data");
        }
        this.checkOpen();
        try {
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("collection", this.collPath);
            params.put("name", res.getId());
            params.put("document", res.getContent());
            String name = (String)this.runRemoteCommand("InsertResource", params);
            if (res instanceof XMLResource) {
                ((XMLResourceImpl)res).setId(name);
            } else {
                ((BinaryResourceImpl)res).setId(name);
            }
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    public boolean isOpen() {
        return this.client != null;
    }

    public String getURI() {
        return "xmldb:xindice://" + this.client.getURL().getHost() + ':' + this.client.getURL().getPort() + this.collPath;
    }

    public Collection getChildCollection(String name) throws XMLDBException {
        if (name.indexOf(47) != -1) {
            throw new XMLDBException(201);
        }
        try {
            return new CollectionImpl(this.client, this.collPath + "/" + name);
        }
        catch (XMLDBException e) {
            if (e.errorCode == 200) {
                return null;
            }
            throw e;
        }
    }

    public String createId() throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            return (String)this.runRemoteCommand("CreateNewOID", params);
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    public void close() throws XMLDBException {
        this.client = null;
    }

    public Collection getParentCollection() throws XMLDBException {
        if (this.collPath.lastIndexOf("/") == 0) {
            return null;
        }
        try {
            return new CollectionImpl(this.client, this.collPath.substring(0, this.collPath.lastIndexOf(47)));
        }
        catch (XMLDBException e) {
            if (e.errorCode == 200) {
                return null;
            }
            throw e;
        }
    }

    public void removeResource(Resource res) throws XMLDBException {
        if (res == null || res.getId() == null || res.getId().length() == 0) {
            throw new XMLDBException(301, "Resource passed is null or its ID is empty.");
        }
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            params.put("name", res.getId());
            this.runRemoteCommand("RemoveDocument", params);
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(300, (Throwable)e);
        }
    }

    public String[] listChildCollections() throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            Vector list = (Vector)this.runRemoteCommand("ListCollections", params);
            return list.toArray(new String[list.size()]);
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    public int getChildCollectionCount() throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            Integer result = (Integer)this.runRemoteCommand("GetCollectionCount", params);
            return result;
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    public String[] listResources() throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            Vector list = (Vector)this.runRemoteCommand("ListDocuments", params);
            return list.toArray(new String[list.size()]);
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    public ResourceSet query(String name, String queryLang, String query, Hashtable nsMap) throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("collection", this.collPath);
            params.put("type", queryLang);
            params.put("namespaces", nsMap);
            params.put("query", query);
            if (name != null) {
                params.put("name", name);
            }
            String result = (String)this.runRemoteCommand("Query", params);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document resultDoc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(result)));
            ResourceSetImpl rs = new ResourceSetImpl(this, resultDoc);
            return rs;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw FaultCodes.createXMLDBException(641, "Query error", e);
        }
    }

    public Collection createCollection(String name) throws XMLDBException {
        return this.createCollection(name, null);
    }

    public Collection createCollection(String path, Document configuration) throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            params.put("name", path);
            if (configuration != null) {
                params.put("configuration", TextWriter.toString(configuration));
            }
            this.runRemoteCommand("CreateCollection", params);
            CollectionImpl col = this;
            if (path.indexOf("/") != -1) {
                StringTokenizer st = new StringTokenizer(path, "/");
                while (col != null && st.hasMoreTokens()) {
                    path = st.nextToken().trim();
                    if (path.length() == 0) continue;
                    if (!st.hasMoreTokens()) break;
                    col = col.getChildCollection(path);
                }
            }
            return col.getChildCollection(path);
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(201, "Cannot create child collection", (Throwable)e);
        }
    }

    public void removeCollection(String childName) throws XMLDBException {
        if (null == childName || childName.length() == 0) {
            throw new XMLDBException(200, 200, "Cannot remove child collection '" + childName + "': Name is empty");
        }
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            params.put("name", childName);
            String result = (String)this.runRemoteCommand("RemoveCollection", params);
            if (!result.equals("yes")) {
                throw new XMLDBException(201, "Cannot remove child collection '" + childName + "'");
            }
        }
        catch (XMLDBException x) {
            throw x;
        }
        catch (Exception e) {
            throw new XMLDBException(201, "Cannot remove child collection '" + childName + "'", (Throwable)e);
        }
    }

    public String[] listIndexers() throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            Vector list = (Vector)this.runRemoteCommand("ListIndexers", params);
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void createIndexer(Document configuration) throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            params.put("configuration", TextWriter.toString(configuration));
            this.runRemoteCommand("CreateIndexer", params);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void dropIndexer(String name) throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            params.put("name", name);
            this.runRemoteCommand("RemoveIndexer", params);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void shutdown() throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable params = new Hashtable();
            this.runRemoteCommand("Shutdown", params);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public MetaData getMetaData(String id) throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            if (id != null) {
                params.put("name", id);
            }
            params.put("compressed", "true");
            Object result = this.runRemoteCommand(id == null ? "GetCollectionMeta" : "GetDocumentMeta", params);
            Document metaDoc = DOMParser.toDocument(result.toString());
            MetaData meta = new MetaData(id);
            meta.streamFromXML(metaDoc.getDocumentElement(), true);
            return meta;
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    public void setMetaData(String id, MetaData meta) throws XMLDBException {
        this.checkOpen();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("collection", this.collPath);
            if (id != null) {
                params.put("name", id);
            }
            params.put("compressed", "true");
            DocumentImpl doc = new DocumentImpl();
            doc.appendChild(meta.streamToXML(doc, true));
            params.put("meta", TextWriter.toString(doc));
            this.runRemoteCommand(id == null ? "SetCollectionMeta" : "SetDocumentMeta", params);
        }
        catch (Exception e) {
            throw FaultCodes.createXMLDBException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

