/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.server.rpc.messages;

import java.util.Hashtable;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.CollectionManager;
import org.apache.xindice.server.rpc.RPCDefaultMessage;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.xml.dom.DOMParser;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateCollection
extends RPCDefaultMessage {
    public Hashtable execute(Hashtable message) throws Exception {
        Document doc;
        if (!message.containsKey("collection")) {
            throw new Exception("Required parameter 'collection' not found.");
        }
        if (!message.containsKey("configuration") && !message.containsKey("name")) {
            throw new Exception("You must either provide a document containing the configuration or specify the 'name' and 'patter' parameters.");
        }
        if (message.containsKey("configuration")) {
            doc = DOMParser.toDocument((String)message.get("configuration"));
            if (doc == null) {
                throw new Exception("Unable to parse Collection configuration");
            }
        } else {
            doc = new DocumentImpl();
            Element colEle = doc.createElement("collection");
            colEle.setAttribute("compressed", "true");
            colEle.setAttribute("name", (String)message.get("name"));
            doc.appendChild(colEle);
            Element filEle = doc.createElement("filer");
            filEle.setAttribute("class", "org.apache.xindice.core.filer.BTreeFiler");
            colEle.appendChild(filEle);
        }
        Collection colman = this.getCollection((String)message.get("collection"));
        Configuration config = new Configuration(doc.getDocumentElement(), false);
        ((CollectionManager)colman).createCollection((String)message.get("name"), config);
        Hashtable result = new Hashtable();
        result.put("result", message.get("name"));
        return result;
    }
}

