/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.filer;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.core.filer.FilerException;
import org.apache.xindice.util.SimpleConfigurable;

public final class MemFiler
extends SimpleConfigurable
implements Filer {
    private Map hashTable = null;
    private boolean opened = false;
    private boolean readOnly = false;

    public MemFiler() {
        this.hashTable = Collections.synchronizedMap(new HashMap());
    }

    public MemFiler(Map hashTable, boolean readOnly) {
        this.hashTable = hashTable;
        this.readOnly = readOnly;
    }

    public MemFiler(Map hashTable) {
        this(hashTable, false);
    }

    public void setLocation(File root, String location) {
    }

    public String getName() {
        return "MemFiler";
    }

    private void checkOpened() throws DBException {
        if (!this.opened) {
            throw new FilerException(247, "Filer is closed");
        }
    }

    private void checkReadOnly() throws DBException {
        if (this.readOnly) {
            throw new FilerException(246, "Filer is read-only");
        }
    }

    public boolean create() {
        this.hashTable.clear();
        return true;
    }

    public boolean open() {
        this.opened = true;
        return this.opened;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean exists() {
        return true;
    }

    public boolean drop() {
        this.hashTable.clear();
        this.opened = false;
        return !this.opened;
    }

    public boolean close() {
        this.opened = false;
        return !this.opened;
    }

    public void flush() {
    }

    public Record readRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return null;
        }
        this.checkOpened();
        return (Record)this.hashTable.get(key);
    }

    public boolean writeRecord(Key key, Value value) throws DBException {
        if (key == null || key.getLength() == 0) {
            throw new FilerException(571, "Invalid key: '" + key + "'");
        }
        if (value == null) {
            throw new FilerException(571, "Invalid null value");
        }
        this.checkOpened();
        this.checkReadOnly();
        this.hashTable.put(key, new Record(key, value));
        return true;
    }

    public boolean deleteRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return false;
        }
        this.checkOpened();
        this.checkReadOnly();
        return this.hashTable.remove(key) != null;
    }

    public long getRecordCount() throws DBException {
        this.checkOpened();
        return this.hashTable.size();
    }

    public RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new MemRecordSet();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MemRecordSet
    implements RecordSet {
        private Iterator enum;

        private MemRecordSet() {
            this.enum = MemFiler.this.hashTable.values().iterator();
        }

        public synchronized boolean hasMoreRecords() throws DBException {
            return this.enum.hasNext();
        }

        public synchronized Record getNextRecord() throws DBException {
            MemFiler.this.checkOpened();
            return (Record)this.enum.next();
        }

        public synchronized Value getNextValue() throws DBException {
            MemFiler.this.checkOpened();
            return ((Record)this.enum.next()).getValue();
        }

        public synchronized Key getNextKey() {
            return ((Record)this.enum.next()).getKey();
        }
    }
}

