/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.FootprintPlugin;
import jp.sourceforge.concierge.plugin.footprint.Category;
import jp.sourceforge.concierge.plugin.footprint.CategoryViewer;
import jp.sourceforge.concierge.plugin.footprint.FootprintDialog;
import jp.sourceforge.concierge.plugin.footprint.FootprintDialogListener;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;

public class CalItem {
    private Composite droot;
    private Label label;
    private Font labelfont;
    private FootprintDialog dialog;
    private int year;
    private int month;
    private int day;
    private ArrayList listeners = new ArrayList();
    private ArrayList items = new ArrayList();
    private Color SELECTCOLOR = new Color(null, 236, 243, 250);

    private void rearrange() {
        ArrayList<Composite> ctrls = new ArrayList<Composite>();
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            if (it.root.getVisible()) {
                ctrls.add(it.root);
            }
            ++i;
        }
        Label pc = this.label;
        int i2 = 0;
        while (i2 < ctrls.size()) {
            Control c = (Control)ctrls.get(i2);
            c.moveBelow((Control)pc);
            pc = c;
            ++i2;
        }
        this.droot.layout();
    }

    public CalItem(Composite parent, int year, int month, int day, FootprintDialog dlg) {
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        parent.setLayout((Layout)gl);
        this.label = new Label(parent, 131072);
        this.label.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)this.label, (int)1);
        int sz = SystemUtil.GetOSType() == 1 ? 11 : 9;
        this.labelfont = new Font(null, "Arial", sz, 0);
        this.label.setFont(this.labelfont);
        this.label.setText(String.valueOf(day));
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CalItem.this.labelfont.dispose();
            }
        });
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.droot = parent;
        this.droot.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.dialog = dlg;
        this.year = year;
        this.month = month;
        this.day = day;
    }

    protected void finalize() throws Throwable {
        this.SELECTCOLOR.dispose();
        super.finalize();
    }

    public void setEnabled(boolean en) {
        this.droot.setEnabled(en);
        int i = 0;
        while (i < this.items.size()) {
            ((Item)this.items.get(i)).setEnabled(en);
            ++i;
        }
        GraphicUtil.setForeground((Control)this.label, (int)(en ? 2 : 15));
    }

    public void setDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.label.setText(String.valueOf(day));
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public void setBackground(Color color) {
        this.label.setBackground(color);
        this.droot.setBackground(color);
        int i = 0;
        while (i < this.items.size()) {
            ((Item)this.items.get(i)).setBackground(color);
            ++i;
        }
    }

    public void select() {
        this.setBackground(this.SELECTCOLOR);
    }

    public void deselect() {
        this.setBackground(this.droot.getDisplay().getSystemColor(1));
    }

    public void createItem(Category curcat) {
        Item it = new Item(this.droot, null, curcat, true);
        this.droot.layout();
        this.items.add(it);
    }

    public void setDocuments(ArrayList docs) {
        this.clearAll();
        if (docs == null) {
            return;
        }
        int i = 0;
        while (i < docs.size()) {
            Item it = new Item(this.droot, (Document)docs.get(i), null, false);
            this.items.add(it);
            ++i;
        }
        this.droot.layout();
    }

    public void addDocument(Document doc) {
        int i = 0;
        while (i < this.items.size()) {
            Item tt = (Item)this.items.get(i);
            if (tt.document == doc) {
                return;
            }
            ++i;
        }
        Item it = new Item(this.droot, doc, null, false);
        this.droot.layout();
        this.items.add(it);
    }

    public void clearAll() {
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            it.dispose();
            ++i;
        }
        this.items.clear();
    }

    public void update() {
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            it.update();
            ++i;
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.listeners.add(listener);
    }

    public void categoryVisible(String category, boolean visible) {
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            String cat = FootprintPlugin.getCategory(it.document);
            if (cat.compareTo(category) == 0) {
                it.root.setVisible(visible);
            }
            ++i;
        }
        this.rearrange();
    }

    public void deleteItem(Document doc) {
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            if (it.document.equals(doc)) {
                this.items.remove(it);
                it.dispose();
            }
            ++i;
        }
        this.droot.layout();
    }

    public class Item {
        private Composite root;
        private Label dot;
        private CLabel titlectrl;
        private Document document;
        private FootprintDialogListener listener;

        public Item(Composite parent, Document doc, Category curcat, boolean open) {
            this.root = new Composite(parent, 4);
            this.root.setLayoutData((Object)new GridData(768));
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            this.root.setLayout((Layout)gl);
            this.root.setBackground(parent.getBackground());
            this.dot = new Label(this.root, 0);
            this.dot.setText("\u30fb");
            this.dot.setLayoutData((Object)new GridData(1));
            this.dot.setBackground(parent.getBackground());
            String text = "";
            if (doc != null) {
                this.document = doc;
                text = FootprintPlugin.getTitle(doc);
            } else {
                this.document = FootprintPlugin.createDocument();
                text = "New item";
                FootprintPlugin.setTitle(this.document, text);
                if (curcat != null) {
                    FootprintPlugin.setCategory(this.document, curcat.name);
                }
                FootprintPlugin.setDate(this.document, String.valueOf(String.valueOf(CalItem.this.year)) + "-" + String.valueOf(CalItem.this.month) + "-" + String.valueOf(CalItem.this.day));
                FootprintPlugin plugin = FootprintPlugin.getDefault();
                plugin.addDocument(this.document, true, null);
            }
            this.titlectrl = new CLabel(this.root, 0);
            this.titlectrl.setLayoutData((Object)new GridData(768));
            this.titlectrl.setText(text);
            this.titlectrl.setFont(CalItem.this.labelfont);
            this.titlectrl.setBackground(this.root.getBackground());
            this.titlectrl.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (e.button != 1) {
                        return;
                    }
                    Item.this.root.layout();
                    CalItem.this.dialog.setDocument(Item.this.document);
                    CalItem.this.dialog.setListener(Item.this.listener);
                    CalItem.this.dialog.open();
                }
            });
            this.titlectrl.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    Document doc = Item.this.document;
                    if (doc == null) {
                        Item.this.titlectrl.setToolTipText("");
                        return;
                    }
                    String str = "ID:" + String.valueOf(DomImpl.getID((Document)doc));
                    String txt = FootprintPlugin.getTitle(doc);
                    if (txt.length() != 0) {
                        str = String.valueOf(str) + "\n" + txt;
                    }
                    Item.this.titlectrl.setToolTipText(str);
                }
            });
            this.listener = new FootprintDialogListener(){

                public void saveClicked(Document doc) {
                    if (doc != Item.this.document) {
                        return;
                    }
                    Item.this.save();
                }

                public void closeClicked(Document doc) {
                    if (doc != Item.this.document) {
                        return;
                    }
                    Item.this.save();
                }
            };
            CalItem.this.dialog.setTitle(text);
            if (open) {
                CalItem.this.dialog.setDocument(this.document);
                CalItem.this.dialog.setListener(this.listener);
                CalItem.this.dialog.open();
            }
            this.update();
        }

        public void setEnabled(boolean en) {
            this.titlectrl.setEnabled(en);
            if (this.document != null && en) {
                this.update();
            } else {
                GraphicUtil.setForeground((Control)this.dot, (int)15);
                GraphicUtil.setForeground((Control)this.titlectrl, (int)15);
            }
        }

        public void setBackground(Color color) {
            this.root.setBackground(color);
            this.dot.setBackground(color);
            this.titlectrl.setBackground(color);
        }

        public void setTitle(String title) {
            this.titlectrl.setText(title);
            FootprintPlugin.setTitle(this.document, title);
        }

        public String getTitle() {
            return FootprintPlugin.getTitle(this.document);
        }

        public void update() {
            String cat = FootprintPlugin.getCategory(this.document);
            if (cat.length() > 0) {
                Color c = CategoryViewer.getCategoryColor(CategoryViewer.getCategory(cat));
                this.titlectrl.setForeground(c);
                this.dot.setForeground(c);
            }
        }

        public void dispose() {
            if (this.root != null) {
                this.root.dispose();
            }
        }

        private void save() {
            this.titlectrl.setText(FootprintPlugin.getTitle(this.document));
            this.root.layout();
            this.update();
        }
    }
}

