/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ByteBuffer;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUResourceBundleIterator;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceTypeMismatchException;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ICUResourceBundleImpl
extends ICUResourceBundle {
    private byte[] rawData;
    private long rootResource;
    private boolean noFallback;
    private String localeID;
    private String baseName;
    private ULocale ulocale;
    private ClassLoader loader;
    private static final boolean ASSERT = false;
    private static final char RES_PATH_SEP_CHAR = '/';
    private static final String ICUDATA = "ICUDATA";
    private static final String LOCALE = "LOCALE";

    public static ICUResourceBundle createBundle(String baseName, String localeID, ClassLoader root) {
        ICUResourceBundleReader reader = ICUResourceBundleReader.getReader(baseName, localeID, root);
        if (reader == null) {
            return null;
        }
        ICUResourceBundleImpl bundle = new ICUResourceBundleImpl(reader, baseName, localeID, root);
        return bundle.getBundle();
    }

    protected String getLocaleID() {
        return this.localeID;
    }

    protected String getBaseName() {
        return this.baseName;
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public UResourceBundle getParent() {
        return (UResourceBundle)this.parent;
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    protected boolean getNoFallback() {
        return this.noFallback;
    }

    private ICUResourceBundle getBundle() {
        int type = ICUResourceBundleImpl.RES_GET_TYPE(this.rootResource);
        if (type == 2) {
            ResourceTable table = new ResourceTable(null, this.rootResource, "", true);
            if (table.size == 1) {
                ICUResourceBundle b = table.handleGet(0, (ICUResourceBundle)table);
                String itemKey = b.getKey();
                if (itemKey.equals("%%ALIAS")) {
                    String locale = b.getString();
                    ICUResourceBundle actual = (ICUResourceBundle)UResourceBundle.getBundleInstance(this.baseName, locale);
                    return (ResourceTable)actual;
                }
                return table;
            }
            return table;
        }
        if (type == 4) {
            return new ResourceTable32(null, this.rootResource, "", true);
        }
        throw new IllegalStateException("Invalid format error");
    }

    private ICUResourceBundleImpl(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
        this.rawData = reader.getData();
        this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
        this.noFallback = reader.getNoFallback();
        this.baseName = baseName;
        this.localeID = localeID;
        this.ulocale = new ULocale(localeID);
        this.loader = loader;
    }

    static final int RES_GET_TYPE(long res) {
        return (int)(res >> 28);
    }

    private static final int RES_GET_OFFSET(long res) {
        return (int)((res & 0xFFFFFFFL) * 4L);
    }

    private static final int RES_GET_INT(long res) {
        return (int)(res << 4) >> 4;
    }

    private static final long RES_GET_UINT(long res) {
        long t = res & 0xFFFFFFFL;
        return t;
    }

    private static final StringBuffer RES_GET_KEY(byte[] rawData, int keyOffset) {
        char ch = '\uffff';
        StringBuffer key = new StringBuffer();
        while (true) {
            char c = (char)rawData[keyOffset];
            ch = c;
            if (c == '\u0000') break;
            key.append(ch);
            ++keyOffset;
        }
        return key;
    }

    private static final int getIntOffset(int offset) {
        return offset * 4;
    }

    private static final int getCharOffset(int offset) {
        return offset * 2;
    }

    private final ICUResourceBundle createBundleObject(String key, long resource, String resPath, HashMap table, ICUResourceBundle requested) {
        switch (ICUResourceBundleImpl.RES_GET_TYPE(resource)) {
            case 0: {
                return new ResourceString(key, resPath, resource);
            }
            case 1: {
                return new ResourceBinary(key, resPath, resource);
            }
            case 3: {
                return this.findResource(key, resource, table, requested);
            }
            case 7: {
                return new ResourceInt(key, resPath, resource);
            }
            case 14: {
                return new ResourceIntVector(key, resPath, resource);
            }
            case 8: {
                return new ResourceArray(key, resPath, resource);
            }
            case 4: {
                return new ResourceTable32(key, resPath, resource);
            }
            case 2: {
                return new ResourceTable(key, resPath, resource);
            }
        }
        throw new IllegalStateException("The resource type is unknown");
    }

    private int findKey(int size, int currentOffset, Resource res, String target) {
        int mid = 0;
        int start = 0;
        int limit = size;
        int lastMid = -1;
        while (lastMid != (mid = (start + limit) / 2)) {
            lastMid = mid;
            String comp = res.getKey(currentOffset, mid);
            int rc = target.compareTo(comp);
            if (rc < 0) {
                limit = mid;
                continue;
            }
            if (rc > 0) {
                start = mid;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private static char makeChar(byte b1, byte b0) {
        return (char)(b1 << 8 | b0 & 0xFF);
    }

    private static char getChar(byte[] data, int offset) {
        return ICUResourceBundleImpl.makeChar(data[offset], data[offset + 1]);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    private static int getInt(byte[] data, int offset) {
        return ICUResourceBundleImpl.makeInt(data[offset], data[offset + 1], data[offset + 2], data[offset + 3]);
    }

    private String getStringValue(long resource) {
        int offset = ICUResourceBundleImpl.RES_GET_OFFSET(resource);
        int length = ICUResourceBundleImpl.getInt(this.rawData, offset);
        int stringOffset = offset + ICUResourceBundleImpl.getIntOffset(1);
        char[] dst = new char[length];
        for (int i = 0; i < length; ++i) {
            dst[i] = ICUResourceBundleImpl.getChar(this.rawData, stringOffset + ICUResourceBundleImpl.getCharOffset(i));
        }
        return new String(dst);
    }

    private static final int getIndex(String s) {
        if (s.length() >= 1) {
            return Integer.valueOf(s);
        }
        return -1;
    }

    private ICUResourceBundle findResource(String key, long resource, HashMap table, ICUResourceBundle requested) {
        String bundleName;
        int i;
        ClassLoader loaderToUse = this.loader;
        String locale = null;
        String keyPath = null;
        String resPath = this.getStringValue(resource);
        if (table == null) {
            table = new HashMap<String, String>();
        }
        if (table.get(resPath) != null) {
            throw new IllegalArgumentException("Circular references in the resource bundles");
        }
        table.put(resPath, "");
        if (resPath.indexOf(47) == 0) {
            i = resPath.indexOf(47, 1);
            int j = resPath.indexOf(47, i + 1);
            bundleName = resPath.substring(1, i);
            locale = resPath.substring(i + 1);
            if (j != -1) {
                locale = resPath.substring(i + 1, j);
                keyPath = resPath.substring(j + 1, resPath.length());
            }
            if (bundleName.equals(ICUDATA)) {
                bundleName = "com/ibm/icu/impl/data/icudt34b";
                loaderToUse = ICU_DATA_CLASS_LOADER;
            }
        } else {
            i = resPath.indexOf(47);
            keyPath = resPath.substring(i + 1);
            if (i != -1) {
                locale = resPath.substring(0, i);
            } else {
                locale = keyPath;
                keyPath = null;
            }
            bundleName = this.baseName;
        }
        ICUResourceBundle bundle = null;
        ICUResourceBundle sub = null;
        if (bundleName.equals(LOCALE)) {
            bundleName = this.baseName;
            bundle = requested;
            keyPath = resPath.substring(LOCALE.length() + 2, resPath.length());
            locale = requested.getLocaleID();
            sub = ICUResourceBundle.findResourceWithFallback(keyPath, requested, null);
            sub.resPath = "/" + sub.getLocaleID() + "/" + keyPath;
        } else {
            bundle = locale == null ? (ICUResourceBundle)ICUResourceBundleImpl.getBundleInstance(bundleName, "", loaderToUse, false) : (ICUResourceBundle)ICUResourceBundleImpl.getBundleInstance(bundleName, locale, loaderToUse, false);
            if (keyPath != null) {
                String subKey;
                StringTokenizer st = new StringTokenizer(keyPath, "/");
                ICUResourceBundle current = bundle;
                while (st.hasMoreTokens() && (sub = current.getImpl(subKey = st.nextToken(), table, requested)) != null) {
                    current = sub;
                }
            } else {
                sub = bundle.get(key);
            }
            sub.resPath = resPath;
        }
        if (sub == null) {
            throw new MissingResourceException(this.localeID, this.baseName, key);
        }
        return sub;
    }

    private static interface Resource {
        public String getKey(int var1, int var2);
    }

    private class ResourceArray
    extends ICUResourceBundle {
        protected String[] handleGetStringArray() {
            String[] strings = new String[this.size];
            ICUResourceBundleIterator iter = this.getIterator();
            int i = 0;
            while (iter.hasNext()) {
                strings[i++] = iter.next().getString();
            }
            return strings;
        }

        public String[] getStringArray() {
            return this.handleGetStringArray();
        }

        protected ICUResourceBundle handleGet(String index, ICUResourceBundle requested) {
            return this.handleGet(index, null, requested);
        }

        protected ICUResourceBundle handleGet(String index, HashMap table, ICUResourceBundle requested) {
            int val = ICUResourceBundleImpl.getIndex(index);
            if (val > -1) {
                return this.handleGet(val, table, requested);
            }
            throw new UResourceTypeMismatchException("Could not get the correct value for index: " + index);
        }

        protected ICUResourceBundle handleGet(int index, ICUResourceBundle requested) {
            return this.handleGet(index, null, requested);
        }

        protected ICUResourceBundle handleGet(int index, HashMap table, ICUResourceBundle requested) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int itemOffset = offset + ICUResourceBundleImpl.getIntOffset(index + 1);
            long itemResource = 0xFFFFFFFFL & (long)ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, itemOffset);
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return ICUResourceBundleImpl.this.createBundleObject(null, itemResource, path, table, requested);
        }

        private int countItems() {
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int value = ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, offset);
            return value;
        }

        private ResourceArray(String key, String resPath, long resource) {
            this.resource = resource;
            this.key = key;
            this.size = this.countItems();
            this.resPath = resPath;
        }

        protected String getLocaleID() {
            return ICUResourceBundleImpl.this.localeID;
        }

        protected String getBaseName() {
            return ICUResourceBundleImpl.this.baseName;
        }

        public ULocale getULocale() {
            return ICUResourceBundleImpl.this.ulocale;
        }

        public UResourceBundle getParent() {
            return ICUResourceBundleImpl.this.getParent();
        }
    }

    private class ResourceBinary
    extends ICUResourceBundle {
        private byte[] value;

        public ByteBuffer getBinary() {
            return ByteBuffer.wrap(this.value);
        }

        private byte[] getValue() {
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, offset);
            int byteOffset = offset + ICUResourceBundleImpl.getIntOffset(1);
            byte[] dst = new byte[length];
            System.arraycopy(ICUResourceBundleImpl.this.rawData, byteOffset, dst, 0, length);
            return dst;
        }

        public ResourceBinary(String key, String resPath, long resource) {
            this.resource = resource;
            this.key = key;
            this.resPath = resPath;
            this.value = this.getValue();
        }

        protected String getLocaleID() {
            return ICUResourceBundleImpl.this.localeID;
        }

        protected String getBaseName() {
            return ICUResourceBundleImpl.this.baseName;
        }

        public ULocale getULocale() {
            return ICUResourceBundleImpl.this.ulocale;
        }

        public UResourceBundle getParent() {
            return ICUResourceBundleImpl.this.getParent();
        }
    }

    private class ResourceInt
    extends ICUResourceBundle {
        public int getInt() {
            return ICUResourceBundleImpl.RES_GET_INT(this.resource);
        }

        public int getUInt() {
            long ret = ICUResourceBundleImpl.RES_GET_UINT(this.resource);
            return (int)ret;
        }

        private ResourceInt(String key, String resPath, long resource) {
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }

        protected String getLocaleID() {
            return ICUResourceBundleImpl.this.localeID;
        }

        protected String getBaseName() {
            return ICUResourceBundleImpl.this.baseName;
        }

        public ULocale getULocale() {
            return ICUResourceBundleImpl.this.ulocale;
        }

        public UResourceBundle getParent() {
            return ICUResourceBundleImpl.this.getParent();
        }
    }

    private class ResourceIntVector
    extends ICUResourceBundle {
        private int[] value;

        public int[] getIntVector() {
            return this.value;
        }

        private int[] getValue() {
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, offset);
            int intOffset = offset + ICUResourceBundleImpl.getIntOffset(1);
            int[] val = new int[length];
            int byteLength = ICUResourceBundleImpl.getIntOffset(length);
            for (int i = 0; i < length; ++i) {
                val[i] = ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, intOffset + ICUResourceBundleImpl.getIntOffset(i));
            }
            return val;
        }

        public ResourceIntVector(String key, String resPath, long resource) {
            this.key = key;
            this.resource = resource;
            this.size = 1;
            this.resPath = resPath;
            this.value = this.getValue();
        }

        protected String getLocaleID() {
            return ICUResourceBundleImpl.this.localeID;
        }

        protected String getBaseName() {
            return ICUResourceBundleImpl.this.baseName;
        }

        public ULocale getULocale() {
            return ICUResourceBundleImpl.this.ulocale;
        }

        public UResourceBundle getParent() {
            return ICUResourceBundleImpl.this.getParent();
        }
    }

    private class ResourceString
    extends ICUResourceBundle {
        private String value;

        public String getString() {
            return this.value;
        }

        private ResourceString(String key, String resPath, long resource) {
            this.value = ICUResourceBundleImpl.this.getStringValue(resource);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }

        protected String getLocaleID() {
            return ICUResourceBundleImpl.this.localeID;
        }

        protected String getBaseName() {
            return ICUResourceBundleImpl.this.baseName;
        }

        public ULocale getULocale() {
            return ICUResourceBundleImpl.this.ulocale;
        }

        public UResourceBundle getParent() {
            return ICUResourceBundleImpl.this.getParent();
        }
    }

    private class ResourceTable
    extends ICUResourceBundle
    implements Resource {
        protected ICUResourceBundle handleGet(String key, ICUResourceBundle requested) {
            return this.handleGet(key, null, requested);
        }

        protected ICUResourceBundle handleGet(String key, HashMap table, ICUResourceBundle requested) {
            if (this.size <= 0) {
                return null;
            }
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundleImpl.getCharOffset(1);
            int foundOffset = ICUResourceBundleImpl.this.findKey(this.size, currentOffset, this, key);
            if (foundOffset == -1) {
                return null;
            }
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, currentOffset += ICUResourceBundleImpl.getCharOffset(this.size + (~this.size & 1)) + ICUResourceBundleImpl.getIntOffset(foundOffset));
            String path = this.isTopLevel ? key : this.resPath + "/" + key;
            return ICUResourceBundleImpl.this.createBundleObject(key, resource, path, table, requested);
        }

        protected ICUResourceBundle handleGet(int index, ICUResourceBundle requested) {
            return this.handleGet(index, null, requested);
        }

        public String getKey(int currentOffset, int index) {
            int charOffset = currentOffset + ICUResourceBundleImpl.getCharOffset(index);
            char keyOffset = ICUResourceBundleImpl.getChar(ICUResourceBundleImpl.this.rawData, charOffset);
            return ICUResourceBundleImpl.RES_GET_KEY(ICUResourceBundleImpl.this.rawData, keyOffset).toString();
        }

        protected ICUResourceBundle handleGet(int index, HashMap table, ICUResourceBundle requested) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundleImpl.getCharOffset(1);
            String itemKey = this.getKey(currentOffset, index);
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, currentOffset += ICUResourceBundleImpl.getCharOffset(this.size + (~this.size & 1)) + ICUResourceBundleImpl.getIntOffset(index));
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return ICUResourceBundleImpl.this.createBundleObject(itemKey, resource, path, table, requested);
        }

        private int countItems() {
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            char value = ICUResourceBundleImpl.getChar(ICUResourceBundleImpl.this.rawData, offset);
            return value;
        }

        private ResourceTable(String key, String resPath, long resource) {
            this(key, resource, resPath, false);
        }

        private ResourceTable(String key, long resource, String resPath, boolean isTopLevel) {
            this.key = key;
            this.resource = resource;
            this.isTopLevel = isTopLevel;
            this.size = this.countItems();
            this.resPath = resPath;
        }

        protected String getLocaleID() {
            return ICUResourceBundleImpl.this.localeID;
        }

        protected String getBaseName() {
            return ICUResourceBundleImpl.this.baseName;
        }

        public ULocale getULocale() {
            return ICUResourceBundleImpl.this.ulocale;
        }

        public UResourceBundle getParent() {
            return ICUResourceBundleImpl.this.getParent();
        }

        protected void setParent(ResourceBundle parent) {
            ICUResourceBundleImpl.this.setParent(parent);
        }
    }

    private class ResourceTable32
    extends ICUResourceBundle
    implements Resource {
        protected ICUResourceBundle handleGet(String key, ICUResourceBundle requested) {
            if (this.size <= 0) {
                return null;
            }
            return this.handleGet(key, null, requested);
        }

        protected ICUResourceBundle handleGet(String key, HashMap table, ICUResourceBundle requested) {
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundleImpl.getIntOffset(1);
            int foundOffset = ICUResourceBundleImpl.this.findKey(this.size, currentOffset, this, key);
            if (foundOffset == -1) {
                throw new MissingResourceException("Could not find resource ", ICUResourceBundleReader.getFullName(ICUResourceBundleImpl.this.baseName, ICUResourceBundleImpl.this.localeID), key);
            }
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, currentOffset += ICUResourceBundleImpl.getIntOffset(this.size) + ICUResourceBundleImpl.getIntOffset(foundOffset));
            String path = this.isTopLevel ? key : this.resPath + "/" + key;
            return ICUResourceBundleImpl.this.createBundleObject(key, resource, path, table, requested);
        }

        protected ICUResourceBundle handleGet(int index, ICUResourceBundle requested) {
            return this.handleGet(index, null, requested);
        }

        public String getKey(int currentOffset, int index) {
            int charOffset = currentOffset + ICUResourceBundleImpl.getIntOffset(index);
            int keyOffset = ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, charOffset);
            return ICUResourceBundleImpl.RES_GET_KEY(ICUResourceBundleImpl.this.rawData, keyOffset).toString();
        }

        protected ICUResourceBundle handleGet(int index, HashMap table, ICUResourceBundle requested) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundleImpl.getIntOffset(1) + ICUResourceBundleImpl.getIntOffset(index);
            String itemKey = this.getKey(currentOffset, 0);
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, currentOffset += ICUResourceBundleImpl.getIntOffset(this.size));
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return ICUResourceBundleImpl.this.createBundleObject(itemKey, resource, path, table, requested);
        }

        private int countItems() {
            int offset = ICUResourceBundleImpl.RES_GET_OFFSET(this.resource);
            int value = ICUResourceBundleImpl.getInt(ICUResourceBundleImpl.this.rawData, offset);
            return value;
        }

        private ResourceTable32(String key, long resource, String resPath, boolean isTopLevel) {
            this.resource = resource;
            this.key = key;
            this.isTopLevel = isTopLevel;
            this.size = this.countItems();
            this.resPath = resPath;
        }

        private ResourceTable32(String key, String resPath, long resource) {
            this(key, resource, resPath, false);
        }

        protected String getLocaleID() {
            return ICUResourceBundleImpl.this.localeID;
        }

        protected String getBaseName() {
            return ICUResourceBundleImpl.this.baseName;
        }

        public ULocale getULocale() {
            return ICUResourceBundleImpl.this.ulocale;
        }

        public UResourceBundle getParent() {
            return ICUResourceBundleImpl.this.getParent();
        }

        protected void setParent(ResourceBundle parent) {
            ICUResourceBundleImpl.this.setParent(parent);
        }
    }
}

