/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint;

import jp.sourceforge.concierge.plugin.FootprintPlugin;
import jp.sourceforge.concierge.plugin.footprint.CalTitleListener;
import jp.sourceforge.concierge.util.CalendarUtil;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class CalTitle {
    private Label lyearmonth;
    private Font labelfont;
    CalTitleListener listener = null;
    int currentyear;
    int currentmonth;

    protected void finalize() throws Throwable {
        if (this.labelfont != null) {
            this.labelfont.dispose();
        }
    }

    public CalTitle(Composite parent, int year, int month) {
        int sz = SystemUtil.GetOSType() == 1 ? 12 : 8;
        this.labelfont = new Font((Device)parent.getDisplay(), "Helvetica", sz, 0);
        parent.setLayout((Layout)new GridLayout(7, true));
        Composite hc = new Composite(parent, 0);
        FormLayout fl = new FormLayout();
        fl.marginWidth = 0;
        fl.marginHeight = 0;
        hc.setLayout((Layout)fl);
        GridData gdhc = new GridData(1808);
        gdhc.horizontalSpan = 7;
        hc.setLayoutData((Object)gdhc);
        GraphicUtil.setBackground((Control)hc, (int)1);
        this.lyearmonth = new Label(hc, 0x1000000);
        FormData fd = new FormData();
        fd.left = new FormAttachment(50, -50);
        this.lyearmonth.setLayoutData((Object)fd);
        this.lyearmonth.setFont(this.labelfont);
        GraphicUtil.setBackground((Control)this.lyearmonth, (int)1);
        ImageHyperlink lb = new ImageHyperlink(hc, 0x800000);
        FormData lbfd = new FormData();
        lbfd.right = new FormAttachment((Control)this.lyearmonth, -10);
        lb.setLayoutData((Object)lbfd);
        GraphicUtil.setBackground((Control)lb, (int)1);
        lb.setImage(FootprintPlugin.getImageDescriptor("icons/left.png").createImage());
        lb.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                --CalTitle.this.currentmonth;
                if (CalTitle.this.currentmonth == 0) {
                    CalTitle.this.currentmonth = 12;
                    --CalTitle.this.currentyear;
                }
                CalTitle.this.setYearMonth(CalTitle.this.currentyear, CalTitle.this.currentmonth);
                if (CalTitle.this.listener != null) {
                    CalTitle.this.listener.calendarChanged(CalTitle.this.currentyear, CalTitle.this.currentmonth);
                }
            }
        });
        ImageHyperlink rb = new ImageHyperlink(hc, 0x800000);
        FormData rbfd = new FormData();
        rbfd.left = new FormAttachment((Control)this.lyearmonth, 10);
        rb.setLayoutData((Object)rbfd);
        GraphicUtil.setBackground((Control)rb, (int)1);
        rb.setImage(FootprintPlugin.getImageDescriptor("icons/right.png").createImage());
        rb.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                ++CalTitle.this.currentmonth;
                if (CalTitle.this.currentmonth == 13) {
                    CalTitle.this.currentmonth = 1;
                    ++CalTitle.this.currentyear;
                }
                CalTitle.this.setYearMonth(CalTitle.this.currentyear, CalTitle.this.currentmonth);
                if (CalTitle.this.listener != null) {
                    CalTitle.this.listener.calendarChanged(CalTitle.this.currentyear, CalTitle.this.currentmonth);
                }
            }
        });
        this.currentyear = year;
        this.currentmonth = month;
        this.lyearmonth.setText(String.valueOf(CalendarUtil.getNameOfMonth((int)month)) + "  " + String.valueOf(year));
        this.lyearmonth.pack();
        String[] week = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        int i = 0;
        while (i < week.length) {
            Label wl = new Label(parent, 0x1000000);
            GridData wlgd = new GridData(0x1000710);
            wlgd.minimumHeight = 15;
            wlgd.minimumWidth = 40;
            wlgd.grabExcessHorizontalSpace = true;
            wlgd.horizontalAlignment = 4;
            wlgd.verticalAlignment = 0x1000000;
            wl.setLayoutData((Object)wlgd);
            wl.setText(week[i]);
            wl.setFont(this.labelfont);
            GraphicUtil.setBackground((Control)wl, (int)1);
            ++i;
        }
    }

    public void setYearMonth(int year, int month) {
        this.currentyear = year;
        this.currentmonth = month;
        this.lyearmonth.setText(String.valueOf(CalendarUtil.getNameOfMonth((int)month)) + "  " + String.valueOf(year));
        this.lyearmonth.pack();
    }

    public void setListener(CalTitleListener listener) {
        this.listener = listener;
    }
}

