/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.FileLauncher;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataDialog
extends ConciergeDialog {
    private static final int VMARGIN = 5;
    private static final int HMARGIN = 2;
    private static final int HEIGHT = 15;
    private static final int FIRSTWIDTH = 55;
    private static final int SECONDWIDTH = 65;
    private static final String DIALOGTITLE = "Metadata Editor for iPapers";
    private Document schema = null;
    private Document metadata = null;
    private Hashtable texthash = null;
    private Object sender = null;
    private Shell myshell = null;
    private boolean ismodified = false;

    public MetadataDialog(Shell shell, int style) {
        super(shell, 67680);
        String xpath = "/type[@name='Paper']";
        Request request = new Request(4, (Object)xpath, "type");
        ArrayList ret = FrameworkPlugin.getDefault().getDocumentsOfQuery(request);
        if (ret.size() > 0) {
            this.schema = (Document)ret.get(0);
        }
        this.texthash = new Hashtable();
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.metadata = null;
        this.texthash = null;
        this.sender = null;
        this.ismodified = false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialog = (Composite)super.createDialogArea(parent);
        dialog.setLayout((Layout)new GridLayout(1, false));
        Group rig = new Group(dialog, 64);
        rig.setText("Reference Info");
        rig.setLayoutData((Object)new GridData(768));
        rig.setLayout((Layout)new FormLayout());
        Label lblAuthor = new Label((Composite)rig, 0);
        lblAuthor.setText("Author");
        lblAuthor.setAlignment(131072);
        FormData fdr = new FormData();
        fdr.top = new FormAttachment(0, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblAuthor.setLayoutData((Object)fdr);
        Text txtAuthor = new Text((Composite)rig, 2052);
        FormData fdl = new FormData();
        fdl.top = new FormAttachment(0, 5);
        fdl.left = new FormAttachment((Control)lblAuthor, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtAuthor.setLayoutData((Object)fdl);
        this.texthash.put("Author", txtAuthor);
        Label lblTitle = new Label((Composite)rig, 0);
        lblTitle.setText("Title");
        lblTitle.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtAuthor, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblTitle.setLayoutData((Object)fdr);
        Text txtTitle = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtAuthor, 5);
        fdl.left = new FormAttachment((Control)lblTitle, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtTitle.setLayoutData((Object)fdl);
        this.texthash.put("Title", txtTitle);
        Label lblJournal = new Label((Composite)rig, 0);
        lblJournal.setText("Journal");
        lblJournal.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtTitle, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblJournal.setLayoutData((Object)fdr);
        Text txtJournal = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtTitle, 5);
        fdl.left = new FormAttachment((Control)lblJournal, 2);
        fdl.right = new FormAttachment(66, -5);
        fdl.height = 15;
        txtJournal.setLayoutData((Object)fdl);
        this.texthash.put("Journal", txtJournal);
        Label lblYear = new Label((Composite)rig, 0);
        lblYear.setText("Year");
        lblYear.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtTitle, 5);
        fdr.left = new FormAttachment((Control)txtJournal, 5);
        fdr.height = 15;
        lblYear.setLayoutData((Object)fdr);
        Text txtYear = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtTitle, 5);
        fdl.left = new FormAttachment((Control)lblYear, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtYear.setLayoutData((Object)fdl);
        this.texthash.put("Year", txtYear);
        Label lblVolume = new Label((Composite)rig, 0);
        lblVolume.setText("Vol");
        lblVolume.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment(0, 5);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblVolume.setLayoutData((Object)fdr);
        Text txtVolume = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblVolume, 2);
        fdl.right = new FormAttachment(33, -5);
        fdl.height = 15;
        txtVolume.setLayoutData((Object)fdl);
        this.texthash.put("Volume", txtVolume);
        Label lblNumber = new Label((Composite)rig, 0);
        lblNumber.setText("No");
        lblNumber.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment((Control)txtVolume, 5);
        fdr.height = 15;
        lblNumber.setLayoutData((Object)fdr);
        Text txtNumber = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblNumber, 2);
        fdl.right = new FormAttachment(66, -5);
        fdl.height = 15;
        txtNumber.setLayoutData((Object)fdl);
        this.texthash.put("Number", txtNumber);
        Label lblPages = new Label((Composite)rig, 0);
        lblPages.setText("Pages");
        lblPages.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment((Control)txtNumber, 5);
        fdr.height = 15;
        lblPages.setLayoutData((Object)fdr);
        Text txtPages = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblPages, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtPages.setLayoutData((Object)fdl);
        this.texthash.put("Pages", txtPages);
        Label lblIDs = new Label((Composite)rig, 0);
        lblIDs.setText("IDs");
        lblIDs.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtVolume, 5);
        fdr.left = new FormAttachment(0, 5);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblIDs.setLayoutData((Object)fdr);
        Text txtIDs = new Text((Composite)rig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtVolume, 5);
        fdl.left = new FormAttachment((Control)lblIDs, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtIDs.setLayoutData((Object)fdl);
        this.texthash.put("IDs", txtIDs);
        Label lblAbstract = new Label((Composite)rig, 0);
        lblAbstract.setText("Abstract");
        lblAbstract.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtIDs, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblAbstract.setLayoutData((Object)fdr);
        Text txtAbstract = new Text((Composite)rig, 514);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtIDs, 5);
        fdl.left = new FormAttachment((Control)lblAbstract, 5);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 90;
        txtAbstract.setLayoutData((Object)fdl);
        this.texthash.put("Abstract", txtAbstract);
        Group aig = new Group(dialog, 64);
        aig.setText("Additional Info");
        aig.setLayoutData((Object)new GridData(768));
        aig.setLayout((Layout)new FormLayout());
        Label lblKeywords = new Label((Composite)aig, 0);
        lblKeywords.setText("Keywords");
        lblKeywords.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment(0, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 65);
        fdr.height = 15;
        lblKeywords.setLayoutData((Object)fdr);
        Text txtKeywords = new Text((Composite)aig, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment(0, 5);
        fdl.left = new FormAttachment((Control)lblKeywords, 2);
        fdl.right = new FormAttachment(100, 0);
        fdl.height = 15;
        txtKeywords.setLayoutData((Object)fdl);
        this.texthash.put("Keywords", txtKeywords);
        Label lblComment = new Label((Composite)aig, 0);
        lblComment.setText("Comment");
        lblComment.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtKeywords, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 65);
        fdr.height = 15;
        lblComment.setLayoutData((Object)fdr);
        Text txtComment = new Text((Composite)aig, 514);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtKeywords, 5);
        fdl.left = new FormAttachment((Control)lblComment, 5);
        fdl.right = new FormAttachment(100, -5);
        fdl.bottom = new FormAttachment(100, -5);
        fdl.height = 90;
        txtComment.setLayoutData((Object)fdl);
        this.texthash.put("Comment", txtComment);
        Group lig = new Group(dialog, 16);
        lig.setText("PDF Reprint File");
        lig.setLayoutData((Object)new GridData(768));
        lig.setLayout((Layout)new FormLayout());
        Button btnOpen = new Button((Composite)lig, 4096);
        btnOpen.setText("Open");
        btnOpen.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                FileLauncher.LaunchFile((Document)MetadataDialog.this.metadata);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        fdl = new FormData();
        fdl.top = new FormAttachment(0, 8);
        fdl.left = new FormAttachment(50, -150);
        fdl.right = new FormAttachment(50, -15);
        fdl.bottom = new FormAttachment(100, -8);
        btnOpen.setLayoutData((Object)fdl);
        Button btnPath = new Button((Composite)lig, 4096);
        btnPath.setText("Change");
        btnPath.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                FileDialog dialog = new FileDialog(MetadataDialog.this.myshell, 4096);
                String path = dialog.open();
                DataDomImpl.setFilePath((Document)MetadataDialog.this.metadata, (String)path);
                MetadataDialog.this.ismodified = true;
                MetadataDialog.this.updateTitle();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        fdl = new FormData();
        fdl.top = new FormAttachment(0, 8);
        fdl.left = new FormAttachment(50, 15);
        fdl.right = new FormAttachment(50, 150);
        fdl.bottom = new FormAttachment(100, -8);
        btnPath.setLayoutData((Object)fdl);
        this.updateDocument();
        this.updateTitle();
        return dialog;
    }

    protected void initializeBounds() {
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(500, size.y);
    }

    protected void configureShell(Shell myshell) {
        super.configureShell(myshell);
        this.myshell = myshell;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 64, "Close", false);
        this.createButton(parent, 8192, "Save", true);
    }

    protected void buttonPressed(int button) {
        this.setReturnCode(1);
        if (button == 8192) {
            this.saveDocument();
            this.close();
        } else if (button == 64) {
            if (this.ismodified) {
                MessageBox box = new MessageBox(this.myshell, 200);
                box.setMessage("The metadata was modified. Save before leaving?");
                int ret = box.open();
                if (ret == 64) {
                    this.saveDocument();
                    this.close();
                } else if (ret == 128) {
                    this.close();
                }
            } else {
                this.close();
            }
        }
    }

    public void setDocument(Document metadata, Object sender) {
        this.sender = sender;
        if (metadata == null) {
            this.metadata = DataDomImpl.createDocument((Document)this.schema);
            this.ismodified = false;
        } else {
            this.metadata = metadata;
            this.ismodified = sender == IPapersPlugin.getDefault().getBundle().getSymbolicName();
        }
        String filepath = DataDomImpl.getFilePath((Document)this.metadata);
        if (filepath != null && filepath.length() > 0) {
            try {
                this.searchPubMedID(filepath, this.metadata);
                this.ismodified = true;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private void saveDocument() {
        ArrayList metas = DataDomImpl.getAllParsersTopElements((Document)this.metadata);
        int i = 0;
        while (i < metas.size()) {
            Element schm;
            String pname;
            IParserPlugin pp;
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Text text = (Text)this.texthash.get(tname);
            if (text != null && (pp = FrameworkPlugin.getParserPlugin((String)(pname = TypeDomImpl.getParser((Element)(schm = TypeDomImpl.getElement((Document)this.schema, (String)tname)))))) != null) {
                try {
                    ITypeParser parser = pp.createInstance();
                    if (parser != null) {
                        parser.addToElement(meta, text.getText());
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
        ArrayList<Request> reqs = new ArrayList<Request>();
        Request req = new Request(3, (Object)this.metadata, "data");
        reqs.add(req);
        FrameworkPlugin.getDefault().updateDocuments(reqs, this.sender);
        this.setReturnCode(0);
    }

    private void updateDocument() {
        ArrayList metas = DataDomImpl.getAllParsersTopElements((Document)this.metadata);
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Element schm = TypeDomImpl.getElement((Document)this.schema, (String)tname);
            String pname = TypeDomImpl.getParser((Element)schm);
            Text txt = (Text)this.texthash.get(tname);
            if (txt != null) {
                IParserPlugin pp = FrameworkPlugin.getParserPlugin((String)pname);
                if (pp != null) {
                    try {
                        ITypeParser parser = pp.createInstance();
                        if (parser != null) {
                            String cntnt = parser.getViewForm(meta);
                            txt.setText(cntnt);
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
                txt.addModifyListener((ModifyListener)new TextListener());
            }
            ++i;
        }
    }

    private void updateTitle() {
        if (this.myshell != null) {
            if (this.ismodified) {
                this.myshell.setText("Metadata Editor for iPapers*");
            } else {
                this.myshell.setText(DIALOGTITLE);
            }
        }
    }

    private void searchPubMedID(String filepath, Document metadata) {
        InputSource inputSource;
        InputStream is;
        SAXParser saxParser;
        SAXParserFactory saxParserFactory;
        URL url;
        String pubmedid = this.getPubMedIDfromFilePath(filepath);
        if (pubmedid == null) {
            return;
        }
        if (pubmedid.length() == 0) {
            return;
        }
        String QueryKey = "";
        String WebEnv = "";
        try {
            String urlAddress = null;
            urlAddress = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=";
            String en = URLEncoder.encode(pubmedid, "UTF-8");
            urlAddress = String.valueOf(urlAddress) + en + "[UID]";
            urlAddress = String.valueOf(urlAddress) + "&retmax=1&usehistory=y";
            System.out.println("iPapers URL:" + urlAddress);
            url = null;
            url = new URL(urlAddress);
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            saxParser = saxParserFactory.newSAXParser();
            is = url.openStream();
            inputSource = new InputSource(is);
            XmlSAX_QueryKeyAndWebEnv xsqw = new XmlSAX_QueryKeyAndWebEnv();
            saxParser.parse(inputSource, (DefaultHandler)xsqw);
            QueryKey = xsqw.getQueryKey();
            WebEnv = xsqw.getWebEnv();
            is.close();
        }
        catch (Exception exception) {
            QueryKey = null;
            WebEnv = null;
        }
        System.out.println("QueryKey:" + QueryKey);
        System.out.println("WebEnv:" + WebEnv);
        if (QueryKey == null || WebEnv == null) {
            return;
        }
        if (QueryKey.length() == 0 || WebEnv.length() == 0) {
            return;
        }
        Hashtable items = null;
        try {
            String urlAddress = null;
            urlAddress = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed";
            urlAddress = String.valueOf(urlAddress) + "&query_key=";
            urlAddress = String.valueOf(urlAddress) + QueryKey;
            urlAddress = String.valueOf(urlAddress) + "&WebEnv=";
            urlAddress = String.valueOf(urlAddress) + WebEnv;
            urlAddress = String.valueOf(urlAddress) + "&retmode=xml";
            System.out.println("iPapers URL:" + urlAddress);
            url = null;
            url = new URL(urlAddress);
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            saxParser = saxParserFactory.newSAXParser();
            is = url.openStream();
            inputSource = new InputSource(is);
            XmlSAX_Result xsr = new XmlSAX_Result();
            saxParser.parse(inputSource, (DefaultHandler)xsr);
            items = xsr.getItems();
            is.close();
        }
        catch (Exception exception) {
            items = null;
        }
        if (items != null) {
            ArrayList metas = DataDomImpl.getAllParsersTopElements((Document)metadata);
            int i = 0;
            while (i < metas.size()) {
                Element meta = (Element)metas.get(i);
                String tname = DataDomImpl.getTagName((Element)meta);
                Element schm = TypeDomImpl.getElement((Document)this.schema, (String)tname);
                String pname = TypeDomImpl.getParser((Element)schm);
                IParserPlugin pp = FrameworkPlugin.getParserPlugin((String)pname);
                if (pp != null) {
                    try {
                        String value;
                        ITypeParser parser = pp.createInstance();
                        if (parser != null && (value = (String)items.get(tname)) != null && value.length() > 0) {
                            parser.addToElement(meta, value);
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
                ++i;
            }
        }
    }

    private String getPubMedIDfromFilePath(String filepath) {
        File file = new File(filepath);
        if (file.exists()) {
            String filename = file.getName();
            filename = FilenameUtils.getBaseName((String)filename);
            char[] data = filename.toCharArray();
            StringBuffer strbuf = null;
            int j = 0;
            while (j < data.length) {
                if ('0' <= data[j] && data[j] <= '9') {
                    if (strbuf == null) {
                        strbuf = new StringBuffer();
                    }
                    strbuf.append(data[j]);
                } else if (strbuf != null) break;
                ++j;
            }
            if (strbuf != null) {
                try {
                    Integer.valueOf(strbuf.toString()).intValue();
                    return strbuf.toString();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        } else {
            System.out.println("iPapers Not file exist");
        }
        return null;
    }

    class TextListener
    implements ModifyListener {
        TextListener() {
        }

        public void modifyText(ModifyEvent e) {
            MetadataDialog.this.ismodified = true;
            MetadataDialog.this.updateTitle();
        }
    }

    public class XmlSAX_QueryKeyAndWebEnv
    extends DefaultHandler {
        String elementpath = null;
        String QueryKey = "";
        String WebEnv = "";

        public String getQueryKey() {
            return this.QueryKey;
        }

        public String getWebEnv() {
            return this.WebEnv;
        }

        public void startDocument() {
            System.out.println("iPapers ===>startDocument");
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.elementpath = this.elementpath == null ? qName : String.valueOf(this.elementpath) + "/" + qName;
        }

        public void characters(char[] ch, int start, int length) {
            if (this.elementpath.equalsIgnoreCase("eSearchResult/QueryKey")) {
                this.QueryKey = new String(ch, start, length);
            } else if (this.elementpath.equalsIgnoreCase("eSearchResult/WebEnv")) {
                this.WebEnv = new String(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            String[] values = this.elementpath.split("/");
            this.elementpath = "";
            int i = 0;
            while (i < values.length - 1) {
                this.elementpath = this.elementpath.length() == 0 ? values[i] : String.valueOf(this.elementpath) + "/" + values[i];
                ++i;
            }
        }

        public void endDocument() {
            System.out.println("iPapers ===>endDocument");
        }
    }

    public class XmlSAX_Result
    extends DefaultHandler {
        private final int AUTHOR_INDEX = 0;
        private final int TITLE_INDEX = 1;
        private final int JOURNAL_INDEX = 2;
        private final int YEAR_INDEX = 3;
        private final int VOLUME_INDEX = 4;
        private final int NUMBER_INDEX = 5;
        private final int PAGES_INDEX = 6;
        private final int ABSTRACT_INDEX = 7;
        private final int IDS_INDEX = 8;
        private final int URL_INDEX = 9;
        private String[] properties = new String[]{"Author", "Title", "Journal", "Year", "Volume", "Number", "Pages", "Abstract", "IDs", "URL"};
        String elementpath = null;
        private Hashtable items = null;
        private ArrayList authors = null;
        private Hashtable author = null;
        private String idtype = null;

        public Hashtable getItems() {
            return this.items;
        }

        public void startDocument() {
            System.out.println("iPapers ===>startDocument");
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.elementpath = this.elementpath == null ? qName : String.valueOf(this.elementpath) + "/" + qName;
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation")) {
                this.items = new Hashtable();
                int i = 0;
                while (i < this.properties.length) {
                    this.items.put(this.properties[i], new String());
                    ++i;
                }
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList")) {
                this.authors = new ArrayList();
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author")) {
                this.author = new Hashtable();
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/PubmedData/ArticleIdList/ArticleId")) {
                this.idtype = atts.getValue("IdType");
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/ArticleTitle")) {
                String value = (String)this.items.get(this.properties[1]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[1], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/PMID")) {
                String value = new String(ch, start, length);
                String url = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/elink.fcgi?dbfrom=pubmed&id=" + value + "&retmode=ref&cmd=prlinks";
                this.items.put(this.properties[9], url);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/PubmedData/ArticleIdList/ArticleId")) {
                if (this.idtype.equalsIgnoreCase("pubmed") || this.idtype.equalsIgnoreCase("doi")) {
                    String cont = (String)this.items.get(this.properties[8]);
                    String newValue = String.valueOf(this.idtype) + ":=" + new String(ch, start, length);
                    cont = cont != null && cont.length() > 0 ? String.valueOf(cont) + ", " + newValue : newValue;
                    this.items.put(this.properties[8], cont);
                }
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Abstract/AbstractText")) {
                String value = (String)this.items.get(this.properties[7]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[7], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/MedlineJournalInfo/MedlineTA")) {
                String value = (String)this.items.get(this.properties[2]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[2], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Pagination/MedlinePgn")) {
                String value = (String)this.items.get(this.properties[6]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[6], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Journal/JournalIssue/Issue")) {
                String value = (String)this.items.get(this.properties[5]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[5], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Journal/JournalIssue/Volume")) {
                String value = (String)this.items.get(this.properties[4]);
                value = String.valueOf(value) + new String(ch, start, length);
                this.items.put(this.properties[4], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Journal/JournalIssue/PubDate/MedlineDate")) {
                String value = new String(ch, start, length);
                String[] values = value.split(" ");
                if (values.length > 0) {
                    this.items.put(this.properties[3], values[0]);
                }
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/Journal/JournalIssue/PubDate/Year")) {
                String value = new String(ch, start, length);
                this.items.put(this.properties[3], value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/LastName")) {
                String value = new String(ch, start, length);
                this.author.put("LastName", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/FirstName")) {
                String value = new String(ch, start, length);
                this.author.put("FirstName", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/MiddleName")) {
                String value = new String(ch, start, length);
                this.author.put("MiddleName", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/Initials")) {
                String value = new String(ch, start, length);
                this.author.put("Initials", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/ForeName")) {
                String value = new String(ch, start, length);
                this.author.put("ForeName", value);
            } else if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author/CollectiveName")) {
                String value = new String(ch, start, length);
                this.author.put("CollectiveName", value);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            int i;
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList/Author") && this.authors != null) {
                if (this.author != null && !this.author.isEmpty()) {
                    this.authors.add(this.author);
                }
                this.author = null;
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/MedlineCitation/Article/AuthorList") && this.authors != null) {
                String name = "";
                i = 0;
                while (i < this.authors.size()) {
                    Hashtable ht = (Hashtable)this.authors.get(i);
                    String CollectiveName = (String)ht.get("CollectiveName");
                    String Initials = (String)ht.get("Initials");
                    String LastName = (String)ht.get("LastName");
                    if (LastName == null) {
                        LastName = "";
                    }
                    if (Initials == null) {
                        Initials = "";
                    }
                    String value = "";
                    if (CollectiveName != null) {
                        value = CollectiveName;
                    } else if (LastName != null) {
                        value = LastName;
                        if (Initials != null) {
                            value = String.valueOf(value) + " " + Initials;
                        }
                    }
                    if (value.length() > 0) {
                        if (name.length() > 0) {
                            name = String.valueOf(name) + ", ";
                        }
                        name = String.valueOf(name) + value;
                    }
                    ++i;
                }
                if (name.length() > 0) {
                    this.items.put(this.properties[0], name);
                }
            }
            if (this.elementpath.equalsIgnoreCase("PubmedArticleSet/PubmedArticle/PubmedData/ArticleIdList/ArticleId")) {
                this.idtype = null;
            }
            String[] values = this.elementpath.split("/");
            this.elementpath = "";
            i = 0;
            while (i < values.length - 1) {
                this.elementpath = this.elementpath.length() == 0 ? values[i] : String.valueOf(this.elementpath) + "/" + values[i];
                ++i;
            }
        }

        public void endDocument() {
            System.out.println("iPapers ===>endDocument");
        }
    }
}

