/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.view.PaperListener;
import org.eclipse.core.runtime.ListenerList;

public class PaperList {
    private static final PaperList singleton = new PaperList();
    private final List paperList = new ArrayList();
    private final ListenerList listenerList = new ListenerList();

    public static PaperList getInstance() {
        return singleton;
    }

    public List getArticleList() {
        return this.paperList;
    }

    public void addPaper(Paper paper) {
        this.paperList.add(paper);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            PaperListener listener = (PaperListener)listeners[i];
            listener.paperAdded(paper);
            ++i;
        }
    }

    public void addPapers(ArrayList papers) {
        int j = 0;
        while (j < papers.size()) {
            this.addPaper((Paper)papers.get(j));
            ++j;
        }
    }

    public void addPaperListener(PaperListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removePaperListener(PaperListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public int size() {
        return this.paperList.size();
    }

    public void clear() {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            PaperListener listener = (PaperListener)listeners[i];
            listener.paperCleared();
            ++i;
        }
        this.paperList.clear();
    }

    public void removePaper(Paper article) {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            PaperListener listener = (PaperListener)listeners[i];
            listener.paperRemoved(article);
            ++i;
        }
        this.paperList.remove(article);
    }
}

