/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.pubmed;

import java.net.ConnectException;
import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperList;
import jp.sourceforge.concierge.plugin.ipapers.search.NoSearchResultsFoundException;
import jp.sourceforge.concierge.plugin.ipapers.search.PaperSearchMethod;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PubMedSearch
extends PaperSearchMethod {
    private PubMedCore pubMedCore = new PubMedCore();

    public PubMedSearch() {
        super("PubMed");
    }

    public void search(PaperList papers, String query, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Searching...", 100);
        if (monitor.isCanceled()) {
            this.pubMedCore.cancel();
        }
        try {
            monitor.subTask(query);
            monitor.worked(1);
            ArrayList results = this.pubMedCore.search(query);
            monitor.worked(10);
            papers.clear();
            int i = 0;
            while (i < results.size()) {
                Paper paper = new Paper((String)results.get(i), "PubMed");
                papers.addPaper(paper);
                monitor.subTask(String.valueOf(i + 1) + "/" + results.size() + ":" + paper.getPaperInfo().getTitle());
                monitor.worked(90 / results.size());
                ++i;
            }
            monitor.done();
        }
        catch (NoSearchResultsFoundException e) {
            this.pubMedCore.cancel();
            throw e;
        }
        catch (ConnectException e) {
            this.pubMedCore.cancel();
            throw e;
        }
        catch (CoreException e) {
            this.pubMedCore.cancel();
            throw e;
        }
        catch (Exception e) {
            this.pubMedCore.cancel();
            throw e;
        }
    }

    public ArrayList search(String query) {
        ArrayList<Paper> papers = new ArrayList<Paper>();
        try {
            ArrayList results = this.pubMedCore.search(query);
            int i = 0;
            while (i < results.size()) {
                papers.add(new Paper((String)results.get(i), "PubMed"));
                ++i;
            }
        }
        catch (NoSearchResultsFoundException noSearchResultsFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return papers;
    }
}

