/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFilter;

public class FileImporter {
    public static boolean importFile(String originalfile, String importdir, String importfile) {
        File f1 = new File(originalfile);
        File f2 = new File(String.valueOf(importdir) + File.separator + importfile);
        if (f1.equals(f2)) {
            return true;
        }
        try {
            if (f1.isDirectory()) {
                FileUtils.copyDirectory((File)f1, (File)f2, (boolean)true);
            } else {
                FileUtils.copyFile((File)f1, (File)f2, (boolean)true);
            }
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            System.err.println(msg);
            return false;
        }
    }

    public static boolean deleteFile(String importdir, String id) {
        File dir = new File(importdir);
        WildcardFilter fileFilter = new WildcardFilter(String.valueOf(id) + ".*");
        File[] files = dir.listFiles((FileFilter)fileFilter);
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    System.err.println(msg);
                    return false;
                }
            } else {
                f.delete();
            }
            ++i;
        }
        return true;
    }

    public static String findFile(String finddir, String pattern) {
        File dir = new File(finddir);
        WildcardFilter fileFilter = new WildcardFilter(pattern);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files.length == 0) {
            return null;
        }
        return files[0].getAbsolutePath();
    }

    public static String getPathFromID(String importdir, long id) {
        String s = FileImporter.findFile(importdir, String.valueOf(String.valueOf(id)) + "*");
        if (s != null) {
            return s;
        }
        String path = String.valueOf(importdir) + File.separator + String.valueOf(id);
        File f = new File(path);
        return f.exists() ? path : null;
    }

    public static long getIDFromPath(String importdir, String path) {
        return -1L;
    }
}

