/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import jp.sourceforge.concierge.util.Base64;
import jp.sourceforge.concierge.util.DomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccountData {
    private Document _doc = null;
    private int _status = -1;
    private static int _number = 0;
    public static final int STATUS_NOCHANGE = 0;
    public static final int STATUS_UPDATE = 1;
    public static final int STATUS_DELETE = 2;
    public static final int STATUS_NEW = 3;
    static /* synthetic */ Class class$0;

    public AccountData() {
        SecretKey secretkey;
        this._doc = DomImpl.createDocument();
        Element root_elem = this._doc.createElement("account");
        root_elem.setAttribute("id", String.valueOf(DomImpl.getUniqueID()));
        this._doc.appendChild(root_elem);
        Element root = this._doc.getDocumentElement();
        String value = root.getAttribute("secretkey");
        if (value == null) {
            SecretKey secretkey2 = this.createSecretKey();
            if (secretkey2 != null) {
                this.setSecretKey(secretkey2);
            }
        } else if (value != null && value.length() == 0 && (secretkey = this.createSecretKey()) != null) {
            this.setSecretKey(secretkey);
        }
        this._status = 3;
        ++_number;
    }

    public AccountData(Document doc) {
        this._status = 0;
        if (doc == null) {
            SecretKey secretkey;
            doc = DomImpl.createDocument();
            Element root_elem = doc.createElement("account");
            root_elem.setAttribute("id", String.valueOf(DomImpl.getUniqueID()));
            doc.appendChild(root_elem);
            Element root = this._doc.getDocumentElement();
            String value = root.getAttribute("secretkey");
            if (value == null) {
                SecretKey secretkey2 = this.createSecretKey();
                if (secretkey2 != null) {
                    this.setSecretKey(secretkey2);
                }
            } else if (value != null && value.length() == 0 && (secretkey = this.createSecretKey()) != null) {
                this.setSecretKey(secretkey);
            }
            this._status = 3;
            ++_number;
        }
        this._doc = doc;
    }

    public Document getDoc() {
        return this._doc;
    }

    public long getID() {
        return DomImpl.getID(this._doc);
    }

    public int getSTATUS() {
        return this._status;
    }

    public void setSTATUS(int value) {
        this._status = value;
    }

    public String getName() {
        Element root = this._doc.getDocumentElement();
        String value = root.getAttribute("name");
        if (value == null) {
            value = "untitled " + String.valueOf(_number);
            this.setName(value);
        } else if (value.length() == 0) {
            value = "untitled " + String.valueOf(_number);
            this.setName(value);
        }
        return value;
    }

    public void setName(String value) {
        Element root = this._doc.getDocumentElement();
        String name = root.getAttribute("name");
        if (name == null) {
            name = "";
        }
        if (!value.equals(name)) {
            root.setAttribute("name", value);
            if (this._status != 3 || this._status != 2) {
                this._status = 1;
            }
        }
    }

    public String getType() {
        Element root = this._doc.getDocumentElement();
        String value = root.getAttribute("type");
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setType(String value) {
        Element root = this._doc.getDocumentElement();
        String type = root.getAttribute("type");
        if (type == null) {
            type = "";
        }
        if (!value.equals(type)) {
            root.setAttribute("type", value);
            if (this._status != 3 || this._status != 2) {
                this._status = 1;
            }
        }
    }

    public String getUrl() {
        Element root = this._doc.getDocumentElement();
        String value = root.getAttribute("url");
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setUrl(String value) {
        Element root = this._doc.getDocumentElement();
        String url = root.getAttribute("url");
        if (url == null) {
            url = "";
        }
        if (!value.equals(url)) {
            root.setAttribute("url", value);
            if (this._status != 3 || this._status != 2) {
                this._status = 1;
            }
        }
    }

    public String getUser() {
        String value = null;
        Element root = this._doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("user");
        if (nl.getLength() > 0) {
            Node node = nl.item(0);
            value = DomImpl.getElementText((Element)node);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setUser(String value) {
        Element root = this._doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("user");
        Element elem = null;
        if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
            String user = DomImpl.getElementText(elem);
            if (user == null) {
                user = "";
            }
            if (value.equals(user)) {
                return;
            }
            Node node = elem.getFirstChild();
            while (node != null) {
                elem.removeChild(node);
                node = node.getNextSibling();
            }
        }
        if (elem == null) {
            elem = this._doc.createElement("user");
            root.appendChild(elem);
        }
        DomImpl.setElementText(elem, value);
        if (this._status != 3 || this._status != 2) {
            this._status = 1;
        }
    }

    public String getPasswd() {
        String value = null;
        try {
            Node node;
            String elementText;
            Element root = this._doc.getDocumentElement();
            NodeList nl = root.getElementsByTagName("passwd");
            if (nl.getLength() > 0 && (elementText = DomImpl.getElementText((Element)(node = nl.item(0)))) != null && elementText.length() > 0) {
                byte[] elementData = elementText.getBytes("US-ASCII");
                ByteArrayOutputStream baos = Base64.decodeToByteArrayOutputStream(elementData, elementData.length);
                byte[] decodeData = baos.toByteArray();
                SecretKey secretKey = this.getSecretKey();
                byte[] decryptData = this.decrypt(decodeData, secretKey);
                value = new String(decryptData);
            }
        }
        catch (Exception exception) {}
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setPasswd(String value) {
        try {
            if (value == null) {
                return;
            }
            if (value.length() == 0) {
                return;
            }
            SecretKey secretKey = this.getSecretKey();
            byte[] srcData = value.getBytes("US-ASCII");
            byte[] encryptData = this.encrypt(srcData, secretKey);
            String encodeStr = Base64.encodeToString(encryptData, encryptData.length);
            Element root = this._doc.getDocumentElement();
            NodeList nl = root.getElementsByTagName("passwd");
            Element elem = null;
            if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
                String passwd = DomImpl.getElementText(elem);
                if (passwd == null) {
                    passwd = "";
                }
                if (encodeStr.equals(passwd)) {
                    return;
                }
                Node node = elem.getFirstChild();
                while (node != null) {
                    elem.removeChild(node);
                    node = node.getNextSibling();
                }
            }
            if (elem == null) {
                elem = this._doc.createElement("passwd");
                root.appendChild(elem);
            }
            DomImpl.setElementText(elem, encodeStr);
            if (this._status != 3 || this._status != 2) {
                this._status = 1;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public String getComment() {
        String value = null;
        Element root = this._doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("comment");
        if (nl.getLength() > 0) {
            Node node = nl.item(0);
            value = DomImpl.getElementText((Element)node);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setComment(String value) {
        Element root = this._doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("comment");
        Element elem = null;
        if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
            String comment = DomImpl.getElementText(elem);
            if (comment == null) {
                comment = "";
            }
            if (value.equals(comment)) {
                return;
            }
            Node node = elem.getFirstChild();
            while (node != null) {
                elem.removeChild(node);
                node = node.getNextSibling();
            }
        }
        if (elem == null) {
            elem = this._doc.createElement("comment");
            root.appendChild(elem);
        }
        DomImpl.setElementText(elem, value);
        if (this._status != 3 || this._status != 2) {
            this._status = 1;
        }
    }

    public byte[] encrypt(byte[] plaintext, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, secretKey);
            return cipher.doFinal(plaintext);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    public byte[] decrypt(byte[] ciphertext, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, secretKey);
            return cipher.doFinal(ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    private SecretKey createSecretKey() {
        try {
            KeyGenerator desGen = KeyGenerator.getInstance("DES");
            SecretKey desKey = desGen.generateKey();
            return desKey;
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    private void setSecretKey(SecretKey desKey) {
        try {
            SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.crypto.spec.DESKeySpec");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DESKeySpec desSpec = (DESKeySpec)desFactory.getKeySpec(desKey, clazz);
            byte[] rawDesKey = desSpec.getKey();
            String value = Base64.encodeToString(rawDesKey, rawDesKey.length);
            Element root = this._doc.getDocumentElement();
            root.setAttribute("secretkey", value);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private SecretKey getSecretKey() {
        try {
            Element root = this._doc.getDocumentElement();
            String value = root.getAttribute("secretkey");
            if (value != null && value.length() > 0) {
                ByteArrayOutputStream baos = Base64.decodeToByteArrayOutputStream(value.getBytes(), value.getBytes().length);
                byte[] rawDesKey = baos.toByteArray();
                SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
                DESKeySpec desSpec = new DESKeySpec(rawDesKey);
                return desFactory.generateSecret(desSpec);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }
}

