/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.util.AccountData;
import jp.sourceforge.concierge.util.DomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AccountsDomImpl
extends DomImpl {
    public static final String MappingCollectionName = "account";

    public static ArrayList getAllAccountData() {
        ArrayList<AccountData> al = new ArrayList<AccountData>();
        String xpath = "/account";
        Request req = new Request(4, xpath, MappingCollectionName);
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        if (docs != null) {
            int i = 0;
            while (i < docs.size()) {
                Document doc = (Document)docs.get(i);
                AccountData ad = new AccountData(doc);
                al.add(ad);
                ++i;
            }
        }
        return al;
    }

    public static ArrayList getAllAccountDataByType(String type) {
        ArrayList<AccountData> al = new ArrayList<AccountData>();
        String xpath = "/account";
        Request req = new Request(4, xpath, MappingCollectionName);
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        if (docs != null) {
            int i = 0;
            while (i < docs.size()) {
                Document doc = (Document)docs.get(i);
                Element root_elem = doc.getDocumentElement();
                String value = root_elem.getAttribute("type");
                if (value != null && value.equalsIgnoreCase(type)) {
                    AccountData ad = new AccountData(doc);
                    al.add(ad);
                }
                ++i;
            }
        }
        return al;
    }

    public static ArrayList getAllAccountDataByName(String name) {
        ArrayList<AccountData> al = new ArrayList<AccountData>();
        String xpath = "/account";
        Request req = new Request(4, xpath, MappingCollectionName);
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        if (docs != null) {
            int i = 0;
            while (i < docs.size()) {
                Document doc = (Document)docs.get(i);
                Element root_elem = doc.getDocumentElement();
                String value = root_elem.getAttribute("name");
                if (value != null && value.equalsIgnoreCase(name)) {
                    AccountData ad = new AccountData(doc);
                    al.add(ad);
                }
                ++i;
            }
        }
        return al;
    }

    public static AccountData getAccountDataByURL(String url) {
        String xpath = "/account";
        Request req = new Request(4, xpath, MappingCollectionName);
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        if (docs != null) {
            int i = 0;
            while (i < docs.size()) {
                Document doc = (Document)docs.get(i);
                Element root_elem = doc.getDocumentElement();
                String value = root_elem.getAttribute("url");
                if (value != null && value.equalsIgnoreCase(url)) {
                    AccountData ad = new AccountData(doc);
                    return ad;
                }
                ++i;
            }
        }
        return null;
    }

    public static void addAccountList(ArrayList al, Object sender) {
        AccountsDomImpl.requestAccountList(al, 1, sender);
    }

    public static void deleteAccountList(ArrayList al, Object sender) {
        AccountsDomImpl.requestAccountList(al, 2, sender);
    }

    public static void updateAccountList(ArrayList al, Object sender) {
        AccountsDomImpl.requestAccountList(al, 3, sender);
    }

    public static void requestAccountList(ArrayList al, int command, Object sender) {
        if (al != null && al.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            int i = 0;
            while (i < al.size()) {
                reqs.add(new Request(command, ((AccountData)al.get(i)).getDoc(), MappingCollectionName));
                ++i;
            }
            if (reqs.size() > 0) {
                FrameworkPlugin.getDefault().updateDocuments(reqs, sender);
            }
            reqs.clear();
            Object var3_3 = null;
        }
    }

    public static void addAccountData(AccountData ad, Object sender) {
        AccountsDomImpl.requestAccountData(ad, 1, sender);
    }

    public static void deleteAccountData(AccountData ad, Object sender) {
        AccountsDomImpl.requestAccountData(ad, 2, sender);
    }

    public static void updateAccountData(AccountData ad, Object sender) {
        AccountsDomImpl.requestAccountData(ad, 3, sender);
    }

    public static void requestAccountData(AccountData ad, int command, Object sender) {
        if (ad != null) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            Document doc = ad.getDoc();
            if (doc != null) {
                reqs.add(new Request(command, doc, MappingCollectionName));
            }
            if (reqs.size() > 0) {
                FrameworkPlugin.getDefault().updateDocuments(reqs, sender);
            }
            reqs.clear();
            Object var3_3 = null;
        }
    }
}

