/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatNameData;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceFormatData {
    private Document typedoc = null;
    private ArrayList formatNameList = null;
    private int formatNameListIndex = 0;

    public ReferenceFormatData(Document typedoc) {
        this.typedoc = typedoc;
        this.formatNameList = new ArrayList();
    }

    public long getID() {
        return DomImpl.getID(this.typedoc);
    }

    public String getTypeName() {
        return TypeDomImpl.getTypeName(this.typedoc);
    }

    public ArrayList getFormatNameList() {
        return this.formatNameList;
    }

    public ReferenceFormatNameData newFormatName(String formatname) {
        ReferenceFormatNameData rfnd = new ReferenceFormatNameData(formatname);
        this.formatNameList.add(rfnd);
        ArrayList typeelems = TypeDomImpl.getAllElements(this.typedoc);
        int i = 0;
        while (i < typeelems.size()) {
            Element typeelem = (Element)typeelems.get(i);
            String itemname = TypeDomImpl.getElementName(typeelem);
            rfnd.addTypeItem(itemname);
            ++i;
        }
        rfnd.initializeFormatString();
        return rfnd;
    }

    public void removeFormatName(ReferenceFormatNameData rfnd) {
        if (rfnd == null) {
            return;
        }
        this.formatNameList.remove(rfnd);
    }

    public int getFormatNameListIndex() {
        return this.formatNameListIndex;
    }

    public void setFormatNameListIndex(int index) {
        this.formatNameListIndex = index;
    }
}

