/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;
import jp.sourceforge.concierge.util.ReferenceFormatTypeItemData;

public class ReferenceFormatNameData {
    public static final String[] fontitems = new String[]{"Helvetica", "Times", "Courier"};
    private String formatname = null;
    private ArrayList typeItemList = null;
    private String formatString = null;
    private int fontitemindex = -1;
    private int fontsize = 0;

    public ReferenceFormatNameData(String formatname) {
        this.formatname = formatname;
        this.typeItemList = new ArrayList();
        this.formatString = null;
        this.fontitemindex = 0;
        this.fontsize = 12;
    }

    public String getName() {
        return this.formatname;
    }

    public void setName(String name) {
        this.formatname = name;
    }

    public ArrayList getTypeItemList() {
        return this.typeItemList;
    }

    public void addTypeItem(String itemname) {
        ReferenceFormatTypeItemData rftid = new ReferenceFormatTypeItemData(itemname);
        this.typeItemList.add(rftid);
    }

    public void setFontname(String fontname) {
        int i = 0;
        while (i < fontitems.length) {
            if (fontitems[i].equalsIgnoreCase(fontname)) {
                this.setFontItemIndex(i);
                break;
            }
            ++i;
        }
    }

    public String getFontname() {
        if (this.fontitemindex >= 0 && this.fontitemindex < fontitems.length) {
            return fontitems[this.fontitemindex];
        }
        return fontitems[0];
    }

    public int getFontItemIndex() {
        return this.fontitemindex;
    }

    public void setFontItemIndex(int index) {
        this.fontitemindex = index >= 0 && index < fontitems.length ? index : -1;
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public void setFontSize(int fontsize) {
        this.fontsize = fontsize;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void initializeFormatString() {
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        while (i < this.typeItemList.size()) {
            ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)this.typeItemList.get(i);
            if (rftid.getCheck()) {
                if (strBuf.length() > 0) {
                    strBuf.append(",");
                }
                strBuf.append(rftid.getTag());
            }
            ++i;
        }
        this.formatString = strBuf.toString();
    }
}

