/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;
import java.util.Arrays;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.util.Base64;
import jp.sourceforge.concierge.util.DomImpl_internal;
import jp.sourceforge.concierge.util.XMLString;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeDomImpl_internal
extends DomImpl_internal {
    public static Document createDocument(String name) {
        try {
            Document doc = DomImpl_internal.createDocument();
            Element topelem = doc.createElement("type");
            topelem.setAttribute("name", name);
            topelem.setAttribute("image", "");
            doc.appendChild(topelem);
            String id = String.valueOf(DomImpl_internal.getUniqueID());
            doc.getDocumentElement().setAttribute("id", id);
            doc.getDocumentElement().setAttribute("lastmod", id);
            return doc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Element appendElement(Document doc, String name, String type, boolean visible, boolean editable, boolean index) {
        ITypeParser parser = FrameworkPlugin.getParserPlugin(type).createInstance();
        String namespace = parser.getParserNS();
        String ns_prefix = parser.getParserNSPrefix();
        Element elem = DomImpl_internal.appendElement(doc, "element", null);
        TypeDomImpl_internal.setElement(elem, name, type, namespace, ns_prefix, visible, editable, index);
        return elem;
    }

    protected static Element appendElement(Document doc, String name, String parser, String parserns, String parsernsprefix, boolean visible, boolean editable, boolean indexable) {
        Element elem = DomImpl_internal.appendElement(doc, "element", null);
        TypeDomImpl_internal.setElement(elem, name, parser, parserns, parsernsprefix, visible, editable, indexable);
        return elem;
    }

    protected static void setElement(Element elem, String name, String parser, String parserns, String parsernsprefix, boolean visible, boolean editable, boolean index) {
        elem.setAttribute("name", name);
        elem.setAttribute("parser", parser);
        elem.setAttribute("parserns", parserns);
        elem.setAttribute("parsernsprefix", parsernsprefix);
        elem.setAttribute("visible", visible ? "true" : "false");
        elem.setAttribute("editable", editable ? "true" : "false");
        elem.setAttribute("index", index ? "true" : "false");
        elem.setAttribute("colOrder", "");
        elem.setAttribute("colWidth", "");
    }

    protected static void setName(Document doc, String name) {
        TypeDomImpl_internal.setElementName(doc.getDocumentElement(), name);
    }

    protected static ArrayList getAllElements(Document doc) {
        return DomImpl_internal.getElements(doc, "element", null);
    }

    protected static void setElementName(Element elem, String value) {
        elem.setAttribute("name", value);
    }

    protected static void setPluginID(Document doc, String id) {
        doc.getDocumentElement().setAttribute("pluginid", id);
    }

    protected static void setParser(Element elem, String value) {
        elem.setAttribute("parser", value);
    }

    protected static void setParserNS(Element elem, String value) {
        elem.setAttribute("parserns", value);
    }

    protected static void setParserNSPrefix(Element elem, String value) {
        elem.setAttribute("parsernsprefix", value);
    }

    protected static void setVisible(Element elem, boolean value) {
        elem.setAttribute("visible", value ? "true" : "false");
    }

    protected static void setIndex(Element elem, boolean value) {
        elem.setAttribute("index", value ? "true" : "false");
    }

    protected static void setEditable(Element elem, boolean value) {
        elem.setAttribute("editable", value ? "true" : "false");
    }

    protected static void setColOrder(Element elem, int order) {
        elem.setAttribute("colOrder", String.valueOf(order));
    }

    protected static void setColWidth(Element elem, int width) {
        elem.setAttribute("colWidth", String.valueOf(width));
    }

    protected static String getTypeName(Document doc) {
        return doc.getDocumentElement().getAttribute("name");
    }

    protected static void setTypeName(Document doc, String name) {
        doc.getDocumentElement().setAttribute("name", name);
    }

    protected static String getElementName(Element elem) {
        return elem.getAttribute("name");
    }

    protected static String getPluginID(Document doc) {
        return doc.getDocumentElement().getAttribute("pluginid");
    }

    protected static String getParser(Element elem) {
        return elem.getAttribute("parser");
    }

    protected static String getParserNS(Element elem) {
        return elem.getAttribute("parserns");
    }

    protected static String getParserNSPrefix(Element elem) {
        return elem.getAttribute("parsernsprefix");
    }

    protected static boolean getVisible(Element elem) {
        return elem.getAttribute("visible").compareTo("true") == 0;
    }

    protected static boolean getIndex(Element elem) {
        return elem.getAttribute("index").compareTo("true") == 0;
    }

    protected static boolean getEditable(Element elem) {
        return elem.getAttribute("editable").compareTo("true") == 0;
    }

    protected static int getColOrder(Element elem) {
        String order = elem.getAttribute("colOrder");
        return Integer.parseInt(order.length() == 0 ? "-1" : order);
    }

    protected static int getColWidth(Element elem) {
        String width = elem.getAttribute("colWidth");
        return Integer.parseInt(width.length() == 0 ? "-1" : width);
    }

    public static String getStringOfDocumentQueryByType(String typename) {
        return XMLString.getElementQueryStringByFullPath("@name", typename, "type");
    }

    public static String getStringOfDocumentQueryByID(long niid) {
        return XMLString.getElementQueryStringByFullPath("@id", String.valueOf(niid), "type");
    }

    protected static boolean isInstance(Document doc) {
        return doc.getDocumentElement().getNodeName().compareTo("type") == 0;
    }

    protected static void setImage(Document doc, Image img) {
        String imgstr = Base64.encode(img.getImageData());
        doc.getDocumentElement().setAttribute("image", imgstr);
    }

    protected static void setImage(Document doc, String filename) {
        String ext = FilenameUtils.getExtension((String)filename);
        String newfilename = "__type__" + String.valueOf(DomImpl_internal.getID(doc)) + "." + ext;
        if (FrameworkPlugin.importFile(filename, newfilename)) {
            doc.getDocumentElement().setAttribute("image", newfilename);
        }
    }

    protected static Image getImage(Document doc, Device display) {
        String imgstr = doc.getDocumentElement().getAttribute("image");
        if (imgstr.length() == 0) {
            try {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.framework", (String)"icons/concierge.png").createImage();
            }
            catch (Exception exception) {
                return null;
            }
        }
        ImageData imgd = Base64.decode(imgstr);
        if (imgd == null) {
            return new Image(display, FrameworkPlugin.findImportedFile(imgstr));
        }
        return new Image(display, imgd);
    }

    protected static void orderNormalize(Document doc) {
        ArrayList elems = TypeDomImpl_internal.getAllElements(doc);
        int[] orders = new int[elems.size()];
        int NOORDER = 10000;
        int i = 0;
        while (i < elems.size()) {
            orders[i] = TypeDomImpl_internal.getColOrder((Element)elems.get(i));
            if (orders[i] < 0) {
                orders[i] = NOORDER + i;
                TypeDomImpl_internal.setColOrder((Element)elems.get(i), orders[i]);
            }
            ++i;
        }
        Arrays.sort(orders);
        i = 0;
        while (i < elems.size()) {
            int order = TypeDomImpl_internal.getColOrder((Element)elems.get(i));
            int j = 0;
            while (j < orders.length) {
                if (orders[j] == order) {
                    TypeDomImpl_internal.setColOrder((Element)elems.get(i), j);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected static Element getElement(Document typedoc, String name) {
        Element topelem = typedoc.getDocumentElement();
        if (topelem == null) {
            return null;
        }
        NodeList elems = topelem.getChildNodes();
        int i = 0;
        while (i < elems.getLength()) {
            Element elem;
            Node node = elems.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().compareTo("element") == 0 && (elem = (Element)node).getAttribute("name").compareTo(name) == 0) {
                return elem;
            }
            ++i;
        }
        return null;
    }
}

