/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.FootprintPlugin;
import jp.sourceforge.concierge.plugin.footprint.Category;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CategoryViewer {
    private static ArrayList flags = new ArrayList();
    private static ArrayList colors = new ArrayList();
    private static Font font;
    private static int colorcounter;
    private static Image defimage;
    private static Category unknown;
    private CheckboxTableViewer tableview;
    private ArrayList categories = new ArrayList();

    static {
        colorcounter = 0;
        defimage = FootprintPlugin.getImageDescriptor("icons/flag-bk.png").createImage();
        unknown = new Category("<Unknown>", -1);
        colors.add(new Color(null, 230, 77, 70));
        colors.add(new Color(null, 110, 47, 109));
        colors.add(new Color(null, 18, 135, 111));
        colors.add(new Color(null, 24, 49, 89));
        colors.add(new Color(null, 242, 180, 19));
        colors.add(new Color(null, 67, 21, 10));
        int sz = SystemUtil.GetOSType() == 1 ? 12 : 8;
        font = new Font(null, "Arial", sz, 1);
        flags.add(FootprintPlugin.getImageDescriptor("icons/flag-syu.png").createImage());
        flags.add(FootprintPlugin.getImageDescriptor("icons/flag-edom.png").createImage());
        flags.add(FootprintPlugin.getImageDescriptor("icons/flag-aotake.png").createImage());
        flags.add(FootprintPlugin.getImageDescriptor("icons/flag-ai.png").createImage());
        flags.add(FootprintPlugin.getImageDescriptor("icons/flag-yamabuki.png").createImage());
        flags.add(FootprintPlugin.getImageDescriptor("icons/flag-kuri.png").createImage());
    }

    public static Color getColor(int colorid) {
        return colorid >= 0 ? (Color)colors.get(colorid) : null;
    }

    public static Image getImage(int colorid) {
        return colorid >= 0 ? (Image)flags.get(colorid) : defimage;
    }

    protected void finalize() throws Throwable {
        int i = 0;
        while (i < colors.size()) {
            ((Color)colors.get(i)).dispose();
            ++i;
        }
        font.dispose();
        super.finalize();
    }

    private void updateData() {
        FootprintPlugin fp = FootprintPlugin.getDefault();
        fp.updateCategories(this.categories);
    }

    private void refresh() {
        this.tableview.refresh();
        this.tableview.getTable().getColumn(0).pack();
    }

    public CategoryViewer(Composite parent, ArrayList cats) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Table table = new Table(parent, 67616);
        this.tableview = new CheckboxTableViewer(table);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        col.setMoveable(false);
        this.tableview.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table)});
        this.tableview.setColumnProperties(new String[]{"name"});
        this.tableview.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableview.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider());
        this.tableview.setCellModifier((ICellModifier)new CategoryCellModifier((TableViewer)this.tableview));
        this.tableview.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection s = (IStructuredSelection)e.getSelection();
                if (s.isEmpty()) {
                    return;
                }
                CellEditor[] eds = CategoryViewer.this.tableview.getCellEditors();
                if (eds.length == 0) {
                    return;
                }
                Category cat = (Category)s.getFirstElement();
                Color c = (Color)colors.get(cat.colorid);
                eds[0].getControl().setForeground(c);
            }
        });
        int i = 0;
        while (i < cats.size()) {
            Category c = (Category)cats.get(i);
            if (c.colorid < 0) {
                c.colorid = i % colors.size();
            }
            this.categories.add(c);
            ++i;
        }
        colorcounter = cats.size();
        this.tableview.setInput((Object)this.categories);
        this.tableview.setAllChecked(true);
        this.tableview.addDragSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new CategoryDragAdapter());
        this.tableview.addDropSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new CategoryDropListener());
        this.refresh();
    }

    public void addCategory() {
        String name = "";
        int i = 0;
        while (true) {
            name = "Category" + String.valueOf(i);
            boolean find = false;
            int j = 0;
            while (j < this.categories.size()) {
                if (((Category)this.categories.get((int)j)).name.compareTo(name) == 0) {
                    find = true;
                    break;
                }
                ++j;
            }
            if (!find) break;
            ++i;
        }
        Category cat = new Category(name, colorcounter % flags.size());
        this.categories.add(cat);
        ++colorcounter;
        this.refresh();
        this.updateData();
        this.tableview.setChecked((Object)cat, true);
    }

    public void deleteCategory() {
        IStructuredSelection sel = (IStructuredSelection)this.tableview.getSelection();
        if (sel == null) {
            return;
        }
        Category c = (Category)sel.getFirstElement();
        this.categories.remove(c);
        FootprintPlugin fp = FootprintPlugin.getDefault();
        fp.updateDocumentsDeletingCategory(c.name);
        this.refresh();
        this.updateData();
    }

    public Category getCategory(String name) {
        int i = 0;
        while (i < this.categories.size()) {
            Category c = (Category)this.categories.get(i);
            if (c.name.compareTo(name) == 0) {
                return c;
            }
            ++i;
        }
        return unknown;
    }

    public void addCheckListener(ICheckStateListener listener) {
        this.tableview.addCheckStateListener(listener);
    }

    public Category getCurrentCategory() {
        IStructuredSelection s = (IStructuredSelection)this.tableview.getSelection();
        if (s.isEmpty()) {
            return null;
        }
        return (Category)s.getFirstElement();
    }

    private class CategoryDragAdapter
    extends DragSourceAdapter {
        IStructuredSelection selection = null;

        private CategoryDragAdapter() {
        }

        public void dragSetData(DragSourceEvent e) {
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.selection);
        }

        public void dragStart(DragSourceEvent e) {
            this.selection = (IStructuredSelection)CategoryViewer.this.tableview.getSelection();
            if (this.selection.size() != 1) {
                this.selection = null;
                e.doit = false;
                return;
            }
            e.doit = true;
        }

        public void dragFinished(DragSourceEvent e) {
        }
    }

    private class CategoryDropListener
    extends DropTargetAdapter {
        private CategoryDropListener() {
        }

        public void dragEnter(DropTargetEvent e) {
            e.detail = 2;
        }

        public void drop(DropTargetEvent e) {
            Category oldc = (Category)((IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()).getFirstElement();
            Category newc = (Category)((TableItem)e.item).getData();
            ArrayList list = (ArrayList)CategoryViewer.this.tableview.getInput();
            int nidx = list.indexOf(newc);
            list.remove(oldc);
            list.add(nidx, oldc);
            CategoryViewer.this.tableview.refresh();
            CategoryViewer.this.updateData();
        }
    }

    private class CategoryCellModifier
    implements ICellModifier {
        private TableViewer viewer;

        public CategoryCellModifier(TableViewer tv) {
            this.viewer = tv;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return property == "name" ? ((Category)element).name : null;
        }

        public void modify(Object element, String property, Object value) {
            if (((String)value).trim().length() == 0) {
                FootprintPlugin.showMessage(this.viewer.getTable().getShell(), "Category name has at least one character.");
                return;
            }
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            Category c = (Category)element;
            int i = 0;
            while (i < CategoryViewer.this.categories.size()) {
                Category ac = (Category)CategoryViewer.this.categories.get(i);
                if (!c.equals(ac) && ((String)value).compareTo(ac.name) == 0) {
                    FootprintPlugin.showMessage(this.viewer.getTable().getShell(), "Category name already exists.");
                    return;
                }
                ++i;
            }
            String oldcat = c.name;
            String newcat = (String)value;
            if (property.compareTo("name") == 0) {
                if (c.name.compareTo((String)value) == 0) {
                    return;
                }
                c.name = (String)value;
            }
            this.viewer.refresh();
            this.viewer.getTable().getColumn(0).pack();
            FootprintPlugin fp = FootprintPlugin.getDefault();
            fp.updateDocumentsUpdatingCategory(oldcat, newcat);
            CategoryViewer.this.updateData();
        }
    }

    private class CategoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    IColorProvider {
        private CategoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return columnIndex == 0 ? ((Category)element).name : null;
        }

        public Color getForeground(Object element) {
            return (Color)colors.get(((Category)element).colorid);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            return font;
        }
    }
}

