/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search;

import java.util.HashMap;
import jp.sourceforge.concierge.plugin.ipapers.search.PaperSearchMethod;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedSearch;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.CacheSearch;

public class PaperSearchFactory {
    private static final PaperSearchFactory singleton = new PaperSearchFactory();
    private HashMap paperSearchMap = new HashMap();

    public static PaperSearchFactory getInstance() {
        return singleton;
    }

    PaperSearchFactory() {
        this.addNewPaperSearch(new PubMedSearch());
        this.addNewPaperSearch(new CacheSearch());
    }

    private void addNewPaperSearch(PaperSearchMethod searchMethod) {
        this.paperSearchMap.put(searchMethod.getType(), searchMethod);
    }

    public PaperSearchMethod paperSearch(String type) throws Exception {
        if (this.paperSearchMap.containsKey(type)) {
            return (PaperSearchMethod)this.paperSearchMap.get(type);
        }
        throw new Exception("no paper search method");
    }
}

