/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.smart;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartSearch;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SmartQuery {
    Document document = null;
    DOMImplementation domImpl = null;

    public SmartQuery() {
        try {
            File queries;
            String dbdir = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + "ipapers";
            File db = new File(dbdir);
            if (!db.exists()) {
                db.mkdir();
            }
            if (!(queries = new File(String.valueOf(dbdir) + System.getProperty("file.separator") + "smartQueries.xml")).exists()) {
                this.createNewFile();
            } else {
                DOMParser parser = new DOMParser();
                parser.parse(queries.getPath());
                this.document = parser.getDocument();
            }
        }
        catch (SAXException sAXException) {
            this.createNewFile();
        }
        catch (IOException iOException) {
            this.createNewFile();
        }
    }

    private void createNewFile() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.domImpl = builder.getDOMImplementation();
            this.document = this.domImpl.createDocument("", "root", null);
            this.document = this.domImpl.createDocument("", "smartQueries", null);
        }
        catch (ParserConfigurationException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
        }
    }

    public void saveFile() {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            String dbdir = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + "ipapers";
            File newXML = new File(String.valueOf(dbdir) + System.getProperty("file.separator") + "smartQueries.xml");
            FileOutputStream os = new FileOutputStream(newXML);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
        }
        catch (TransformerException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
        }
        catch (FileNotFoundException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
        }
    }

    public void addQuery(SmartSearch lists) {
        Element smartQueries = this.document.getDocumentElement();
        smartQueries.appendChild(this.makeSmartQueryNode(lists));
    }

    private Element makeSmartQueryNode(SmartSearch lists) {
        Element smartQuery = this.document.createElement("smartQuery");
        Element name = this.document.createElement("name");
        name.appendChild(this.document.createTextNode(lists.getName()));
        smartQuery.appendChild(name);
        Element lastSearch = this.document.createElement("lastSearch");
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        lastSearch.appendChild(this.document.createTextNode(df.format(lists.getSearchTime())));
        smartQuery.appendChild(lastSearch);
        Element period = this.document.createElement("period");
        period.appendChild(this.document.createTextNode(lists.getPeriod()));
        smartQuery.appendChild(period);
        Element queries = this.document.createElement("queries");
        smartQuery.appendChild(queries);
        int i = 0;
        while (i < lists.numberOfQuery()) {
            if (!(lists.get(i).getTarget() == null || lists.get(i).getKeyword() == null || lists.get(i).getParameter() == null || lists.get(i).getTarget().equals("") || lists.get(i).getKeyword().equals("") || lists.get(i).getParameter().equals(""))) {
                Element query = this.document.createElement("query");
                queries.appendChild(query);
                Element target = this.document.createElement("target");
                target.appendChild(this.document.createTextNode(lists.get(i).getTarget()));
                query.appendChild(target);
                Element keyword = this.document.createElement("keyword");
                keyword.appendChild(this.document.createTextNode(lists.get(i).getKeyword()));
                query.appendChild(keyword);
                Element parameter = this.document.createElement("parameter");
                parameter.appendChild(this.document.createTextNode(lists.get(i).getParameter()));
                query.appendChild(parameter);
            }
            ++i;
        }
        return smartQuery;
    }

    public void get() {
        Element smartQueries = this.document.getDocumentElement();
        NodeList gchildren = smartQueries.getChildNodes();
        int j = 0;
        while (j < gchildren.getLength()) {
            Node gchild = gchildren.item(j);
            System.out.println("Name: " + gchild.getNodeName());
            ++j;
        }
    }

    private Node getSmartQuery(int i) {
        Element smartQueries = this.document.getDocumentElement();
        Node smartQueryNode = null;
        if (i < smartQueries.getChildNodes().getLength()) {
            smartQueryNode = smartQueries.getChildNodes().item(i);
        }
        return smartQueryNode;
    }

    public String getLastSearch(int i) {
        Node lastSearch = this.getSmartQuery(i).getFirstChild();
        return lastSearch.getFirstChild().getNodeValue();
    }

    public ArrayList getAllSmartQuery() {
        ArrayList<SmartSearch> lists = new ArrayList<SmartSearch>();
        Element smartQueries = this.document.getDocumentElement();
        if (smartQueries != null && smartQueries.getChildNodes().getLength() != 0) {
            int i = 0;
            while (i < smartQueries.getChildNodes().getLength()) {
                if (smartQueries.getChildNodes().item(i).getNodeName().equals("smartQuery")) {
                    lists.add(this.getSmartQueryAt(i));
                }
                ++i;
            }
        }
        return lists;
    }

    public SmartSearch getSmartQueryAt(int i) {
        SmartSearch list = new SmartSearch();
        Node smartQuery = this.getSmartQuery(i);
        if (smartQuery != null) {
            NodeList nodes = smartQuery.getChildNodes();
            int j = 0;
            while (j < nodes.getLength()) {
                if (nodes.item(j).getNodeName().equalsIgnoreCase("name")) {
                    list.setName(nodes.item(j).getFirstChild().getNodeValue());
                } else if (nodes.item(j).getNodeName().equalsIgnoreCase("period")) {
                    list.setPeriod(nodes.item(j).getFirstChild().getNodeValue());
                } else if (nodes.item(j).getNodeName().equalsIgnoreCase("lastSearch")) {
                    DateFormat df = DateFormat.getDateTimeInstance(2, 2);
                    Date date = null;
                    try {
                        date = df.parse(nodes.item(j).getFirstChild().getNodeValue());
                    }
                    catch (DOMException e) {
                        IPapersPlugin.log.error((Object)e.getMessage());
                    }
                    catch (ParseException e) {
                        IPapersPlugin.log.error((Object)e.getMessage());
                    }
                    Timestamp time = new Timestamp(date.getTime());
                    list.setSearchTime(time);
                } else if (nodes.item(j).getNodeName().equalsIgnoreCase("queries")) {
                    this.getQueries(nodes.item(j).getChildNodes(), list);
                }
                ++j;
            }
        }
        return list;
    }

    private void getQueries(NodeList queries, SmartSearch list) {
        int j = 0;
        while (j < queries.getLength()) {
            Node gchild = queries.item(j);
            NodeList q = gchild.getChildNodes();
            int k = 0;
            while (k < q.getLength()) {
                if (q.item(k).getNodeName().equalsIgnoreCase("keyword")) {
                    list.get(j).setKeyword(q.item(k).getFirstChild().getNodeValue());
                } else if (q.item(k).getNodeName().equalsIgnoreCase("parameter")) {
                    list.get(j).setParameter(q.item(k).getFirstChild().getNodeValue());
                } else if (q.item(k).getNodeName().equalsIgnoreCase("target")) {
                    list.get(j).setTarget(q.item(k).getFirstChild().getNodeValue());
                }
                ++k;
            }
            ++j;
        }
    }

    public void removeQuery(SmartSearch list) {
        Element smartQueries = this.document.getDocumentElement();
        Node deleteSmartQuery = null;
        if (smartQueries != null && smartQueries.getChildNodes().getLength() != 0) {
            int i = 0;
            while (i < smartQueries.getChildNodes().getLength()) {
                Node smartQuery = smartQueries.getChildNodes().item(i);
                if (smartQuery.getNodeName().equals("smartQuery")) {
                    NodeList nodes = smartQuery.getChildNodes();
                    int j = 0;
                    while (j < nodes.getLength()) {
                        if (nodes.item(j).getNodeName().equalsIgnoreCase("name") && nodes.item(j).getFirstChild().getNodeValue().equalsIgnoreCase(list.getName())) {
                            deleteSmartQuery = smartQuery;
                            break;
                        }
                        ++j;
                    }
                    if (deleteSmartQuery != null) break;
                }
                ++i;
            }
        }
        if (deleteSmartQuery != null) {
            smartQueries.removeChild(deleteSmartQuery);
        }
    }

    public void updateQuery(SmartSearch list) {
        Element smartQueries = this.document.getDocumentElement();
        Node targetSmartQuery = null;
        if (smartQueries != null && smartQueries.getChildNodes().getLength() != 0) {
            int i = 0;
            while (i < smartQueries.getChildNodes().getLength()) {
                Node smartQuery = smartQueries.getChildNodes().item(i);
                if (smartQuery.getNodeName().equals("smartQuery")) {
                    NodeList nodes = smartQuery.getChildNodes();
                    int j = 0;
                    while (j < nodes.getLength()) {
                        if (nodes.item(j).getNodeName().equalsIgnoreCase("name") && nodes.item(j).getFirstChild().getNodeValue().equalsIgnoreCase(list.getName())) {
                            targetSmartQuery = smartQuery;
                            break;
                        }
                        ++j;
                    }
                    if (targetSmartQuery != null) break;
                }
                ++i;
            }
        }
        if (targetSmartQuery != null) {
            smartQueries.replaceChild(this.makeSmartQueryNode(list), targetSmartQuery);
        }
    }
}

