/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.view;

import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PaperLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(Object element, int columnIndex) {
        try {
            Paper info = (Paper)element;
            switch (columnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    return info.getPaperInfo().getAuthor();
                }
                case 2: {
                    return info.getPaperInfo().getTitle();
                }
                case 3: {
                    return info.getPaperInfo().getJournal();
                }
                case 4: {
                    return info.getPaperInfo().getVolume();
                }
                case 5: {
                    return info.getPaperInfo().getYear();
                }
                case 6: {
                    return info.getPaperInfo().getIssue();
                }
                case 7: {
                    return info.getPaperInfo().getPages();
                }
                case 8: {
                    return info.getId();
                }
                case 9: {
                    return info.getIdType();
                }
            }
            return null;
        }
        catch (CannotGetPaperInfoException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        try {
            PaperInfo info = ((Paper)element).getPaperInfo();
            switch (columnIndex) {
                case 0: {
                    switch (info.getFlag()) {
                        case 2: {
                            return IPapersPlugin.getDefault().getImageRegistry().get("concierge");
                        }
                        case 0: {
                            return IPapersPlugin.getDefault().getImageRegistry().get("unread");
                        }
                        case 4: {
                            return IPapersPlugin.getDefault().getImageRegistry().get("icon_pdf16");
                        }
                    }
                    return null;
                }
            }
            return null;
        }
        catch (CannotGetPaperInfoException e) {
            IPapersPlugin.log.error((Object)e.getMessage());
            return null;
        }
    }
}

