/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.view;

import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.PaperList;
import jp.sourceforge.concierge.plugin.ipapers.search.PaperSearchFactory;
import jp.sourceforge.concierge.plugin.ipapers.search.PaperSearchMethod;
import jp.sourceforge.concierge.plugin.ipapers.search.PaperSearchQuery;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class SearchViewBase {
    private static PaperSearchFactory paperSearchFactory = PaperSearchFactory.getInstance();
    private PaperList papers = PaperList.getInstance();

    protected void searchWithQuery(PaperSearchQuery query) {
        Job job = new Job(String.valueOf(query.getType()) + " Search "){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PaperSearchMethod search = paperSearchFactory.paperSearch(query.getType());
                    search.search(SearchViewBase.this.papers, query.getQuery(), monitor);
                }
                catch (Exception e) {
                    if (IPapersPlugin.log.isInfoEnabled()) {
                        IPapersPlugin.log.error((Object)e.getMessage());
                    }
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        IPreferenceStore store = IPapersPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("suppres dialog")) {
            job.setUser(false);
        } else {
            job.setUser(true);
        }
        job.schedule();
    }
}

