/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.IConciergeDialog;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.HTMLDocumentParser;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.footprint.Category;
import jp.sourceforge.concierge.plugin.footprint.FootprintDialog;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FootprintPlugin
extends AbstractDocumentUIPlugin
implements IConciergeDialog {
    public static final String PLUGIN_ID = "jp.sourceforge.concierge.plugin.footprint";
    public static final String UNKNOWNCATEGORY = "<Unknown>";
    private static final String UNKNOWNDATE = "UD";
    private static final String CATEGORYTAG = "category";
    private static final String CATCOLORID = "colorid";
    private static FootprintPlugin plugin;
    private ArrayList footprintdocuments;
    private Document configdocument;
    private Hashtable documents = new Hashtable();
    private Document miscfiledocument;
    private FootprintDialog dialog;

    private static String getString(Document doc, String itemname, String type) {
        Element elem = DataDomImpl.getElement((Document)doc, (String)itemname);
        if (elem == null) {
            return null;
        }
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)type);
        if (ip == null) {
            return null;
        }
        ITypeParser parser = ip.createInstance();
        return parser.getViewForm(elem);
    }

    private static void setString(Document doc, String itemname, String type, String val) {
        Element elem = DataDomImpl.getElement((Document)doc, (String)itemname);
        if (elem == null) {
            return;
        }
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)type);
        if (ip == null) {
            return;
        }
        ITypeParser parser = ip.createInstance();
        parser.addToElement(elem, val);
    }

    private Hashtable parseDate(Document doc) {
        String val = FootprintPlugin.getString(doc, "Date", "date");
        if (val == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        try {
            Date d = df.parse(val);
            Calendar cd = Calendar.getInstance();
            cd.setTime(d);
            ht.put("year", new Integer(cd.get(1)));
            ht.put("month", new Integer(cd.get(2) + 1));
            ht.put("day", new Integer(cd.get(5)));
        }
        catch (Exception exception) {
            return null;
        }
        return ht;
    }

    private void getAllDocuments(Object obj, ArrayList list) {
        if (obj instanceof Hashtable) {
            Enumeration e = ((Hashtable)obj).elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                this.getAllDocuments(o, list);
            }
        } else if (obj instanceof ArrayList) {
            list.addAll((ArrayList)obj);
        }
    }

    public void setDocument(Document doc) {
        Hashtable ht = this.parseDate(doc);
        if (ht == null) {
            ArrayList al = (ArrayList)this.documents.get(UNKNOWNDATE);
            al.add(doc);
        } else {
            ArrayList<Document> days;
            Hashtable<String, ArrayList<Document>> mht;
            String year = ((Integer)ht.get("year")).toString();
            String month = ((Integer)ht.get("month")).toString();
            String day = ((Integer)ht.get("day")).toString();
            Hashtable yht = (Hashtable)this.documents.get(year);
            if (yht == null) {
                yht = new Hashtable();
                this.documents.put(year, yht);
            }
            if ((mht = (Hashtable<String, ArrayList<Document>>)yht.get(month)) == null) {
                mht = new Hashtable<String, ArrayList<Document>>();
                yht.put(month, mht);
            }
            if ((days = (ArrayList<Document>)mht.get(day)) == null) {
                days = new ArrayList<Document>();
                mht.put(day, days);
            }
            days.add(doc);
        }
    }

    public ArrayList getDocuments(int year, int month, int day) {
        String y = String.valueOf(year);
        String m = String.valueOf(month);
        String d = String.valueOf(day);
        Hashtable yht = (Hashtable)this.documents.get(y);
        if (yht == null) {
            return null;
        }
        Hashtable mht = (Hashtable)yht.get(m);
        if (mht == null) {
            return null;
        }
        ArrayList dl = (ArrayList)mht.get(d);
        if (dl == null) {
            return null;
        }
        return dl;
    }

    public static String getTitle(Document doc) {
        return FootprintPlugin.getString(doc, "Title", "text");
    }

    public static String getCategory(Document doc) {
        return FootprintPlugin.getString(doc, "Category", "text");
    }

    public static Document getComment(Document doc) {
        Element body;
        Document html = DomImpl.createDocument((String)"html", (boolean)true);
        html.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)"htmldocument");
        if (ip == null) {
            return null;
        }
        Element elem = DataDomImpl.getElement((Document)doc, (String)"Content");
        ITypeParser parser = ip.createInstance();
        Element head = ((HTMLDocumentParser)parser).getHTMLNode(elem, "head");
        if (head != null) {
            html.getDocumentElement().appendChild(html.importNode(head, true));
        }
        if ((body = ((HTMLDocumentParser)parser).getHTMLNode(elem, "body")) != null) {
            html.getDocumentElement().appendChild(html.importNode(body, true));
        }
        return html;
    }

    public static String getCommentAsString(Document doc) {
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)"htmldocument");
        if (ip == null) {
            return null;
        }
        ITypeParser parser = ip.createInstance();
        Element elem = DataDomImpl.getElement((Document)doc, (String)"Content");
        Element body = ((HTMLDocumentParser)parser).getHTMLNode(elem, "body");
        return DomImpl.getAllText((Element)body);
    }

    public static String getDate(Document doc) {
        return FootprintPlugin.getString(doc, "Date", "date");
    }

    public static ArrayList getDocumentsByTheSameLastMod(Document doc) {
        Request req = new Request(4, (Object)"/*", "data");
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        Calendar c = Calendar.getInstance();
        Hashtable ht = plugin.parseDate(doc);
        int year = (Integer)ht.get("year");
        int month = (Integer)ht.get("month");
        int day = (Integer)ht.get("day");
        c.set(year, month - 1, day, 0, 0, 0);
        long minval = c.getTimeInMillis();
        long maxval = minval + 86400000L - 1L;
        String doctype = DataDomImpl.getType((Document)doc);
        ArrayList<Document> rdocs = new ArrayList<Document>();
        int i = 0;
        while (i < docs.size()) {
            Document d = (Document)docs.get(i);
            long lastmod = DomImpl.getLastModifiedTime((Document)d);
            if (lastmod >= minval && maxval >= lastmod && !DataDomImpl.getType((Document)d).equals(doctype)) {
                rdocs.add(d);
            }
            ++i;
        }
        return rdocs;
    }

    public static void setTitle(Document doc, String val) {
        FootprintPlugin.setString(doc, "Title", "text", val);
    }

    public static void setCategory(Document doc, String val) {
        FootprintPlugin.setString(doc, "Category", "text", val);
    }

    public static void setComment(Document doc, Document html) {
        Element elem = DataDomImpl.getElement((Document)doc, (String)"Content");
        if (elem == null) {
            return;
        }
        NodeList head = html.getElementsByTagName("head");
        NodeList body = html.getElementsByTagName("body");
        IParserPlugin ip = FrameworkPlugin.getParserPlugin((String)"htmldocument");
        if (ip == null) {
            return;
        }
        ITypeParser parser = ip.createInstance();
        if (head.getLength() > 0) {
            ((HTMLDocumentParser)parser).setHTMLNode(elem, (Element)head.item(0));
        }
        if (body.getLength() > 0) {
            ((HTMLDocumentParser)parser).setHTMLNode(elem, (Element)body.item(0));
        }
    }

    public static void setDate(Document doc, String val) {
        FootprintPlugin.setString(doc, "Date", "date", val);
    }

    public FootprintPlugin() {
        plugin = this;
        this.documents.put(UNKNOWNDATE, new ArrayList());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        FrameworkPlugin plugin = FrameworkPlugin.getDefault();
        Request req = new Request();
        req.collection = "type";
        req.command = 4;
        req.options = 0;
        req.data = "/type[@pluginid='jp.sourceforge.concierge.plugin.footprint']";
        ArrayList docs = plugin.getDocumentsOfQuery(req);
        if (docs.size() == 0) {
            Document doc = TypeDomImpl.createDocument((String)"Note");
            TypeDomImpl.appendElement((Document)doc, (String)"Title", (String)"text", (boolean)true, (boolean)false, (boolean)true);
            TypeDomImpl.appendElement((Document)doc, (String)"Content", (String)"htmldocument", (boolean)true, (boolean)false, (boolean)false);
            TypeDomImpl.appendElement((Document)doc, (String)"Category", (String)"text", (boolean)true, (boolean)false, (boolean)true);
            TypeDomImpl.appendElement((Document)doc, (String)"Date", (String)"date", (boolean)true, (boolean)false, (boolean)false);
            TypeDomImpl.setPluginID((Document)doc, (String)this.getBundle().getSymbolicName());
            String path = this.getFilePath("icons/footprint.png");
            if (path != null) {
                TypeDomImpl.setImage((Document)doc, (String)path);
            }
            ArrayList<Request> reqs = new ArrayList<Request>();
            req = new Request();
            req.collection = "type";
            req.command = 1;
            req.data = doc;
            reqs.add(req);
            plugin.updateDocuments(reqs, (Object)this.getBundle().getSymbolicName());
            this.footprintdocuments = new ArrayList();
            this.footprintdocuments.add(doc);
        } else {
            this.footprintdocuments = docs;
        }
        req = new Request();
        req.collection = "data";
        req.command = 4;
        req.options = 0;
        String query = "/data[";
        int i = 0;
        while (i < this.footprintdocuments.size()) {
            Document fd = (Document)this.footprintdocuments.get(i);
            String t = TypeDomImpl.getTypeName((Document)fd);
            if (i > 0) {
                query = String.valueOf(query) + " or ";
            }
            query = String.valueOf(query) + "@name='" + t + "'";
            ++i;
        }
        req.data = String.valueOf(query) + "]";
        docs = plugin.getDocumentsOfQuery(req);
        i = 0;
        while (i < docs.size()) {
            Document ddoc = (Document)docs.get(i);
            this.setDocument(ddoc);
            ++i;
        }
        req.collection = "ccgconfig";
        req.command = 4;
        req.options = 0;
        req.data = "/ccgconfig[@name='Note']";
        docs = plugin.getDocumentsOfQuery(req);
        if (docs.size() == 0) {
            Document doc = DomImpl.createDocument((String)"ccgconfig", (boolean)true);
            Element docnode = DomImpl.getRootElement((Document)doc);
            DomImpl.setAttribute((Element)docnode, (String)"name", (String)"Note");
            Element celem = DomImpl.appendElement((Element)docnode, (String)"Category");
            Element unknown = DomImpl.appendElement((Element)celem, (String)CATEGORYTAG);
            DomImpl.setElementText((Element)unknown, (String)UNKNOWNCATEGORY);
            ArrayList<Request> reqs = new ArrayList<Request>();
            req = new Request();
            req.collection = "ccgconfig";
            req.command = 1;
            req.data = doc;
            reqs.add(req);
            plugin.updateDocuments(reqs, (Object)this.getBundle().getSymbolicName());
            this.configdocument = doc;
        } else {
            this.configdocument = (Document)docs.get(0);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static FootprintPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return FootprintPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Document createDocument() {
        Document doc = DataDomImpl.createDocument((Document)((Document)FootprintPlugin.plugin.footprintdocuments.get(0)));
        return doc;
    }

    public void updateDocumentsUpdatingCategory(String oldcat, String newcat) {
        ITypeParser parser = FrameworkPlugin.getParserPlugin((String)"text").createInstance();
        ArrayList list = new ArrayList();
        this.getAllDocuments(this.documents, list);
        int i = 0;
        while (i < list.size()) {
            Document doc = (Document)list.get(i);
            Element catelem = DataDomImpl.getElement((Document)doc, (String)"Category");
            String cat = parser.getViewForm(catelem);
            if (cat.compareTo(oldcat) == 0) {
                parser.addToElement(catelem, newcat);
                this.updateDocument(doc, null);
            }
            ++i;
        }
    }

    public void updateDocumentsDeletingCategory(String category) {
        this.updateDocumentsUpdatingCategory(category, UNKNOWNCATEGORY);
    }

    public void updateCategories(ArrayList newcats) {
        ArrayList celems = DomImpl.getElements((Element)DomImpl.getRootElement((Document)this.configdocument), (String)"Category");
        Element celem = (Element)celems.get(0);
        DomImpl.removeChildElements((Element)celem);
        int i = 0;
        while (i < newcats.size()) {
            Category c = (Category)newcats.get(i);
            Element newelem = DomImpl.appendElement((Element)celem, (String)CATEGORYTAG);
            DomImpl.setElementText((Element)newelem, (String)c.name);
            DomImpl.setAttribute((Element)newelem, (String)CATCOLORID, (String)String.valueOf(c.colorid));
            ++i;
        }
        this.sendDocumentRequest(this.configdocument, "ccgconfig", 3, null);
    }

    public ArrayList getCategories() {
        ArrayList<Category> l = new ArrayList<Category>();
        ArrayList celems = DomImpl.getElements((Element)DomImpl.getRootElement((Document)this.configdocument), (String)"Category");
        Element celem = (Element)celems.get(0);
        ArrayList cel = DomImpl.getElements((Element)celem, (String)CATEGORYTAG);
        int i = 0;
        while (i < cel.size()) {
            Element e = (Element)cel.get(i);
            String name = DomImpl.getElementText((Element)e);
            String idstr = DomImpl.getAttribute((Element)e, (String)CATCOLORID);
            if (name.compareTo(UNKNOWNCATEGORY) != 0) {
                int cid = idstr.length() > 0 ? Integer.parseInt(DomImpl.getAttribute((Element)e, (String)CATCOLORID)) : -1;
                l.add(new Category(name, cid));
            }
            ++i;
        }
        return l;
    }

    private void sendDocumentRequest(Document doc, String col, int type, Object sender) {
        FrameworkPlugin p = FrameworkPlugin.getDefault();
        ArrayList<Request> reqs = new ArrayList<Request>();
        Request req = new Request();
        req.collection = col;
        req.command = type;
        req.data = doc;
        reqs.add(req);
        if (sender == null) {
            sender = this.getBundle().getSymbolicName();
        }
        p.updateDocuments(reqs, sender);
    }

    public void addDocument(Document doc, boolean dbupdate, Object sender) {
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        this.setDocument(doc);
        if (dbupdate) {
            this.sendDocumentRequest(doc, "data", 1, sender);
        }
    }

    public void updateDocument(Document doc, Object sender) {
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        this.sendDocumentRequest(doc, "data", 3, sender);
    }

    public void deleteDocument(Document doc, boolean dbupdate, Object sender) {
        Hashtable ht;
        if (sender == null) {
            sender = plugin.getBundle().getSymbolicName();
        }
        if ((ht = this.parseDate(doc)) == null) {
            ArrayList l = (ArrayList)this.documents.get(UNKNOWNDATE);
            l.remove(doc);
        } else {
            int y = (Integer)ht.get("year");
            int m = (Integer)ht.get("month");
            int d = (Integer)ht.get("day");
            ArrayList l = this.getDocuments(y, m, d);
            l.remove(doc);
        }
        if (dbupdate) {
            this.sendDocumentRequest(doc, "data", 2, sender);
        }
    }

    public static void setLocalConfiguration(String key, String val) {
        plugin.getPreferenceStore().setValue(key, val);
    }

    public static String getLocalConfiguration(String key) {
        return plugin.getPreferenceStore().getString(key);
    }

    public static void showMessage(Shell parent, String message) {
        MessageDialog.openInformation((Shell)parent, (String)"Footprint", (String)message);
    }

    public static boolean showConfirm(Shell parent, String message) {
        return MessageDialog.openConfirm((Shell)parent, (String)"Footprint", (String)message);
    }

    public ConciergeDialog getDialog(Shell shell, int style) {
        if (this.dialog == null) {
            this.dialog = new FootprintDialog(shell, style);
        }
        return this.dialog;
    }

    public static Document createMiscFileDocument(String filename) {
        Document tdoc = FootprintPlugin.getMiscFileTypeDocument();
        ITypeParser parser = FrameworkPlugin.getParserPlugin((String)"text").createInstance();
        Document mdoc = DataDomImpl.createDocument((Document)tdoc);
        Element titleelem = DataDomImpl.getElement((Document)mdoc, (String)"Title");
        parser.addToElement(titleelem, FilenameUtils.getName((String)filename));
        DataDomImpl.setFilePath((Document)mdoc, (String)filename);
        return mdoc;
    }

    public static Document getMiscDocument(String filename) {
        long id = Long.parseLong(FilenameUtils.getBaseName((String)filename));
        return FrameworkPlugin.getDefault().getDocumentByID("data", id);
    }

    public static Document getMiscFileTypeDocument() {
        if (FootprintPlugin.plugin.miscfiledocument == null) {
            String xpath = "/type[@name='Misc']";
            Request rq = new Request(4, (Object)xpath, "type");
            ArrayList types = FrameworkPlugin.getDefault().getDocumentsOfQuery(rq);
            if (types.size() == 0) {
                return null;
            }
            FootprintPlugin.plugin.miscfiledocument = (Document)types.get(0);
        }
        return FootprintPlugin.plugin.miscfiledocument;
    }
}

