/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.FootprintPlugin;
import jp.sourceforge.concierge.plugin.footprint.Category;
import jp.sourceforge.concierge.plugin.footprint.CategoryViewer;
import jp.sourceforge.concierge.plugin.footprint.FootprintDialog;
import jp.sourceforge.concierge.plugin.footprint.FootprintDialogListener;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolTip;
import org.w3c.dom.Document;

public class CalItem {
    private Composite droot;
    private Label label;
    private Font labelfont;
    private FootprintDialog dialog;
    private CategoryViewer catviewer;
    private ToolTip tooltip;
    private int year;
    private int month;
    private int day;
    private boolean holiday = false;
    private ArrayList listeners = new ArrayList();
    private ArrayList items = new ArrayList();
    private Color SELECTCOLOR = new Color(null, 236, 243, 250);

    private void rearrange() {
        ArrayList<Composite> ctrls = new ArrayList<Composite>();
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            if (it.root.getVisible()) {
                ctrls.add(it.root);
            }
            ++i;
        }
        Control pc = null;
        int i2 = 0;
        while (i2 < ctrls.size()) {
            Control c = (Control)ctrls.get(i2);
            if (pc == null) {
                c.moveAbove(null);
            } else {
                c.moveBelow(pc);
            }
            pc = c;
            ++i2;
        }
        this.droot.layout();
    }

    public CalItem(Composite parent, int year, int month, int day, CategoryViewer cv, FootprintDialog dlg) {
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 1;
        gl.marginWidth = 1;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        parent.setLayout((Layout)gl);
        this.label = new Label(parent, 131072);
        this.label.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)this.label, (int)1);
        int sz = SystemUtil.GetOSType() == 1 ? 11 : 9;
        this.labelfont = new Font(null, "Arial", sz, 0);
        this.label.setFont(this.labelfont);
        this.label.setText(String.valueOf(day));
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CalItem.this.labelfont.dispose();
            }
        });
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.droot = new Composite(parent, 0);
        RowLayout rl = new RowLayout();
        this.droot.setLayout((Layout)rl);
        this.droot.setLayoutData((Object)new GridData(1808));
        this.droot.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDoubleClick(e);
                    ++i;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                int i = 0;
                while (i < CalItem.this.listeners.size()) {
                    MouseListener ml = (MouseListener)CalItem.this.listeners.get(i);
                    e.data = CalItem.this;
                    ml.mouseDown(e);
                    ++i;
                }
            }
        });
        this.dialog = dlg;
        this.catviewer = cv;
        this.year = year;
        this.month = month;
        this.day = day;
        this.tooltip = new ToolTip(this.droot.getShell(), 4096);
    }

    protected void finalize() throws Throwable {
        this.SELECTCOLOR.dispose();
        super.finalize();
    }

    public void setEnabled(boolean en) {
        this.droot.setEnabled(en);
        int i = 0;
        while (i < this.items.size()) {
            ((Item)this.items.get(i)).setEnabled(en);
            ++i;
        }
        GraphicUtil.setForeground((Control)this.label, (int)(en ? (this.holiday ? 3 : 2) : 15));
    }

    public void setDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.label.setText(String.valueOf(day));
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public void setBackground(Color color) {
        this.label.setBackground(color);
        this.droot.setBackground(color);
        int i = 0;
        while (i < this.items.size()) {
            ((Item)this.items.get(i)).setBackground(color);
            ++i;
        }
    }

    public void select() {
        this.setBackground(this.SELECTCOLOR);
    }

    public void deselect() {
        this.setBackground(this.droot.getDisplay().getSystemColor(1));
    }

    public void createItem(Category curcat) {
        Item it = new Item(this.droot, null, curcat, true);
        this.droot.layout();
        this.items.add(it);
    }

    public void setDocuments(ArrayList docs) {
        this.clearAll();
        if (docs == null) {
            return;
        }
        int i = 0;
        while (i < docs.size()) {
            Item it = new Item(this.droot, (Document)docs.get(i), null, false);
            this.items.add(it);
            ++i;
        }
        this.droot.layout();
    }

    public void addDocument(Document doc) {
        int i = 0;
        while (i < this.items.size()) {
            Item tt = (Item)this.items.get(i);
            if (tt.document == doc) {
                return;
            }
            ++i;
        }
        Item it = new Item(this.droot, doc, null, false);
        this.droot.layout();
        this.items.add(it);
    }

    public void clearAll() {
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            it.dispose();
            ++i;
        }
        this.items.clear();
    }

    public void update() {
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            it.update();
            ++i;
        }
    }

    public void addMouseListener(MouseListener listener) {
        this.listeners.add(listener);
    }

    public void categoryVisible(String category, boolean visible) {
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            String cat = FootprintPlugin.getCategory(it.document);
            if (cat.compareTo(category) == 0) {
                it.root.setVisible(visible);
            }
            ++i;
        }
        this.rearrange();
    }

    public void deleteItem(Document doc) {
        int i = 0;
        while (i < this.items.size()) {
            Item it = (Item)this.items.get(i);
            if (it.document.equals(doc)) {
                this.items.remove(it);
                it.dispose();
            }
            ++i;
        }
        this.droot.layout();
    }

    public void setHoliday(boolean hol) {
        this.holiday = hol;
        GraphicUtil.setForeground((Control)this.label, (int)(hol ? 3 : 2));
    }

    static /* synthetic */ ToolTip access$6(CalItem calItem) {
        return calItem.tooltip;
    }

    public class Item {
        private Composite root;
        private CLabel titlectrl;
        private Document document;
        private FootprintDialogListener listener;

        public Item(Composite parent, Document doc, Category curcat, boolean open) {
            this.root = new Composite(parent, 4);
            this.root.setLayoutData((Object)new RowData(-1, -1));
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            this.root.setLayout((Layout)gl);
            this.root.setBackground(parent.getBackground());
            String text = "";
            if (doc != null) {
                this.document = doc;
                text = FootprintPlugin.getTitle(doc);
            } else {
                this.document = FootprintPlugin.createDocument();
                text = "New item";
                FootprintPlugin.setTitle(this.document, text);
                if (curcat != null) {
                    FootprintPlugin.setCategory(this.document, curcat.name);
                }
                FootprintPlugin.setDate(this.document, String.valueOf(String.valueOf(CalItem.this.year)) + "-" + String.valueOf(CalItem.this.month) + "-" + String.valueOf(CalItem.this.day));
                FootprintPlugin plugin = FootprintPlugin.getDefault();
                plugin.addDocument(this.document, true, null);
            }
            this.titlectrl = new CLabel(this.root, 0);
            this.titlectrl.setLayoutData((Object)new GridData(768));
            this.titlectrl.setFont(CalItem.this.labelfont);
            this.titlectrl.setBackground(this.root.getBackground());
            this.titlectrl.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ Item this$1;
                {
                    this.this$1 = item;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    if (e.button != 1) {
                        return;
                    }
                    Item.access$0(this.this$1).layout();
                    CalItem.access$4(Item.access$4(this.this$1)).setDocument(Item.access$1(this.this$1));
                    CalItem.access$4(Item.access$4(this.this$1)).setListener(Item.access$2(this.this$1));
                    CalItem.access$4(Item.access$4(this.this$1)).open();
                }

                public void mouseDown(MouseEvent e) {
                    if (e.button != 1) {
                        return;
                    }
                    int i = 0;
                    while (i < CalItem.access$5(Item.access$4(this.this$1)).size()) {
                        MouseListener ml = (MouseListener)CalItem.access$5(Item.access$4(this.this$1)).get(i);
                        e.data = Item.access$4(this.this$1);
                        ml.mouseDown(e);
                        ++i;
                    }
                }
            });
            this.titlectrl.addMouseTrackListener(new MouseTrackListener(this){
                final /* synthetic */ Item this$1;
                {
                    this.this$1 = item;
                }

                public void mouseHover(MouseEvent e) {
                    Point p = Item.access$0(this.this$1).getSize();
                    CalItem.access$6(Item.access$4(this.this$1)).setLocation(Item.access$0(this.this$1).toDisplay(p.x / 2, p.y / 2));
                }

                public void mouseEnter(MouseEvent e) {
                    Document doc = Item.access$1(this.this$1);
                    if (doc == null) {
                        CalItem.access$6(Item.access$4(this.this$1)).setVisible(false);
                        return;
                    }
                    String str = "";
                    String txt = FootprintPlugin.getTitle(doc);
                    String val = FootprintPlugin.getCommentAsString(doc);
                    if (val != null && val.length() != 0) {
                        int len = val.length() > 40 ? 40 : val.length();
                        String ppp = len < 40 ? "" : "...";
                        str = String.valueOf(val.substring(0, len)) + ppp;
                    }
                    if (txt.length() > 0) {
                        CalItem.access$6(Item.access$4(this.this$1)).setText(txt);
                    }
                    CalItem.access$6(Item.access$4(this.this$1)).setMessage(str);
                    Point p = Item.access$0(this.this$1).getSize();
                    CalItem.access$6(Item.access$4(this.this$1)).setLocation(Item.access$0(this.this$1).toDisplay(p.x / 2, p.y / 2));
                    CalItem.access$6(Item.access$4(this.this$1)).setVisible(true);
                }

                public void mouseExit(MouseEvent e) {
                    CalItem.access$6(Item.access$4(this.this$1)).setVisible(false);
                }
            });
            this.listener = new FootprintDialogListener(this){
                final /* synthetic */ Item this$1;
                {
                    this.this$1 = item;
                }

                public void saveClicked(Document doc) {
                    if (doc != Item.access$1(this.this$1)) {
                        return;
                    }
                    Item.access$3(this.this$1);
                }

                public void closeClicked(Document doc) {
                    if (doc != Item.access$1(this.this$1)) {
                        return;
                    }
                    Item.access$3(this.this$1);
                }
            };
            CalItem.this.dialog.setTitle(text);
            if (open) {
                CalItem.this.dialog.setDocument(this.document);
                CalItem.this.dialog.setListener(this.listener);
                CalItem.this.dialog.open();
            }
            this.update();
        }

        public void setEnabled(boolean en) {
            this.titlectrl.setEnabled(en);
            if (this.document != null && en) {
                this.update();
            } else {
                GraphicUtil.setForeground((Control)this.titlectrl, (int)15);
            }
        }

        public void setBackground(Color color) {
            this.root.setBackground(color);
            this.titlectrl.setBackground(color);
        }

        public void setTitle(String title) {
            FootprintPlugin.setTitle(this.document, title);
        }

        public String getTitle() {
            return FootprintPlugin.getTitle(this.document);
        }

        public void update() {
            String cs = FootprintPlugin.getCategory(this.document);
            Category cat = CalItem.this.catviewer.getCategory(cs);
            this.titlectrl.setForeground(CategoryViewer.getColor(cat.colorid));
            this.titlectrl.setImage(CategoryViewer.getImage(cat.colorid));
        }

        public void dispose() {
            if (this.root != null) {
                this.root.dispose();
            }
        }

        private void save() {
            this.root.layout();
            this.update();
        }

        static /* synthetic */ FootprintDialogListener access$2(Item item) {
            return item.listener;
        }

        static /* synthetic */ void access$3(Item item) {
            item.save();
        }

        static /* synthetic */ CalItem access$4(Item item) {
            return item.CalItem.this;
        }
    }
}

