/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint.text;

import java.io.File;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedObject;
import jp.sourceforge.concierge.plugin.footprint.text.FileTypeUtils;
import jp.sourceforge.concierge.util.DomImpl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmbeddedFile
extends EmbeddedObject {
    private Image objimage = null;
    private String filename = null;
    private String orgname = null;
    private long lastmodified = 0L;

    public Image getObjectImage() {
        return this.objimage;
    }

    public void setFileName(String fname) {
        if (this.objimage != null && !this.objimage.isDisposed() && this.filename != null && FileTypeUtils.isImage(this.filename)) {
            this.objimage.dispose();
        }
        this.orgname = this.filename = fname;
        this.lastmodified = this.filename != null ? new File(this.filename).lastModified() : 0L;
        this.size = null;
        this.objimage = this.filename != null && FileTypeUtils.isImage(this.filename) ? new Image((Device)PlatformUI.getWorkbench().getDisplay(), this.filename) : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    public String getFileName() {
        return this.filename;
    }

    public void setOrgName(String name) {
        this.orgname = name;
    }

    public String getOrgName() {
        return this.orgname;
    }

    public void setSize(Point sz) {
        if (this.filename != null && FileTypeUtils.isImage(this.filename)) {
            this.size = sz;
        }
    }

    public Point getSize() {
        if (this.filename != null && FileTypeUtils.isImage(this.filename) && this.size != null) {
            return this.size;
        }
        Rectangle r = this.objimage.getBounds();
        return new Point(r.width, r.height);
    }

    public Element createElement(Document doc) {
        Element e;
        String newname = this.importFileName();
        if (this.filename != null && FileTypeUtils.isImage(this.filename)) {
            e = doc.createElement("img");
            e.setAttribute("src", newname);
            e.setAttribute("alt", this.orgname);
            if (this.size != null) {
                e.setAttribute("width", String.valueOf(this.size.x));
                e.setAttribute("height", String.valueOf(this.size.y));
            }
        } else {
            e = doc.createElement("a");
            e.setAttribute("href", newname);
            e.setAttribute("alt", this.orgname);
            Element ie = doc.createElement("img");
            ie.setAttribute("src", "__object.gif");
            ie.setAttribute("alt", "__object.gif");
            e.appendChild(ie);
        }
        return e;
    }

    public String importFileName() {
        String ext = this.filename != null ? "." + FilenameUtils.getExtension((String)this.filename) : "";
        return String.valueOf(String.valueOf(DomImpl.getID((Document)this.document))) + ext;
    }

    public void refresh() {
        String path = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)this.document));
        if (path == null) {
            this.setFileName(path);
            return;
        }
        try {
            File f2;
            File f1;
            File f;
            if (this.filename != null && (this.filename.equals(path) ? (f = new File(path)).lastModified() == this.lastmodified : FileUtils.contentEquals((File)(f1 = new File(this.filename)), (File)(f2 = new File(path))))) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        this.setFileName(path);
    }

    public boolean resizable() {
        return this.filename != null && FileTypeUtils.isImage(this.filename);
    }

    public boolean editable() {
        return true;
    }

    protected void finalize() throws Throwable {
        if (this.objimage != null && !this.objimage.isDisposed() && FileTypeUtils.isImage(this.filename)) {
            this.objimage.dispose();
        }
        super.finalize();
    }
}

