/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint.text;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Stack;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.FootprintPlugin;
import jp.sourceforge.concierge.plugin.footprint.text.ConciergeEditorPreference;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedDocument;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedFile;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedObject;
import jp.sourceforge.concierge.plugin.footprint.text.LineUtils;
import jp.sourceforge.concierge.util.DomImpl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class HTMLConverter {
    StyledText textview;

    public HTMLConverter(StyledText textview) {
        this.textview = textview;
    }

    private String[] getKeyValue(String item) {
        String[] param = item.split(":");
        if (param.length < 2) {
            return null;
        }
        int i = 0;
        while (i < 2) {
            param[i] = param[i].trim();
            ++i;
        }
        return param;
    }

    private Color getColor(String cstr) {
        if (!cstr.startsWith("rgb(")) {
            return null;
        }
        cstr = cstr.replaceFirst("rgb(", "");
        String[] rgb = (cstr = cstr.replaceFirst(")", "")).split(",");
        if (rgb.length < 3) {
            return null;
        }
        return new Color((Device)this.textview.getDisplay(), Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
    }

    private int getFontStyle(String cstr) {
        String[] st = cstr.split(" ");
        int stval = 0;
        int i = 0;
        while (i < st.length) {
            if (st[i].compareTo("bold") == 0) {
                stval |= 1;
            } else if (st[i].compareTo("italic") == 0) {
                stval |= 2;
            }
            ++i;
        }
        return stval;
    }

    private int getFontSize(String cstr) {
        cstr = cstr.replaceFirst("pt", "");
        return Integer.parseInt(cstr);
    }

    private boolean includeVal(String cstr, String val) {
        String[] st = cstr.split(" ");
        int i = 0;
        while (i < st.length) {
            if (st[i].compareTo(val) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isBold(String cstr) {
        return this.includeVal(cstr, "bold");
    }

    private boolean isUnderline(String cstr) {
        return this.includeVal(cstr, "underline");
    }

    private boolean isStrikeout(String cstr) {
        return this.includeVal(cstr, "line-through");
    }

    private StyleRange getStyleRange(String style) {
        if (style.length() == 0) {
            return null;
        }
        StyleRange sr = new StyleRange();
        String[] item = style.split(";");
        String tfont = null;
        int tstyle = 0;
        int tsize = 10;
        boolean isbold = false;
        int i = 0;
        while (i < item.length) {
            String[] keyval = this.getKeyValue(item[i]);
            if (keyval != null) {
                String key = keyval[0];
                String val = keyval[1];
                if (key.compareTo("color") == 0) {
                    sr.foreground = this.getColor(val);
                } else if (key.compareTo("background") == 0) {
                    sr.background = this.getColor(val);
                } else if (key.compareTo("font-style") == 0) {
                    tstyle = this.getFontStyle(val);
                } else if (key.compareTo("font-weight") == 0) {
                    isbold = this.isBold(val);
                } else if (key.compareTo("font-size") == 0) {
                    tsize = this.getFontSize(val);
                } else if (key.compareTo("font-family") == 0) {
                    tfont = val;
                    if (tfont.length() > 0 && tfont.startsWith("'")) {
                        tfont = tfont.substring(1);
                    }
                    if (tfont.length() > 1 && tfont.endsWith("'")) {
                        tfont = tfont.substring(0, tfont.length() - 1);
                    }
                } else if (key.compareTo("text-decoration") == 0) {
                    sr.underline = this.isUnderline(val);
                    sr.strikeout = this.isStrikeout(val);
                }
            }
            ++i;
        }
        if (isbold) {
            tstyle |= 1;
        }
        if (tfont != null) {
            sr.font = new Font((Device)this.textview.getDisplay(), tfont, tsize, tstyle);
        } else {
            sr.font = null;
            sr.fontStyle = tstyle;
        }
        return sr;
    }

    private String createStyleString(StyleRange sr) {
        Color c;
        FontData fd;
        String attrval = "";
        String stval = "";
        int style = 0;
        if (sr.font != null) {
            fd = sr.font.getFontData()[0];
            style = fd.getStyle();
        } else {
            fd = null;
            style = sr.fontStyle;
        }
        stval = (style & 2) != 0 ? "font-style: italic;" : "font-style: normal;";
        if ((style & 1) != 0) {
            stval = String.valueOf(stval) + "font-weight: bold;";
        }
        String szval = fd != null ? "font-size: " + String.valueOf(fd.getHeight()) + "pt;" : "";
        String ffval = fd != null ? "font-family: '" + fd.getName() + "';" : "";
        String colval = "";
        if (sr.foreground != null) {
            c = sr.foreground;
            colval = "color: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");";
        }
        if (sr.background != null) {
            c = sr.background;
            colval = String.valueOf(colval) + "background: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");";
        }
        String txtval = "text-decoration:";
        if (sr.underline) {
            txtval = String.valueOf(txtval) + " underline";
        }
        if (sr.strikeout) {
            txtval = String.valueOf(txtval) + " line-through";
        }
        txtval = sr.underline || sr.strikeout ? String.valueOf(txtval) + ";" : String.valueOf(txtval) + " none;";
        attrval = String.valueOf(stval) + szval + ffval + colval + txtval;
        return attrval;
    }

    private Element createStyleTag(Document doc, StyleRange sr, String text) {
        Element e = doc.createElement("span");
        e.setAttribute("style", this.createStyleString(sr));
        DomImpl.setElementText((Element)e, (String)text);
        return e;
    }

    private Element createImageTag(Document doc, StyleRange sr) {
        ArrayList images = (ArrayList)this.textview.getData();
        int i = 0;
        while (i < images.size()) {
            EmbeddedObject ei = (EmbeddedObject)images.get(i);
            if (ei.getOffset() == sr.start) {
                Document mdoc = ei.getDocument();
                long mid = DomImpl.getID((Document)mdoc);
                Element e = ei.createElement(doc);
                String newfile = ei.importFileName();
                String path = FrameworkPlugin.getPathFromID((long)mid);
                if (newfile != null) {
                    String fname = ei.getFileName();
                    if (path == null && fname != null) {
                        FrameworkPlugin.importRelatedFile((String)fname, (String)newfile);
                    }
                } else {
                    newfile = String.valueOf(DomImpl.getID((Document)mdoc)) + ".gif";
                    if (path == null) {
                        FrameworkPlugin.importRelatedFile((String)FootprintPlugin.getDefault().getFilePath("icons/__object.gif"), (String)newfile);
                    }
                }
                return e;
            }
            ++i;
        }
        return null;
    }

    private Element createULTag(Document doc) {
        return doc.createElement("ul");
    }

    private Element createLITag(Document doc) {
        return doc.createElement("li");
    }

    private Element createBRTag(Document doc) {
        return doc.createElement("br");
    }

    private ArrayList createStyleList() {
        String text = this.textview.getText();
        StyleRange[] srs = this.textview.getStyleRanges(true);
        int start = 0;
        ArrayList<Object> styles = new ArrayList<Object>();
        int i = 0;
        while (i < srs.length) {
            if (srs[i].start == start) {
                styles.add(srs[i].clone());
                start = srs[i].start + srs[i].length;
            } else {
                StyleRange sr = new StyleRange();
                sr.start = start;
                sr.length = srs[i].start - start;
                sr.fontStyle = 0;
                styles.add(sr);
                start = srs[i].start;
                --i;
            }
            ++i;
        }
        if (start < text.length()) {
            StyleRange sr = new StyleRange();
            sr.start = start;
            sr.length = text.length() - start;
            sr.fontStyle = 0;
            styles.add(sr);
        }
        return styles;
    }

    private void exportToFile(Document html, String filename) {
        String newf;
        String orgf;
        String alt;
        String src;
        Element el;
        String dir = FilenameUtils.getFullPath((String)filename);
        NodeList nl = html.getElementsByTagName("img");
        int i = 0;
        while (i < nl.getLength()) {
            el = (Element)nl.item(i);
            src = el.getAttribute("src");
            alt = el.getAttribute("alt");
            orgf = null;
            newf = null;
            if (src.equals("__document.gif")) {
                el.setAttribute("src", String.valueOf(alt) + ".gif");
                orgf = FootprintPlugin.getDefault().getFilePath("icons/__document.gif");
                newf = String.valueOf(dir) + File.separator + alt + ".gif";
            } else if (src.equals("__object.gif")) {
                el.setAttribute("src", alt);
                orgf = FootprintPlugin.getDefault().getFilePath("icons/__object.gif");
                newf = String.valueOf(dir) + File.separator + alt;
            } else {
                alt = FilenameUtils.getName((String)alt);
                el.setAttribute("src", alt);
                orgf = FrameworkPlugin.findRelatedFile((String)src);
                newf = String.valueOf(dir) + File.separator + alt;
            }
            if (!orgf.equals(newf)) {
                try {
                    FileUtils.copyFile((File)new File(orgf), (File)new File(newf));
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        nl = html.getElementsByTagName("a");
        i = 0;
        while (i < nl.getLength()) {
            el = (Element)nl.item(i);
            src = el.getAttribute("href");
            alt = el.getAttribute("alt");
            orgf = FrameworkPlugin.findRelatedFile((String)src);
            newf = String.valueOf(dir) + File.separator + alt;
            el.setAttribute("href", alt);
            try {
                FileUtils.copyFile((File)new File(orgf), (File)new File(newf));
            }
            catch (Exception exception) {}
            ++i;
        }
        DOMImplementationImpl dimpl = new DOMImplementationImpl();
        LSOutput lsout = dimpl.createLSOutput();
        LSSerializer lsser = dimpl.createLSSerializer();
        try {
            FileOutputStream out = new FileOutputStream(filename);
            lsout.setEncoding("UTF-8");
            lsout.setByteStream(out);
            lsser.write(html, lsout);
            out.flush();
            out.close();
        }
        catch (Exception exception) {}
    }

    public void exportToFile(String filename) {
        Document html = this.exportToDocument();
        this.exportToFile(html, filename);
    }

    private ArrayList getStyleRanges(ArrayList styles, int start, int end) {
        int sidx = -1;
        int eidx = -1;
        int i = 0;
        while (i < styles.size()) {
            StyleRange sr = (StyleRange)styles.get(i);
            if (sr.start <= start && start < sr.start + sr.length) {
                sidx = i;
            }
            if (sr.start <= end && end < sr.start + sr.length) {
                eidx = i;
            }
            if (eidx >= 0) break;
            ++i;
        }
        ArrayList<StyleRange> al = new ArrayList<StyleRange>();
        if (sidx == -1 || eidx == -1) {
            return al;
        }
        int i2 = sidx;
        while (i2 <= eidx) {
            StyleRange sr = (StyleRange)((StyleRange)styles.get(i2)).clone();
            if (i2 == sidx) {
                sr.length = sr.start + sr.length - start;
                sr.start = start;
            }
            if (i2 == eidx) {
                sr.length = end - sr.start + 1;
            }
            al.add(sr);
            ++i2;
        }
        return al;
    }

    private void setTag(Document html, Element parent, ArrayList styles, boolean rmhyphn) {
        int i = 0;
        while (i < styles.size()) {
            StyleRange sr = (StyleRange)styles.get(i);
            String txt = this.textview.getTextRange(sr.start, sr.length);
            if (rmhyphn && txt.startsWith("\u30fb ")) {
                txt = txt.substring("\u30fb ".length());
            }
            if (txt.length() > 1 && (txt.endsWith("\r") || txt.endsWith("\n"))) {
                txt = txt.substring(0, txt.length() - 1);
            }
            Element e = null;
            if (txt.equals("\ufffc")) {
                e = this.createImageTag(html, sr);
            } else if (!txt.equals("\n") && !txt.equals("\r")) {
                e = this.createStyleTag(html, sr, txt);
            }
            if (e != null) {
                parent.appendChild(e);
            }
            ++i;
        }
    }

    public Document exportToDocument() {
        ArrayList styles = this.createStyleList();
        Document html = DomImpl.createDocument((String)"html", (boolean)true);
        html.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        Element head = DomImpl.appendElement((Element)html.getDocumentElement(), (String)"head");
        Element meta = DomImpl.appendElement((Element)head, (String)"meta");
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", "text/html;charset=utf-8");
        Element body = DomImpl.appendElement((Element)html.getDocumentElement(), (String)"body");
        body.setAttribute("style", this.createStyleString(new StyleRange()));
        boolean indent = false;
        Element parent = body;
        int lc = this.textview.getLineCount();
        int i = 0;
        while (i < lc) {
            int ls = this.textview.getOffsetAtLine(i);
            int le = LineUtils.getLastOffsetAtLine(this.textview, i);
            if (!indent && this.textview.getLineIndent(i) > 0) {
                Element ule = this.createULTag(html);
                parent.appendChild(ule);
                parent = ule;
                indent = true;
            } else if (indent && this.textview.getLineIndent(i) == 0) {
                parent = body;
                indent = false;
            }
            ArrayList sts = this.getStyleRanges(styles, ls, le);
            if (indent) {
                Element p = this.createLITag(html);
                parent.appendChild(p);
                this.setTag(html, p, sts, true);
            } else {
                this.setTag(html, body, sts, false);
                if (i != lc - 1) {
                    body.appendChild(this.createBRTag(html));
                }
            }
            ++i;
        }
        return html;
    }

    private void parseUL(Element elemul, LineInformation li) {
        ConciergeEditorPreference preference = new ConciergeEditorPreference();
        String val = preference.getValue("indent");
        int indent = val == null || val.length() == 0 ? 4 : Integer.parseInt(val);
        li.indent += indent;
        this.parseElements(elemul.getChildNodes(), li);
        li.indent -= indent;
    }

    private void parseLI(Element elemli, LineInformation li) {
        int curline = this.textview.getLineCount() - 1;
        StyleRange sr = this.getStyleRange(elemli.getAttribute("style"));
        if (sr != null) {
            li.styles.add(sr);
        }
        this.textview.append("\u30fb ");
        this.parseElements(elemli.getChildNodes(), li);
        this.textview.append(this.textview.getLineDelimiter());
        this.textview.setLineIndent(curline, 1, li.indent);
        if (sr != null) {
            li.styles.remove(sr);
        }
    }

    private void parseBR(Element elembr, LineInformation li) {
        this.textview.append(this.textview.getLineDelimiter());
    }

    private void parseText(Text elemtxt, LineInformation li) {
        String text = elemtxt.getNodeValue();
        if (text.equals("\n") || text.equals("\r")) {
            return;
        }
        if (li.styles.size() > 0) {
            StyleRange sr = (StyleRange)li.styles.peek();
            sr.start = this.textview.getCharCount();
            sr.length = text.length();
            this.textview.replaceTextRange(sr.start, 0, text);
            this.textview.setStyleRange(sr);
        } else {
            this.textview.append(text);
        }
    }

    private void setStyleRange(EmbeddedObject e, Point sz) {
        this.textview.replaceTextRange(e.getOffset(), 0, "\ufffc");
        StyleRange style = new StyleRange();
        style.start = e.getOffset();
        style.length = 1;
        if (sz != null) {
            style.metrics = new GlyphMetrics(sz.y, 0, sz.x);
        } else {
            Rectangle rect = e.getObjectImage().getBounds();
            style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        }
        this.textview.setStyleRange(style);
    }

    private void createImage(long docid) {
        int curoffset = this.textview.getCharCount();
        EmbeddedDocument e = new EmbeddedDocument();
        e.setOffset(curoffset);
        Document doc = FrameworkPlugin.getDefault().getDocumentByID("data", docid);
        if (doc == null) {
            return;
        }
        e.setDocument(doc);
        e.setUpdate(false);
        this.setStyleRange(e, null);
        ArrayList emimages = (ArrayList)this.textview.getData();
        emimages.add(e);
    }

    private void createImage(String imgfile, String orgname, Point sz) {
        Document mdoc;
        String newimgf = null;
        if (FilenameUtils.getPath((String)imgfile).length() == 0) {
            newimgf = FrameworkPlugin.findRelatedFile((String)imgfile);
        }
        int curoffset = this.textview.getCharCount();
        EmbeddedFile e = new EmbeddedFile();
        ((EmbeddedObject)e).setFileName(newimgf);
        ((EmbeddedObject)e).setOrgName(orgname);
        e.setOffset(curoffset);
        if (sz != null) {
            ((EmbeddedObject)e).setSize(sz);
        }
        if ((mdoc = FootprintPlugin.getMiscDocument(imgfile)) != null) {
            e.setDocument(mdoc);
            e.setUpdate(false);
        }
        this.setStyleRange(e, sz);
        ArrayList emimages = (ArrayList)this.textview.getData();
        emimages.add(e);
    }

    private void parseImage(Element elemimg, LineInformation li) {
        String imgfile = elemimg.getAttribute("src");
        String orgname = elemimg.getAttribute("alt");
        String width = elemimg.getAttribute("width");
        String height = elemimg.getAttribute("height");
        if (imgfile.equals("__object.gif")) {
            return;
        }
        if (imgfile.equals("__document.gif")) {
            this.createImage(Long.parseLong(orgname));
        } else {
            Point sz = width.length() == 0 || height.length() == 0 ? null : new Point(Integer.parseInt(width), Integer.parseInt(height));
            this.createImage(imgfile, orgname, sz);
        }
    }

    private void parseA(Element elema, LineInformation li) {
        String imgfile = elema.getAttribute("href");
        String orgname = elema.getAttribute("alt");
        this.createImage(imgfile, orgname, null);
    }

    private void parseSpan(Element elemspan, LineInformation li) {
        StyleRange sr = this.getStyleRange(elemspan.getAttribute("style"));
        if (sr != null) {
            li.styles.add(sr);
        }
        this.parseElements(elemspan.getChildNodes(), li);
        if (sr != null) {
            li.styles.remove(sr);
        }
    }

    private void parseElements(NodeList tags, LineInformation linfo) {
        int i = 0;
        while (i < tags.getLength()) {
            Node tag = tags.item(i);
            short type = tag.getNodeType();
            if (type == 3) {
                this.parseText((Text)tag, linfo);
            } else if (type == 1) {
                if (tag.getNodeName().compareTo("li") == 0) {
                    this.parseLI((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("ul") == 0) {
                    this.parseUL((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("br") == 0) {
                    this.parseBR((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("img") == 0) {
                    this.parseImage((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("a") == 0) {
                    this.parseA((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("span") == 0) {
                    this.parseSpan((Element)tag, linfo);
                }
            }
            ++i;
        }
    }

    public void importFromDocument(Document doc) {
        ArrayList bs = DomImpl.getElements((Document)doc, (String)"body");
        if (bs.size() == 0) {
            return;
        }
        this.textview.setText("");
        ArrayList imgs = (ArrayList)this.textview.getData();
        if (imgs != null) {
            imgs.clear();
        } else {
            imgs = new ArrayList();
            this.textview.setData(imgs);
        }
        Element body = (Element)bs.get(0);
        this.parseElements(body.getChildNodes(), new LineInformation());
    }

    private class LineInformation {
        int indent = 0;
        Stack styles = new Stack();

        private LineInformation() {
        }
    }
}

