/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction preferencesAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction openNewWindowAction;
    private IContributionItem openWindowsItem;
    private IContributionItem viewsShortList;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
        this.preferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.preferencesAction);
        this.openNewWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        this.register((IAction)this.openNewWindowAction);
        this.openWindowsItem = ContributionItemFactory.OPEN_WINDOWS.create(window);
        this.viewsShortList = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager("&File", "file");
        MenuManager editMenu = new MenuManager("&Edit", "edit");
        MenuManager navigateMenu = new MenuManager("&Navigate", "navigate");
        MenuManager helpMenu = new MenuManager("&Help", "help");
        MenuManager windowMenu = new MenuManager("&Window", "window");
        MenuManager showViewMenu = new MenuManager("Show View(&V)");
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)editMenu);
        menuBar.add((IContributionItem)navigateMenu);
        menuBar.add((IContributionItem)windowMenu);
        menuBar.add((IContributionItem)helpMenu);
        fileMenu.add((IAction)this.exitAction);
        helpMenu.add((IAction)this.aboutAction);
        windowMenu.add((IAction)this.preferencesAction);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.openNewWindowAction);
        windowMenu.add(this.openWindowsItem);
        showViewMenu.add(this.viewsShortList);
        windowMenu.add((IContributionItem)showViewMenu);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager stoolbar = new ToolBarManager(0x820000);
        stoolbar.add((IContributionItem)new KeywordSearch(""));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)stoolbar, "search"));
    }

    class KeywordSearch
    extends ControlContribution {
        public KeywordSearch(String id) {
            super(id);
        }

        protected Control createControl(Composite parent) {
            Composite compo = new Composite(parent, 0);
            GridLayout gl = new GridLayout(3, false);
            gl.marginHeight = 0;
            gl.marginWidth = 2;
            gl.horizontalSpacing = 2;
            compo.setLayout((Layout)gl);
            Label icon = new Label(compo, 0);
            icon.setImage(FrameworkPlugin.getImageDescriptor("icons/search.gif").createImage());
            GridData gdi = new GridData();
            icon.setLayoutData((Object)gdi);
            Text text = new Text(compo, 2048);
            text.setFont(new Font(null, "Arial", 12, 0));
            text.setText(" Enter search keywords, then hit the RETURN key.                         ");
            text.addTraverseListener(new TraverseListener(this, text){
                final /* synthetic */ KeywordSearch this$1;
                private final /* synthetic */ Text val$text;
                {
                    this.this$1 = keywordSearch;
                    this.val$text = text;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 4) {
                        String[] words = this.val$text.getText().split(" ");
                        String xpath = "/data[";
                        int i = 0;
                        while (i < words.length) {
                            xpath = String.valueOf(xpath) + "contains(translate(., 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'), '" + words[i].toLowerCase() + "')";
                            if (i < words.length - 1) {
                                xpath = String.valueOf(xpath) + " and ";
                            }
                            ++i;
                        }
                        xpath = String.valueOf(xpath) + "]";
                        System.out.println(xpath);
                        Request rq = new Request(4, xpath, "data");
                        ArrayList<E> results = new ArrayList<E>();
                        results.addAll(FrameworkPlugin.getDefault().getDocumentsOfQuery(rq));
                        if (results != null) {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            ConciergeViewPart tabulator = (ConciergeViewPart)page.findView("jp.sourceforge.concierge.plugin.tabulator");
                            if (tabulator == null) {
                                return;
                            }
                            tabulator.setDocuments(results);
                        }
                    }
                }
            });
            text.addMouseListener(new MouseListener(this, text){
                final /* synthetic */ KeywordSearch this$1;
                private final /* synthetic */ Text val$text;
                {
                    this.this$1 = keywordSearch;
                    this.val$text = text;
                }

                public void mouseDown(MouseEvent e) {
                    this.val$text.selectAll();
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            GridData gdt = new GridData(768);
            text.setLayoutData((Object)gdt);
            return compo;
        }
    }
}

