/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.database.IDatabaseAdapter;
import jp.sourceforge.concierge.database.IDatabasePlugin;
import jp.sourceforge.concierge.framework.Alias;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.DatabaseKeeper;
import jp.sourceforge.concierge.framework.FileImporter;
import jp.sourceforge.concierge.framework.IConciergeDialog;
import jp.sourceforge.concierge.framework.ParserKeeper;
import jp.sourceforge.concierge.framework.PluginKeeper;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatDomImpl;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;

public class FrameworkPlugin
extends AbstractUIPlugin {
    private static final String DEFAULTDB = "Xindice Embedded with cache";
    public static final String TYPECOLLECTIONNAME = "type";
    public static final String DATACOLLECTIONNAME = "data";
    public static final String CONFCOLLECTIONNAME = "ccgconfig";
    private static FrameworkPlugin plugin;
    BundleContext bundlecontext;
    private ParserKeeper parsers;
    private DatabaseKeeper databases;
    private IDatabasePlugin currentdb;

    private void updateViews(ArrayList requests, Object sender) {
        ArrayList views = ConciergeViewPart.getViews();
        int i = 0;
        while (i < views.size()) {
            ConciergeViewPart vp = (ConciergeViewPart)((Object)views.get(i));
            vp.Update(requests, sender);
            ++i;
        }
    }

    public FrameworkPlugin() {
        plugin = this;
        this.parsers = new ParserKeeper();
        this.databases = new DatabaseKeeper();
        this.currentdb = null;
    }

    public void start(BundleContext context) throws Exception {
        Bundle[] bundles;
        block8: {
            super.start(context);
            this.bundlecontext = context;
            bundles = context.getBundles();
            try {
                this.parsers.initialize(bundles);
                this.databases.initialize(bundles);
            }
            catch (Exception e) {
                if (e == null) break block8;
                System.err.println(e.getMessage());
            }
        }
        String dbname = this.getPreferenceStore().getString("CCGDatabaseName");
        if (dbname.length() == 0) {
            dbname = DEFAULTDB;
            this.getPreferenceStore().setValue("CCGDatabaseName", dbname);
        }
        this.currentdb = this.databases.getDatabasePlugin(dbname);
        ArrayList props = this.currentdb.getProperties();
        int i = 0;
        while (i < props.size()) {
            String p = this.getPreferenceStore().getString((String)props.get(i));
            if (p.length() > 0) {
                this.currentdb.setProperty((String)props.get(i), p);
            } else {
                this.getPreferenceStore().setValue((String)props.get(i), this.currentdb.getProperty((String)props.get(i)));
            }
            ++i;
        }
        if (this.currentdb.getInstance(TYPECOLLECTIONNAME) == null || this.currentdb.getInstance(DATACOLLECTIONNAME) == null) {
            PluginKeeper.stopPlugins(bundles);
            System.err.println("Quit concierge");
            System.exit(0);
        }
        this.initializePreferences();
        FrameworkPlugin.getDefault().getPreferenceStore().setValue("CCGDatabaseName", this.currentdb.getDatabaseName());
        ArrayList properties = this.currentdb.getProperties();
        int i2 = 0;
        while (i2 < properties.size()) {
            String p = (String)properties.get(i2);
            FrameworkPlugin.getDefault().getPreferenceStore().setValue(p, this.currentdb.getProperty(p));
            ++i2;
        }
        plugin.savePluginPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static FrameworkPlugin getDefault() {
        return plugin;
    }

    public void activateAllPlugins() {
        PluginKeeper.initialize(this.bundlecontext.getBundles());
    }

    public Document getDocumentByID(String collection, long id) {
        String xpath = "/child::*[@id='" + String.valueOf(id) + "']";
        ArrayList docs = this.currentdb.getInstance(collection).query(xpath);
        return docs == null || docs.size() == 0 ? null : (Document)docs.get(0);
    }

    public static IParserPlugin getParserPlugin(String typename) {
        return FrameworkPlugin.plugin.parsers.getParserPlugin(typename);
    }

    public static IConciergeDialog getDialogPlugin(String pluginid) {
        AbstractUIPlugin p = PluginKeeper.getPlugin(pluginid);
        return p instanceof IConciergeDialog ? (IConciergeDialog)p : null;
    }

    public static AbstractUIPlugin getPlugin(String pluginid) {
        return PluginKeeper.getPlugin(pluginid);
    }

    public static ArrayList getAllParserTypes() {
        return FrameworkPlugin.plugin.parsers.getAllParserTypes();
    }

    public static IDatabasePlugin getDatabasePlugin(String dbname) {
        return FrameworkPlugin.plugin.databases.getDatabasePlugin(dbname);
    }

    public static ArrayList getAllDatabases() {
        return FrameworkPlugin.plugin.databases.getAllDatabases();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.framework", (String)path);
    }

    public ArrayList getDocumentsOfQuery(Request req) {
        return this.currentdb.getInstance(req.collection).query((String)req.data);
    }

    private String getDatabaseDir(String path) {
        File f;
        String dbdir = this.currentdb.getLocalDatabaseDirectory();
        if (dbdir == null) {
            dbdir = System.getProperty("user.home");
        }
        if (!(f = new File(dbdir = String.valueOf(dbdir) + File.separator + path)).exists()) {
            f.mkdir();
        }
        return dbdir;
    }

    private String getAliasDir() {
        return this.getDatabaseDir(".concierge");
    }

    private String getImportDir() {
        return this.getDatabaseDir(".import");
    }

    private void adddocument(IDatabaseAdapter adapter, Document doc) {
        ArrayList<Document> list = new ArrayList<Document>();
        String path = DataDomImpl.getFilePath(doc);
        if (path != null && path.length() > 0) {
            DataDomImpl.setFileName(doc, FilenameUtils.getName((String)path));
            DataDomImpl.removeFilePath(doc);
        }
        list.add(doc);
        if (!adapter.append(list)) {
            return;
        }
        if (path == null || path.length() == 0) {
            return;
        }
        String ext = FilenameUtils.getExtension((String)path);
        String aliaspath = String.valueOf(String.valueOf(DomImpl.getID(doc))) + (ext.length() > 0 ? "." : "") + ext;
        FileImporter.importFile(path, this.getAliasDir(), aliaspath);
    }

    private void deldocument(IDatabaseAdapter adapter, Document doc) {
        ArrayList<Document> list = new ArrayList<Document>();
        list.add(doc);
        if (adapter.delete(list) && adapter.getCollectionName().compareTo(DATACOLLECTIONNAME) == 0) {
            FileImporter.deleteFile(this.getAliasDir(), String.valueOf(DomImpl.getID(doc)));
        }
    }

    private void upddocument(IDatabaseAdapter adapter, Document doc) {
        String path = DataDomImpl.getFilePath(doc);
        if (path != null && path.length() > 0) {
            DataDomImpl.setFileName(doc, FilenameUtils.getName((String)path));
            DataDomImpl.removeFilePath(doc);
        }
        ArrayList<Document> list = new ArrayList<Document>();
        DomImpl.setLastModifiedTime(doc, System.currentTimeMillis());
        list.add(doc);
        adapter.update(list);
        if (path == null || path.length() == 0) {
            return;
        }
        String id = String.valueOf(DomImpl.getID(doc));
        FileImporter.deleteFile(this.getAliasDir(), id);
        String ext = FilenameUtils.getExtension((String)path);
        String aliaspath = String.valueOf(id) + (ext.length() > 0 ? "." : "") + ext;
        FileImporter.importFile(path, this.getAliasDir(), aliaspath);
    }

    public boolean updateDocuments(ArrayList requests, Object sender) {
        int i = 0;
        while (i < requests.size()) {
            Request req = (Request)requests.get(i);
            IDatabaseAdapter dba = this.currentdb.getInstance(req.collection);
            Document doc = (Document)req.data;
            long id = DomImpl.getID(doc);
            switch (req.command) {
                case 1: 
                case 3: {
                    if (dba.documentExists(id)) {
                        this.upddocument(dba, doc);
                        break;
                    }
                    this.adddocument(dba, doc);
                    break;
                }
                case 2: {
                    this.deldocument(dba, doc);
                }
            }
            ++i;
        }
        this.updateViews(requests, sender);
        return true;
    }

    public static boolean importFile(String originalfile, String filename) {
        return FileImporter.importFile(originalfile, plugin.getImportDir(), filename);
    }

    public static String findImportedFile(String filename) {
        if (filename.length() == 0) {
            return null;
        }
        return FileImporter.findFile(plugin.getImportDir(), filename);
    }

    public static boolean importRelatedFile(String originalfile, String filename) {
        return FileImporter.importFile(originalfile, plugin.getAliasDir(), filename);
    }

    public static String findRelatedFile(String filename) {
        return FileImporter.findFile(plugin.getAliasDir(), filename);
    }

    public static boolean deleteFile(long id) {
        return FileImporter.deleteFile(plugin.getAliasDir(), String.valueOf(id));
    }

    public static String getPathFromID(long id) {
        return FileImporter.getPathFromID(plugin.getAliasDir(), id);
    }

    public static long getIDFromPath(String path) {
        return FileImporter.getIDFromPath(plugin.getAliasDir(), path);
    }

    public static Document getDocumentFromPath(String path) {
        long id = Alias.getIDFromPath(plugin.getAliasDir(), path);
        return id < 0L ? null : plugin.getDocumentByID(DATACOLLECTIONNAME, id);
    }

    public static ArrayList getDocumentsFromPath(String dir) {
        File f = new File(dir);
        File[] children = f.listFiles();
        if (children == null) {
            return null;
        }
        ArrayList<Document> docs = new ArrayList<Document>();
        int i = 0;
        while (i < children.length) {
            Document doc;
            if (!children[i].isDirectory() && (doc = FrameworkPlugin.getDocumentFromPath(children[i].getAbsolutePath())) != null) {
                docs.add(doc);
            }
            ++i;
        }
        return docs;
    }

    public static String getLocalDatabaseDirectory() {
        if (FrameworkPlugin.plugin.currentdb == null) {
            return null;
        }
        return FrameworkPlugin.plugin.currentdb.getLocalDatabaseDirectory();
    }

    private void initializePreferences() {
        this.setHttpProxy();
        this.setReferenceFormat();
    }

    private void setHttpProxy() {
        String proxyHost = FrameworkPlugin.getDefault().GetHttpProxyHost();
        String proxyPort = FrameworkPlugin.getDefault().GetHttpProxyPort();
        System.out.println("Http Proxy Host = " + proxyHost + ", Port = " + proxyPort);
        if (proxyHost != null && proxyHost.length() > 0) {
            System.setProperty("http.proxyHost", proxyHost);
        }
        if (proxyPort != null && proxyPort.length() > 0) {
            System.setProperty("http.proxyPort", proxyPort);
        }
    }

    public String GetHttpProxyHost() {
        return FrameworkPlugin.getDefault().getPreferenceStore().getString("HTTPproxyHostPreference");
    }

    public String GetHttpProxyPort() {
        return FrameworkPlugin.getDefault().getPreferenceStore().getString("HTTPproxyPortPreference");
    }

    public void setReferenceFormat() {
        try {
            ReferenceFormatDomImpl.initializeReferenceFormatTable();
        }
        catch (Exception exception) {}
    }
}

