/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework.preferences;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatData;
import jp.sourceforge.concierge.util.ReferenceFormatDomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatNameData;
import jp.sourceforge.concierge.util.ReferenceFormatTypeItemData;
import jp.sourceforge.concierge.util.ReferenceFormatTypeItemTransfer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceFormatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite _parent = null;
    private TableViewer typeTableViewer = null;
    private CheckboxTableViewer formatNameTableViewer = null;
    private CheckboxTableViewer typeItemTableViewer = null;
    private Button boldButton = null;
    private Button italicButton = null;
    private Button underlineButton = null;
    private Combo fontCombo = null;
    private Spinner fontSizeSpinner = null;
    private StyledText sampleStyledText = null;
    private Image blueButtonImage = null;
    private Color rectColor;
    private Color fillColor;

    public ReferenceFormatPreferencePage() {
        super("Reference Format");
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        if (this.blueButtonImage != null) {
            this.blueButtonImage.dispose();
            this.blueButtonImage = null;
        }
        super.dispose();
    }

    public boolean performOk() {
        this.DoSave();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{"apply"});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatPreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    protected Control createContents(Composite parent) {
        this._parent = parent;
        this.noDefaultAndApplyButton();
        if (this.blueButtonImage == null) {
            ImageDescriptor imgDes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.framework", (String)"icons/BlueBall.png");
            this.blueButtonImage = imgDes.createImage();
        }
        SashForm sf = new SashForm(parent, 0);
        sf.setLayout((Layout)new FillLayout());
        this.createPartControl((Composite)sf);
        sf.setWeights(new int[]{30, 70});
        GridData data = new GridData(1808);
        sf.setLayoutData((Object)data);
        return sf;
    }

    protected void InitializeSettings() {
        ArrayList al = this.GetTypeDocuments();
        int i = 0;
        while (i < al.size()) {
            ReferenceFormatData rfd = new ReferenceFormatData((Document)al.get(i));
            this.typeTableViewer.add((Object)rfd);
            this.readDoc(rfd);
            ++i;
        }
        if (al.size() > 0) {
            this.typeTableViewer.getTable().deselectAll();
            this.typeTableViewer.getTable().select(0);
            ReferenceFormatData rfd = (ReferenceFormatData)this.typeTableViewer.getElementAt(0);
            this.selectTypeTableViewer(rfd);
        }
    }

    protected void createPartControl(Composite parent) {
        this.createLeftComposite(parent);
        this.createRightComposite(parent);
        this.InitializeSettings();
    }

    private void createLeftComposite(Composite parent) {
        GridLayout gl = null;
        GridData gd = null;
        Composite left = new Composite(parent, 2048);
        gl = new GridLayout(1, false);
        gl.marginWidth = 2;
        gl.marginHeight = 2;
        left.setLayout((Layout)gl);
        SashForm sf = new SashForm(left, 512);
        sf.setLayoutData((Object)new GridData(1808));
        sf.setLayout((Layout)new FillLayout());
        this.typeTableViewer = new TableViewer((Composite)sf, 66308);
        this.typeTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.typeTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.typeTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.typeTableViewer.getTable().setHeaderVisible(true);
        TableColumn tc = new TableColumn(this.typeTableViewer.getTable(), 16384, 0);
        tc.setText("Type");
        this.typeTableViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ReferenceFormatPreferencePage.this.typeTableViewer.getTable().getClientArea();
                TableColumn[] col = ReferenceFormatPreferencePage.this.typeTableViewer.getTable().getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
        this.typeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null && obj instanceof ReferenceFormatData) {
                    ReferenceFormatData rfd = (ReferenceFormatData)obj;
                    ReferenceFormatPreferencePage.this.selectTypeTableViewer(rfd);
                }
            }
        });
        this.formatNameTableViewer = CheckboxTableViewer.newCheckList((Composite)sf, (int)66340);
        this.formatNameTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.formatNameTableViewer.getTable().setLinesVisible(true);
        this.formatNameTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.formatNameTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.formatNameTableViewer.getTable().setHeaderVisible(true);
        tc = new TableColumn(this.formatNameTableViewer.getTable(), 16384, 0);
        tc.setText("Format Name");
        this.formatNameTableViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().getClientArea();
                TableColumn[] col = ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
        this.formatNameTableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem ti = (TableItem)event.item;
                    ReferenceFormatData rfd = ReferenceFormatPreferencePage.this.getSelectionTypeTableViewer();
                    if (rfd != null) {
                        rfd.setFormatNameListIndex(ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().indexOf(ti));
                    }
                    int i = 0;
                    while (i < ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().getItemCount()) {
                        if (!ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().getItem(i).equals(ti)) {
                            ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().getItem(i).setChecked(false);
                        }
                        ++i;
                    }
                }
            }
        });
        this.formatNameTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                System.out.println("FontName:" + obj);
                if (obj != null && obj instanceof ReferenceFormatNameData) {
                    ReferenceFormatNameData rfnd = (ReferenceFormatNameData)obj;
                    ReferenceFormatPreferencePage.this.setInputTypeItemTableViewer(rfnd);
                }
            }
        });
        this.formatNameTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                ArrayList formatNameList = (ArrayList)ReferenceFormatPreferencePage.this.formatNameTableViewer.getInput();
                if (formatNameList.get(0).equals(obj)) {
                    return;
                }
                ReferenceFormatNameData oldRfnd = (ReferenceFormatNameData)obj;
                if (oldRfnd == null) {
                    return;
                }
                InputDialog dlg = new InputDialog(ReferenceFormatPreferencePage.this._parent.getShell(), "Input Format Name", "Format Name:", oldRfnd.getName(), new IInputValidator(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "Please input Format Name.";
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0) {
                    oldRfnd.setName(dlg.getValue());
                    ReferenceFormatPreferencePage.this.formatNameTableViewer.update((Object)oldRfnd, null);
                }
                dlg = null;
            }
        });
        sf.setWeights(new int[]{40, 60});
        Composite tablecontrol = new Composite(left, 0);
        tablecontrol.setLayoutData((Object)new GridData(768));
        gl = new GridLayout(2, false);
        gl.marginWidth = 1;
        gl.marginHeight = 1;
        tablecontrol.setLayout((Layout)gl);
        Button plus = new Button(tablecontrol, 8);
        gd = new GridData(768);
        plus.setLayoutData((Object)gd);
        plus.setText("new");
        plus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatData rfd;
                InputDialog dlg = new InputDialog(ReferenceFormatPreferencePage.this._parent.getShell(), "Input Format Name", "Format Name:", "", new IInputValidator(this){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "Please input Format Name.";
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0 && (rfd = ReferenceFormatPreferencePage.this.getSelectionTypeTableViewer()) != null) {
                    ReferenceFormatNameData newRfnd = rfd.newFormatName(dlg.getValue());
                    ReferenceFormatPreferencePage.this.formatNameTableViewer.setInput((Object)rfd.getFormatNameList());
                    ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().select(ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().getItemCount() - 1);
                    ReferenceFormatPreferencePage.this.setInputTypeItemTableViewer(newRfnd);
                }
                dlg = null;
            }
        });
        Button minus = new Button(tablecontrol, 8);
        gd = new GridData(768);
        minus.setLayoutData((Object)gd);
        minus.setText("delete");
        minus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatData rfd;
                ArrayList formatNameList;
                System.out.println("delete");
                ReferenceFormatNameData rfnd = ReferenceFormatPreferencePage.this.getSelectionFormatNameTableViewer();
                if (rfnd != null && !(formatNameList = (ArrayList)ReferenceFormatPreferencePage.this.formatNameTableViewer.getInput()).get(0).equals(rfnd) && (rfd = ReferenceFormatPreferencePage.this.getSelectionTypeTableViewer()) != null) {
                    ReferenceFormatPreferencePage.this.setInputTypeItemTableViewer(null);
                    rfd.removeFormatName(rfnd);
                    ReferenceFormatPreferencePage.this.formatNameTableViewer.setInput((Object)rfd.getFormatNameList());
                    rfd.setFormatNameListIndex(0);
                    ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().getItem(0).setChecked(true);
                    ReferenceFormatPreferencePage.this.formatNameTableViewer.getTable().select(0);
                    ReferenceFormatPreferencePage.this.setInputTypeItemTableViewer((ReferenceFormatNameData)rfd.getFormatNameList().get(0));
                }
            }
        });
    }

    private void selectTypeTableViewer(ReferenceFormatData rfd) {
        this.formatNameTableViewer.getTable().deselectAll();
        this.formatNameTableViewer.setInput((Object)rfd.getFormatNameList());
        int i = 0;
        while (i < rfd.getFormatNameList().size()) {
            ReferenceFormatNameData rfnd = (ReferenceFormatNameData)rfd.getFormatNameList().get(i);
            this.formatNameTableViewer.setChecked((Object)rfnd, rfd.getFormatNameListIndex() == i);
            ++i;
        }
        this.formatNameTableViewer.getTable().select(rfd.getFormatNameListIndex());
        ReferenceFormatNameData rfnd = (ReferenceFormatNameData)rfd.getFormatNameList().get(rfd.getFormatNameListIndex());
        this.setInputTypeItemTableViewer(rfnd);
    }

    private ReferenceFormatNameData getSelectionFormatNameTableViewer() {
        Object obj;
        ISelection selection = this.formatNameTableViewer.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ReferenceFormatNameData) {
            return (ReferenceFormatNameData)obj;
        }
        return null;
    }

    private ReferenceFormatData getSelectionTypeTableViewer() {
        Object obj;
        ISelection selection = this.typeTableViewer.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ReferenceFormatData) {
            return (ReferenceFormatData)obj;
        }
        return null;
    }

    private ReferenceFormatTypeItemData getSelectionTypeItemTableViewer() {
        Object obj;
        ISelection selection = this.typeItemTableViewer.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ReferenceFormatTypeItemData) {
            return (ReferenceFormatTypeItemData)obj;
        }
        return null;
    }

    private void setInputTypeItemTableViewer(ReferenceFormatNameData rfnd) {
        if (rfnd != null) {
            this.typeItemTableViewer.setInput((Object)rfnd.getTypeItemList());
            int i = 0;
            while (i < rfnd.getTypeItemList().size()) {
                ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)rfnd.getTypeItemList().get(i);
                this.typeItemTableViewer.setChecked((Object)rftid, rftid.getCheck());
                ++i;
            }
            this.boldButton.setSelection(false);
            this.italicButton.setSelection(false);
            this.underlineButton.setSelection(false);
            int selectIndex = rfnd.getFontItemIndex();
            if (selectIndex >= 0 && selectIndex < ReferenceFormatNameData.fontitems.length) {
                this.fontCombo.select(selectIndex);
            } else {
                this.fontCombo.deselectAll();
            }
            this.fontSizeSpinner.setSelection(rfnd.getFontSize());
            this.sampleStyledText.setFont(new Font(null, rfnd.getFontname(), rfnd.getFontSize(), 0));
            String formatString = rfnd.getFormatString();
            if (formatString == null || formatString.length() == 0) {
                rfnd.initializeFormatString();
            }
            this.setSampleString(rfnd);
        } else {
            this.typeItemTableViewer.setInput(null);
            this.boldButton.setSelection(false);
            this.italicButton.setSelection(false);
            this.underlineButton.setSelection(false);
            this.fontCombo.deselectAll();
            this.fontSizeSpinner.setSelection(12);
            this.sampleStyledText.setFont(new Font(null, ReferenceFormatNameData.fontitems[0], 12, 0));
            this.sampleStyledText.setText("");
        }
    }

    private void createRightComposite(Composite parent) {
        GridLayout gl = null;
        Composite right = new Composite(parent, 2048);
        gl = new GridLayout(1, false);
        gl.marginWidth = 2;
        gl.marginHeight = 2;
        right.setLayout((Layout)gl);
        this.sampleStyledText = new StyledText(right, 2816);
        this.sampleStyledText.setLayoutData((Object)new GridData(1808));
        this.sampleStyledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StyledText text = (StyledText)e.getSource();
                ReferenceFormatNameData rfnd = ReferenceFormatPreferencePage.this.getSelectionFormatNameTableViewer();
                if (rfnd != null) {
                    rfnd.setFormatString(text.getText());
                }
            }
        });
        this.typeItemTableViewer = CheckboxTableViewer.newCheckList((Composite)right, (int)66340);
        this.typeItemTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.typeItemTableViewer.getTable().setLinesVisible(true);
        this.typeItemTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.typeItemTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.rectColor = new Color(null, 164, 189, 236);
        this.fillColor = new Color(null, 222, 231, 248);
        this.typeItemTableViewer.getTable().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 0) {
                    GC gc = event.gc;
                    TableItem item = (TableItem)event.item;
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    gc.setBackground(ReferenceFormatPreferencePage.this.fillColor);
                    gc.fillRoundRectangle(event.x, event.y + 1, event.width + 4, event.height - 2, 15, 15);
                    gc.setForeground(ReferenceFormatPreferencePage.this.rectColor);
                    gc.drawRoundRectangle(event.x, event.y + 1, event.width + 4, event.height - 2, 15, 15);
                    gc.setForeground(ReferenceFormatPreferencePage.this.typeItemTableViewer.getTable().getDisplay().getSystemColor(2));
                    String text = item.getText();
                    Point size = gc.textExtent(text);
                    int offset = Math.max(0, (event.height - size.y) / 2);
                    gc.drawText(text, event.x + 2, event.y + offset + 2, true);
                    gc.setForeground(foreground);
                    gc.setBackground(background);
                }
            }
        });
        this.typeItemTableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item;
                Object obj;
                if (event.detail == 32 && (obj = (item = (TableItem)event.item).getData()) instanceof ReferenceFormatTypeItemData) {
                    String formatString;
                    ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)obj;
                    rftid.setCheck(item.getChecked());
                    ReferenceFormatNameData rfnd = ReferenceFormatPreferencePage.this.getSelectionFormatNameTableViewer();
                    if (rfnd != null && (formatString = rfnd.getFormatString()) != null) {
                        StringBuffer strBuf = new StringBuffer(formatString);
                        if (rftid.getCheck()) {
                            int position = rfnd.getTypeItemList().indexOf(rftid);
                            int max = rfnd.getTypeItemList().size() - 1;
                            int index = strBuf.indexOf(rftid.getTag());
                            if (index == -1) {
                                if (max > position) {
                                    int tmpIndex = -1;
                                    int i = position + 1;
                                    while (i < rfnd.getTypeItemList().size()) {
                                        ReferenceFormatTypeItemData tmp = (ReferenceFormatTypeItemData)rfnd.getTypeItemList().get(i);
                                        if (tmp.getCheck() && (tmpIndex = strBuf.indexOf(tmp.getTag())) != -1) {
                                            strBuf.insert(tmpIndex, rftid.getTag());
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (tmpIndex == -1) {
                                        strBuf.append(rftid.getTag());
                                    }
                                } else if (max == position) {
                                    strBuf.append(rftid.getTag());
                                }
                                rfnd.setFormatString(strBuf.toString());
                                ReferenceFormatPreferencePage.this.setSampleString(rfnd);
                            }
                        } else {
                            int index = strBuf.indexOf(rftid.getTag());
                            if (index != -1) {
                                strBuf.replace(index, index + rftid.getTag().length(), "");
                                rfnd.setFormatString(strBuf.toString());
                                ReferenceFormatPreferencePage.this.setSampleString(rfnd);
                            }
                        }
                    }
                }
            }
        });
        this.typeItemTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj instanceof ReferenceFormatTypeItemData) {
                    ReferenceFormatTypeItemData data = (ReferenceFormatTypeItemData)obj;
                    ReferenceFormatPreferencePage.this.boldButton.setSelection(data.getBold());
                    ReferenceFormatPreferencePage.this.italicButton.setSelection(data.getItalic());
                    ReferenceFormatPreferencePage.this.underlineButton.setSelection(data.getUnderline());
                }
            }
        });
        this.typeItemTableViewer.getTable().setHeaderVisible(true);
        TableColumn tc = new TableColumn(this.typeItemTableViewer.getTable(), 16384, 0);
        tc.setWidth(150);
        tc.setResizable(true);
        tc.setText("Name");
        tc = new TableColumn(this.typeItemTableViewer.getTable(), 0x1000000, 1);
        tc.setWidth(50);
        tc.setResizable(true);
        tc.setText("Bold");
        tc = new TableColumn(this.typeItemTableViewer.getTable(), 0x1000000, 2);
        tc.setWidth(50);
        tc.setResizable(true);
        tc.setText("Italic");
        tc = new TableColumn(this.typeItemTableViewer.getTable(), 0x1000000, 3);
        tc.setWidth(100);
        tc.setResizable(true);
        tc.setText("Underline");
        ReferenceFormatTypeItemTransfer rftiTransfer = ReferenceFormatTypeItemTransfer.getInstance();
        Transfer[] transferTypes = new Transfer[]{rftiTransfer};
        this.typeItemTableViewer.addDragSupport(2, transferTypes, (DragSourceListener)new DragTableAdapter());
        this.typeItemTableViewer.addDropSupport(2, transferTypes, (DropTargetListener)new DropTableAdapter());
        Composite attrComposite = new Composite(right, 0);
        attrComposite.setLayoutData((Object)new GridData(768));
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        attrComposite.setLayout((Layout)gl);
        Group fg1 = new Group(attrComposite, 0);
        fg1.setLayoutData((Object)new GridData(1808));
        fg1.setLayout((Layout)new GridLayout(3, false));
        this.boldButton = new Button((Composite)fg1, 32);
        this.boldButton.setLayoutData((Object)new GridData(1024));
        this.boldButton.setText("Bold");
        this.boldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatTypeItemData data = ReferenceFormatPreferencePage.this.getSelectionTypeItemTableViewer();
                if (data != null) {
                    data.setBold(((Button)e.getSource()).getSelection());
                    ReferenceFormatPreferencePage.this.setStyleSampleString(data);
                    ReferenceFormatPreferencePage.this.typeItemTableViewer.update((Object)data, null);
                }
            }
        });
        this.italicButton = new Button((Composite)fg1, 32);
        this.italicButton.setLayoutData((Object)new GridData(1024));
        this.italicButton.setText("Italic");
        this.italicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatTypeItemData data = ReferenceFormatPreferencePage.this.getSelectionTypeItemTableViewer();
                if (data != null) {
                    data.setItalic(((Button)e.getSource()).getSelection());
                    ReferenceFormatPreferencePage.this.setStyleSampleString(data);
                    ReferenceFormatPreferencePage.this.typeItemTableViewer.update((Object)data, null);
                }
            }
        });
        this.underlineButton = new Button((Composite)fg1, 32);
        this.underlineButton.setLayoutData((Object)new GridData(1024));
        this.underlineButton.setText("Underline");
        this.underlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatTypeItemData data = ReferenceFormatPreferencePage.this.getSelectionTypeItemTableViewer();
                if (data != null) {
                    data.setUnderline(((Button)e.getSource()).getSelection());
                    ReferenceFormatPreferencePage.this.setStyleSampleString(data);
                    ReferenceFormatPreferencePage.this.typeItemTableViewer.update((Object)data, null);
                }
            }
        });
        Group fg2 = new Group(attrComposite, 0);
        fg2.setLayoutData((Object)new GridData(768));
        fg2.setLayout((Layout)new GridLayout(2, false));
        this.fontCombo = new Combo((Composite)fg2, 8);
        this.fontCombo.setItems(ReferenceFormatNameData.fontitems);
        this.fontCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatNameData data = ReferenceFormatPreferencePage.this.getSelectionFormatNameTableViewer();
                if (data != null) {
                    data.setFontItemIndex(((Combo)e.getSource()).getSelectionIndex());
                    ReferenceFormatPreferencePage.this.sampleStyledText.setFont(new Font(null, data.getFontname(), data.getFontSize(), 0));
                }
            }
        });
        this.fontSizeSpinner = new Spinner((Composite)fg2, 2048);
        this.fontSizeSpinner.setMinimum(8);
        this.fontSizeSpinner.setMaximum(64);
        this.fontSizeSpinner.setSelection(12);
        this.fontSizeSpinner.setIncrement(1);
        this.fontSizeSpinner.setPageIncrement(4);
        this.fontSizeSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceFormatNameData data = ReferenceFormatPreferencePage.this.getSelectionFormatNameTableViewer();
                if (data != null) {
                    data.setFontSize(((Spinner)e.getSource()).getSelection());
                    ReferenceFormatPreferencePage.this.sampleStyledText.setFont(new Font(null, data.getFontname(), data.getFontSize(), 0));
                }
            }
        });
    }

    private void setSampleString(ReferenceFormatNameData rfnd) {
        this.sampleStyledText.setText(rfnd.getFormatString());
        int i = 0;
        while (i < rfnd.getTypeItemList().size()) {
            ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)rfnd.getTypeItemList().get(i);
            if (rftid.getCheck()) {
                this.setStyleSampleString(rftid);
            }
            ++i;
        }
    }

    private void setStyleSampleString(ReferenceFormatTypeItemData rftid) {
        int index = this.sampleStyledText.getText().indexOf(rftid.getTag());
        if (index != -1) {
            StyleRange styleR = new StyleRange();
            styleR.start = index + 1;
            styleR.length = rftid.getItemName().length();
            styleR.fontStyle = 0;
            if (rftid.getBold()) {
                styleR.fontStyle |= 1;
            }
            if (rftid.getItalic()) {
                styleR.fontStyle |= 2;
            }
            styleR.underline = rftid.getUnderline();
            this.sampleStyledText.setStyleRange(styleR);
        }
    }

    private void DoSave() {
        this.saveReferenceFormat();
        int i = 0;
        while (i < this.typeTableViewer.getTable().getItemCount()) {
            ReferenceFormatData rfd = (ReferenceFormatData)this.typeTableViewer.getElementAt(i);
            ArrayList al = rfd.getFormatNameList();
            int j = 0;
            while (j < al.size()) {
                ReferenceFormatNameData rfnd = (ReferenceFormatNameData)al.get(j);
                ReferenceFormatDomImpl.setReferenceFormatTable(rfd.getID(), rfnd);
                ++j;
            }
            ++i;
        }
    }

    private void deleteReferenceFormat() {
        String xpath = new String();
        xpath = String.valueOf(xpath) + "/referenceformat";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, xpath, "referenceformat");
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            int i = 0;
            while (i < docs.size()) {
                reqs.add(new Request(2, docs.get(i), "referenceformat"));
                ++i;
            }
            FrameworkPlugin.getDefault().updateDocuments(reqs, "jp.sourceforge.concierge.framework.preferences.ReferenceFormatPreferencePage");
            reqs.clear();
            reqs = null;
        }
        docs = null;
    }

    private void saveReferenceFormat() {
        this.deleteReferenceFormat();
        ArrayList<Request> reqs = new ArrayList<Request>();
        int i = 0;
        while (i < this.typeTableViewer.getTable().getItemCount()) {
            ReferenceFormatData rfd = (ReferenceFormatData)this.typeTableViewer.getElementAt(i);
            Document doc = this.writeDoc(rfd);
            if (doc != null) {
                reqs.add(new Request(1, doc, "referenceformat"));
            }
            ++i;
        }
        if (reqs.size() > 0) {
            FrameworkPlugin.getDefault().updateDocuments(reqs, "jp.sourceforge.concierge.framework.preferences.ReferenceFormatPreferencePage");
        }
    }

    private Document writeDoc(ReferenceFormatData rfd) {
        Document doc = null;
        try {
            doc = DomImpl.createDocument("referenceformat", true);
            Element root_elem = doc.getDocumentElement();
            root_elem.setAttribute("typeid", String.valueOf(rfd.getID()));
            root_elem.setAttribute("select", String.valueOf(rfd.getFormatNameListIndex()));
            ArrayList formatNameList = rfd.getFormatNameList();
            int j = 0;
            while (j < formatNameList.size()) {
                ReferenceFormatNameData rfnd = (ReferenceFormatNameData)formatNameList.get(j);
                Element rfnd_elem = doc.createElement(rfnd.getName());
                root_elem.appendChild(rfnd_elem);
                rfnd_elem.setAttribute("fontname", rfnd.getFontname());
                rfnd_elem.setAttribute("fontsize", String.valueOf(rfnd.getFontSize()));
                DomImpl.setElementText(rfnd_elem, rfnd.getFormatString());
                ArrayList typeItemList = rfnd.getTypeItemList();
                int k = 0;
                while (k < typeItemList.size()) {
                    ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(k);
                    Element rftid_elem = doc.createElement(rftid.getItemName());
                    rfnd_elem.appendChild(rftid_elem);
                    rftid_elem.setAttribute("visible", String.valueOf(rftid.getCheck()));
                    rftid_elem.setAttribute("bold", String.valueOf(rftid.getBold()));
                    rftid_elem.setAttribute("italic", String.valueOf(rftid.getItalic()));
                    rftid_elem.setAttribute("underline", String.valueOf(rftid.getUnderline()));
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            doc = null;
        }
        return doc;
    }

    private void readDoc(ReferenceFormatData rfd) {
        ArrayList formatNameList;
        String xpath = "/referenceformat[@typeid='" + String.valueOf(rfd.getID()) + "']";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, xpath, "referenceformat");
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            Document doc = (Document)docs.get(0);
            Element root_elem = doc.getDocumentElement();
            String selectString = root_elem.getAttribute("select");
            if (selectString == null || selectString.length() == 0) {
                selectString = "0";
            }
            rfd.setFormatNameListIndex(Integer.valueOf(selectString));
            Node rfnd_node = root_elem.getFirstChild();
            while (rfnd_node != null) {
                if (rfnd_node.getNodeType() == 1) {
                    ReferenceFormatNameData rfnd = rfd.newFormatName(rfnd_node.getNodeName());
                    rfnd.setFontname(((Element)rfnd_node).getAttribute("fontname"));
                    String fontsize = ((Element)rfnd_node).getAttribute("fontsize");
                    rfnd.setFontSize(Integer.valueOf(fontsize));
                    String formatString = DomImpl.getElementText((Element)rfnd_node);
                    rfnd.setFormatString(formatString);
                    ArrayList typeItemList = rfnd.getTypeItemList();
                    int location = 0;
                    Node rftid_node = rfnd_node.getFirstChild();
                    while (rftid_node != null) {
                        if (rftid_node.getNodeType() == 1) {
                            int i = location;
                            while (i < typeItemList.size()) {
                                ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(i);
                                if (rftid.getItemName().equals(rftid_node.getNodeName())) {
                                    typeItemList.remove(rftid);
                                    typeItemList.add(location, rftid);
                                    rftid.setCheck(((Element)rftid_node).getAttribute("visible").equals("true"));
                                    rftid.setBold(((Element)rftid_node).getAttribute("bold").equals("true"));
                                    rftid.setItalic(((Element)rftid_node).getAttribute("italic").equals("true"));
                                    rftid.setUnderline(((Element)rftid_node).getAttribute("underline").equals("true"));
                                    ++location;
                                    break;
                                }
                                ++i;
                            }
                        }
                        rftid_node = rftid_node.getNextSibling();
                    }
                    while (location < typeItemList.size()) {
                        ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(location);
                        rftid.setCheck(false);
                        ++location;
                    }
                }
                rfnd_node = rfnd_node.getNextSibling();
            }
        }
        if ((formatNameList = rfd.getFormatNameList()).size() == 0) {
            rfd.newFormatName("Default");
            rfd.setFormatNameListIndex(0);
        }
    }

    protected ArrayList GetTypeDocuments() {
        FrameworkPlugin plugin = FrameworkPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        String xpath = "/type";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, xpath, "type");
        ArrayList list = plugin.getDocumentsOfQuery(req);
        System.out.println("Result size = " + list.size());
        return list;
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ReferenceFormatData) {
                ReferenceFormatData rfd = (ReferenceFormatData)obj;
                if (index == 0) {
                    return rfd.getTypeName();
                }
            }
            if (obj instanceof ReferenceFormatNameData) {
                ReferenceFormatNameData rfnd = (ReferenceFormatNameData)obj;
                if (index == 0) {
                    return rfnd.getName();
                }
            } else if (obj instanceof ReferenceFormatTypeItemData) {
                ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)obj;
                if (index == 0) {
                    return rftid.getTag();
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (obj instanceof ReferenceFormatTypeItemData) {
                ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)obj;
                if (index == 0) {
                    return null;
                }
                if (index == 1 ? rftid.getBold() : (index == 2 ? rftid.getItalic() : index == 3 && rftid.getUnderline())) {
                    return ReferenceFormatPreferencePage.this.blueButtonImage;
                }
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }
    }

    private class DragTableAdapter
    extends DragSourceAdapter {
        private DragTableAdapter() {
        }

        public void dragSetData(DragSourceEvent e) {
            System.out.println("dragSetData");
            IStructuredSelection selection = (IStructuredSelection)ReferenceFormatPreferencePage.this.typeItemTableViewer.getSelection();
            if (selection != null && selection.size() > 0 && ReferenceFormatTypeItemTransfer.getInstance().isSupportedType(e.dataType)) {
                ReferenceFormatTypeItemData obj = (ReferenceFormatTypeItemData)selection.getFirstElement();
                ArrayList al = (ArrayList)ReferenceFormatPreferencePage.this.typeItemTableViewer.getInput();
                int index = al.indexOf(obj);
                if (index != -1) {
                    Integer integer = new Integer(index);
                    e.data = integer;
                }
            }
        }

        public void dragStart(DragSourceEvent e) {
            System.out.println("dragStart");
            e.doit = true;
        }

        public void dragFinished(DragSourceEvent e) {
            System.out.println("dragFinished");
        }
    }

    private class DropTableAdapter
    extends DropTargetAdapter {
        private DropTableAdapter() {
        }

        public void drop(DropTargetEvent e) {
            block25: {
                System.out.println("Drop");
                if (!ReferenceFormatTypeItemTransfer.getInstance().isSupportedType(e.currentDataType)) break block25;
                TableItem ti = (TableItem)e.item;
                String replaceString = "<_____>";
                if (ti != null) {
                    int position = 0;
                    int i = 0;
                    while (i < ReferenceFormatPreferencePage.this.typeItemTableViewer.getTable().getItemCount()) {
                        if (ti.equals(ReferenceFormatPreferencePage.this.typeItemTableViewer.getTable().getItem(i))) {
                            position = i;
                            break;
                        }
                        ++i;
                    }
                    ReferenceFormatNameData rfnd = ReferenceFormatPreferencePage.this.getSelectionFormatNameTableViewer();
                    ArrayList newAl = rfnd.getTypeItemList();
                    Integer integer = (Integer)e.data;
                    if (integer != null) {
                        ReferenceFormatTypeItemData rftid;
                        if (position < integer) {
                            rftid = (ReferenceFormatTypeItemData)newAl.get(integer);
                            newAl.remove(integer);
                            newAl.add(position, rftid);
                        } else if (integer < position) {
                            rftid = (ReferenceFormatTypeItemData)newAl.get(integer);
                            newAl.add(position + 1, rftid);
                            newAl.remove(integer);
                        }
                        ReferenceFormatPreferencePage.this.typeItemTableViewer.setInput((Object)newAl);
                        StringBuffer strBuf = new StringBuffer(rfnd.getFormatString());
                        int i2 = 0;
                        while (i2 < newAl.size()) {
                            ReferenceFormatTypeItemData olddata = (ReferenceFormatTypeItemData)newAl.get(i2);
                            int index = strBuf.indexOf(olddata.getTag());
                            if (index != -1) {
                                strBuf.replace(index, index + olddata.getTag().length(), replaceString);
                            }
                            ++i2;
                        }
                        int strIndex = 0;
                        int alIndex = 0;
                        while (alIndex < newAl.size()) {
                            ReferenceFormatTypeItemData newdata = (ReferenceFormatTypeItemData)newAl.get(alIndex);
                            if (newdata.getCheck()) {
                                if ((strIndex = strBuf.indexOf(replaceString, strIndex)) == -1) break;
                                strBuf.replace(strIndex, strIndex + replaceString.length(), newdata.getTag());
                                strIndex += newdata.getTag().length();
                            }
                            ++alIndex;
                        }
                        while (strIndex != -1) {
                            if ((strIndex = strBuf.indexOf(replaceString, strIndex)) == -1) continue;
                            strBuf.replace(strIndex, strIndex + replaceString.length(), "");
                        }
                        while (alIndex < newAl.size()) {
                            ReferenceFormatTypeItemData newdata = (ReferenceFormatTypeItemData)newAl.get(alIndex);
                            if (newdata.getCheck()) {
                                strBuf.append(" " + newdata.getTag());
                            }
                            ++alIndex;
                        }
                        rfnd.setFormatString(strBuf.toString());
                        ReferenceFormatPreferencePage.this.setSampleString(rfnd);
                    }
                    int i3 = 0;
                    while (i3 < newAl.size()) {
                        ReferenceFormatTypeItemData data = (ReferenceFormatTypeItemData)newAl.get(i3);
                        ReferenceFormatPreferencePage.this.typeItemTableViewer.setChecked((Object)data, data.getCheck());
                        ++i3;
                    }
                } else {
                    ReferenceFormatNameData rfnd = ReferenceFormatPreferencePage.this.getSelectionFormatNameTableViewer();
                    ArrayList newAl = rfnd.getTypeItemList();
                    Integer integer = (Integer)e.data;
                    if (integer != null) {
                        ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)newAl.get(integer);
                        newAl.add(rftid);
                        newAl.remove(integer);
                        ReferenceFormatPreferencePage.this.typeItemTableViewer.setInput((Object)newAl);
                        StringBuffer strBuf = new StringBuffer(rfnd.getFormatString());
                        int i = 0;
                        while (i < newAl.size()) {
                            ReferenceFormatTypeItemData olddata = (ReferenceFormatTypeItemData)newAl.get(i);
                            int index = strBuf.indexOf(olddata.getTag());
                            if (index != -1) {
                                strBuf.replace(index, index + olddata.getTag().length(), replaceString);
                            }
                            ++i;
                        }
                        int strIndex = 0;
                        int alIndex = 0;
                        while (alIndex < newAl.size()) {
                            ReferenceFormatTypeItemData newdata = (ReferenceFormatTypeItemData)newAl.get(alIndex);
                            if (newdata.getCheck()) {
                                if ((strIndex = strBuf.indexOf(replaceString, strIndex)) == -1) break;
                                strBuf.replace(strIndex, strIndex + replaceString.length(), newdata.getTag());
                                strIndex += newdata.getTag().length();
                            }
                            ++alIndex;
                        }
                        while (strIndex != -1) {
                            if ((strIndex = strBuf.indexOf(replaceString, strIndex)) == -1) continue;
                            strBuf.replace(strIndex, strIndex + replaceString.length(), "");
                        }
                        while (alIndex < newAl.size()) {
                            ReferenceFormatTypeItemData newdata = (ReferenceFormatTypeItemData)newAl.get(alIndex);
                            if (newdata.getCheck()) {
                                strBuf.append(" " + newdata.getTag());
                            }
                            ++alIndex;
                        }
                        rfnd.setFormatString(strBuf.toString());
                        ReferenceFormatPreferencePage.this.setSampleString(rfnd);
                    }
                    int i = 0;
                    while (i < newAl.size()) {
                        ReferenceFormatTypeItemData data = (ReferenceFormatTypeItemData)newAl.get(i);
                        ReferenceFormatPreferencePage.this.typeItemTableViewer.setChecked((Object)data, data.getCheck());
                        ++i;
                    }
                }
            }
        }

        public void dragOver(DropTargetEvent e) {
            e.feedback |= 8;
        }
    }
}

