/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.Calendar;
import java.util.Date;

public class CalendarUtil {
    private static int[] days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static String[] weeks = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    private static boolean isleapyear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static int getNumberOfDays(int year, int month) {
        if (month == 2) {
            return CalendarUtil.isleapyear(year) ? days[1] + 1 : days[1];
        }
        return days[month - 1];
    }

    public static int getDayOfWeek(int year, int month, int date) {
        Calendar cd = Calendar.getInstance();
        cd.set(year, month - 1, date);
        return cd.get(7);
    }

    public static String getNameOfMonth(int month) {
        return months[month - 1];
    }

    public static String getNameOfWeek(int week) {
        return weeks[week - 1];
    }

    public static String getDateString(Date date) {
        Calendar cd = Calendar.getInstance();
        if (date != null) {
            cd.setTime(date);
        }
        int year = cd.get(1);
        String mon = months[cd.get(2)];
        int day = cd.get(5);
        String week = weeks[cd.get(7) - 1];
        return String.valueOf(week) + " " + mon + " " + String.valueOf(day) + " " + String.valueOf(year);
    }

    public static String getTodaysString() {
        return CalendarUtil.getDateString(null);
    }
}

