/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.util;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.parser.IParserPlugin;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.ReferenceFormatNameData;
import jp.sourceforge.concierge.util.ReferenceFormatTypeItemData;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceFormatDomImpl {
    private static Hashtable referenceformattable = null;

    public static ReferenceFormatNameData getCurrentReferenceFormatNameData(Document typedoc) {
        ReferenceFormatNameData rfnd = null;
        String xpath = "/referenceformat[@typeid='" + String.valueOf(DomImpl.getID(typedoc)) + "']";
        System.out.println("ReferenceFormatDomImpl xpath = " + xpath);
        Request req = new Request(4, xpath, "referenceformat");
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("ReferenceFormatDomImpl Result size = " + docs.size());
        if (docs.size() > 0) {
            Document doc = (Document)docs.get(0);
            Element root_elem = doc.getDocumentElement();
            String selectString = root_elem.getAttribute("select");
            if (selectString == null || selectString.length() == 0) {
                selectString = "0";
            }
            int select = Integer.valueOf(selectString);
            int count = 0;
            Node rfnd_node = root_elem.getFirstChild();
            while (rfnd_node != null) {
                if (rfnd_node.getNodeType() == 1 && count == select) {
                    rfnd = new ReferenceFormatNameData(rfnd_node.getNodeName());
                    ArrayList typeelems = TypeDomImpl.getAllElements(typedoc);
                    int i = 0;
                    while (i < typeelems.size()) {
                        Element typeelem = (Element)typeelems.get(i);
                        String itemname = TypeDomImpl.getElementName(typeelem);
                        rfnd.addTypeItem(itemname);
                        ++i;
                    }
                    rfnd.initializeFormatString();
                    rfnd.setFontname(((Element)rfnd_node).getAttribute("fontname"));
                    String fontsize = ((Element)rfnd_node).getAttribute("fontsize");
                    rfnd.setFontSize(Integer.valueOf(fontsize));
                    String formatString = DomImpl.getElementText((Element)rfnd_node);
                    rfnd.setFormatString(formatString);
                    ArrayList typeItemList = rfnd.getTypeItemList();
                    int location = 0;
                    Node rftid_node = rfnd_node.getFirstChild();
                    while (rftid_node != null) {
                        if (rftid_node.getNodeType() == 1) {
                            int i2 = location;
                            while (i2 < typeItemList.size()) {
                                ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(i2);
                                if (rftid.getItemName().equals(rftid_node.getNodeName())) {
                                    typeItemList.remove(rftid);
                                    typeItemList.add(location, rftid);
                                    rftid.setCheck(((Element)rftid_node).getAttribute("visible").equals("true"));
                                    rftid.setBold(((Element)rftid_node).getAttribute("bold").equals("true"));
                                    rftid.setItalic(((Element)rftid_node).getAttribute("italic").equals("true"));
                                    rftid.setUnderline(((Element)rftid_node).getAttribute("underline").equals("true"));
                                    ++location;
                                    break;
                                }
                                ++i2;
                            }
                        }
                        rftid_node = rftid_node.getNextSibling();
                    }
                    while (location < typeItemList.size()) {
                        ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(location);
                        rftid.setCheck(false);
                        ++location;
                    }
                    break;
                }
                rfnd_node = rfnd_node.getNextSibling();
            }
        }
        if (rfnd == null) {
            rfnd = ReferenceFormatDomImpl.createDefaultReferenceFormatNameData(typedoc);
        }
        return rfnd;
    }

    public static void initializeReferenceFormatTable() {
        if (referenceformattable != null) {
            referenceformattable.clear();
            referenceformattable = null;
        }
        referenceformattable = new Hashtable();
        String xpath = "/type";
        System.out.println("ReferenceFormatDomImpl xpath = " + xpath);
        Request req = new Request(4, xpath, "type");
        ArrayList list = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("ReferenceFormatDomImpl Result size = " + list.size());
        int i = 0;
        while (i < list.size()) {
            Document typedoc = (Document)list.get(i);
            ReferenceFormatNameData rfnd = ReferenceFormatDomImpl.getCurrentReferenceFormatNameData(typedoc);
            referenceformattable.put(String.valueOf(DomImpl.getID(typedoc)), rfnd);
            ++i;
        }
    }

    public static void setReferenceFormatTable(String tid, ReferenceFormatNameData rfnd) {
        if (referenceformattable == null) {
            referenceformattable = new Hashtable();
        }
        referenceformattable.put(tid, rfnd);
    }

    public static void setReferenceFormatTable(long typeid, ReferenceFormatNameData rfnd) {
        if (referenceformattable == null) {
            referenceformattable = new Hashtable();
        }
        referenceformattable.put(String.valueOf(typeid), rfnd);
    }

    public static ReferenceFormatNameData getReferenceFormatTable(String tid) {
        if (referenceformattable != null) {
            return (ReferenceFormatNameData)referenceformattable.get(tid);
        }
        String xpath = "/type[@id='" + tid + "']";
        System.out.println("ReferenceFormatDomImpl xpath = " + xpath);
        Request req = new Request(4, xpath, "type");
        ArrayList docs = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
        System.out.println("ReferenceFormatDomImpl Result size = " + docs.size());
        if (docs.size() > 0) {
            Document typedoc = (Document)docs.get(0);
            return ReferenceFormatDomImpl.createDefaultReferenceFormatNameData(typedoc);
        }
        return null;
    }

    public static ReferenceFormatNameData createDefaultReferenceFormatNameData(Document typedoc) {
        ReferenceFormatNameData rfnd = new ReferenceFormatNameData("Default");
        ArrayList typeelems = TypeDomImpl.getAllElements(typedoc);
        int i = 0;
        while (i < typeelems.size()) {
            Element typeelem = (Element)typeelems.get(i);
            String itemname = TypeDomImpl.getElementName(typeelem);
            rfnd.addTypeItem(itemname);
            ++i;
        }
        rfnd.initializeFormatString();
        return rfnd;
    }

    public static String getPlainText(Document datadoc, ReferenceFormatNameData rfnd) {
        StringBuffer strBuf = new StringBuffer(rfnd.getFormatString());
        ArrayList typeItemList = rfnd.getTypeItemList();
        int i = 0;
        while (i < typeItemList.size()) {
            ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(i);
            String value = ReferenceFormatDomImpl.getItemText(datadoc, rftid.getItemName());
            int index = strBuf.indexOf(rftid.getTag());
            if (index != -1) {
                strBuf.replace(index, index + rftid.getTag().length(), value);
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String getRTFText(Document[] datadocs) {
        StringBuffer outBuf = new StringBuffer();
        StringBuffer fonttblBuf = new StringBuffer();
        int i = 0;
        while (i < datadocs.length) {
            Document datadoc = datadocs[i];
            Element root_elem = datadoc.getDocumentElement();
            String tid = root_elem.getAttribute("tid");
            if (tid == null || tid.length() == 0) {
                tid = "0";
            }
            ReferenceFormatNameData rfnd = ReferenceFormatDomImpl.getReferenceFormatTable(tid);
            String font = new String();
            if (rfnd.getFontItemIndex() == 0) {
                if (fonttblBuf.indexOf("\\f0\\fswiss\\fcharset77 Helvetica;") == -1) {
                    fonttblBuf.append("\\f0\\fswiss\\fcharset77 Helvetica;");
                }
                font = "\\f0\\fs" + String.valueOf(rfnd.getFontSize() * 2);
            } else if (rfnd.getFontItemIndex() == 1) {
                if (fonttblBuf.indexOf("\\f1\\froman\\fcharset77 Times-Roman;") == -1) {
                    fonttblBuf.append("\\f1\\froman\\fcharset77 Times-Roman;");
                }
                font = "\\f1\\fs" + String.valueOf(rfnd.getFontSize() * 2);
            } else if (rfnd.getFontItemIndex() == 2) {
                if (fonttblBuf.indexOf("\\f2\\fmodern\\fcharset77 Courier;") == -1) {
                    fonttblBuf.append("\\f2\\fmodern\\fcharset77 Courier;");
                }
                font = "\\f2\\fs" + String.valueOf(rfnd.getFontSize() * 2);
            }
            StringBuffer strBuf = new StringBuffer(rfnd.getFormatString());
            ArrayList typeItemList = rfnd.getTypeItemList();
            int j = 0;
            while (j < typeItemList.size()) {
                ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(j);
                int index = strBuf.indexOf(rftid.getTag());
                if (index != -1) {
                    String value = new String();
                    value = String.valueOf(value) + "{";
                    value = rftid.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                    value = rftid.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                    value = rftid.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                    value = String.valueOf(value) + " ";
                    value = String.valueOf(value) + ReferenceFormatDomImpl.rtfEncode(ReferenceFormatDomImpl.getItemText(datadoc, rftid.getItemName()));
                    value = String.valueOf(value) + "}";
                    strBuf.replace(index, index + rftid.getTag().length(), value);
                }
                ++j;
            }
            if (strBuf.length() > 0) {
                strBuf.insert(0, "{" + font + " ");
                strBuf.append("\\par}");
            }
            outBuf.append(strBuf);
            ++i;
        }
        if (fonttblBuf.length() > 0) {
            fonttblBuf.insert(0, "{\\fonttbl");
            fonttblBuf.append("}");
        }
        if (outBuf.length() > 0) {
            String head = "{\\rtf1{\\colortbl;\\red255\\green255\\blue255;}" + fonttblBuf.toString();
            outBuf.insert(0, head);
            outBuf.append("}");
        }
        return outBuf.toString();
    }

    public static String getRTFText(Document datadoc) {
        StringBuffer outBuf = new StringBuffer();
        StringBuffer fonttblBuf = new StringBuffer();
        Element root_elem = datadoc.getDocumentElement();
        String tid = root_elem.getAttribute("tid");
        if (tid == null || tid.length() == 0) {
            tid = "0";
        }
        ReferenceFormatNameData rfnd = ReferenceFormatDomImpl.getReferenceFormatTable(tid);
        String font = new String();
        if (rfnd.getFontItemIndex() == 0) {
            if (fonttblBuf.indexOf("\\f0\\fswiss\\fcharset77 Helvetica;") == -1) {
                fonttblBuf.append("\\f0\\fswiss\\fcharset77 Helvetica;");
            }
            font = "\\f0\\fs" + String.valueOf(rfnd.getFontSize() * 2);
        } else if (rfnd.getFontItemIndex() == 1) {
            if (fonttblBuf.indexOf("\\f1\\froman\\fcharset77 Times-Roman;") == -1) {
                fonttblBuf.append("\\f1\\froman\\fcharset77 Times-Roman;");
            }
            font = "\\f1\\fs" + String.valueOf(rfnd.getFontSize() * 2);
        } else if (rfnd.getFontItemIndex() == 2) {
            if (fonttblBuf.indexOf("\\f2\\fmodern\\fcharset77 Courier;") == -1) {
                fonttblBuf.append("\\f2\\fmodern\\fcharset77 Courier;");
            }
            font = "\\f2\\fs" + String.valueOf(rfnd.getFontSize() * 2);
        }
        StringBuffer strBuf = new StringBuffer(rfnd.getFormatString());
        ArrayList typeItemList = rfnd.getTypeItemList();
        int j = 0;
        while (j < typeItemList.size()) {
            ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(j);
            int index = strBuf.indexOf(rftid.getTag());
            if (index != -1) {
                String value = new String();
                value = String.valueOf(value) + "{";
                value = rftid.getBold() ? String.valueOf(value) + "\\b" : String.valueOf(value) + "\\b0";
                value = rftid.getItalic() ? String.valueOf(value) + "\\i" : String.valueOf(value) + "\\i0";
                value = rftid.getUnderline() ? String.valueOf(value) + "\\ul" : String.valueOf(value) + "\\ulnone";
                value = String.valueOf(value) + " ";
                value = String.valueOf(value) + ReferenceFormatDomImpl.rtfEncode(ReferenceFormatDomImpl.getItemText(datadoc, rftid.getItemName()));
                value = String.valueOf(value) + "}";
                strBuf.replace(index, index + rftid.getTag().length(), value);
            }
            ++j;
        }
        if (strBuf.length() > 0) {
            strBuf.insert(0, "{" + font + " ");
            strBuf.append("\\par}");
        }
        outBuf.append(strBuf);
        if (fonttblBuf.length() > 0) {
            fonttblBuf.insert(0, "{\\fonttbl");
            fonttblBuf.append("}");
        }
        if (outBuf.length() > 0) {
            String head = "{\\rtf1{\\colortbl;\\red255\\green255\\blue255;}" + fonttblBuf.toString();
            outBuf.insert(0, head);
            outBuf.append("}");
        }
        return outBuf.toString();
    }

    public static String getHTMLText(Document[] datadocs) {
        StringBuffer outBuf = new StringBuffer();
        int i = 0;
        while (i < datadocs.length) {
            Document datadoc = datadocs[i];
            Element root_elem = datadoc.getDocumentElement();
            String tid = root_elem.getAttribute("tid");
            if (tid == null || tid.length() == 0) {
                tid = "0";
            }
            ReferenceFormatNameData rfnd = ReferenceFormatDomImpl.getReferenceFormatTable(tid);
            StringBuffer strBuf = new StringBuffer(rfnd.getFormatString());
            ArrayList typeItemList = rfnd.getTypeItemList();
            int j = 0;
            while (j < typeItemList.size()) {
                ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(j);
                int index = strBuf.indexOf(rftid.getTag());
                if (index != -1) {
                    String value = ReferenceFormatDomImpl.getItemText(datadoc, rftid.getItemName());
                    value = ReferenceFormatDomImpl.htmlEncode(value);
                    if (rftid.getBold()) {
                        value = "<b>" + value + "</b>";
                    }
                    if (rftid.getItalic()) {
                        value = "<i>" + value + "</i>";
                    }
                    if (rftid.getUnderline()) {
                        value = "<u>" + value + "</u>";
                    }
                    if (value == null || value.length() == 0) {
                        value = " ";
                    }
                    strBuf.replace(index, index + rftid.getTag().length(), value);
                }
                ++j;
            }
            outBuf.append(strBuf);
            outBuf.append("<br>");
            ++i;
        }
        if (outBuf.length() > 0) {
            outBuf.insert(0, "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><body>");
            outBuf.append("</body></html>");
        }
        return outBuf.toString();
    }

    public static String getHTMLText(Document datadoc) {
        StringBuffer outBuf = new StringBuffer();
        Element root_elem = datadoc.getDocumentElement();
        String tid = root_elem.getAttribute("tid");
        if (tid == null || tid.length() == 0) {
            tid = "0";
        }
        ReferenceFormatNameData rfnd = ReferenceFormatDomImpl.getReferenceFormatTable(tid);
        StringBuffer strBuf = new StringBuffer(rfnd.getFormatString());
        ArrayList typeItemList = rfnd.getTypeItemList();
        int j = 0;
        while (j < typeItemList.size()) {
            ReferenceFormatTypeItemData rftid = (ReferenceFormatTypeItemData)typeItemList.get(j);
            int index = strBuf.indexOf(rftid.getTag());
            if (index != -1) {
                String value = ReferenceFormatDomImpl.getItemText(datadoc, rftid.getItemName());
                value = ReferenceFormatDomImpl.htmlEncode(value);
                if (rftid.getBold()) {
                    value = "<b>" + value + "</b>";
                }
                if (rftid.getItalic()) {
                    value = "<i>" + value + "</i>";
                }
                if (rftid.getUnderline()) {
                    value = "<u>" + value + "</u>";
                }
                if (value == null || value.length() == 0) {
                    value = " ";
                }
                strBuf.replace(index, index + rftid.getTag().length(), value);
            }
            ++j;
        }
        outBuf.append(strBuf);
        outBuf.append("<br>");
        if (outBuf.length() > 0) {
            outBuf.insert(0, "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><body>");
            outBuf.append("</body></html>");
        }
        return outBuf.toString();
    }

    private static String getItemText(Document datadoc, String name) {
        Element elem3;
        String typename;
        IParserPlugin pp;
        String value = null;
        ArrayList al1 = DomImpl.getElements(datadoc, name);
        if (al1.size() > 0 && (pp = FrameworkPlugin.getParserPlugin(typename = (elem3 = (Element)al1.get(0)).getAttribute("parser"))) != null) {
            ITypeParser p = pp.createInstance();
            Document schemedoc = p.getScheme();
            Element s_root = schemedoc.getDocumentElement();
            Node s_node = s_root.getFirstChild();
            ArrayList al2 = DomImpl.getElements(elem3, s_node.getNodeName());
            if (al2.size() > 0) {
                Element e = (Element)al2.get(0);
                value = DomImpl.getAllText(e);
            }
            p = null;
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static String rtfEncode(String rtfStr) {
        try {
            byte[] data = rtfStr.getBytes("SJIS");
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < data.length) {
                int c = data[i] & 0xFF;
                if (129 <= c && c <= 159 || 224 <= c && c <= 239 || 240 <= c && c <= 252) {
                    strBuf.append("\\");
                    strBuf.append("'");
                    strBuf.append(Integer.toHexString(c));
                    c = data[++i] & 0xFF;
                    strBuf.append("\\");
                    strBuf.append("'");
                    strBuf.append(Integer.toHexString(c));
                } else if (c == 123 || c == 125 || c == 92) {
                    strBuf.append("\\");
                    strBuf.append((char)data[i]);
                } else {
                    strBuf.append((char)data[i]);
                }
                ++i;
            }
            return strBuf.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String rtfEncode_FormatStringOnly(String rtfStr) {
        try {
            byte[] data = rtfStr.getBytes("SJIS");
            StringBuffer strBuf = new StringBuffer();
            int i = 0;
            while (i < data.length) {
                int c = data[i] & 0xFF;
                if (c == 123 || c == 125 || c == 92) {
                    strBuf.append("\\");
                    strBuf.append((char)data[i]);
                } else {
                    strBuf.append((char)data[i]);
                }
                ++i;
            }
            return strBuf.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String htmlEncode(String htmlStr) {
        htmlStr = htmlStr.replaceAll("&", "&amp;");
        htmlStr = htmlStr.replaceAll("<", "&lt;");
        htmlStr = htmlStr.replaceAll(">", "&gt;");
        htmlStr = htmlStr.replaceAll("\"", "&quot;");
        htmlStr = htmlStr.replaceAll("'", "&#39;");
        return htmlStr;
    }
}

